/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.controller;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpTcpConnectionException;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.npv.controller.AbstractAsyncSwitchTask;
import com.cisco.dcbu.sm.client.npv.controller.SwitchActionTracker;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.client.npv.view.BulkActionTableModel;
import com.cisco.dcbu.sm.client.npv.view.ProgressPanel;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.dto.TrafficMap;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class NpvSwitchTask
extends AbstractAsyncSwitchTask {
    public static final Logger _Logger = Logger.getLogger(NpvSwitchTask.class);
    public static final String Snmp_Vsan_Exist_Msg = "This entry already exists";
    private List<List<FcPortBase>> portList = new ArrayList<List<FcPortBase>>();
    private VsanBase vsanbase;
    private short vsanId;
    private ProgressPanel progress;
    private BulkActionTableModel tm;
    private int flexMode;
    private List<TrafficMap> tMap;

    public NpvSwitchTask(AbstractAsyncSwitchTask.Type type, List<Switch> swList, BulkActionTableModel tm, ProgressPanel progress) {
        if (type == null || swList == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        if (swList.size() < 1) {
            throw new IllegalArgumentException("Switch list cannot be empty");
        }
        if (type == EnableNPV || type == EnableNPIV || type == SaveConfig || type == SetFlexAttach) {
            this.type = type;
            this.progress = progress;
            this.tm = tm;
            for (Switch sw : swList) {
                this.allSet.add(sw.getSwitchBase());
                this.swbList.add(sw.getSwitchBase());
                this.swUserList.add(sw.getFabric().getSnmpUserOpt());
            }
        } else {
            throw new IllegalArgumentException("Use wrong constructor for the task type:" + type.getName());
        }
    }

    public NpvSwitchTask(AbstractAsyncSwitchTask.Type type, Map<Switch, List<FcPortBase>> portListMap, BulkActionTableModel tm, ProgressPanel progress) {
        if (type == null || portListMap == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        if (portListMap.size() < 1) {
            throw new IllegalArgumentException("Port list cannot be empty");
        }
        if (type == SetNpPorts || type == SetFPorts || type == SetNpivPorts || type == EnablePorts) {
            this.type = type;
            this.progress = progress;
            this.tm = tm;
            for (Map.Entry<Switch, List<FcPortBase>> entry : portListMap.entrySet()) {
                this.allSet.add(entry.getKey().getSwitchBase());
                this.swbList.add(entry.getKey().getSwitchBase());
                this.swUserList.add(entry.getKey().getFabric().getSnmpUserOpt());
                this.portList.add(new ArrayList(entry.getValue()));
            }
        } else {
            throw new IllegalArgumentException("Use wrong constructor for the task type:" + type.getName());
        }
    }

    public NpvSwitchTask(AbstractAsyncSwitchTask.Type type, List<Switch> swList, short vsanId, Vsan vsan, BulkActionTableModel tm, ProgressPanel progress) {
        if (type == null || swList == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        if (swList.size() < 1) {
            throw new IllegalArgumentException("Switch list cannot be empty");
        }
        if (vsanId < 0 && vsan == null) {
            throw new IllegalArgumentException("Vsan and VsanId cannot be both invalid");
        }
        if (type == AddVSANSwitches) {
            this.type = type;
            this.progress = progress;
            this.tm = tm;
            for (Switch sw : swList) {
                this.allSet.add(sw.getSwitchBase());
                this.swbList.add(sw.getSwitchBase());
                this.swUserList.add(sw.getFabric().getSnmpUserOpt());
            }
            this.vsanId = vsanId;
            if (vsan != null) {
                this.vsanbase = (VsanBase)vsan.getBaseModelObject();
            }
        } else {
            throw new IllegalArgumentException("Use wrong constructor for the task type:" + type.getName());
        }
    }

    public NpvSwitchTask(AbstractAsyncSwitchTask.Type type, Map<Switch, List<FcPortBase>> portListMap, short vsanId, Vsan vsan, BulkActionTableModel tm, ProgressPanel progress) {
        if (type == null || portListMap == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        if (portListMap.size() < 1) {
            throw new IllegalArgumentException("Port list cannot be empty");
        }
        if (vsanId < 0 && vsan == null) {
            throw new IllegalArgumentException("Vsan and VsanId cannot be both invalid");
        }
        if (type == AddVSANPorts) {
            this.type = type;
            this.progress = progress;
            this.tm = tm;
            Set<Map.Entry<Switch, List<FcPortBase>>> portListSet = portListMap.entrySet();
            for (Map.Entry<Switch, List<FcPortBase>> entry : portListSet) {
                this.allSet.add(entry.getKey().getSwitchBase());
                this.swbList.add(entry.getKey().getSwitchBase());
                this.swUserList.add(entry.getKey().getFabric().getSnmpUserOpt());
                ArrayList ports = new ArrayList(entry.getValue());
                this.portList.add(ports);
            }
            this.vsanId = vsanId;
            if (vsan != null) {
                this.vsanbase = (VsanBase)vsan.getBaseModelObject();
            } else {
                vsan = null;
            }
        } else {
            throw new IllegalArgumentException("Use wrong constructor for the task type:" + type.getName());
        }
    }

    public NpvSwitchTask(AbstractAsyncSwitchTask.Type type, List<Switch> swList, int mode, BulkActionTableModel tm, ProgressPanel progress) {
        this(type, swList, tm, progress);
        this.flexMode = mode;
    }

    public NpvSwitchTask(AbstractAsyncSwitchTask.Type type, BulkActionTableModel tm, ProgressPanel progress, List<TrafficMap> trafficMap, SnmpUserOpt userOpt) {
        if (type != SetTrafficMap) {
            throw new IllegalArgumentException("Use wrong constructor for the task type:" + type.getName());
        }
        this.tMap = trafficMap;
        for (TrafficMap map : this.tMap) {
            this.allSet.add(map.getSw());
            this.swbList.add(map.getSw());
            this.swUserList.add(userOpt);
        }
        this.type = type;
        this.progress = progress;
        this.tm = tm;
    }

    @Override
    public AbstractAsyncSwitchTask.Type getType() {
        return this.type;
    }

    public List<List<FcPortBase>> getPortList() {
        return this.portList;
    }

    public VsanBase getVsanbase() {
        return this.vsanbase;
    }

    public short getVsanId() {
        return this.vsanId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Object event) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            _Logger.trace((Object)(this + "- onMessage: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + ", message->" + event));
            _Logger.trace((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        NpvSwitchTask npvSwitchTask = this;
        synchronized (npvSwitchTask) {
            if (event instanceof QueueResponseObject) {
                QueueResponseObject resp = (QueueResponseObject)event;
                if (resp.getRequestId() == this.requestId && this.isTaskRunning()) {
                    SwitchBase sw = resp.getSwitchBase();
                    int result = resp.getResultValue();
                    SwitchActionTracker.Status status = SwitchActionTracker.NA;
                    String message = resp.getStatusStr();
                    Exception error = resp.getException();
                    switch (result) {
                        case 3: {
                            status = SwitchActionTracker.INPROGRESS;
                            if (message != null) break;
                            message = "In progress";
                            break;
                        }
                        case 4: {
                            status = SwitchActionTracker.ERROR;
                            if (error instanceof SnmpException && error.getMessage() != null && (error.getMessage().indexOf("Invalid Credentials") >= 0 || error.getMessage().indexOf("Privacy unsupported for this user") >= 0)) {
                                _Logger.warn((Object)(this + " got authentication error from " + sw.getIpAddress() + " SNMP"), (Throwable)error);
                                status = SwitchActionTracker.FAILED;
                                if (message == null) {
                                    message = "Switch (" + sw.getIpAddress() + ") authentication failed.";
                                }
                            } else {
                                if (this.type == AddVSANSwitches && error instanceof SnmpException && error.getMessage() != null && error.getMessage().indexOf(Snmp_Vsan_Exist_Msg) >= 0) {
                                    status = SwitchActionTracker.SUCCESS;
                                    if (message == null) {
                                        message = "Successful";
                                    }
                                }
                                if (this.type == EnableNPV && (error instanceof SnmpTcpConnectionException || error instanceof SnmpException && error.getMessage() != null && error.getMessage().indexOf("timeout") >= 0)) {
                                    status = SwitchActionTracker.SUCCESS;
                                    message = "NPV enabled and switch starts to reboot";
                                }
                            }
                            if (message != null) break;
                            message = "Got error";
                            break;
                        }
                        case 1: 
                        case 6: {
                            status = SwitchActionTracker.SUCCESS;
                            if (message != null) break;
                            message = "Successful";
                            break;
                        }
                        case 2: {
                            status = SwitchActionTracker.FAILED;
                            if (message != null) break;
                            message = "Failed";
                            break;
                        }
                        case 5: {
                            status = SwitchActionTracker.UNKNOW;
                            if (message != null) break;
                            message = "Unknown";
                        }
                    }
                    if (status != SwitchActionTracker.NA) {
                        this.updateSwitchTaskStatus(sw, status, message, error);
                    }
                    this.notifyAll();
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug((Object)(this + "- onMessage: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + ", message->" + event + ": notifyAll"));
                    }
                } else {
                    _Logger.debug((Object)(this + "- onMessage unexpected: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + " received wrong response:" + event));
                }
            } else {
                _Logger.warn((Object)(this + "- onMessage unexpected: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + " received unexpected object (" + event.getClass() + "): " + event));
            }
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " process onMessage at time:" + this.timer.getTimeDisplay()));
        }
    }

    @Override
    protected long sendRequest() throws Exception {
        long reqId = -1L;
        switch (this.type) {
            case AddVSANSwitches: {
                reqId = NpvClientHelper.getInstance().addSwitchesToVsanAsync(this.swbList, this.swUserList, this.vsanId, this.vsanbase, this.p2pHandler);
                break;
            }
            case AddVSANPorts: {
                reqId = NpvClientHelper.getInstance().addPortsToVsanAsync(this.swbList, this.swUserList, this.portList, this.vsanId, this.vsanbase, this.p2pHandler);
                break;
            }
            case SetNpPorts: {
                reqId = NpvClientHelper.getInstance().setPortTypeAsync(this.swbList, this.swUserList, this.portList, (short)16, this.p2pHandler);
                break;
            }
            case SetFPorts: {
                reqId = NpvClientHelper.getInstance().setPortTypeAsync(this.swbList, this.swUserList, this.portList, (short)2, this.p2pHandler);
                break;
            }
            case SetNpivPorts: {
                reqId = NpvClientHelper.getInstance().setPortTypeAsync(this.swbList, this.swUserList, this.portList, (short)2, this.p2pHandler);
                break;
            }
            case EnableNPIV: {
                reqId = NpvClientHelper.getInstance().enableSwitchNpivAsync(this.swbList, this.swUserList, this.p2pHandler);
                break;
            }
            case EnableNPV: {
                reqId = NpvClientHelper.getInstance().enableSwitchNpvAsync(this.swbList, this.swUserList, this.p2pHandler);
                break;
            }
            case EnablePorts: {
                reqId = NpvClientHelper.getInstance().setPortsEnabledAsync(this.swbList, this.swUserList, this.portList, this.p2pHandler);
                break;
            }
            case SaveConfig: {
                reqId = NpvClientHelper.getInstance().saveSwitchCfgAsync(this.swbList, this.swUserList, this.p2pHandler);
                break;
            }
            case SetFlexAttach: {
                reqId = NpvClientHelper.getInstance().setFlexAttachMode(this.swbList, this.swUserList, this.flexMode, this.p2pHandler);
                break;
            }
            case SetTrafficMap: {
                reqId = NpvClientHelper.getInstance().setTrafficMapAsync(this.swbList, this.tMap, this.swUserList, this.p2pHandler);
                break;
            }
            default: {
                throw new Exception("Task (" + this.type.getName() + ") does not support");
            }
        }
        return reqId;
    }

    @Override
    protected void adjustComponents() {
        ArrayList oldSwbList = new ArrayList(this.swbList);
        ArrayList oldSwUserList = new ArrayList(this.swUserList);
        ArrayList<List<FcPortBase>> oldPortList = new ArrayList<List<FcPortBase>>(this.portList);
        this.swbList.clear();
        this.swUserList.clear();
        this.portList.clear();
        int i = 0;
        for (SwitchBase swb : oldSwbList) {
            if (!this.succSet.contains(swb)) {
                this.swbList.add(swb);
                this.swUserList.add(oldSwUserList.get(i));
                this.portList.add((List<FcPortBase>)oldPortList.get(i));
            }
            ++i;
        }
        oldSwbList.clear();
        oldSwUserList.clear();
        oldPortList.clear();
    }

    @Override
    public void closeTask() {
        super.closeTask();
        for (List<FcPortBase> plist : this.portList) {
            if (plist == null) continue;
            plist.clear();
        }
        this.portList.clear();
    }

    @Override
    protected void updateStartStatus() {
        if (this.tm != null) {
            List<SwitchActionTracker> actions = this.tm.getActionData();
            for (SwitchActionTracker action : actions) {
                if (action.getType() != this.type || this.succSet.contains(action.getSwitchTarget().getSwitchBase())) continue;
                action.setStatus(SwitchActionTracker.STARTED, null, null);
            }
        }
        if (this.progress != null) {
            this.progress.setStatus(this.type.getName());
            this.progress.increaseProgress();
        }
    }

    @Override
    protected void updateFailStatus(Exception error) {
        for (SwitchBase sw : this.swbList) {
            if (this.succSet.contains(sw)) continue;
            this.updateSwitchTaskStatus(sw, SwitchActionTracker.FAILED, "Got exception", error);
        }
    }

    @Override
    protected void updateSwitchTaskStatus(SwitchBase sw, SwitchActionTracker.Status status, String message, Exception error) {
        if (this.tm != null) {
            List<SwitchActionTracker> actions = this.tm.findActionByTarget(sw);
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)("update status ==>" + sw + ", " + message + ", " + (Object)((Object)status) + ", " + actions));
            }
            if (actions != null) {
                for (int k = 0; k < actions.size(); ++k) {
                    final SwitchActionTracker action = actions.get(k);
                    if (action.getType() != this.type) continue;
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)("update action==>" + action + ", " + (Object)((Object)status)));
                    }
                    if (action.getStatus() == SwitchActionTracker.SUCCESS || action.getStatus() == SwitchActionTracker.FAILED) {
                        return;
                    }
                    action.setStatus(status, message, error);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NpvSwitchTask.this.tm.updateAction(action);
                        }
                    });
                }
            }
        }
        if (this.progress != null) {
            if (status == SwitchActionTracker.INPROGRESS || status == SwitchActionTracker.WARNING) {
                this.progress.setStatus(this.type.getName() + " on switch " + sw + " is in progress");
            } else if (status == SwitchActionTracker.ERROR) {
                this.progress.setStatus(this.type.getName() + " on switch " + sw + " got error");
                this.progress.increaseProgress();
            } else if (status == SwitchActionTracker.FAILED) {
                this.progress.setStatus(this.type.getName() + " on switch " + sw + " failed");
                this.progress.increaseProgress();
            } else if (status == SwitchActionTracker.SUCCESS) {
                this.progress.setStatus(this.type.getName() + " on switch " + sw + " is successful");
                this.progress.increaseProgress();
            }
        }
        if (status == SwitchActionTracker.ERROR || status == SwitchActionTracker.FAILED) {
            this.failedSet.add(sw);
        } else if (status == SwitchActionTracker.SUCCESS) {
            this.succSet.add(sw);
        }
        if (this.succSet.size() + this.failedSet.size() >= this.swbList.size()) {
            this.setState(AbstractAsyncSwitchTask.State.End);
            if (this.p2pHandler != null) {
                try {
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)(this + " close P2P queue:" + this.p2pHandler));
                    }
                    try {
                        NpvClientHelper.getInstance().getNPVRif().destroyPtoPQueue(this.p2pHandler.getCommunicationObject());
                    }
                    catch (Exception re) {
                        _Logger.error((Object)"error cleaning up P to P Queue on Server", (Throwable)re);
                    }
                    this.p2pHandler.stop();
                }
                catch (Exception e) {
                    _Logger.debug((Object)"Exception from close P2P queue", (Throwable)e);
                }
            }
            this.p2pHandler = null;
        }
    }

    @Override
    protected void updataEndStatus() {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("Task Succ sw==>" + this.succSet.size() + "--" + this.succSet));
            _Logger.trace((Object)("Task Failed sw==>" + this.failedSet.size() + "--" + this.failedSet));
            _Logger.trace((Object)("Task All Sw==>" + this.swbList.size() + "--" + this.swbList));
        }
        if (this.progress != null) {
            if (this.isTaskSuccess()) {
                this.progress.setStatus(this.type.getName() + " finished");
            } else if (this.isTaskInterrupted()) {
                this.progress.setStatus(this.type.getName() + " did not complete");
            } else if (this.isTaskFailed()) {
                this.progress.setStatus(this.type.getName() + " is failed");
            }
        }
    }

    @Override
    protected void updateCancelStatus() {
        if (this.progress != null) {
            this.progress.setStatus(this.type.getName() + " is cancelled");
        }
    }
}

