/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.controller;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.script.AbstractWorker;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.controller.AbstractAsyncSwitchTask;
import com.cisco.dcbu.sm.client.npv.controller.NpvSwitchTask;
import com.cisco.dcbu.sm.client.npv.controller.SwitchActionTracker;
import com.cisco.dcbu.sm.client.npv.controller.TEWizardController;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.client.npv.view.ProgressWindow;
import com.cisco.dcbu.sm.client.npv.wizard.CompleteStep;
import com.cisco.dcbu.sm.client.npv.wizard.NPVTrafficEngStep;
import com.cisco.dcbu.sm.client.npv.wizard.TESetupWizard;
import com.cisco.dcbu.sm.common.dto.TrafficMap;
import com.cisco.dcbu.sm.common.dto.TrafficMapElement;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class TESetupWizardController
implements TEWizardController {
    public static final Logger _Logger = Logger.getLogger(TESetupWizardController.class);
    private static final Color AREA_BG_Color = UIManager.getColor("Label.background");
    private TESetupWizard wizard;
    private Fabric fabric;
    private List<Switch> teCapableSwList = new ArrayList<Switch>();
    private List<Switch> teSelectedSwList = new ArrayList<Switch>();
    private List<TrafficMap> originalTrafficMap = new ArrayList<TrafficMap>();
    private boolean runApply = false;
    private boolean isCanceled = false;
    private List<AbstractAsyncSwitchTask> taskList = new ArrayList<AbstractAsyncSwitchTask>();
    private List<AbstractWorker> workers = new ArrayList<AbstractWorker>();
    private int flexAttachMode = 0;
    private List<TrafficMap> setMeTrafficMap;
    private ArrayList<TrafficMap> queryTMap = new ArrayList();
    private Map<Switch, Map> serverIfMap = new HashMap<Switch, Map>();

    public static String convertToHtml(String plainMessage) {
        String str = plainMessage;
        if (str != null && str.indexOf("<html>") < 0) {
            StringBuffer sb = new StringBuffer();
            str = str.replaceAll("\n", "<br>");
            str = str.replaceAll("<html>", "");
            str = str.replaceAll("</html>", "");
            str = "<html><body>" + str + "</body></html>";
            return str;
        }
        return plainMessage;
    }

    public static ArrayList convertToMultiLines(String plainMessage, int maxLen, String token) {
        ArrayList<String> list = new ArrayList<String>();
        if (plainMessage.length() <= maxLen) {
            list.add(plainMessage);
            return list;
        }
        if (token == null) {
            token = " ";
        }
        String[] substrs = plainMessage.split(token, 0);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < substrs.length; ++i) {
            if (sb.length() + substrs[i].length() > maxLen && sb.length() > 0) {
                list.add(sb.toString());
                sb.setLength(0);
            }
            sb.append(substrs[i]);
            if (i >= substrs.length - 1) continue;
            sb.append(token);
        }
        return list;
    }

    public static JPanel getIndentedPanel(JComponent[] comps, int indent) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        p.setBorder(new EmptyBorder(0, 0, 0, 0));
        p.add(Box.createHorizontalStrut(indent));
        for (JComponent comp : comps) {
            p.add(comp);
            p.add(Box.createRigidArea(new Dimension(5, 5)));
        }
        p.add(Box.createHorizontalGlue());
        return p;
    }

    public TESetupWizardController(TESetupWizard wizard) {
        this.wizard = wizard;
        this.fabric = ClientController.getInstance().getFabric();
    }

    @Override
    public synchronized boolean isRunApply() {
        return this.runApply;
    }

    @Override
    public synchronized void setCanceled(boolean b) {
        this.isCanceled = b;
    }

    public synchronized void setRunApply(boolean runApply) {
        this.runApply = runApply;
    }

    @Override
    public Fabric getFabric() {
        return this.fabric;
    }

    public Object preloadData(ProgressWindow progressWindow) {
        try {
            progressWindow.setStatus("Loading all visible switches ...");
            List<Switch> swList = NpvClientHelper.getInstance().getSwitches(this.getFabric());
            progressWindow.setStatus("Loaded all visible switches");
            progressWindow.setProgress(5);
            if (swList.size() == 0) {
                throw new Exception("There are no switches visible to client.");
            }
            progressWindow.setStatus("Loading NPV capable switches ...");
            this.teCapableSwList = NpvClientHelper.getInstance().getTECapableDevices(swList);
            progressWindow.setStatus("Loaded NPV capable switches");
            progressWindow.setProgress(12);
            if (this.teCapableSwList.size() == 0) {
                throw new Exception("There are no Traffic Map capable switches.\nThey are either unmanageable or not present.\nNPV switches support Traffic Map capabilities from version 3.4.1 and later.\nNPV enabled switches are MDS 9124, 9134 or\nBlade Server with version 3.2(2) or later and have the NPV mode enabled.\n");
            }
        }
        catch (Exception e) {
            _Logger.warn((Object)"Get exception from NPV preload: ", (Throwable)e);
            return e;
        }
        return null;
    }

    @Override
    public List<TrafficMap> setTrafficMap(List<TrafficMap> map) {
        this.setMeTrafficMap = map;
        return this.setMeTrafficMap;
    }

    private boolean doTrafficMapTask(CompleteStep step) {
        boolean hasError = false;
        if (this.setMeTrafficMap != null && this.setMeTrafficMap.size() > 0) {
            NpvSwitchTask teTask = new NpvSwitchTask(AbstractAsyncSwitchTask.Type.SetTrafficMap, step.getBulkActionTableModel(), step.getProgressPanel(), this.setMeTrafficMap, this.getFabric().getSnmpUserOpt());
            this.taskList.add(teTask);
            _Logger.info((Object)("run task " + (Object)((Object)teTask.getType()) + ": " + teTask.toString()));
            teTask.run();
            if (teTask.isTaskSuccess()) {
                _Logger.warn((Object)("run task " + (Object)((Object)teTask.getType()) + " with failed switches:" + teTask.getFailedSet()));
                hasError = true;
            } else {
                _Logger.info((Object)("run task " + (Object)((Object)teTask.getType()) + " successful"));
            }
            teTask.closeTask();
            this.taskList.remove(teTask);
        }
        return hasError;
    }

    @Override
    public void runSetupApply(final CompleteStep step) {
        AbstractWorker worker = new AbstractWorker(){

            public void checkCanceled() throws Exception {
                if (TESetupWizardController.this.isCanceled) {
                    throw new Exception("NPV operations canceled by user");
                }
            }

            @Override
            public Object construct() {
                try {
                    TESetupWizardController.this.setRunApply(true);
                    _Logger.debug((Object)"runSetupApply start to apply setup");
                    boolean hasError = false;
                    this.checkCanceled();
                    TESetupWizardController.this.doTrafficMapTask(step);
                    this.checkCanceled();
                    List<Switch> allSwList = TESetupWizardController.this.getTESelectedSwList();
                    if (allSwList.size() > 0) {
                        NpvSwitchTask saveCfgTask = new NpvSwitchTask(AbstractAsyncSwitchTask.Type.SaveConfig, allSwList, null, step.getProgressPanel());
                        int swCnt = allSwList.size();
                        int runs = Math.max(Math.round(swCnt / 10), 5);
                        saveCfgTask.setTaskTimeout((long)runs * saveCfgTask.getMessageTimeout());
                        TESetupWizardController.this.taskList.add(saveCfgTask);
                        _Logger.info((Object)("run task " + (Object)((Object)saveCfgTask.getType()) + " on switches: " + saveCfgTask.getSwbList()));
                        saveCfgTask.run();
                        if (!saveCfgTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + (Object)((Object)saveCfgTask.getType()) + " with failed switches:" + saveCfgTask.getFailedSet()));
                        } else {
                            _Logger.info((Object)("run task " + (Object)((Object)saveCfgTask.getType()) + " successful"));
                        }
                        saveCfgTask.closeTask();
                        TESetupWizardController.this.taskList.remove(saveCfgTask);
                    }
                    return new Boolean(hasError);
                }
                catch (Exception e) {
                    if (TESetupWizardController.this.isCanceled) {
                        _Logger.warn((Object)(e.getMessage() + ".  Cancel pressed."));
                        return false;
                    }
                    _Logger.warn((Object)"Got exceptions from apply NPV settings:", (Throwable)e);
                    return e;
                }
            }

            @Override
            public void finished() {
                Object ret = this.getValue();
                TESetupWizardController.this.setRunApply(false);
                if (ret instanceof Exception) {
                    step.actionFinished(false);
                    Util.errorMessage((Component)step.getWizard(), (Exception)ret);
                } else if (ret instanceof Boolean) {
                    step.actionFinished((Boolean)ret == false);
                }
            }
        };
        worker.start();
    }

    @Override
    public List<Switch> getTESelectedSwList() {
        return this.teSelectedSwList;
    }

    @Override
    public Set<Switch> getTESelectedSwSet() {
        List<Switch> npvSws = this.getTESelectedSwList();
        HashSet<Switch> sw2Query = new HashSet<Switch>();
        for (Switch sw : npvSws) {
            sw2Query.add(sw);
        }
        return sw2Query;
    }

    public void setTESelectedSwList(List<Switch> npvSelectedSwList) {
        this.teSelectedSwList.clear();
        if (npvSelectedSwList != null) {
            this.teSelectedSwList.addAll(npvSelectedSwList);
        }
    }

    @Override
    public List<Switch> getTECapableSwList() {
        return this.teCapableSwList;
    }

    @Override
    public Set<Switch> getTECapableSwSet() {
        List<Switch> npvSws = this.getTECapableSwList();
        HashSet<Switch> sw2Query = new HashSet<Switch>();
        for (Switch sw : npvSws) {
            sw2Query.add(sw);
        }
        return sw2Query;
    }

    @Override
    public List<SwitchActionTracker> createTESetActions() {
        ArrayList<SwitchActionTracker> actions = new ArrayList<SwitchActionTracker>();
        if (this.setMeTrafficMap == null) {
            return actions;
        }
        HashMap<SwitchBase, Switch> cache = new HashMap<SwitchBase, Switch>();
        for (Switch sw : this.getTESelectedSwList()) {
            cache.put(sw.getSwitchBase(), sw);
        }
        for (TrafficMap tm : this.setMeTrafficMap) {
            StringBuffer addServerIfs = new StringBuffer();
            StringBuffer delServerIfs = new StringBuffer();
            Map<Integer, TrafficMapElement> map = tm.getMap();
            SwitchBase sw = tm.getSw();
            if (map != null) {
                ArrayList<TrafficMapElement> mapElements = new ArrayList<TrafficMapElement>(map.values());
                Collections.sort(mapElements, new Comparator<TrafficMapElement>(){

                    @Override
                    public int compare(TrafficMapElement obj1, TrafficMapElement obj2) {
                        Integer port1 = obj1.getServerPort();
                        Integer port2 = obj2.getServerPort();
                        return NpvClientHelper.compare(port1, port2);
                    }

                    @Override
                    public boolean equals(Object obj) {
                        return false;
                    }
                });
                for (TrafficMapElement element : mapElements) {
                    if (element.getType() == 3) {
                        if (delServerIfs.length() > 0) {
                            delServerIfs.append(",");
                        }
                        delServerIfs.append(sw.ifIndexToName(element.getServerPort()));
                        continue;
                    }
                    addServerIfs.append("\n--").append(sw.ifIndexToName(element.getServerPort())).append(" - external interface(s): ");
                    List<Integer> externalPorts = element.getExternalPorts();
                    for (int index = 0; index < externalPorts.size(); ++index) {
                        Integer port = externalPorts.get(index);
                        if (index != 0) {
                            addServerIfs.append(", ");
                        }
                        addServerIfs.append(sw.ifIndexToName(port));
                    }
                }
            }
            String msg = null;
            for (TrafficMap orig : this.originalTrafficMap) {
                SwitchBase oSw = orig.getSw();
                if (oSw == null || !oSw.getPK().equals(sw.getPK()) || orig.isEnableDisruptiveLoadBalance() == tm.isEnableDisruptiveLoadBalance()) continue;
                msg = "\n-" + (tm.isEnableDisruptiveLoadBalance() ? "enabling " : "disabling ") + "load balancing";
                break;
            }
            SwitchActionTracker tracker = new SwitchActionTracker((Switch)cache.get(sw), "Set Traffic Management policy: " + (addServerIfs.length() > 0 ? "\n-adding/updating server interface(s): " + addServerIfs.toString() : "") + (addServerIfs.length() > 0 && delServerIfs.length() > 0 ? "; " : "") + (delServerIfs.length() > 0 ? "\n-deleting server interface(s): " + delServerIfs.toString() : "") + (msg == null ? "" : msg), NpvSwitchTask.SetTrafficMap);
            actions.add(tracker);
        }
        return actions;
    }

    public TESetupWizard getWizard() {
        return this.wizard;
    }

    public void clear() {
        for (AbstractAsyncSwitchTask task : this.taskList) {
            if (task == null) continue;
            try {
                task.cancelTask();
                task.closeTask();
            }
            catch (Exception exception) {}
        }
        this.taskList.clear();
        this.teSelectedSwList.clear();
        this.teCapableSwList.clear();
        for (AbstractWorker worker : this.workers) {
            worker.stop();
        }
        this.workers.clear();
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    @Override
    public List<TrafficMap> getQueriedTMap() {
        ArrayList<TrafficMap> copyQueryTMap = new ArrayList<TrafficMap>();
        for (TrafficMap nextMap : this.queryTMap) {
            copyQueryTMap.add(nextMap.clone());
        }
        return copyQueryTMap;
    }

    @Override
    public boolean isMapEqualToQueryTMap(List<TrafficMap> pMap) {
        if (this.queryTMap != null) {
            return this.queryTMap.equals(pMap);
        }
        return pMap == null;
    }

    @Override
    public Map<Switch, Map> getQueriedServerIfTableMap() {
        return this.serverIfMap;
    }

    @Override
    public void queryTrafficMap(final NPVTrafficEngStep step) throws Exception {
        boolean TRAFFIC_MAP_INDEX = false;
        boolean SERVER_IF_MAP_INDEX = true;
        AbstractWorker worker = new AbstractWorker(){

            @Override
            public Object construct() {
                ArrayList<Object> allData = new ArrayList<Object>();
                step.actionFinished(false);
                Set<Switch> sw2Query = TESetupWizardController.this.getTESelectedSwSet();
                try {
                    List<TrafficMap> trafficMap = NpvClientHelper.getInstance().getTrafficMap(sw2Query, TESetupWizardController.this.getFabric().getSnmpUserOpt());
                    allData.add(trafficMap);
                }
                catch (Exception e) {
                    _Logger.warn((Object)"Cannot query traffic map:", (Throwable)e);
                    allData.add(e);
                }
                try {
                    Map<Switch, Map> serverIFMap = NpvClientHelper.getInstance().getCnpvServerIfTable(sw2Query, TESetupWizardController.this.getFabric().getSnmpUserOpt());
                    allData.add(serverIFMap);
                }
                catch (Exception e) {
                    _Logger.warn((Object)"Cannot query Server IF table:", (Throwable)e);
                    allData.add(e);
                }
                return allData;
            }

            @Override
            public void finished() {
                Object ret = this.getValue();
                TESetupWizardController.this.getWizard().setStatus("");
                Object mapResult = ((List)ret).get(0);
                Object serverIfTableResults = ((List)ret).get(1);
                if (mapResult instanceof Exception) {
                    step.showError((Exception)mapResult);
                } else if (mapResult instanceof List) {
                    TESetupWizardController.this.queryTMap = (ArrayList)mapResult;
                    if (serverIfTableResults instanceof Exception) {
                        step.showError((Exception)serverIfTableResults);
                    } else if (serverIfTableResults instanceof Map) {
                        TESetupWizardController.this.serverIfMap = (Map)serverIfTableResults;
                        step.doRefresh();
                    }
                } else {
                    step.doRefresh();
                }
                step.actionFinished(true);
            }
        };
        this.workers.add(worker);
        worker.start();
    }

    @Override
    public void setOriginalTrafficMap(List<TrafficMap> originalTrafficMap) {
        this.originalTrafficMap = originalTrafficMap;
    }
}

