/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.util;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.TimeWatch;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.dto.NpvPortPairCfg;
import com.cisco.dcbu.sm.common.dto.TrafficMap;
import com.cisco.dcbu.sm.common.event.PtoPEventHandler;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.NpvLinkBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.rif.NPVRif;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class NpvClientHelper {
    public static final Logger _Logger = Logger.getLogger(NpvClientHelper.class);
    public static final String NPV_MIN_VERSION = "3.2(2)";
    public static final String NPIV_MIN_VERSION = "3.2(1)";
    public static final String STATIC_CFS_MIN_VERSION = "3.4(1)";
    public static final String TE_MIN_VERSION = "3.4(1)";
    private static NpvClientHelper _Helper = null;
    private Map<SwitchBase, Switch> sanSwMap = null;

    public static synchronized NpvClientHelper getInstance() {
        if (_Helper == null) {
            _Helper = new NpvClientHelper();
        }
        return _Helper;
    }

    public static synchronized void destoryInstance() {
        _Helper.clear();
        _Helper = null;
    }

    public static String getPortsString(Switch sw, List<FcPortBase> ports) {
        if (ports == null) {
            return "";
        }
        ArrayList<FcPortBase> sortedPorts = new ArrayList<FcPortBase>(ports);
        Collections.sort(sortedPorts);
        StringBuffer sb = new StringBuffer();
        for (FcPortBase p : sortedPorts) {
            sb.append(sw.ifIndexToName(p.getIfIndex()));
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sortedPorts.clear();
        return sb.toString();
    }

    public String getPortsString(SwitchBase swb, List<FcPortBase> ports) {
        if (ports == null) {
            return "";
        }
        ArrayList<FcPortBase> sortedPorts = new ArrayList<FcPortBase>(ports);
        Collections.sort(sortedPorts);
        StringBuffer sb = new StringBuffer();
        Switch sw = this.querySwitchFromSAN(swb);
        for (FcPortBase p : sortedPorts) {
            if (sw != null) {
                sb.append(sw.ifIndexToName(p.getIfIndex()));
            } else {
                sb.append(p.getIfIndex());
            }
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sortedPorts.clear();
        return sb.toString();
    }

    public static void copyMapList(Map<Switch, List<FcPortBase>> from, Map<Switch, List<FcPortBase>> to) {
        if (from == null || to == null) {
            return;
        }
        for (Map.Entry<Switch, List<FcPortBase>> entry : from.entrySet()) {
            List<FcPortBase> plist = to.get(entry.getKey());
            if (entry.getValue() != null) {
                if (plist == null) {
                    plist = new ArrayList<FcPortBase>();
                }
                if (entry.getValue() != null) {
                    plist.addAll((Collection<FcPortBase>)entry.getValue());
                }
            }
            to.put(entry.getKey(), plist);
        }
    }

    public static void clearMapList(Map<Switch, List<FcPortBase>> from) {
        if (from == null) {
            return;
        }
        for (Map.Entry<Switch, List<FcPortBase>> entry : from.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().clear();
        }
        from.clear();
    }

    public NPVRif getNPVRif() throws Exception {
        NPVRif npvRif = ClientController.getInstance().assertNPV();
        return npvRif;
    }

    public boolean isNpvCapable(Switch sw) {
        if (sw == null) {
            throw new IllegalArgumentException("Switch object cannot be null");
        }
        return sw.isVersionGreaterThanEqual(NPV_MIN_VERSION) && sw.isParadise() || sw.isN5K() && this.isNpvDevice(sw) && sw.findPorts(1).size() > 0;
    }

    public boolean isManageableByServer(Switch sw) {
        if (sw == null) {
            throw new IllegalArgumentException("Switch object cannot be null");
        }
        return sw.getSwitchBase().isManageable();
    }

    public boolean isNpivCapable(Switch sw) {
        if (sw == null) {
            throw new IllegalArgumentException("Switch object cannot be null");
        }
        return sw.isVersionGreaterThanEqual(NPIV_MIN_VERSION) && !sw.isNpvEnabled() && !sw.isN7K();
    }

    public boolean isNpvDevice(Switch sw) {
        if (sw == null) {
            throw new IllegalArgumentException("Switch object cannot be null");
        }
        return sw.isFeatureEnabled(AbstractSwitchBase.Feature.NPV.flag()) && sw.isManageableByBoth();
    }

    public boolean isNpvCoreSwitch(Switch sw) {
        if (sw == null) {
            throw new IllegalArgumentException("Switch object cannot be null");
        }
        return sw.isFeatureEnabled(AbstractSwitchBase.Feature.NPIV.flag());
    }

    public List<Switch> getNpvCapableSwitches(List<Switch> swList, boolean includeUCS) {
        ArrayList<Switch> npvswList = new ArrayList<Switch>();
        if (swList != null) {
            for (Switch sw : swList) {
                if (!this.isNpvCapable(sw) || !this.isManageableByServer(sw) || sw.isUCS() && !includeUCS) continue;
                npvswList.add(sw);
            }
        }
        return npvswList;
    }

    public List<Switch> getNpvDevices(List<Switch> swList) {
        ArrayList<Switch> npvDeviceList = new ArrayList<Switch>();
        if (swList != null) {
            for (Switch sw : swList) {
                if (!this.isNpvDevice(sw)) continue;
                npvDeviceList.add(sw);
            }
        }
        return npvDeviceList;
    }

    public Vector<Switch> getSwitchListAsVector(List<Switch> swList) {
        Vector<Switch> npvDeviceList = new Vector<Switch>();
        if (swList != null) {
            for (Switch sw : swList) {
                npvDeviceList.add(sw);
            }
        }
        return npvDeviceList;
    }

    public List<Switch> getTECapableDevices(List<Switch> swList) {
        ArrayList<Switch> npvDeviceList = new ArrayList<Switch>();
        if (swList != null) {
            for (Switch sw : swList) {
                if (!this.isNpvDevice(sw) || !sw.isVersionGreaterThanEqual("3.4(1)") || !sw.isManageableByBoth() || sw.isN5K()) continue;
                npvDeviceList.add(sw);
            }
        }
        return npvDeviceList;
    }

    public List<Switch> getNpvEnabledDevices(List<Switch> swList) {
        ArrayList<Switch> npvDeviceList = new ArrayList<Switch>();
        if (swList != null) {
            for (Switch sw : swList) {
                if (!this.isNpvDevice(sw)) continue;
                npvDeviceList.add(sw);
            }
        }
        return npvDeviceList;
    }

    public List<Switch> getStaticCfsNpvEnabledDevices(List<Switch> swList) {
        ArrayList<Switch> npvDeviceList = new ArrayList<Switch>();
        if (swList != null) {
            for (Switch sw : swList) {
                if (!this.isNpvDevice(sw) || !sw.isVersionGreaterThanEqual("3.4(1)") || sw.isN5K()) continue;
                npvDeviceList.add(sw);
            }
        }
        return npvDeviceList;
    }

    public List<Switch> getNpivCapableSwitches(List<Switch> swList) {
        ArrayList<Switch> npivswList = new ArrayList<Switch>();
        if (swList != null) {
            for (Switch sw : swList) {
                if (!this.isNpivCapable(sw) || !this.isManageableByServer(sw)) continue;
                npivswList.add(sw);
            }
        }
        return npivswList;
    }

    public List<Switch> getNpivSwitches(List<Switch> swList) {
        ArrayList<Switch> npivswList = new ArrayList<Switch>();
        if (swList != null) {
            for (Switch sw : swList) {
                if (!this.isNpvCoreSwitch(sw)) continue;
                npivswList.add(sw);
            }
        }
        return npivswList;
    }

    public Set queryAssociatedNpvCores(List<NpvLinkBase> npvLinks, List<Switch> npvDevices) {
        if (npvLinks == null || npvDevices == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        HashSet<WwnKey> deviceSet = new HashSet<WwnKey>();
        for (Switch sw : npvDevices) {
            deviceSet.add(sw.getSwitchPK());
        }
        HashSet<WwnKey> coreSet = new HashSet<WwnKey>();
        for (NpvLinkBase link : npvLinks) {
            if (!deviceSet.contains(link.getEdgeSwitchPK())) continue;
            coreSet.add(link.getCoreSwitchPK());
        }
        return coreSet;
    }

    public List<SwitchBase> convertToSwitchBase(Collection<Switch> swList) {
        if (swList == null) {
            return null;
        }
        ArrayList<SwitchBase> swbList = new ArrayList<SwitchBase>();
        for (Switch sw : swList) {
            swbList.add(sw.getSwitchBase());
        }
        return swbList;
    }

    public FcPortBase queryPort(Map<SwitchBase, List<FcPortBase>> swPortMap, SwitchBase sw, int portIfIndex) {
        if (swPortMap == null || sw == null || portIfIndex < 0) {
            return null;
        }
        List<FcPortBase> ports = swPortMap.get(sw);
        if (ports == null) {
            return null;
        }
        for (FcPortBase port : ports) {
            if (portIfIndex != port.getIfIndex()) continue;
            return port;
        }
        return null;
    }

    public List<Fabric> getAllFabrics() {
        Fabric[] fabrics;
        ArrayList<Fabric> fabList = new ArrayList<Fabric>();
        for (Fabric fab : fabrics = ClientController.getInstance().getFabrics()) {
            fabList.add(fab);
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("getAllFabrics return: " + fabList));
        }
        return fabList;
    }

    public List<Switch> getSwitches(Fabric fab) {
        Switch[] switches;
        ArrayList<Switch> swList = new ArrayList<Switch>();
        for (Switch sw : switches = fab.getSwitches()) {
            swList.add(sw);
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("getAllSwitches return: " + swList));
        }
        return swList;
    }

    public List<Switch> getAllSwitches() {
        ArrayList<Switch> swList = new ArrayList<Switch>();
        List<Fabric> fabList = this.getAllFabrics();
        for (Fabric fab : fabList) {
            Switch[] switches;
            for (Switch sw : switches = fab.getSwitches()) {
                swList.add(sw);
            }
        }
        fabList.clear();
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("getAllSwitches return: " + swList));
        }
        return swList;
    }

    public List<Vsan> getVsans(Fabric fab) {
        ArrayList<Vsan> vsanList = new ArrayList<Vsan>();
        for (Vsan vsan : fab.getVsansCollection()) {
            vsanList.add(vsan);
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("getAllVsans return: " + vsanList));
        }
        return vsanList;
    }

    public List<Vsan> getAllVsans() {
        ArrayList<Vsan> vsanList = new ArrayList<Vsan>();
        List<Fabric> fabList = this.getAllFabrics();
        for (Fabric fab : fabList) {
            for (Vsan vsan : fab.getVsansCollection()) {
                vsanList.add(vsan);
            }
        }
        fabList.clear();
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("getAllVsans return: " + vsanList));
        }
        return vsanList;
    }

    public List<SnmpUserOpt> getSwitchUsers(List<Switch> swList) {
        ArrayList<SnmpUserOpt> swUserList = new ArrayList<SnmpUserOpt>();
        if (swList != null) {
            Fabric[] fabrics = ClientController.getInstance().getFabrics();
            boolean index = false;
            for (Switch sw : swList) {
                SnmpUserOpt swUser = null;
                for (Fabric fab : fabrics) {
                    if (fab.findSwitchByWwn(sw.getWwn()) == null) continue;
                    swUser = fab.getSnmpUserOpt();
                    break;
                }
                swUserList.add(swUser);
            }
            Object var3_3 = null;
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("getSwitchUsers swList:" + swList));
            _Logger.trace((Object)("getSwitchUsers swUserList:" + swUserList));
        }
        return swUserList;
    }

    public List<Switch> queryAllVsanSwitches(List<Switch> selectedNpvDevList, List<NpvPortPairCfg> npvPairCfgList) {
        ArrayList<Switch> swList = new ArrayList<Switch>();
        HashSet<Switch> swSet = new HashSet<Switch>();
        if (selectedNpvDevList != null) {
            swSet.addAll(selectedNpvDevList);
        }
        if (npvPairCfgList != null) {
            this.refreshSanSwMap();
            for (NpvPortPairCfg pcfg : npvPairCfgList) {
                Switch coreSw = this.querySwitchFromSAN(pcfg.getNpvCore());
                if (coreSw == null) {
                    _Logger.warn((Object)("Cannot query core switch object:" + pcfg.getNpvCore()));
                }
                swSet.add(coreSw);
            }
        }
        swList.addAll(swSet);
        Collections.sort(swList);
        swSet.clear();
        _Logger.debug((Object)("queryAllVsanSwitches return:" + swList));
        return swList;
    }

    public Map<Switch, List<FcPortBase>> queryAllPorts(List<Switch> selectedNpvDevList) throws Exception {
        HashMap<Switch, List<FcPortBase>> portSwMap = new HashMap<Switch, List<FcPortBase>>();
        TimeWatch timer = null;
        if (_Logger.isTraceEnabled()) {
            timer = new TimeWatch();
            timer.start();
            _Logger.trace((Object)"queryAllPorts");
        }
        List<SwitchBase> npvDevList = this.convertToSwitchBase(selectedNpvDevList);
        Map<SwitchBase, List<FcPortBase>> npvPM = this.findSwitchFcPortBase(npvDevList);
        for (Switch sw : selectedNpvDevList) {
            portSwMap.put(sw, npvPM.get(sw.getSwitchBase()));
        }
        npvDevList.clear();
        if (_Logger.isTraceEnabled() && timer != null) {
            timer.stop();
            _Logger.trace((Object)("queryAllPorts used time:" + timer.getTimeDisplay()));
        }
        _Logger.debug((Object)("queryAllPorts  return:" + portSwMap));
        return portSwMap;
    }

    public Map<Switch, List<Integer>> queryAllVFCIndexes(List<Switch> selectedNpvDevList) throws Exception {
        HashMap<Switch, List<Integer>> portSwMap = new HashMap<Switch, List<Integer>>();
        TimeWatch timer = null;
        if (_Logger.isTraceEnabled()) {
            timer = new TimeWatch();
            timer.start();
            _Logger.trace((Object)"queryAllVFCIndexes");
        }
        ArrayList<WwnKey> swPKs = new ArrayList<WwnKey>(selectedNpvDevList.size());
        for (Switch sw : selectedNpvDevList) {
            swPKs.add(sw.getSwitchPK());
        }
        Map<SwitchBase, List<Integer>> swVfcMap = ClientController.getInstance().assertModelFacade().findVFCIfIndices(swPKs);
        for (Switch sw : selectedNpvDevList) {
            portSwMap.put(sw, swVfcMap.get(sw.getSwitchBase()));
        }
        if (_Logger.isTraceEnabled() && timer != null) {
            timer.stop();
            _Logger.trace((Object)("queryAllVFCIndexes used time:" + timer.getTimeDisplay()));
        }
        _Logger.debug((Object)("queryAllVFCIndexes  return:" + portSwMap));
        return portSwMap;
    }

    public Map<Switch, List<Integer>> queryAllPortIndexes(List<Switch> selectedNpvDevList) throws Exception {
        HashMap<Switch, List<Integer>> portSwMap = new HashMap<Switch, List<Integer>>();
        TimeWatch timer = null;
        if (_Logger.isTraceEnabled()) {
            timer = new TimeWatch();
            timer.start();
            _Logger.trace((Object)"queryAllPortIndexes");
        }
        List<SwitchBase> npvDevList = this.convertToSwitchBase(selectedNpvDevList);
        Map<SwitchBase, List<Integer>> npvPM = this.findSwitchFcIndexes(npvDevList);
        for (Switch sw : selectedNpvDevList) {
            portSwMap.put(sw, npvPM.get(sw.getSwitchBase()));
        }
        npvDevList.clear();
        if (_Logger.isTraceEnabled() && timer != null) {
            timer.stop();
            _Logger.trace((Object)("queryAllPortIndexes used time:" + timer.getTimeDisplay()));
        }
        _Logger.debug((Object)("queryAllPortIndexes  return:" + portSwMap));
        return portSwMap;
    }

    public Map<Switch, List<FcPortBase>> queryAllVsanPorts(List<Switch> selectedNpvDevList, List<NpvPortPairCfg> npvPairCfgList, boolean includeNpvSw) throws Exception {
        HashMap<Switch, List<FcPortBase>> portSwMap = new HashMap<Switch, List<FcPortBase>>();
        if (selectedNpvDevList == null || npvPairCfgList == null) {
            return portSwMap;
        }
        TimeWatch timer = null;
        if (_Logger.isTraceEnabled()) {
            timer = new TimeWatch();
            timer.start();
            _Logger.trace((Object)"queryAllVsanPorts");
        }
        List<SwitchBase> npvDevList = this.convertToSwitchBase(selectedNpvDevList);
        Map<SwitchBase, List<FcPortBase>> npvPM = this.findSwitchFcPortBase(npvDevList);
        for (Switch sw : selectedNpvDevList) {
            if (includeNpvSw) {
                portSwMap.put(sw, npvPM.get(sw.getSwitchBase()));
                continue;
            }
            if (sw.isNpvEnabled()) continue;
            portSwMap.put(sw, npvPM.get(sw.getSwitchBase()));
        }
        npvDevList.clear();
        this.refreshSanSwMap();
        for (NpvPortPairCfg pair : npvPairCfgList) {
            List<FcPortBase> plist;
            SwitchBase swb = pair.getNpvCore();
            Switch sw = this.querySwitchFromSAN(swb);
            if (sw == null) {
                _Logger.warn((Object)("Cannot query switch object:" + swb));
                continue;
            }
            ArrayList<FcPortBase> npivPorts = (ArrayList<FcPortBase>)portSwMap.get(sw);
            if (npivPorts == null) {
                npivPorts = new ArrayList<FcPortBase>();
                if (includeNpvSw) {
                    portSwMap.put(sw, npivPorts);
                } else if (!sw.isNpivEnabled()) {
                    portSwMap.put(sw, npivPorts);
                }
            }
            if ((plist = pair.getCoreFPorts()) == null) continue;
            for (FcPortBase p : plist) {
                if (npivPorts.contains(p)) continue;
                npivPorts.add(p);
            }
        }
        if (_Logger.isTraceEnabled() && timer != null) {
            timer.stop();
            _Logger.trace((Object)("queryAllVsanPorts used time:" + timer.getTimeDisplay()));
        }
        _Logger.debug((Object)("queryAllVsanPorts  return:" + portSwMap));
        return portSwMap;
    }

    public Map<Switch, List<FcPortBase>> queryVsanPorts(List<Switch> selectedNpvDevList, boolean includeNpvSw) throws Exception {
        HashMap<Switch, List<FcPortBase>> portSwMap = new HashMap<Switch, List<FcPortBase>>();
        if (selectedNpvDevList == null) {
            return portSwMap;
        }
        TimeWatch timer = null;
        if (_Logger.isTraceEnabled()) {
            timer = new TimeWatch();
            timer.start();
            _Logger.trace((Object)"queryAllVsanPorts");
        }
        List<SwitchBase> npvDevList = this.convertToSwitchBase(selectedNpvDevList);
        Map<SwitchBase, List<FcPortBase>> npvPM = this.findSwitchFcPortBase(npvDevList);
        for (Switch sw : selectedNpvDevList) {
            if (includeNpvSw) {
                portSwMap.put(sw, npvPM.get(sw.getSwitchBase()));
                continue;
            }
            if (sw.isNpvEnabled()) continue;
            portSwMap.put(sw, npvPM.get(sw.getSwitchBase()));
        }
        npvDevList.clear();
        return portSwMap;
    }

    public List<Switch[]> queryConnectedPair(List<Switch> npvDevList, List<Switch> npvCoreList) {
        ArrayList<Switch[]> pairList = new ArrayList<Switch[]>();
        if (npvDevList == null || npvCoreList == null) {
            return pairList;
        }
        HashSet<Switch> npvDevSet = new HashSet<Switch>(npvDevList);
        for (Switch coreSw : npvCoreList) {
            Set<Switch> attachedSwitches = this.findAttachedSwitches(coreSw);
            for (Switch attSw : attachedSwitches) {
                if (!npvDevSet.contains(attSw)) continue;
                Switch[] pair = new Switch[]{attSw, coreSw};
                pairList.add(pair);
            }
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)"queryConnectedPair:");
            for (Switch[] pair : pairList) {
                _Logger.trace((Object)("Device-Core:" + pair[0] + "<--->" + pair[1]));
            }
        }
        _Logger.debug((Object)("queryConnectedPair return:" + pairList));
        return pairList;
    }

    public Set<Switch> findAttachedSwitches(Switch sw) {
        HashSet<Switch> attachedSwSet = new HashSet<Switch>();
        if (sw.isNpvEnabled() || sw.isFeatureEnabled(AbstractSwitchBase.Feature.NPIV.flag())) {
            NpvLink[] links = sw.getFabric().getNpvLinks();
            for (Isl isl : links) {
                if (isl != null && ((NpvLink)isl).getEdgeSwitch() != null && ((NpvLink)isl).getEdgeSwitch().equals(sw)) {
                    attachedSwSet.add(((NpvLink)isl).getCoreSwitch());
                    continue;
                }
                if (isl == null || ((NpvLink)isl).getCoreSwitch() == null || !((NpvLink)isl).getCoreSwitch().equals(sw)) continue;
                attachedSwSet.add(((NpvLink)isl).getEdgeSwitch());
            }
        }
        if (!sw.isNpvEnabled()) {
            Isl[] isls = sw.getFabric().getIsls();
            for (Isl isl : isls) {
                if (isl.getSwitch1().equals(sw)) {
                    attachedSwSet.add(isl.getSwitch2());
                    continue;
                }
                if (!isl.getSwitch2().equals(sw)) continue;
                attachedSwSet.add(isl.getSwitch1());
            }
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(sw + " findAttachedSwitches: " + attachedSwSet));
        }
        return attachedSwSet;
    }

    public Map<Switch, Set<Switch>> queryMaySegmentPairs(Map<Switch, Set<Switch>> selectedSwPairs, List<Switch> selectedNpvDeviceList) {
        HashMap<Switch, Set<Switch>> segmentPairs = new HashMap<Switch, Set<Switch>>();
        if (selectedNpvDeviceList == null || selectedNpvDeviceList.size() == 0) {
            return segmentPairs;
        }
        for (Switch npvDev : selectedNpvDeviceList) {
            if (npvDev.isNpvEnabled()) continue;
            Set<Switch> attachedSwSet = this.findAttachedSwitches(npvDev);
            Set<Switch> attachedCores = null;
            if (selectedSwPairs != null) {
                attachedCores = selectedSwPairs.get(npvDev);
            }
            if (attachedCores != null) {
                for (Switch core : attachedCores) {
                    attachedSwSet.remove(core);
                }
            }
            HashSet<Switch> removeMe = new HashSet<Switch>();
            for (Switch sw : attachedSwSet) {
                if (sw.getSwitchBase().isManageable()) continue;
                removeMe.add(sw);
            }
            for (Switch sw : removeMe) {
                attachedSwSet.remove(sw);
            }
            attachedSwSet.removeAll(selectedNpvDeviceList);
            if (attachedSwSet.size() <= 0) continue;
            segmentPairs.put(npvDev, attachedSwSet);
        }
        _Logger.debug((Object)("queryMaySegmentPairs: " + segmentPairs));
        return segmentPairs;
    }

    public List<Map<Switch, List<FcPortBase>>> getNpvPortSettings(List<NpvPortPairCfg> npvCfgList) throws Exception {
        ArrayList<Map<Switch, List<FcPortBase>>> portMaps = new ArrayList<Map<Switch, List<FcPortBase>>>();
        portMaps.add(new HashMap());
        portMaps.add(new HashMap());
        portMaps.add(new HashMap());
        portMaps.add(new HashMap());
        portMaps.add(new HashMap());
        if (npvCfgList == null || npvCfgList.size() == 0) {
            return portMaps;
        }
        TimeWatch timer = null;
        if (_Logger.isTraceEnabled()) {
            timer = new TimeWatch();
            timer.start();
            _Logger.trace((Object)("getNpvPortSettings npvCfgList:" + npvCfgList));
        }
        HashSet<SwitchBase> devSet = new HashSet<SwitchBase>();
        for (NpvPortPairCfg pcfg : npvCfgList) {
            Switch devSw = ClientController.findFabricSwitchByWwn(pcfg.getDevice().getWwn());
            Switch coreSw = ClientController.findFabricSwitchByWwn(pcfg.getNpvCore().getWwn());
            if (devSw == null || coreSw == null) {
                _Logger.warn((Object)("Cannot resolve switches of " + devSw + "," + coreSw));
                continue;
            }
            ArrayList<FcPortBase> npPorts = (ArrayList<FcPortBase>)((Map)portMaps.get(0)).get(devSw);
            if (pcfg.getNPPorts() != null && pcfg.getNPPorts().size() > 0) {
                if (npPorts == null) {
                    npPorts = new ArrayList<FcPortBase>();
                    ((Map)portMaps.get(0)).put(devSw, npPorts);
                }
                npPorts.addAll(pcfg.getNPPorts());
                devSet.add(pcfg.getDevice());
            }
            ArrayList<FcPortBase> oldNpPorts = (ArrayList<FcPortBase>)((Map)portMaps.get(3)).get(devSw);
            if (pcfg.getExistingNPPorts() != null && pcfg.getExistingNPPorts().size() > 0) {
                if (oldNpPorts == null) {
                    oldNpPorts = new ArrayList<FcPortBase>();
                    ((Map)portMaps.get(3)).put(devSw, oldNpPorts);
                }
                oldNpPorts.addAll(pcfg.getExistingNPPorts());
            }
            ArrayList<FcPortBase> npivPorts = (ArrayList<FcPortBase>)((Map)portMaps.get(1)).get(coreSw);
            if (pcfg.getCoreFPorts() == null || pcfg.getCoreFPorts().size() <= 0 || pcfg.getNPPorts() == null || pcfg.getNPPorts().size() <= 0) continue;
            if (npivPorts == null) {
                npivPorts = new ArrayList<FcPortBase>();
                ((Map)portMaps.get(1)).put(coreSw, npivPorts);
            }
            npivPorts.addAll(pcfg.getCoreFPorts());
        }
        ArrayList<SwitchBase> devList = new ArrayList<SwitchBase>();
        devList.addAll(devSet);
        Map<SwitchBase, List<FcPortBase>> portsOnDevices = this.findSwitchFcPortBase(devList);
        for (Map.Entry entry : ((Map)portMaps.get(0)).entrySet()) {
            List oldNpPorts;
            Switch devSw = (Switch)entry.getKey();
            List<FcPortBase> allPorts = portsOnDevices.get(devSw.getSwitchBase());
            HashSet npPortSet = new HashSet();
            if (entry.getValue() != null) {
                npPortSet.addAll((Collection)entry.getValue());
            }
            if ((oldNpPorts = (List)((Map)portMaps.get(3)).get(devSw)) != null) {
                npPortSet.addAll(oldNpPorts);
            }
            ArrayList<FcPortBase> fPorts = new ArrayList<FcPortBase>();
            for (FcPortBase p : allPorts) {
                if (npPortSet.contains(p)) continue;
                fPorts.add(p);
            }
            if (fPorts.size() > 0) {
                if (!devSw.isNpvEnabled()) {
                    ((Map)portMaps.get(2)).put(devSw, fPorts);
                }
                ((Map)portMaps.get(3)).put(devSw, fPorts);
            }
            allPorts.clear();
        }
        devList.clear();
        portsOnDevices.clear();
        devSet.clear();
        if (_Logger.isTraceEnabled()) {
            if (timer != null) {
                timer.stop();
                _Logger.trace((Object)("getNpvPortSettings used time:" + timer.getTimeDisplay()));
            }
            for (int i = 0; i < 4; ++i) {
                Iterator npivIt = ((Map)portMaps.get(1)).entrySet().iterator();
                if (i == 0) {
                    _Logger.trace((Object)"getNpvPortSettings npPorts:");
                } else if (i == 1) {
                    _Logger.trace((Object)"getNpvPortSettings autoPorts:");
                } else if (i == 2) {
                    _Logger.trace((Object)"getNpvPortSettings fPorts:");
                } else if (i == 3) {
                    _Logger.trace((Object)"getNpvPortSettings existing npPorts:");
                }
                for (Map.Entry entry : ((Map)portMaps.get(i)).entrySet()) {
                    _Logger.trace((Object)("Switch: " + entry.getKey() + " ports: size=" + ((List)entry.getValue()).size() + "list=" + entry.getValue()));
                }
            }
        }
        _Logger.debug((Object)("getPortSettings: " + portMaps));
        return portMaps;
    }

    public boolean queryNpvPortPairsfromIsls(Map<Switch, Set<Switch>> npvPairList, List<NpvPortPairCfg> npvPairCfgList) throws Exception {
        Array<Map<SwitchBase, List<FcPortBase>>> portMaps;
        if (npvPairList == null || npvPairList.size() == 0 || npvPairCfgList == null) {
            return false;
        }
        TimeWatch timer = null;
        if (_Logger.isTraceEnabled()) {
            timer = new TimeWatch();
            timer.start();
            _Logger.trace((Object)("queryNpvPortPairsfromIsls switchPairList:" + npvPairList));
        }
        if ((portMaps = this.getPortsOfNpvPair(npvPairList)).size() < 2) {
            throw new Exception("Cannot get ports of npv pairs");
        }
        Map<SwitchBase, List<FcPortBase>> npvDevMap = portMaps.elementAt(0);
        Map<SwitchBase, List<FcPortBase>> npvCoreMap = portMaps.elementAt(1);
        Set<Map.Entry<Switch, Set<Switch>>> pairSet = npvPairList.entrySet();
        boolean hasNoneISLPairs = false;
        for (Map.Entry<Switch, Set<Switch>> entry : pairSet) {
            Switch devSw = entry.getKey();
            Set<Switch> coreSwSet = entry.getValue();
            if (devSw.isNpvEnabled()) {
                hasNoneISLPairs = true;
                List<NpvLink> links = devSw.getFabric().findNpvLinksByNpvSwitchPK(devSw.getSwitchPK());
                if (links == null || links.size() <= 0) continue;
                HashMap<Switch, ArrayList<FcPortBase>> coreNpivPorts = new HashMap<Switch, ArrayList<FcPortBase>>();
                for (NpvLink link : links) {
                    Switch coreSw = link.getCoreSwitch();
                    if (!coreSwSet.contains(coreSw)) continue;
                    ArrayList<FcPortBase> npivPortList = (ArrayList<FcPortBase>)coreNpivPorts.get(coreSw);
                    if (npivPortList == null) {
                        npivPortList = new ArrayList<FcPortBase>();
                        coreNpivPorts.put(coreSw, npivPortList);
                    }
                    npivPortList.add(this.queryPort(npvCoreMap, coreSw.getSwitchBase(), link.getFPortIfIndex()));
                }
                Set entrySet = coreNpivPorts.entrySet();
                for (Map.Entry ent : entrySet) {
                    NpvPortPairCfg pair = new NpvPortPairCfg(devSw.getSwitchBase(), ((Switch)ent.getKey()).getSwitchBase());
                    pair.setCoreFPorts((List)ent.getValue());
                    npvPairCfgList.add(pair);
                }
                coreNpivPorts.clear();
                continue;
            }
            for (Switch coreSw : coreSwSet) {
                Array<Isl> isls = devSw.getFabric().findIslsBySwitches(devSw, coreSw);
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)("devSw, coreSw==>" + devSw + "----" + coreSw));
                    _Logger.trace((Object)("islsize ==>" + isls.size()));
                }
                NpvPortPairCfg pairCfg = new NpvPortPairCfg(devSw.getSwitchBase(), coreSw.getSwitchBase());
                npvPairCfgList.add(pairCfg);
                if (isls == null || isls.size() == 0) {
                    hasNoneISLPairs = true;
                    continue;
                }
                ArrayList<FcPortBase> npPorts = new ArrayList<FcPortBase>();
                ArrayList<FcPortBase> npivPorts = new ArrayList<FcPortBase>();
                for (int i = 0; i < isls.size(); ++i) {
                    Isl isl = isls.elementAt(i);
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)("isl ==>" + isl));
                    }
                    FcPortBase npPort = null;
                    FcPortBase npivPort = null;
                    if (isl.getSwitch1().equals(devSw)) {
                        npPort = this.queryPort(npvDevMap, isl.getSwitch1().getSwitchBase(), isl.getIfIndex1());
                        npivPort = this.queryPort(npvCoreMap, isl.getSwitch2().getSwitchBase(), isl.getIfIndex2());
                        if (npPort == null || npivPort == null) {
                            throw new IllegalArgumentException("Cannot resolve ISL with ports");
                        }
                    } else {
                        npPort = this.queryPort(npvDevMap, isl.getSwitch2().getSwitchBase(), isl.getIfIndex2());
                        npivPort = this.queryPort(npvCoreMap, isl.getSwitch1().getSwitchBase(), isl.getIfIndex1());
                        if (npPort == null || npivPort == null) {
                            throw new IllegalArgumentException("Cannot resolve ISL with ports");
                        }
                    }
                    if (!npPort.isPortLicensed() || !npivPort.isPortLicensed()) continue;
                    npPorts.add(npPort);
                    npivPorts.add(npivPort);
                }
                if (npPorts.size() == 0) {
                    hasNoneISLPairs = true;
                    continue;
                }
                pairCfg.setNPPorts(npPorts);
                pairCfg.setCoreFPorts(npivPorts);
            }
        }
        if (_Logger.isTraceEnabled() && timer != null) {
            timer.stop();
            _Logger.trace((Object)("queryNpvPortPairsfromIsls used time:" + timer.getTimeDisplay()));
        }
        _Logger.debug((Object)("queryNpvPortPairsfromIsls result:\n" + npvPairCfgList));
        return hasNoneISLPairs;
    }

    public ArrayList<Isl> queryPortChannelFromIsl(Map<Switch, Set<Switch>> npvPairList) throws Exception {
        ArrayList<Isl> pc = new ArrayList<Isl>();
        if (npvPairList == null || npvPairList.size() == 0) {
            return pc;
        }
        TimeWatch timer = null;
        if (_Logger.isTraceEnabled()) {
            timer = new TimeWatch();
            timer.start();
            _Logger.trace((Object)("queryPortChannel switchPairList:" + npvPairList));
        }
        Set<Map.Entry<Switch, Set<Switch>>> pairSet = npvPairList.entrySet();
        for (Map.Entry<Switch, Set<Switch>> entry : pairSet) {
            Switch devSw = entry.getKey();
            Set<Switch> coreSwSet = entry.getValue();
            for (Switch coreSw : coreSwSet) {
                Array<Isl> isls = devSw.getFabric().findIslsBySwitches(devSw, coreSw);
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)("devSw, coreSw==>" + devSw + "----" + coreSw));
                    _Logger.trace((Object)("islsize ==>" + isls.size()));
                }
                if (isls == null || isls.size() == 0) continue;
                for (int i = 0; i < isls.size(); ++i) {
                    Isl isl = isls.elementAt(i);
                    if (!isl.isPortChannel() && !isl.isFcipPortChannel()) continue;
                    pc.add(isl);
                }
            }
        }
        if (_Logger.isTraceEnabled() && timer != null) {
            timer.stop();
            _Logger.trace((Object)("queryPortChannel used time:" + timer.getTimeDisplay()));
        }
        return pc;
    }

    public ArrayList<FcPortBase> queryPortChannelPort(Map<Switch, Set<Switch>> npvPairList) throws Exception {
        String name;
        int type;
        List<FcPortBase> value;
        Array<Map<SwitchBase, List<FcPortBase>>> portMaps;
        ArrayList<FcPortBase> pc = new ArrayList<FcPortBase>();
        if (npvPairList == null || npvPairList.size() == 0) {
            return pc;
        }
        TimeWatch timer = null;
        if (_Logger.isTraceEnabled()) {
            timer = new TimeWatch();
            timer.start();
            _Logger.trace((Object)("queryNpvPortPairsfromIsls switchPairList:" + npvPairList));
        }
        if ((portMaps = this.getPortsOfNpvPair(npvPairList)).size() < 2) {
            throw new Exception("Cannot get ports of npv pairs");
        }
        Map<SwitchBase, List<FcPortBase>> npvDevMap = portMaps.elementAt(0);
        Map<SwitchBase, List<FcPortBase>> npvCoreMap = portMaps.elementAt(1);
        for (Map.Entry<SwitchBase, List<FcPortBase>> entry : npvDevMap.entrySet()) {
            SwitchBase sw = entry.getKey();
            value = entry.getValue();
            for (FcPortBase port : value) {
                type = IfIndexUtil.getType(port.getIfIndex());
                name = port.toString();
                if (IfIndexUtil.getType(port.getIfIndex()) != 4) continue;
                pc.add(port);
            }
        }
        for (Map.Entry<SwitchBase, List<FcPortBase>> entry : npvCoreMap.entrySet()) {
            value = entry.getValue();
            for (FcPortBase port : value) {
                type = IfIndexUtil.getType(port.getIfIndex());
                name = port.toString();
                if (IfIndexUtil.getType(port.getIfIndex()) != 4) continue;
                pc.add(port);
            }
        }
        if (_Logger.isTraceEnabled() && timer != null) {
            timer.stop();
            _Logger.trace((Object)("queryNpvPortPairsfromIsls used time:" + timer.getTimeDisplay()));
        }
        return pc;
    }

    public long enableSwitchNpivAsync(List<SwitchBase> swbList, List<SnmpUserOpt> swUserList, PtoPEventHandler handler) throws Exception {
        try {
            if (swbList == null || swUserList == null || handler == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            if (swbList.size() == 0) {
                throw new IllegalArgumentException("Switch list cannot be empty");
            }
            if (swbList.size() != swUserList.size()) {
                throw new IllegalArgumentException("Switches list size does not match with switch user list");
            }
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
                _Logger.trace((Object)("swEnableNpivAsync  switches:" + swbList));
                _Logger.trace((Object)("swEnableNpivAsync  users:" + swUserList));
            }
            long requestId = this.getNPVRif().enableNPVCoreFeature(swbList, swUserList, handler.getCommunicationObject());
            if (_Logger.isTraceEnabled() && timer != null) {
                timer.stop();
                _Logger.trace((Object)("swEnableNpivAsync used time(ms)" + timer.getTime()));
            }
            _Logger.debug((Object)("Send request to enable switch Npiv, Request Id = " + requestId));
            return requestId;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from enableSwitchNpivAsync:", (Throwable)e);
            throw e;
        }
    }

    public long enableSwitchNpvAsync(List<SwitchBase> swbList, List<SnmpUserOpt> swUserList, PtoPEventHandler handler) throws Exception {
        try {
            if (swbList == null || swUserList == null || handler == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            if (swbList.size() == 0) {
                throw new IllegalArgumentException("Switch list cannot be empty");
            }
            if (swbList.size() != swUserList.size()) {
                throw new IllegalArgumentException("Switches list size does not match with switch user list");
            }
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
                _Logger.trace((Object)("enableSwitchNpvAsync  switches:" + swbList));
                _Logger.trace((Object)("enableSwitchNpvAsync  users:" + swUserList));
            }
            long requestId = this.getNPVRif().enableNPVFeature(swbList, swUserList, handler.getCommunicationObject());
            if (_Logger.isTraceEnabled() && timer != null) {
                timer.stop();
                _Logger.trace((Object)("enableSwitchNpvAsync used time(ms)" + timer.getTime()));
            }
            _Logger.debug((Object)("Send request to enable switch NPV, Request Id = " + requestId));
            return requestId;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from enableSwitchNpvAsync:", (Throwable)e);
            throw e;
        }
    }

    public long saveSwitchCfgAsync(List<SwitchBase> swbList, List<SnmpUserOpt> swUserList, PtoPEventHandler handler) throws Exception {
        try {
            if (swbList == null || swUserList == null || handler == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            if (swbList.size() == 0) {
                throw new IllegalArgumentException("Switch list cannot be empty");
            }
            if (swbList.size() != swUserList.size()) {
                throw new IllegalArgumentException("Switches list size does not match with switch user list");
            }
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
                _Logger.trace((Object)("saveSwitchCfgAsync  switches:" + swbList));
                _Logger.trace((Object)("saveSwitchCfgAsync  users:" + swUserList));
            }
            long requestId = this.getNPVRif().saveRunningConfigOnSwitch(swbList, swUserList, handler.getCommunicationObject());
            if (_Logger.isTraceEnabled() && timer != null) {
                timer.stop();
                _Logger.trace((Object)("saveSwitchCfgAsyncc used time(ms)" + timer.getTime()));
            }
            _Logger.debug((Object)("Send request to save switch config, Request Id = " + requestId));
            return requestId;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from saveSwitchCfgAsync:", (Throwable)e);
            throw e;
        }
    }

    public long setPortTypeAsync(List<SwitchBase> swbList, List<SnmpUserOpt> swUserList, List<List<FcPortBase>> portLists, short portType, PtoPEventHandler handler) throws Exception {
        try {
            if (swbList == null || swUserList == null || portLists == null || handler == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            if (swbList.size() == 0) {
                throw new IllegalArgumentException("Switch list cannot be empty");
            }
            if (swbList.size() != swUserList.size() || swbList.size() != portLists.size()) {
                throw new IllegalArgumentException("Switches list size does not match with other list");
            }
            if (portType != 16 && portType != 2 && portType != 1) {
                throw new IllegalArgumentException("Only support F, NP, Auto type, invalid port type: " + portType);
            }
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
            }
            long requestId = 0L;
            String ptypeStr = "";
            switch (portType) {
                case 16: {
                    ptypeStr = "NP Port";
                    requestId = this.getNPVRif().setNPPorts(swbList, swUserList, portLists, handler.getCommunicationObject());
                    break;
                }
                case 2: {
                    ptypeStr = "F Port";
                    requestId = this.getNPVRif().setFPorts(swbList, swUserList, portLists, handler.getCommunicationObject());
                    break;
                }
                case 1: {
                    ptypeStr = "Auto Port";
                    requestId = this.getNPVRif().setPortsToAuto(swbList, swUserList, portLists, handler.getCommunicationObject());
                }
            }
            if (_Logger.isTraceEnabled()) {
                if (timer != null) {
                    timer.stop();
                    _Logger.trace((Object)("setPortTypeAsync used time(ms)" + timer.getTime()));
                }
                try {
                    _Logger.trace((Object)("setProtTypeAsync portype: " + ptypeStr));
                    for (int i = 0; i < swbList.size(); ++i) {
                        SwitchBase swb = swbList.get(i);
                        List<FcPortBase> ports = portLists.get(i);
                        _Logger.trace((Object)("setPortTypeAsync switch=" + swbList.get(i).getIpAddress() + ", users=" + swUserList.get(i) + ", ports=" + this.getPortsString(swb, ports)));
                    }
                }
                catch (Exception e) {
                    _Logger.trace((Object)e);
                }
            }
            _Logger.debug((Object)("send request to set port type on list of ports, Request Id = " + requestId));
            return requestId;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from setPortTypeAsync:", (Throwable)e);
            throw e;
        }
    }

    public long setPortsEnabledAsync(List<SwitchBase> swbList, List<SnmpUserOpt> swUserList, List<List<FcPortBase>> portLists, PtoPEventHandler handler) throws Exception {
        try {
            if (swbList == null || swUserList == null || portLists == null || handler == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            if (swbList.size() == 0) {
                throw new IllegalArgumentException("Switch list cannot be empty");
            }
            if (swbList.size() != swUserList.size() || swbList.size() != portLists.size()) {
                throw new IllegalArgumentException("Switches list size does not match with other list");
            }
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
                _Logger.trace((Object)("setPortsEnabledAsync  switches:" + swbList));
                _Logger.trace((Object)("setPortsEnabledAsync users:" + swUserList));
                _Logger.trace((Object)("setPortsEnabledAsync ports: " + portLists));
            }
            long requestId = this.getNPVRif().setPortsToEnable(swbList, swUserList, portLists, handler.getCommunicationObject());
            if (_Logger.isTraceEnabled() && timer != null) {
                timer.stop();
                _Logger.trace((Object)("setPortsEnabledAsync used time(ms)" + timer.getTime()));
            }
            _Logger.debug((Object)("send request to set port type on list of ports, Request Id = " + requestId));
            return requestId;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from setPortsEnabledAsync:", (Throwable)e);
            throw e;
        }
    }

    public long setFlexAttachMode(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, int mode, Object channelOrQueue) throws Exception {
        try {
            if (switches == null || snmpUserOpts == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            if (mode != 0 && mode != 1) {
                throw new IllegalArgumentException("Invalid WWN mode");
            }
            if (switches.size() != snmpUserOpts.size()) {
                throw new IllegalArgumentException("Switch list and user opt size do not match");
            }
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
                _Logger.trace((Object)("setFlexAttachWWNMode switches:" + switches));
                _Logger.trace((Object)("setFlexAttachWWNMode users:" + snmpUserOpts));
                _Logger.trace((Object)("setFlexAttachWWNMode WWN mode:" + mode));
            }
            long requestId = this.getNPVRif().setFlexAttachWWNMode(switches, snmpUserOpts, mode, channelOrQueue);
            if (_Logger.isTraceEnabled() && timer != null) {
                timer.stop();
                _Logger.trace((Object)("setFlexAttachWWNMode used time(ms)" + timer.getTime()));
            }
            _Logger.debug((Object)("send request to set WWN mode, Request Id = " + requestId));
            return requestId;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from setFlexAttachWWNMode:", (Throwable)e);
            throw e;
        }
    }

    public Map<SwitchBase, List<FcPortBase>> findSwitchFcPortBase(List<SwitchBase> swbList) throws Exception {
        try {
            if (swbList == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
                _Logger.trace((Object)("findSwitchFcPortBase switches:" + swbList));
            }
            Map<SwitchBase, List<FcPortBase>> swPortsMap = this.getNPVRif().findFcPortBase(swbList);
            if (_Logger.isTraceEnabled() && timer != null) {
                _Logger.trace((Object)("findSwitchFcPortBase used time:" + timer.getTimeDisplay()));
            }
            _Logger.debug((Object)("findSwitchFcPortBase return = " + swPortsMap));
            return swPortsMap;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from findSwitchFcPortBase:", (Throwable)e);
            throw e;
        }
    }

    public Map<SwitchBase, List<Integer>> findSwitchFcIndexes(List<SwitchBase> swbList) throws Exception {
        try {
            if (swbList == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
                _Logger.trace((Object)("findSwitchFcPortBase switches:" + swbList));
            }
            Map<SwitchBase, List<FcPortBase>> swPortsMap = this.getNPVRif().findFcPortBase(swbList);
            HashMap<SwitchBase, List<Integer>> swPortIndexMap = new HashMap<SwitchBase, List<Integer>>();
            for (SwitchBase sw : swPortsMap.keySet()) {
                List<FcPortBase> ports = swPortsMap.get(sw);
                ArrayList<Integer> ifIndexes = new ArrayList<Integer>();
                for (FcPortBase port : ports) {
                    if (port == null) continue;
                    ifIndexes.add(port.getIfIndex());
                }
                swPortIndexMap.put(sw, ifIndexes);
            }
            if (_Logger.isTraceEnabled() && timer != null) {
                _Logger.trace((Object)("findSwitchFcPortBase used time:" + timer.getTimeDisplay()));
            }
            _Logger.debug((Object)("findSwitchFcPortBase return = " + swPortsMap));
            return swPortIndexMap;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from findSwitchFcPortBase:", (Throwable)e);
            throw e;
        }
    }

    public List<List<FcPortBase>> queryFcPortBases(List<SwitchBase> swbList, List<List<SwitchIntKey>> portKeyList) throws Exception {
        try {
            if (swbList == null || portKeyList == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
                _Logger.trace((Object)("queryFcPortBases  switches:" + swbList));
                _Logger.trace((Object)("queryFcPortBases ports: " + portKeyList));
            }
            Map<SwitchBase, List<FcPortBase>> swPortsMap = this.findSwitchFcPortBase(swbList);
            if (_Logger.isTraceEnabled() && timer != null) {
                _Logger.trace((Object)("queryFcPortBasese used time:" + timer.getTimeDisplay()));
            }
            ArrayList<List<FcPortBase>> portLists = new ArrayList<List<FcPortBase>>();
            for (int i = 0; i < portKeyList.size(); ++i) {
                List<SwitchIntKey> swPortKeyList = portKeyList.get(i);
                SwitchBase sw = swbList.get(i);
                if (sw.getWwn() == null || !sw.getWwn().equals(swPortKeyList.get((int)0)._swPK._wwn)) {
                    throw new Exception("Switch List does not with port key list on index:" + i);
                }
                portLists.add(swPortsMap.get(sw));
            }
            swPortsMap.clear();
            if (_Logger.isTraceEnabled() && timer != null) {
                timer.stop();
                _Logger.trace((Object)("queryFcPortBases used time(ms)" + timer.getTime()));
            }
            _Logger.debug((Object)("queryFcPortBases from FMS:" + portLists));
            if (portLists == null || portLists.size() != portKeyList.size()) {
                _Logger.warn((Object)"Could not get valid ports from server.");
            }
            return portLists;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from  queryFcPortBases:", (Throwable)e);
            throw e;
        }
    }

    public long addSwitchesToVsanAsync(List<SwitchBase> swbList, List<SnmpUserOpt> swUserList, int vsanId, VsanBase vsanbase, PtoPEventHandler handler) throws Exception {
        try {
            if (swbList == null || swUserList == null || handler == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            if (swbList.size() == 0) {
                throw new IllegalArgumentException("Switch list cannot be empty");
            }
            if (swbList.size() != swUserList.size()) {
                throw new IllegalArgumentException("Switches list size does not match with switch user list");
            }
            if (vsanId < 1 || vsanId > 4096) {
                throw new IllegalArgumentException("Invalid vsan Id: " + vsanId);
            }
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
                _Logger.trace((Object)("addSwitchesToVsanAsync  switches:" + swbList));
                _Logger.trace((Object)("addSwitchesToVsanAsync users:" + swUserList));
            }
            long requestId = this.getNPVRif().addSwitchesToVsan(swbList, swUserList, vsanId, vsanbase, handler.getCommunicationObject());
            if (_Logger.isTraceEnabled() && timer != null) {
                timer.stop();
                _Logger.trace((Object)("addSwitchesToVsanAsync used time(ms)" + timer.getTime()));
            }
            _Logger.debug((Object)("Send request to add switches to VSAN, Request Id = " + requestId));
            return requestId;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from  addSwitchesToVsanAsync:", (Throwable)e);
            throw e;
        }
    }

    public long addPortsToVsanAsync(List<SwitchBase> swbList, List<SnmpUserOpt> swUserList, List<List<FcPortBase>> portLists, int vsanId, VsanBase vsanbase, PtoPEventHandler handler) throws Exception {
        try {
            if (swbList == null || swUserList == null || portLists == null || handler == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            if (swbList.size() == 0) {
                throw new IllegalArgumentException("Switch list cannot be empty");
            }
            if (swbList.size() != swUserList.size() || swbList.size() != portLists.size()) {
                throw new IllegalArgumentException("Switches list size does not match with other list");
            }
            if (vsanId < 1 || vsanId > 4096) {
                throw new IllegalArgumentException("Invalid vsan Id: " + vsanId);
            }
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
                _Logger.trace((Object)("addPortsToVsanAsyncc  switches:" + swbList));
                _Logger.trace((Object)("addPortsToVsanAsync  users:" + swUserList));
                _Logger.trace((Object)("addPortsToVsanAsync ports: " + portLists));
            }
            long requestId = this.getNPVRif().addPortsToVsan(swbList, portLists, swUserList, vsanId, vsanbase, handler.getCommunicationObject());
            if (_Logger.isTraceEnabled() && timer != null) {
                timer.stop();
                _Logger.trace((Object)("addPortsToVsanAsync used time(ms)" + timer.getTime()));
            }
            _Logger.debug((Object)("Send request to add ports to VSAN, Request Id = " + requestId));
            return requestId;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from addPortsToVsanAsync:", (Throwable)e);
            throw e;
        }
    }

    public long authenSwitchUsersAsync(List<SwitchBase> swbList, List<SnmpUserOpt> swUserList, PtoPEventHandler handler) throws Exception {
        try {
            if (swbList == null || swUserList == null || handler == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            if (swbList.size() != swUserList.size()) {
                throw new IllegalArgumentException("Sizes of switch list and user list do not match:" + swbList.size() + "," + swUserList.size());
            }
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
                _Logger.trace((Object)("authenSwitchUsersAsync  switches:" + swbList));
                _Logger.trace((Object)("authenSwitchUsersAsync  users:" + swUserList));
            }
            long requestId = this.getNPVRif().authenticateSwitch(swbList, swUserList, handler.getCommunicationObject());
            if (_Logger.isTraceEnabled() && timer != null) {
                timer.stop();
                _Logger.trace((Object)("authenSwitchUsersAsync used time(ms)" + timer.getTime()));
            }
            _Logger.debug((Object)("Send request to authenticate switch user, Request Id = " + requestId));
            return requestId;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from authenSwitchUsersAsync:", (Throwable)e);
            throw e;
        }
    }

    public Array<Map<SwitchBase, List<FcPortBase>>> getPortsOfNpvPair(Map<Switch, Set<Switch>> npvPairList) throws Exception {
        Array<Map<SwitchBase, List<FcPortBase>>> portMaps = new Array<Map<SwitchBase, List<FcPortBase>>>();
        try {
            if (npvPairList == null || npvPairList.size() == 0) {
                _Logger.warn((Object)"From getPortsOfNpvPair: npvPairList is empty");
                return portMaps;
            }
            List<SwitchBase> npvDevList = this.convertToSwitchBase(npvPairList.keySet());
            portMaps.addElement(this.findSwitchFcPortBase(npvDevList));
            HashSet<Switch> allCoreSet = new HashSet<Switch>();
            for (Set<Switch> swSet : npvPairList.values()) {
                if (swSet == null) continue;
                allCoreSet.addAll(swSet);
            }
            List<SwitchBase> npvCoreList = this.convertToSwitchBase(allCoreSet);
            portMaps.addElement(this.findSwitchFcPortBase(npvCoreList));
            allCoreSet.clear();
            return portMaps;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from getPortsOfNpvPair:", (Throwable)e);
            throw e;
        }
    }

    public List<NpvPortPairCfg> queryAutoNpvPairPortCfg(List<NpvPortPairCfg> pairs, int numberNPPorts) throws Exception {
        try {
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
                _Logger.trace((Object)("queryAutoNpvPairPortCfg input:" + pairs + ", " + numberNPPorts));
            }
            if (pairs == null || pairs.size() == 0) {
                return pairs;
            }
            List<NpvPortPairCfg> cfgList = this.getNPVRif().getNpvPairPortCfg(pairs, numberNPPorts);
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)("queryAutoNpvPairPortCfg used time:" + timer.getTimeDisplay()));
            }
            _Logger.debug((Object)("queryAutoNpvPairPortCfg return = " + cfgList));
            return cfgList;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from queryAutoNpvPairPortCfg:", (Throwable)e);
            throw e;
        }
    }

    public void refreshSanSwMap() {
        this.sanSwMap = new HashMap<SwitchBase, Switch>();
        ArrayList<Switch> swList = San.getInstance().getSwitches(null);
        for (Switch sw : swList) {
            this.sanSwMap.put(sw.getSwitchBase(), sw);
        }
    }

    public Switch querySwitchFromSAN(SwitchBase swb) {
        if (this.sanSwMap == null) {
            this.sanSwMap = new HashMap<SwitchBase, Switch>();
            ArrayList<Switch> swList = San.getInstance().getSwitches(null);
            for (Switch sw : swList) {
                this.sanSwMap.put(sw.getSwitchBase(), sw);
            }
        }
        return this.sanSwMap.get(swb);
    }

    private void clear() {
        if (this.sanSwMap != null) {
            this.sanSwMap.clear();
        }
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    public List<TrafficMap> getTrafficMap(Set<Switch> npvDev, SnmpUserOpt snmpUserOpt) throws Exception {
        if (npvDev == null || npvDev.size() < 1) {
            return new ArrayList<TrafficMap>();
        }
        List<TrafficMap> tMap = null;
        ArrayList<SwitchBase> switches = new ArrayList<SwitchBase>();
        ArrayList<SnmpUserOpt> snmpUserOpts = new ArrayList<SnmpUserOpt>();
        for (Switch sw : npvDev) {
            snmpUserOpts.add(snmpUserOpt);
            switches.add(sw.getSwitchBase());
        }
        try {
            tMap = this.getNPVRif().getTrafficMap(switches, snmpUserOpts);
        }
        catch (RemoteException re) {
            _Logger.equals(re.getMessage());
            throw new Exception(re);
        }
        return tMap;
    }

    public Map<Switch, Map> getCnpvServerIfTable(Set<Switch> npvDev, SnmpUserOpt snmpUserOpt) throws Exception {
        if (npvDev == null || npvDev.size() < 1) {
            return new HashMap<Switch, Map>();
        }
        ArrayList<SwitchBase> switches = new ArrayList<SwitchBase>();
        ArrayList<SnmpUserOpt> snmpUserOpts = new ArrayList<SnmpUserOpt>();
        for (Switch sw : npvDev) {
            snmpUserOpts.add(snmpUserOpt);
            switches.add(sw.getSwitchBase());
        }
        try {
            Map<SwitchBase, Map> results = this.getNPVRif().getCnpvServerIfTable(switches, snmpUserOpts);
            HashMap<Switch, Map> resultsToReturn = new HashMap<Switch, Map>();
            for (Switch sw : npvDev) {
                Map map = results.get(sw.getSwitchBase());
                resultsToReturn.put(sw, map);
            }
            return resultsToReturn;
        }
        catch (RemoteException re) {
            _Logger.equals(re.getMessage());
            throw new Exception(re);
        }
    }

    public long setTrafficMapAsync(List<SwitchBase> switches, List<TrafficMap> maps, List<SnmpUserOpt> swUserList, PtoPEventHandler handler) throws Exception {
        try {
            if (switches == null || swUserList == null || handler == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            if (switches.size() == 0) {
                throw new IllegalArgumentException("Switch list cannot be empty");
            }
            if (switches.size() != swUserList.size()) {
                throw new IllegalArgumentException("Switches list size does not match with switch user list");
            }
            TimeWatch timer = null;
            if (_Logger.isTraceEnabled()) {
                timer = new TimeWatch();
                timer.start();
                _Logger.trace((Object)("setTrafficMapAsync  switches:" + switches));
                _Logger.trace((Object)("setTrafficMapAsync users:" + swUserList));
            }
            long requestId = this.getNPVRif().setTrafficMap(switches, swUserList, maps, handler.getCommunicationObject());
            if (_Logger.isTraceEnabled() && timer != null) {
                timer.stop();
                _Logger.trace((Object)("setTrafficMapAsync used time(ms)" + timer.getTime()));
            }
            _Logger.debug((Object)("Send request to set traffic map, Request Id = " + requestId));
            return requestId;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Got exception from  setTrafficMapAsync:", (Throwable)e);
            throw e;
        }
    }

    public static int compare(FcPortBase port1, FcPortBase port2) {
        int index1 = port1.getIfIndex();
        int cardnum1 = (index1 >> 19 & 0x1F) + 1;
        int portnum1 = (index1 >> 12 & 0x7F) + 1;
        int index2 = port2.getIfIndex();
        int cardnum2 = (index2 >> 19 & 0x1F) + 1;
        int portnum2 = (index2 >> 12 & 0x7F) + 1;
        if (cardnum1 == cardnum2) {
            if (portnum1 == portnum2) {
                return 0;
            }
            if (portnum1 > portnum2) {
                return 1;
            }
            return -1;
        }
        if (cardnum1 > cardnum2) {
            return 1;
        }
        return -1;
    }

    public static int compare(int index1, int index2) {
        int cardnum1 = (index1 >> 19 & 0x1F) + 1;
        int portnum1 = (index1 >> 12 & 0x7F) + 1;
        int cardnum2 = (index2 >> 19 & 0x1F) + 1;
        int portnum2 = (index2 >> 12 & 0x7F) + 1;
        if (cardnum1 == cardnum2) {
            if (portnum1 == portnum2) {
                return 0;
            }
            if (portnum1 > portnum2) {
                return 1;
            }
            return -1;
        }
        if (cardnum1 > cardnum2) {
            return 1;
        }
        return -1;
    }

    public static boolean contains(List<Switch> sws, Switch sw) {
        for (Switch s : sws) {
            if (!s.equals(sw)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Set<Switch> sws, Switch sw) {
        for (Switch s : sws) {
            if (!s.equals(sw)) continue;
            return true;
        }
        return false;
    }

    public static void checkXternalIf(String value, Switch sw) throws Exception {
        int[] ifs = SnmpIntList.parse(value, sw);
        ArrayList<Integer> ifsList = new ArrayList<Integer>();
        for (int ifNext : ifs) {
            if (ifsList.contains(ifNext)) {
                throw new Exception("Duplicate entry found in the External Interface list: " + sw.ifIndexToName(ifNext) + ".\nPlease remove all duplicate entries.");
            }
            ifsList.add(ifNext);
        }
    }

    public static int[] checkIfs(String value, Switch sw) throws Exception {
        ArrayList<Integer> array = new ArrayList<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int ifIndex = sw.nameToIfIndex(token.trim());
            if (ifIndex == 0) {
                throw new Exception("Bad interface " + token.trim());
            }
            array.add(ifIndex);
        }
        int[] ret = new int[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            ret[i] = (Integer)array.get(i);
        }
        return ret;
    }

    public static Integer[] findPortIfIndexes(List<Integer> ports, Switch sw, String ifNames, boolean channelsOk) throws Exception {
        int[] ifIndexes = SnmpIntList.parse(ifNames, sw);
        ArrayList<Integer> retPorts = new ArrayList<Integer>();
        for (int ifI : ifIndexes) {
            String name;
            if (ports.contains(ifI)) {
                retPorts.add(ifI);
                continue;
            }
            if (channelsOk && ((name = sw.ifIndexToName(ifI)).startsWith("Channel") || name.startsWith("channel"))) {
                retPorts.add(ifI);
                continue;
            }
            throw new Exception("Bad interface " + ifNames);
        }
        return retPorts.toArray(new Integer[0]);
    }

    public static FcPortBase[] findPortBase(List<FcPortBase> ports, Switch sw, String ifNames) throws Exception {
        int[] ifIndexes = SnmpIntList.parse(ifNames, sw);
        ArrayList<FcPortBase> retPorts = new ArrayList<FcPortBase>();
        for (int ifI : ifIndexes) {
            FcPortBase fc = NpvClientHelper.findPortBase(ports, ifI);
            if (fc == null) {
                throw new Exception("Bad interface " + ifNames);
            }
            retPorts.add(fc);
        }
        return retPorts.toArray(new FcPortBase[0]);
    }

    public static FcPortBase findPortBase(List<FcPortBase> ports, int ifIndex) {
        for (FcPortBase port : ports) {
            if (port.getIfIndex() != ifIndex) continue;
            return port;
        }
        return null;
    }
}

