/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.view.CFSStaticTable;
import com.cisco.dcbu.sm.client.npv.view.NPVSwitchSelectTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AddNpvPeerDialog
extends JDialog
implements ActionListener {
    static final String TITLE = "Select switches to add as peers";
    JButton _closeBtn;
    JButton _okBtn;
    List<Switch> _npvDevices;
    Dimension _preferredSize = new Dimension(320, 300);
    NPVSwitchSelectTableModel _cfsModel;
    CFSStaticTable _cfsTable;
    List<Switch> _selectedSwitches;

    public AddNpvPeerDialog(JDialog parent, List<Switch> npvDevices) {
        super(parent, "Select switches to add as peers - " + ClientController.getInstance().getFabric().toString(), true);
        this._npvDevices = npvDevices;
        this.init();
        this.setSize(this._preferredSize);
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void init() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                AddNpvPeerDialog.this.onClose();
            }
        });
        this.setupPanel();
    }

    @Override
    public Dimension getPreferredSize() {
        return this._preferredSize;
    }

    private void onClose() {
        this.setVisible(false);
        this._selectedSwitches = new ArrayList<Switch>();
        this.dispose();
    }

    private void onOK() {
        this.setVisible(false);
        this._selectedSwitches = this._cfsModel.getSelectedSwitches();
        this.dispose();
    }

    public List<Switch> getSelectedSwitches() {
        return this._selectedSwitches;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.startsWith("C")) {
            this.onClose();
        } else if (cmd.startsWith("O")) {
            this.onOK();
        }
    }

    private void setupPanel() {
        this.setLayout(new BorderLayout());
        JPanel mainContentPanel = new JPanel(new BorderLayout());
        mainContentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel selectionPanel = new JPanel(new BorderLayout());
        selectionPanel.setBorder(BorderFactory.createEtchedBorder());
        this._cfsModel = new NPVSwitchSelectTableModel(this._npvDevices);
        this._cfsModel.setEditable(new boolean[]{true, false, false});
        this._cfsTable = new CFSStaticTable(this._cfsModel);
        this._cfsTable.setColumnWidth(new int[]{20, 20, 20});
        this._cfsTable.getTableHeader().setReorderingAllowed(true);
        this._cfsTable.setSelectionMode(2);
        JScrollPane scrollPanel = new JScrollPane(this._cfsTable);
        mainContentPanel.add((Component)scrollPanel, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(2));
        GridLayout gridLayout = new GridLayout(1, 2);
        gridLayout.setHgap(5);
        JPanel conPanel = new JPanel(gridLayout);
        this._okBtn = new JButton("Ok");
        this._okBtn.addActionListener(this);
        this._closeBtn = new JButton("Close");
        this._closeBtn.addActionListener(this);
        conPanel.add(this._okBtn);
        conPanel.add(this._closeBtn);
        btnPanel.add(conPanel);
        mainContentPanel.add((Component)btnPanel, "South");
        this.add((Component)mainContentPanel, "Center");
    }
}

