/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.lib.ui.table.ChangedBooleanCellRenderer;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.sm.client.npv.controller.SwitchActionTracker;
import com.cisco.dcbu.sm.client.npv.view.ActionTrackerRenderer;
import com.cisco.dcbu.sm.client.npv.view.BulkActionTableModel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class BulkActionTable
extends KTable {
    private static final Font TableFont = (Font)UIManager.getDefaults().get("Table.font");
    private static final String DefaultTitle = "Details";
    private static final String DefaultTooltip = "Click to see details";
    private static final String DefaultText = "";
    private BulkActionTableModel tm;
    protected String tooltip = "Click to see details";
    protected boolean actionEnabled = true;
    protected CellMouseListener cellListener;

    public BulkActionTable(BulkActionTableModel tm, boolean actionEnabled) {
        super(tm);
        this.tm = tm;
        this.actionEnabled = actionEnabled;
        this.setSelectionMode(0);
        this.setCellSelectionEnabled(true);
        this.setAutoResizeMode(4);
        this.getSelectionModel().addListSelectionListener(this);
        this.getTableHeader().addMouseListener(new HeaderListener());
        this.setSortable(true);
        this.addPopupMenu();
        ChangedBooleanCellRenderer booleanRenderer = new ChangedBooleanCellRenderer();
        this.setDefaultRenderer(Boolean.class, booleanRenderer);
        booleanRenderer.setHorizontalAlignment(0);
        ActionTrackerRenderer trackerRenderer = new ActionTrackerRenderer();
        this.setDefaultRenderer(SwitchActionTracker.class, trackerRenderer);
        this.cellListener = new CellMouseListener(DefaultTitle);
        if (actionEnabled) {
            this.addMouseListener(this.cellListener);
        }
    }

    public void setColumnWidth(int[] columnNumChars) {
        int cols = this.getColumnCount();
        if (cols > columnNumChars.length) {
            throw new IllegalArgumentException(DefaultText);
        }
        for (int i = 0; i < cols; ++i) {
            int width = this.calcColumnWidth(i, TableFont, columnNumChars[i]);
            this.setColumnWidth(i, width);
        }
    }

    public int calcColumnWidth(int col, Font font, int charLen) {
        FontMetrics fm = this.getFontMetrics(font);
        KTableModel model = (KTableModel)this.getModel();
        int widest = this.getHeaderColumnWidth(fm, col);
        char[] chars = new char[charLen];
        for (int i = 0; i < charLen; ++i) {
            chars[i] = 77;
        }
        int cwidth = fm.charsWidth(chars, 0, charLen - 1);
        if (widest < cwidth) {
            widest = cwidth;
        }
        return widest + 4;
    }

    public int calculateColumnWidth(int col, Font font, String str) {
        int cwidth;
        FontMetrics fm = this.getFontMetrics(font);
        KTableModel model = (KTableModel)this.getModel();
        int widest = this.getHeaderColumnWidth(fm, col);
        if (widest < (cwidth = fm.stringWidth(str))) {
            widest = cwidth;
        }
        return widest + 4;
    }

    public void setColumnWidth(int col, int width) {
        this.getColumnModel().getColumn(col).setPreferredWidth(width);
    }

    public boolean isActionEnabled() {
        return this.actionEnabled;
    }

    public void setActionEnabled(boolean actionEnabled) {
        if (this.actionEnabled == actionEnabled) {
            return;
        }
        if (actionEnabled) {
            this.addMouseListener(this.cellListener);
        } else {
            this.removeMouseListener(this.cellListener);
        }
        this.actionEnabled = actionEnabled;
    }

    public void setDisplayTitle(String displayTitle) {
        if (this.cellListener != null) {
            this.cellListener.setMsgTitle(displayTitle);
        }
    }

    public String getActionTooltip() {
        return this.tooltip;
    }

    public void setActionTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public BulkActionTableModel getBulkActionModel() {
        return this.tm;
    }

    public static String convertToHtml(String plainMessage) {
        if (plainMessage == null) {
            return DefaultText;
        }
        String str = plainMessage.toUpperCase();
        if (str.indexOf("<HTML>") >= 0) {
            plainMessage = plainMessage.replaceAll("\n", "<BR>");
            plainMessage = "<HTML><BODY>" + plainMessage + "</BODY></HTML>";
        }
        return plainMessage;
    }

    class CellMouseListener
    extends MouseAdapter {
        private String msgTitle;

        public CellMouseListener(String msgTitle) {
            this.msgTitle = msgTitle;
        }

        public String getMsgTitle() {
            return this.msgTitle;
        }

        public void setMsgTitle(String msgTitle) {
            this.msgTitle = msgTitle;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object src = e.getSource();
            if (src instanceof BulkActionTable) {
                String msg;
                BulkActionTable table = (BulkActionTable)src;
                Point point = e.getPoint();
                int viewColumn = table.columnAtPoint(point);
                int column = table.convertColumnIndexToModel(viewColumn);
                int row = table.rowAtPoint(point);
                if (column == BulkActionTableModel.Column.STATUS.ordinal() && e.getClickCount() == 1 && column != -1 && e.getButton() == 1 && (msg = table.getBulkActionModel().getResult(row)) != null && msg.length() > 1) {
                    JTextArea ta = new JTextArea(msg);
                    ta.setLineWrap(true);
                    ta.setEditable(false);
                    ta.setWrapStyleWord(true);
                    JScrollPane sp = new JScrollPane();
                    sp.getViewport().add(ta);
                    sp.setAutoscrolls(true);
                    sp.setPreferredSize(new Dimension(600, 350));
                    JOptionPane.showMessageDialog(table, sp, this.msgTitle, -1);
                }
            }
        }
    }
}

