/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.npv.controller.SwitchActionTracker;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BulkActionTableModel
extends KTableModel {
    public final int ColumnSize = Column.values().length;
    private Map<String, IndexEntry> actionIndex = new HashMap<String, IndexEntry>();
    private Map<SwitchBase, List<SwitchActionTracker>> targetIndex = new HashMap<SwitchBase, List<SwitchActionTracker>>();
    private List<SwitchActionTracker> trackerList;
    private int numAction;

    public BulkActionTableModel(String[] headers) {
        if (headers == null || Column.values().length != headers.length) {
            throw new IllegalArgumentException("headers does not match columns:" + headers);
        }
        this.setHeaders(headers);
        this.setEditable(new boolean[]{true, false, false, false});
        this.setData(new Array());
    }

    public void setActionCount(int cnt) {
        this.numAction = cnt;
    }

    public int getActionCount() {
        return this.numAction;
    }

    public void setActionData(List<SwitchActionTracker> actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Actions cannot be null");
        }
        this.trackerList = actions;
        this.clearData();
        Array<Object[]> tableData = new Array<Object[]>();
        this.setActionCount(actions.size());
        for (SwitchActionTracker action : actions) {
            List<SwitchActionTracker> list = this.targetIndex.get(action.getTarget());
            if (list == null) {
                list = new ArrayList<SwitchActionTracker>();
            }
            list.add(action);
            this.targetIndex.put(action.getTarget(), list);
        }
        this.actionIndex.clear();
        int row = 0;
        for (SwitchBase target : this.targetIndex.keySet()) {
            List<SwitchActionTracker> actList = this.targetIndex.get(target);
            Task acts = new Task(target, actList);
            Object[] rowData = new Object[this.ColumnSize];
            rowData[Column.TARGET.ordinal()] = target;
            rowData[Column.CONTENT.ordinal()] = this.getActionContent(actList);
            rowData[Column.STATUS.ordinal()] = acts;
            tableData.addElement(rowData);
            IndexEntry entry = new IndexEntry(target.getIpAddress(), row);
            this.actionIndex.put(target.getIpAddress(), entry);
            ++row;
        }
        this.setData(tableData);
        this.fireTableDataChanged();
    }

    public List<SwitchActionTracker> getActionData() {
        return this.trackerList;
    }

    @Override
    protected void performPostSorting() {
        this.fireTableDataChanged();
    }

    public void clearData() {
        Array tableData = this.getData();
        if (tableData == null) {
            return;
        }
        for (int i = 0; i < tableData.size(); ++i) {
            Object[] rowData = (Object[])tableData.elementAt(i);
            if (rowData == null) continue;
            for (int k = 0; k < rowData.length; ++k) {
                rowData[k] = null;
            }
        }
        tableData.clear();
        this.actionIndex.clear();
        Iterator<List<SwitchActionTracker>> it = this.targetIndex.values().iterator();
        while (it.hasNext()) {
            it.next().clear();
        }
        this.targetIndex.clear();
    }

    public String getActionId(SwitchActionTracker action) {
        return this.getActionTarget(action) + action.getContent();
    }

    public String getActionTarget(SwitchActionTracker action) {
        return action.getTarget().getIpAddress();
    }

    public Object getActionContent(SwitchActionTracker action) {
        return action.getContent();
    }

    public String getActionContent(List<SwitchActionTracker> list) {
        StringBuffer content = new StringBuffer();
        for (SwitchActionTracker action : list) {
            content.append(action.getContent() + "\n");
        }
        return content.toString();
    }

    public String getActionResult(SwitchActionTracker action) {
        List<Exception> errors;
        StringBuffer sb = new StringBuffer();
        sb.append("--" + action.getContent() + "--\n\n");
        if ((action.getStatus() == SwitchActionTracker.ERROR || action.getStatus() == SwitchActionTracker.FAILED || action.getStatus() == SwitchActionTracker.WARNING) && (errors = action.getErrors()) != null && errors.size() > 0) {
            sb.append("Got exceptions:\n");
            for (Exception error : errors) {
                sb.append(error.getMessage() == null ? error.toString() : Util.getErrorMessage(error));
                sb.append("\n");
            }
        }
        sb.append(action.getMessage() + "\n\n");
        return sb.toString();
    }

    public String getActionResult(Task task) {
        StringBuffer sb = new StringBuffer();
        List<SwitchActionTracker> actions = task.getTask();
        for (SwitchActionTracker action : actions) {
            sb.append(this.getActionResult(action));
        }
        return sb.toString();
    }

    public void updateAction(SwitchActionTracker action) {
        int row = this.findDataIndex(action);
        if (row >= 0 && row < this.getData().size()) {
            this.fireTableCellUpdated(row, Column.STATUS.ordinal());
        }
    }

    public int findDataIndex(SwitchActionTracker action) {
        return this.findDataIndex(action.getTarget().getIpAddress());
    }

    public int findDataIndex(String actionId) {
        IndexEntry entry = this.actionIndex.get(actionId);
        if (entry != null) {
            return entry.arrayIndex;
        }
        return -1;
    }

    public List<SwitchActionTracker> findActionByTarget(SwitchBase target) {
        return this.targetIndex.get(target);
    }

    public String getResult(int row) {
        if (row < 0 || row >= this.getData().size()) {
            return "";
        }
        Object[] rowData = (Object[])this.getData().elementAt(row);
        return this.getActionResult((Task)rowData[Column.STATUS.ordinal()]);
    }

    class IndexEntry {
        public String target;
        public int arrayIndex;

        public IndexEntry(String target, int index) {
            this.target = target;
            this.arrayIndex = index;
        }
    }

    public class Task {
        SwitchBase target;
        List<SwitchActionTracker> actions;
        String status = "";

        public Task(SwitchBase target, List<SwitchActionTracker> actions) {
            this.target = target;
            this.actions = actions;
        }

        public SwitchActionTracker.Status getStatus() {
            boolean inProgress = false;
            boolean success = false;
            boolean error = false;
            boolean unknown = false;
            boolean blank = false;
            int successCnt = 0;
            int defCnt = 0;
            for (SwitchActionTracker action : this.actions) {
                if (action.getStatus() == SwitchActionTracker.INPROGRESS || action.getStatus() == SwitchActionTracker.STARTED) {
                    inProgress = true;
                    continue;
                }
                if (action.getStatus() == SwitchActionTracker.SUCCESS) {
                    success = true;
                    ++successCnt;
                    continue;
                }
                if (action.getStatus() == SwitchActionTracker.FAILED || action.getStatus() == SwitchActionTracker.ERROR || action.getStatus() == SwitchActionTracker.WARNING) {
                    error = true;
                    continue;
                }
                if (action.getStatus() == SwitchActionTracker.UNKNOW) {
                    unknown = true;
                    continue;
                }
                blank = true;
                ++defCnt;
            }
            boolean debug = false;
            if (debug) {
                System.out.println("Unknown: " + unknown + " error: " + error + " inprogress: " + inProgress + " success: " + success);
            }
            if (error) {
                this.status = "Error";
                return SwitchActionTracker.ERROR;
            }
            if (inProgress) {
                this.status = "In progress";
                return SwitchActionTracker.INPROGRESS;
            }
            if (success) {
                if (successCnt == this.actions.size()) {
                    this.status = "Success";
                    return SwitchActionTracker.SUCCESS;
                }
                this.status = "In progress";
                return SwitchActionTracker.INPROGRESS;
            }
            if (unknown) {
                this.status = "Unknown";
                return SwitchActionTracker.UNKNOW;
            }
            this.status = "";
            return SwitchActionTracker.BLANK;
        }

        public SwitchBase getTarget() {
            return this.target;
        }

        public List<SwitchActionTracker> getTask() {
            return this.actions;
        }

        public String toString() {
            return this.status;
        }
    }

    public static enum Column {
        TARGET,
        CONTENT,
        STATUS;

    }
}

