/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SwitchChooserTableModel
extends KTableModel {
    public final int ColumnSize = Column.values().length;
    private Map<String, IndexEntry> swIndex = new HashMap<String, IndexEntry>();
    private Map<WwnKey, IndexEntry> keyIndex = new HashMap<WwnKey, IndexEntry>();

    public SwitchChooserTableModel(List<Switch> swList, String[] headers) {
        this.setHeaders(headers);
        this.updateSwitchList(swList);
    }

    public void updateSwitchList(Set<Switch> swList) {
        ArrayList<Switch> switches = new ArrayList<Switch>();
        for (Switch sw : swList) {
            switches.add(sw);
        }
        this.updateSwitchList(switches);
    }

    public void updateSwitchList(List<Switch> swList) {
        if (swList == null) {
            throw new IllegalArgumentException("swList cannot be null");
        }
        this.swIndex.clear();
        this.keyIndex.clear();
        Array<Object[]> swData = new Array<Object[]>();
        int index = 0;
        for (Switch sw : swList) {
            if (sw == null) continue;
            Object[] row = new Object[this.ColumnSize + 1];
            String name = this.getName(sw);
            row[Column.Select.ordinal()] = this.getInitialSelection(sw);
            row[Column.Name.ordinal()] = name;
            if (this.getHeaders().length > 2) {
                row[Column.IPAddr.ordinal()] = sw.getIpAddress();
                row[Column.State.ordinal()] = this.getInitialState(sw);
            }
            swData.addElement(row);
            IndexEntry entry = new IndexEntry(sw, index);
            this.swIndex.put(name, entry);
            this.keyIndex.put(sw.getSwitchPK(), entry);
            ++index;
        }
        this.setData(swData);
        this.fireTableDataChanged();
    }

    public void updateSwitchStates(Switch sw, String state) {
        int index = this.findDataIndex(sw);
        if (index > -1 && index < this.getData().size()) {
            Object[] row = (Object[])this.getData().elementAt(index);
            row[Column.State.ordinal()] = state;
            this.fireTableRowsUpdated(index, index);
        }
    }

    public void updatedSelectedSwitches(List<Switch> swList) {
        for (Switch sw : swList) {
            int index = this.findDataIndex(sw);
            if (index <= -1 || index >= this.getData().size()) continue;
            Object[] row = (Object[])this.getData().elementAt(index);
            row[Column.Select.ordinal()] = true;
        }
        this.fireTableDataChanged();
    }

    public void selectAllSwitches() {
        Array tdata = this.getData();
        for (int i = 0; i < tdata.size(); ++i) {
            Object[] objs = (Object[])tdata.elementAt(i);
            objs[Column.Select.ordinal()] = true;
        }
        this.fireTableDataChanged();
    }

    public void clearSwitchSelection() {
        Array tdata = this.getData();
        for (int i = 0; i < tdata.size(); ++i) {
            Object[] objs = (Object[])tdata.elementAt(i);
            objs[Column.Select.ordinal()] = false;
        }
        this.fireTableDataChanged();
    }

    public void setSelectedSwitches(List<Switch> swList) {
        if (swList == null || swList.size() < 1) {
            return;
        }
        for (int i = 0; i < this.getData().size(); ++i) {
            Object[] row = (Object[])this.getData().elementAt(i);
            row[Column.Select.ordinal()] = false;
        }
        for (Switch sw : swList) {
            int index = this.findDataIndex(sw);
            if (index <= -1 || index >= this.getData().size()) continue;
            Object[] row = (Object[])this.getData().elementAt(index);
            row[Column.Select.ordinal()] = true;
        }
        this.fireTableDataChanged();
    }

    public void setSelectedSwitchesOnKey(List<WwnKey> swKeyList) {
        for (WwnKey swKey : swKeyList) {
            int index = this.findDataIndex(swKey);
            if (index <= -1 || index >= this.getData().size()) continue;
            Object[] row = (Object[])this.getData().elementAt(index);
            row[Column.Select.ordinal()] = true;
        }
        this.fireTableDataChanged();
    }

    public List<Switch> getSelectedSwitches() {
        ArrayList<Switch> swList = new ArrayList<Switch>();
        Array tdata = this.getData();
        for (int i = 0; i < tdata.size(); ++i) {
            IndexEntry entry;
            Object[] objs = (Object[])tdata.elementAt(i);
            if (!((Boolean)objs[Column.Select.ordinal()]).booleanValue() || (entry = this.swIndex.get((String)objs[Column.Name.ordinal()])) == null) continue;
            swList.add(entry.sw);
        }
        return swList;
    }

    public boolean isSelected(int row) throws Exception {
        if (row >= 0 && row < this.getData().size()) {
            Object[] objs = (Object[])this.getData().elementAt(row);
            return (Boolean)objs[Column.Select.ordinal()];
        }
        throw new Exception("Invalid row: " + row);
    }

    public List<Switch> getSwitchesToEnableFeature() {
        ArrayList<Switch> swList = new ArrayList<Switch>();
        List<Switch> selectSwList = this.getSelectedSwitches();
        for (Switch sw : selectSwList) {
            if (this.isFeatureEnabled(sw)) continue;
            swList.add(sw);
        }
        return swList;
    }

    public Switch getSwitch(int index) {
        Object[] row;
        String name;
        IndexEntry entry;
        if (index > -1 && index < this.getData().size() && (entry = this.swIndex.get(name = (String)(row = (Object[])this.getData().elementAt(index))[Column.Name.ordinal()])) != null) {
            return entry.sw;
        }
        return null;
    }

    public int findDataIndex(Switch sw) {
        return this.findDataIndex(sw.getSwitchPK());
    }

    public int findDataIndex(WwnKey swKey) {
        IndexEntry entry = this.keyIndex.get(swKey);
        if (entry != null) {
            return entry.arrayIndex;
        }
        return -1;
    }

    public abstract boolean isFeatureEnabled(Switch var1);

    public String getInitialState(Switch sw) {
        return this.isFeatureEnabled(sw) ? "Enabled" : "Disabled";
    }

    public boolean getInitialSelection(Switch sw) {
        return false;
    }

    public String getState(Switch sw) {
        int index = this.findDataIndex(sw);
        if (index > -1 && index < this.getData().size()) {
            Object[] row = (Object[])this.getData().elementAt(index);
            return (String)row[Column.State.ordinal()];
        }
        return "";
    }

    public String getName(Switch sw) {
        return sw.getName();
    }

    class IndexEntry {
        public Switch sw;
        public int arrayIndex;

        public IndexEntry(Switch sw, int index) {
            this.sw = sw;
            this.arrayIndex = index;
        }
    }

    public static enum Column {
        Select,
        Name,
        IPAddr,
        State;

    }
}

