/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TEUsageTableModel
extends SnmpTableModel {
    Map<Switch, Map> usageMap;
    private Set<Switch> pNpvSws = new HashSet<Switch>();

    public TEUsageTableModel(Map<Switch, Map> usageMap) {
        this.setHeaders(new String[]{"NPV Device", "Server Interface", "External Interface"});
        this.usageMap = usageMap;
        this.updateUsageMap(usageMap);
    }

    public void updateUsageMap(Map<Switch, Map> usageMap) {
        if (usageMap == null) {
            throw new IllegalArgumentException("Traffic usage map cannot be null");
        }
        this.usageMap = usageMap;
        Array<Object[]> data = new Array<Object[]>();
        this.setData(data);
        for (Switch nextSwitch : usageMap.keySet()) {
            Map serverToExtMap = usageMap.get(nextSwitch);
            for (Integer serverIf : serverToExtMap.keySet()) {
                if (serverIf == null) continue;
                Integer externalIf = (Integer)serverToExtMap.get(serverIf);
                Object[] row = new Object[Column.values().length + 1];
                row[Column.NpvDevice.ordinal()] = nextSwitch;
                row[Column.ServerIf.ordinal()] = nextSwitch.ifIndexToName(serverIf);
                row[Column.ExternalIf.ordinal()] = nextSwitch.ifIndexToName(externalIf);
                data.addElement(row);
            }
        }
        this.setData(data);
        this.fireTableDataChanged();
    }

    public boolean isTableEmpty() {
        Array data = this.getData();
        int length = data.size();
        return length == 0;
    }

    public void removeAll() {
        Array data = this.getData();
        data.clear();
        this.fireTableDataChanged();
    }

    public static enum Column {
        NpvDevice,
        ServerIf,
        ExternalIf;

    }
}

