/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.wizard;

import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.SmPortSetCellEditor;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.client.npv.view.DropDownModel;
import com.cisco.dcbu.sm.client.npv.view.NPVPortCellEditor;
import com.cisco.dcbu.sm.client.npv.view.SwitchChooserTable;
import com.cisco.dcbu.sm.client.npv.view.SwitchChooserTableModel;
import com.cisco.dcbu.sm.client.npv.view.TETable;
import com.cisco.dcbu.sm.client.npv.view.TETableModel;
import com.cisco.dcbu.sm.client.npv.view.TEUsageTableModel;
import com.cisco.dcbu.sm.client.npv.wizard.TEModelListener;
import com.cisco.dcbu.sm.client.npv.wizard.TEWizard;
import com.cisco.dcbu.sm.common.dto.TrafficMap;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public class NPVTrafficEngStep
extends WizardPanel
implements ActionListener {
    public static final Logger logger = Logger.getLogger(NPVTrafficEngStep.class);
    public static final String Title = "Traffic Map & Load Balancing";
    public static final String Brief = "To setup traffic management map, choose a switch, server interface and external interface(s).  Click Add to create a new map row.  Then double click on the cells to make/update your selection.  To configure load balancing policy, click on Configure Load Balancing button to launch the dialog.";
    public static final String ERROR_PANEL = new String("Error Panel");
    public static final String BUSY_PANEL = new String("Busy Panel");
    public static final String TE_PANEL = new String("TE Panel");
    public static final String Note = "<html><font color=ff0000><b>  Note: Configuring traffic map can be disruptive, as it will be necessary to disable all server ports (while settings are changed) whose \"External Interface In Use\" has a value of \"N\\A\" or is not contained in the \"External Inteface\" list to be set.</b></font></html>";
    protected JButton lbBtn = new JButton("Configure Load Balancing...");
    protected JButton viewTrafficUsageBtn = new JButton("View Traffic Usage Mapping...");
    protected SwitchChooserTableModel lbTm;
    protected TEUsageTableModel usageTm;
    private List<Switch> previousLb;
    private boolean showError = false;
    private JPanel main;
    private JPanel teCard;
    private JPanel errCard;
    private JPanel busyCard;
    private CardLayout cardLayout;
    private TETableModel teModel;
    private TETable teTable;
    private JButton[] btns;
    private DropDownModel comboModel;
    protected NPVPortCellEditor serverIfCellEditor;
    protected NPVPortCellEditor extIfCellEditor;
    protected DefaultCellEditor comboEditor;
    private List<Switch> lbSwList;

    public NPVTrafficEngStep(TEWizard callingwizard) {
        super(Title, Brief, (JWizard)((Object)callingwizard), callingwizard.getIcon());
        this.init();
    }

    private void init() {
        this.cardLayout = new CardLayout();
        this.main = new JPanel(this.cardLayout);
        this.teCard = new JPanel(new BorderLayout());
        this.teCard.setBorder(DialogUtil._Margin);
        this.btns = new JButton[Actions.values().length];
        for (int i = 0; i < Actions.values().length; ++i) {
            this.btns[i] = new JButton(Actions.values()[i].getName());
            this.btns[i].setActionCommand(Actions.values()[i].getName());
        }
        this.teModel = new TETableModel(new ArrayList<TrafficMap>(), new HashSet<Switch>(), new HashMap<Switch, Map>());
        this.teModel.setData(new Array());
        this.teTable = new TETable(this.teModel);
        this.teTable.setColumnWidth(new int[]{8, 8, 20, 8});
        this.teTable.getTableHeader().setReorderingAllowed(false);
        this.teTable.setSelectionMode(2);
        JScrollPane sc = new JScrollPane(this.teTable);
        this.teCard.add((Component)sc, "Center");
        this.teModel.setEditable(new boolean[]{true, true, true, false});
        this.comboModel = new DropDownModel();
        TableColumnModel colModel = this.teTable.getColumnModel();
        colModel = this.teTable.getColumnModel();
        this.comboEditor = new DefaultCellEditor(new JComboBox(this.comboModel));
        colModel.getColumn(0).setCellEditor(this.comboEditor);
        PortEditorFilter ifEditorFilter = new PortEditorFilter(new int[]{1});
        this.serverIfCellEditor = new NPVPortCellEditor(this.teTable, new int[]{TETableModel.Column.ServerIf.ordinal()}, ifEditorFilter, false, SmPortSetCellEditor.SHOW_VFC_BMP);
        this.serverIfCellEditor.setPeerCol(0);
        this.serverIfCellEditor._portSetEditor.setShowIfPrefix(true);
        this.extIfCellEditor = new NPVPortCellEditor((JTable)this.teTable, new int[0], ifEditorFilter, true);
        this.extIfCellEditor.setPeerCol(0);
        this.extIfCellEditor._portSetEditor.setShowIfPrefix(true);
        colModel.getColumn(TETableModel.Column.ServerIf.ordinal()).setCellEditor(this.serverIfCellEditor);
        colModel.getColumn(TETableModel.Column.ExternalIf.ordinal()).setCellEditor(this.extIfCellEditor);
        new TEModelListener(this.teTable);
        JPanel actionPanelSouth = new JPanel(new FlowLayout(0));
        GridLayout gridLayout = new GridLayout(1, Actions.values().length);
        gridLayout.setHgap(5);
        JPanel btnPanel = new JPanel(gridLayout);
        Actions[] index = Actions.values();
        for (int i = 0; i < index.length; ++i) {
            btnPanel.add(this.btns[index[i].ordinal()]);
            this.btns[index[i].ordinal()].addActionListener(this);
        }
        this.lbTm = new SwitchChooserTableModel(new ArrayList(), new String[]{"Select", "NPV Device"}){

            @Override
            public boolean isFeatureEnabled(Switch sw) {
                return sw.isNpvEnabled();
            }
        };
        this.lbTm.setEditable(new boolean[]{true, false, false});
        final SwitchChooserTable lbTable = new SwitchChooserTable(this.lbTm);
        lbTable.setColumnWidth(new int[]{4, 25});
        this.lbBtn.addActionListener(new ActionListener(){
            JDialog lbDialog = null;
            List<Switch> origSelSwList = null;

            public void doCancel() {
                NPVTrafficEngStep.this.lbTm.clearSwitchSelection();
                NPVTrafficEngStep.this.lbTm.setSelectedSwitches(this.origSelSwList);
                this.lbDialog.dispose();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("OK".equals(e.getActionCommand())) {
                    this.lbDialog.dispose();
                } else if ("Cancel".equals(e.getActionCommand())) {
                    this.doCancel();
                } else {
                    this.lbDialog = new JDialog(NPVTrafficEngStep.this.getWizard(), "Load Balancing", true);
                    this.lbDialog.setDefaultCloseOperation(0);
                    JPanel lbMainPanel = new JPanel(new BorderLayout());
                    lbMainPanel.add((Component)new JScrollPane(lbTable), "Center");
                    lbMainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    JButton okBtn = new JButton("OK");
                    okBtn.setActionCommand("OK");
                    JButton cancelBtn = new JButton("Cancel");
                    cancelBtn.setActionCommand("Cancel");
                    okBtn.addActionListener(this);
                    cancelBtn.addActionListener(this);
                    GridLayout gridLayout = new GridLayout(1, 2);
                    gridLayout.setHgap(5);
                    JPanel dialogBtn = new JPanel(gridLayout);
                    dialogBtn.add(okBtn);
                    dialogBtn.add(cancelBtn);
                    JPanel centerPanel = new JPanel(new FlowLayout());
                    centerPanel.add(dialogBtn);
                    lbMainPanel.add((Component)new JLabel("Select switches you would like to enable load balancing policy."), "North");
                    lbMainPanel.add((Component)centerPanel, "South");
                    this.lbDialog.setContentPane(lbMainPanel);
                    this.origSelSwList = new ArrayList<Switch>();
                    this.origSelSwList.addAll(NPVTrafficEngStep.this.lbTm.getSelectedSwitches());
                    this.lbDialog.pack();
                    this.lbDialog.setLocationRelativeTo(NPVTrafficEngStep.this.getWizard());
                    this.lbDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            this.doCancel();
                        }
                    });
                    this.lbDialog.setVisible(true);
                }
            }
        });
        this.usageTm = new TEUsageTableModel(new HashMap<Switch, Map>());
        this.usageTm.setEditable(new boolean[]{false, false, false});
        final KTable usageTable = new KTable(this.usageTm);
        usageTable.setSortable(true);
        usageTable.getTableHeader().addMouseListener(new HeaderListener());
        this.viewTrafficUsageBtn.addActionListener(new ActionListener(){
            JDialog trafficUsageDialog = null;
            List<Switch> origSelSwList = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("OK".equals(e.getActionCommand())) {
                    this.trafficUsageDialog.dispose();
                } else {
                    this.trafficUsageDialog = new JDialog(NPVTrafficEngStep.this.getWizard(), "Traffic Usage", true);
                    this.trafficUsageDialog.setDefaultCloseOperation(0);
                    JPanel tmMainPanel = new JPanel(new BorderLayout());
                    tmMainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    tmMainPanel.add((Component)new JScrollPane(usageTable), "Center");
                    JButton okBtn = new JButton("OK");
                    okBtn.setActionCommand("OK");
                    okBtn.addActionListener(this);
                    GridLayout gridLayout = new GridLayout(1, 2);
                    gridLayout.setHgap(5);
                    JPanel dialogBtn = new JPanel(gridLayout);
                    dialogBtn.add(okBtn);
                    JPanel centerPanel = new JPanel(new FlowLayout());
                    centerPanel.add(dialogBtn);
                    JPanel textPanel = new JPanel(new GridLayout(3, 1));
                    textPanel.add(new JLabel("For each server interface you can see which external interface is currently being used."));
                    textPanel.add(new JLabel("Note:  Not all Traffic Engineering capable switches support this functionality."));
                    textPanel.add(new JLabel("If a switch isn't listed then the switch either doesn't have any server Interfaces up or it doesn't support getting the usage data."));
                    tmMainPanel.add((Component)textPanel, "North");
                    tmMainPanel.add((Component)centerPanel, "South");
                    this.trafficUsageDialog.setContentPane(tmMainPanel);
                    this.origSelSwList = new ArrayList<Switch>();
                    this.origSelSwList.addAll(NPVTrafficEngStep.this.lbTm.getSelectedSwitches());
                    this.trafficUsageDialog.pack();
                    this.trafficUsageDialog.setLocationRelativeTo(NPVTrafficEngStep.this.getWizard());
                    this.trafficUsageDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            trafficUsageDialog.dispose();
                        }
                    });
                    this.trafficUsageDialog.setVisible(true);
                }
            }
        });
        actionPanelSouth.add(btnPanel);
        JPanel lbPanel = new JPanel(new FlowLayout(0));
        lbPanel.add(this.lbBtn);
        lbPanel.add(this.viewTrafficUsageBtn);
        this.teCard.add((Component)lbPanel, "North");
        this.teCard.add((Component)actionPanelSouth, "South");
        this.errCard = new JPanel(new BorderLayout());
        this.busyCard = new JPanel(new BorderLayout());
        this.busyCard.add(new JLabel("Querying traffic map, please wait..."));
        this.main.add((Component)this.teCard, TE_PANEL);
        this.main.add((Component)this.errCard, ERROR_PANEL);
        this.add((Component)this.main, "Center");
        this.add((Component)new JLabel(Note), "South");
    }

    @Override
    public void doPrevious() {
        if (!this.serverIfCellEditor.stopCellEditing() || !this.extIfCellEditor.stopCellEditing()) {
            return;
        }
        this.comboEditor.stopCellEditing();
        this.previousLb = this.lbTm.getSelectedSwitches();
        super.doPrevious();
    }

    protected boolean checkTableEmpty() {
        return this.teModel.isTableEmpty();
    }

    protected boolean checkEmptyCell() {
        return this.teModel.hasEmptyCell();
    }

    protected void deleteEmptyCell() {
        this.teModel.deleteEmptyCell();
    }

    @Override
    public void doNext() {
        if (this.showError) {
            super.doNext();
            return;
        }
        if (!this.serverIfCellEditor.stopCellEditing() || !this.extIfCellEditor.stopCellEditing()) {
            return;
        }
        this.comboEditor.stopCellEditing();
        if (this.checkEmptyCell()) {
            if (JOptionPane.showConfirmDialog(this, "Empty cell(s) in the table will be deleted.  Would you like to continue?", this.getTitle(), 0) != 0) {
                return;
            }
            this.deleteEmptyCell();
        }
        List<TrafficMap> trafficMap = null;
        try {
            trafficMap = this.teModel.getTrafficMap();
            List<Switch> lbSws = this.lbTm.getSelectedSwitches();
            ArrayList<Switch> addList = new ArrayList<Switch>(lbSws);
            addList.removeAll(this.lbSwList);
            for (Switch lbSw : addList) {
                boolean found = false;
                for (TrafficMap tm : trafficMap) {
                    if (!lbSw.getPK().equals(tm.getSw().getPK())) continue;
                    tm.setEnableDisruptiveLoadBalance(true);
                    found = true;
                }
                if (found) continue;
                TrafficMap newMap = new TrafficMap(lbSw.getSwitchBase(), null, true);
                newMap.setEnableDisruptiveLoadBalance(true);
                trafficMap.add(newMap);
            }
            for (Switch lbSw : this.lbSwList) {
                boolean disabled = true;
                for (Switch selected : lbSws) {
                    if (!lbSw.getPK().equals(selected.getPK())) continue;
                    disabled = false;
                    break;
                }
                if (!disabled) continue;
                boolean found = false;
                for (TrafficMap tm : trafficMap) {
                    if (!lbSw.getPK().equals(tm.getSw().getPK())) continue;
                    tm.setEnableDisruptiveLoadBalance(false);
                    found = true;
                }
                if (found) continue;
                TrafficMap newMap = new TrafficMap(lbSw.getSwitchBase(), null, true);
                newMap.setEnableDisruptiveLoadBalance(false);
                trafficMap.add(newMap);
            }
            if (trafficMap.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No changes were made to the traffic map or the disruptive load balancing, \nplease make changes before clicking next.", this.getTitle(), 0);
                return;
            }
            ((TEWizard)((Object)this.getWizard())).getController().setTrafficMap(trafficMap);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this.getParent(), ex.getMessage() + "\n\n Traffic Map and Load Balancing cannot be configured.");
        }
        super.doNext();
    }

    @Override
    public String getTitle() {
        return Title;
    }

    @Override
    public boolean refresh() {
        ((TEWizard)((Object)this.getWizard())).updateStepTitle(false);
        final NPVTrafficEngStep me = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ((TEWizard)((Object)NPVTrafficEngStep.this.getWizard())).getController().queryTrafficMap(me);
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)me, ex.getMessage());
                }
            }
        });
        return super.refresh();
    }

    @Override
    public void actionFinished(boolean success) {
        if (this.getWizard() == null) {
            return;
        }
        this.getWizard().setCursor(success ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(3));
        this.getWizard().getNavigator().getNextBtn().setEnabled(success);
        this.getWizard().getNavigator().getBackBtn().setEnabled(success);
        for (JButton btn : this.btns) {
            btn.setEnabled(success);
        }
        this.lbBtn.setEnabled(success);
        this.teTable.setEnabled(success);
        this.viewTrafficUsageBtn.setEnabled(success);
    }

    public void showError(Exception ex) {
        this.errCard.removeAll();
        String htmlMsg = "<html><body>An error has occurred. " + Title + " is not available at this moment." + "<br>" + "Cause: " + ex.getMessage() + "</body></html>";
        logger.error((Object)("Traffic Map step not available: " + ex.getCause()));
        this.errCard.add(new JLabel(htmlMsg));
        this.cardLayout.show(this.main, ERROR_PANEL);
        this.showError = true;
    }

    public void doRefresh() {
        List<TrafficMap> trafficMap = null;
        this.showError = false;
        try {
            trafficMap = ((TEWizard)((Object)this.getWizard())).getController().getQueriedTMap();
            Map<Switch, Map> serverIfToExternalIfUsageMap = ((TEWizard)((Object)this.getWizard())).getController().getQueriedServerIfTableMap();
            if (trafficMap.size() < 1) {
                this.errCard.removeAll();
                this.errCard.add(new JLabel("<html><body>Please continue to the next step.  Traffic management options are available on switches version 3.4(1) or above.<br>There are no switches in this category.</body></html>"));
                logger.warn((Object)"TrafficMap is empty");
                this.cardLayout.show(this.main, ERROR_PANEL);
                this.showError = true;
                return;
            }
            ((TEWizard)((Object)this.getWizard())).getController().setOriginalTrafficMap(trafficMap);
            this.usageTm.updateUsageMap(serverIfToExternalIfUsageMap);
            Set<Switch> teCapableSw = ((TEWizard)((Object)this.getWizard())).getController().getTESelectedSwSet();
            this.teModel.updateTEMap(trafficMap, teCapableSw, serverIfToExternalIfUsageMap);
            NpvClientHelper helper = NpvClientHelper.getInstance();
            Map<Switch, List<Integer>> swPortMap = helper.queryAllPortIndexes(((TEWizard)((Object)this.getWizard())).getController().getTESelectedSwList());
            Map<Switch, List<Integer>> swVFCMap = helper.queryAllVFCIndexes(((TEWizard)((Object)this.getWizard())).getController().getTESelectedSwList());
            Map<Switch, List<Integer>> swVFCAndPortMap = this.buildPortAndVFCMap(swPortMap, swVFCMap);
            this.teModel.setIfs(swVFCAndPortMap);
            this.serverIfCellEditor.setIfs(swVFCAndPortMap);
            this.extIfCellEditor.setIfs(swPortMap);
            this.teModel.setChoices(new HashSet<Switch>(teCapableSw));
            this.serverIfCellEditor.setTrafficMap(trafficMap);
            this.serverIfCellEditor.setServerIfToExternalIfUsageMap(serverIfToExternalIfUsageMap);
            this.extIfCellEditor.setTrafficMap(trafficMap);
            this.comboModel.setChoices(new HashSet<Switch>(teCapableSw));
            this.lbTm.updateSwitchList(teCapableSw);
            HashMap<PKIf, Switch> swCache = new HashMap<PKIf, Switch>();
            for (Switch sw : teCapableSw) {
                swCache.put(sw.getPK(), sw);
            }
            List<Switch> oldList = this.lbSwList;
            this.lbSwList = new ArrayList<Switch>();
            for (TrafficMap tm : trafficMap) {
                if (!tm.isEnableDisruptiveLoadBalance()) continue;
                Switch sw = (Switch)swCache.get(tm.getSw().getPK());
                if (sw == null) {
                    throw new RuntimeException("Unable to find switchBase object");
                }
                this.lbSwList.add(sw);
            }
            ArrayList<Switch> selectThese = new ArrayList<Switch>(this.lbSwList);
            if (oldList != null) {
                for (Switch sw : oldList) {
                    selectThese.removeAll(oldList);
                }
            }
            if (this.previousLb != null) {
                selectThese.addAll(this.previousLb);
            }
            this.lbTm.setSelectedSwitches(selectThese);
            this.cardLayout.show(this.main, TE_PANEL);
        }
        catch (Exception ex) {
            this.showError(ex);
        }
    }

    private Map<Switch, List<Integer>> buildPortAndVFCMap(Map<Switch, List<Integer>> swPortMap, Map<Switch, List<Integer>> swVFCMap) {
        ArrayList<Integer> ports;
        HashMap<Switch, List<Integer>> swPortAndVFCMap = new HashMap<Switch, List<Integer>>();
        for (Switch sw : swPortMap.keySet()) {
            ports = new ArrayList<Integer>();
            swPortAndVFCMap.put(sw, ports);
            for (int port : swPortMap.get(sw)) {
                ports.add(port);
            }
        }
        for (Switch sw : swVFCMap.keySet()) {
            ports = swPortAndVFCMap.containsKey(sw) ? (List)swPortAndVFCMap.get(sw) : new ArrayList();
            swPortAndVFCMap.put(sw, ports);
            for (int port : swVFCMap.get(sw)) {
                ports.add(port);
            }
        }
        return swPortAndVFCMap;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (!this.serverIfCellEditor.stopCellEditing() || !this.extIfCellEditor.stopCellEditing()) {
            return;
        }
        this.comboEditor.stopCellEditing();
        if (ev.getSource().getClass().equals(JButton.class)) {
            String command = ev.getActionCommand();
            if (Actions.Add.name.equals(command)) {
                TETableModel model = (TETableModel)this.teTable.getModel();
                model.addNewRow();
                this.teTable.changeSelection(model.getData().size() - 1, 0, false, false);
            } else if (Actions.Del.name.equals(command)) {
                int[] rows = this.teTable.getSelectedRows();
                if (rows == null || rows.length < 1) {
                    Util.errorMessage((Component)this, "There are no selected row.");
                    return;
                }
                TETableModel model = (TETableModel)this.teTable.getModel();
                model.remove(rows);
            } else if (Actions.DelAll.name.equals(command)) {
                ((TETableModel)this.teTable.getModel()).removeAll();
            } else {
                logger.error((Object)("Invalid action command: " + command));
            }
        }
    }

    private static enum Actions {
        Add("Add"),
        Del("Delete"),
        DelAll("Delete all");

        private String name;

        private Actions(String n2) {
            this.name = n2;
        }

        public String getName() {
            return this.name;
        }
    }
}

