/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.wizard;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.controller.NpvSetupWizardController;
import com.cisco.dcbu.sm.client.npv.controller.SwitchActionTracker;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.client.npv.view.BulkActionTable;
import com.cisco.dcbu.sm.client.npv.view.BulkActionTableModel;
import com.cisco.dcbu.sm.client.npv.view.CollapsiblePanel;
import com.cisco.dcbu.sm.client.npv.view.LinkButton;
import com.cisco.dcbu.sm.client.npv.view.ProgressPanel;
import com.cisco.dcbu.sm.client.npv.view.SwitchRenderer;
import com.cisco.dcbu.sm.client.npv.view.TaskRenderer;
import com.cisco.dcbu.sm.client.npv.view.TextAreaRenderer;
import com.cisco.dcbu.sm.client.npv.wizard.NpvSetupWizard;
import com.cisco.dcbu.sm.common.dto.NpvPortPairCfg;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public class NpvCompleteStep
extends WizardPanel {
    public static final Logger _Logger = Logger.getLogger(NpvCompleteStep.class);
    public static final String StepTitle = "Complete NPV Setup";
    public static final String StepDesp = "Please review your configuration and click Finish to apply changes.";
    public static final String ConnLabel_Msg = "This table lists new NPV port pairs.  Please verify their physical connections.";
    public static final String ViewConn_Cmd = "cmd_ViewConn";
    private JPanel mp;
    private ProgressPanel progressPanel;
    private JLabel finalStatus;
    private LinkButton npvPortConnBtn;
    private BulkActionTable swEnableTable;
    private JPanel swEnablePanel;
    private CollapsiblePanel flexAttachPanel;
    private JPanel tablePanel;
    private CardLayout card;
    private JPanel bottomPanel;
    private ViewListener viewListener;

    public NpvCompleteStep() {
        super(StepTitle, StepDesp, NpvSetupWizard.NPV_ICON);
        this.initialize();
    }

    public BulkActionTableModel getSwitchFeatureEnableTableModel() {
        return this.swEnableTable.getBulkActionModel();
    }

    public ProgressPanel getProgressPanel() {
        return this.progressPanel;
    }

    @Override
    public boolean refresh() {
        try {
            ((NpvSetupWizard)this.getWizard()).updateStepTitle(false);
            List<SwitchActionTracker> actions = ((NpvSetupWizard)this.getWizard()).getController().createAllEnableFeatureAction();
            List<SwitchActionTracker> pActions = ((NpvSetupWizard)this.getWizard()).getController().createAllPortSetActoins();
            List<SwitchActionTracker> vActions = ((NpvSetupWizard)this.getWizard()).getController().createVSANSetActoins();
            actions.addAll(pActions);
            actions.addAll(vActions);
            this.swEnableTable.getBulkActionModel().setActionData(actions);
            this.card.last(this.bottomPanel);
            return super.refresh();
        }
        catch (Exception e) {
            Util.errorMessage((Component)this.getWizard(), e);
            return false;
        }
    }

    @Override
    public void doPrevious() {
        this.setDataValid(false);
        super.doPrevious();
    }

    @Override
    public String getTitle() {
        return StepTitle;
    }

    @Override
    public void doFinish() {
        try {
            super.doFinish();
            this.getWizard().getNavigator().getBackBtn().setEnabled(false);
            int actionCnt = this.getSwitchFeatureEnableTableModel().getActionCount();
            this.card.next(this.bottomPanel);
            this.progressPanel.setMaximum(actionCnt * 2);
            this.progressPanel.start();
            ((NpvSetupWizard)this.getWizard()).getController().runSetupApply(this);
            ClientController.getInstance().rediscover(((NpvSetupWizard)this.getWizard()).getController().getFabric());
        }
        catch (Exception e) {
            Util.errorMessage((Component)this.getWizard(), e);
        }
    }

    @Override
    public void actionFinished(boolean success) {
        try {
            if (success) {
                this.finalStatus.setText("All configurations have successfully applied");
            } else {
                this.finalStatus.setText("Cannot apply all configurations");
            }
            if (this.getWizard() != null && this.getWizard().isVisible()) {
                this.getWizard().getNavigator().getNextBtn().setVisible(false);
                this.getWizard().getNavigator().getBackBtn().setVisible(false);
                this.getWizard().getNavigator().getCancel().setText("Close");
                this.progressPanel.stop();
                if (!success) {
                    this.finalStatus.setForeground(Color.red);
                }
                this.card.last(this.bottomPanel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void doCancel() {
        if (((NpvSetupWizard)this.getWizard()).getController().isRunApply()) {
            String msg = "Wizard is applying new settings. Cancelling will stop making further changes but \nwill not roll back already applied configuration. \n\n\n Do you want to continue?";
            int option = JOptionPane.showConfirmDialog(this.getWizard(), msg, "Warning", 2, 3);
            if (option != 0) {
                return;
            }
            ((NpvSetupWizard)this.getWizard()).getController().setCanceled(true);
            _Logger.info((Object)"User interrupted NPV Wizard from applying new configurations.");
        }
        super.doCancel();
    }

    private void initialize() {
        this.viewListener = new ViewListener();
        BulkActionTableModel swEnableTm = new BulkActionTableModel(new String[]{"Switch", "Action", "Status"});
        this.swEnableTable = new BulkActionTable(swEnableTm, true);
        this.swEnableTable.setColumnWidth(new int[]{12, 50, 5});
        TextAreaRenderer strRenderer = new TextAreaRenderer();
        this.swEnableTable.setDefaultRenderer(String.class, strRenderer);
        TaskRenderer tRenderer = new TaskRenderer();
        this.swEnableTable.setDefaultRenderer(BulkActionTableModel.Task.class, tRenderer);
        SwitchRenderer sRenderer = new SwitchRenderer();
        this.swEnableTable.setDefaultRenderer(SwitchBase.class, sRenderer);
        JPanel tableView = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        Component[] tables = new Component[]{new JScrollPane(this.swEnableTable)};
        for (int i = 0; i < tables.length; ++i) {
            DialogUtil.constrain(tableView, tables[i], gbc, 0, i, 1, 18);
        }
        this.progressPanel = new ProgressPanel("process");
        this.progressPanel.setBorder(new EmptyBorder(8, 1, 1, 1));
        this.npvPortConnBtn = new LinkButton("View NPV Port Connections");
        this.npvPortConnBtn.addActionListener(this.viewListener);
        this.npvPortConnBtn.setActionCommand(ViewConn_Cmd);
        this.finalStatus = new JLabel("", 0);
        Font lfont = this.finalStatus.getFont();
        lfont = new Font(lfont.getName(), 1, lfont.getSize() + 1);
        this.finalStatus.setFont(lfont);
        JPanel labelPanel = new JPanel(new FlowLayout(0));
        labelPanel.add(this.finalStatus);
        JPanel btnPanel = new JPanel(new FlowLayout(0));
        btnPanel.add(this.npvPortConnBtn);
        JPanel viewp = new JPanel(new GridLayout(2, 1));
        viewp.add(labelPanel);
        viewp.add(btnPanel);
        this.card = new CardLayout();
        this.bottomPanel = new JPanel(this.card);
        this.bottomPanel.add("progress", this.progressPanel);
        this.bottomPanel.add("viewnpv", viewp);
        this.card.last(this.bottomPanel);
        this.mp = new JPanel(new BorderLayout());
        this.mp.setBorder(DialogUtil._Margin);
        this.mp.add((Component)tableView, "Center");
        this.mp.add((Component)this.bottomPanel, "South");
        this.add((Component)this.mp, "Center");
    }

    private int calcMaxRowHeight(List<SwitchActionTracker> actions, int width) {
        String maxLine = "";
        int maxLen = 0;
        int maxIdx = -1;
        for (int i = 0; i < actions.size(); ++i) {
            SwitchActionTracker action = actions.get(i);
            if (action.getContent().length() <= maxLen) continue;
            maxIdx = i;
            maxLen = action.getContent().length();
        }
        if (maxIdx != -1) {
            maxLine = actions.get(maxIdx).getContent();
        }
        int h = TextAreaRenderer.estimateRowHeight(maxLine, width);
        return h;
    }

    private void showConnections() {
        NPVConnTableModel connTm = new NPVConnTableModel();
        connTm.setHeaders(new String[]{"NPV Device", "NP Port", "NPIV Core Switch", "Auto Port"});
        connTm.updateConnections(((NpvSetupWizard)this.getWizard()).getController().getNpvPairCfgList());
        KTable npvConnTable = new KTable(connTm);
        npvConnTable.getTableHeader().addMouseListener(new HeaderListener());
        npvConnTable.setSortable(true);
        int[] colWidth = new int[]{25, 15, 25, 15};
        TableColumnModel tcm = npvConnTable.getColumnModel();
        for (int i = 0; i < colWidth.length; ++i) {
            tcm.getColumn(i).setPreferredWidth(colWidth[i] * 14);
        }
        JScrollPane sc = new JScrollPane(npvConnTable);
        JPanel p = new JPanel(new BorderLayout());
        JLabel label = new JLabel(NpvSetupWizardController.convertToHtml(ConnLabel_Msg), 2);
        p.add((Component)label, "North");
        p.add((Component)sc, "Center");
        JOptionPane.showMessageDialog(this, p, "NPV Connections", -1);
    }

    class NPVConnTableModel
    extends KTableModel {
        Array cfgList = new Array();

        public NPVConnTableModel() {
            this.setData(this.cfgList);
        }

        public void updateConnections(List<NpvPortPairCfg> npvList) {
            this.clearAll();
            if (npvList != null) {
                NpvClientHelper.getInstance().refreshSanSwMap();
                for (NpvPortPairCfg cfg : npvList) {
                    Switch devSw = NpvClientHelper.getInstance().querySwitchFromSAN(cfg.getDevice());
                    Switch coreSw = NpvClientHelper.getInstance().querySwitchFromSAN(cfg.getNpvCore());
                    List<FcPortBase> npPortList = cfg.getNPPorts();
                    List<FcPortBase> autoPortList = cfg.getCoreFPorts();
                    if (npPortList == null || autoPortList == null) continue;
                    int pairCnt = npPortList.size() < autoPortList.size() ? npPortList.size() : autoPortList.size();
                    for (int i = 0; i < pairCnt; ++i) {
                        this.addPair(devSw, coreSw, npPortList.get(i), autoPortList.get(i));
                    }
                }
            }
            this.fireTableDataChanged();
        }

        public void addPair(Switch npvDevice, Switch npvCore, FcPortBase npPort, FcPortBase autoPort) {
            String deviceName = null;
            String coreName = null;
            deviceName = npvDevice.getSysName() == null || npvDevice.getSysName().trim().equals("") ? npvDevice.getName() : (npvDevice.getSysName().equals(npvDevice.getIpAddress()) ? npvDevice.getSysName() : npvDevice.getSysName() + " (" + npvDevice.getIpAddress() + ")");
            coreName = npvCore.getSysName() == null || npvCore.getSysName().trim().equals("") ? npvCore.getName() : (npvCore.getSysName().equals(npvCore.getIpAddress()) ? npvCore.getSysName() : npvCore.getSysName() + " (" + npvCore.getIpAddress() + ")");
            this.getData().addElement(new String[]{deviceName, npvDevice.ifIndexToName(npPort.getIfIndex()), coreName, npvCore.ifIndexToName(autoPort.getIfIndex())});
        }

        public void deleteRow(int row) {
            this.getData().removeElementAt(row);
        }

        public void clearAll() {
            for (int i = 0; i < this.getData().size(); ++i) {
                Object[] elem = (Object[])this.getData().elementAt(i);
                if (elem == null) continue;
                for (int k = 0; k < elem.length; ++k) {
                    elem[k] = null;
                }
            }
            this.getData().clear();
        }
    }

    class ViewListener
    implements ActionListener {
        ViewListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            if (cmd.equals(NpvCompleteStep.ViewConn_Cmd)) {
                NpvCompleteStep.this.showConnections();
            }
        }
    }
}

