/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.wizard;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.view.SwitchChooserTable;
import com.cisco.dcbu.sm.client.npv.view.SwitchChooserTableModel;
import com.cisco.dcbu.sm.client.npv.wizard.NpvSetupWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class NpvDeviceSelectionStep
extends WizardPanel
implements ActionListener {
    public static final String StepTitle = "Select NPV Devices";
    public static final String StepDesp = "Select one or more NPV devices or NPV capable switches.\n\nNote: UCS switches currently block SNMP write-access and as such are excluded.";
    public static final String bootNote = "<html><font color=ff0000><b>Note: Please ensure boot variables are set before enabling NPV feature and that there are no port-channels configured.</b></font></html>";
    private JPanel mp;
    private SwitchChooserTableModel npvTm;
    private SwitchChooserTable npvTable;

    public NpvDeviceSelectionStep() {
        super(StepTitle, StepDesp, NpvSetupWizard.NPV_ICON);
        this.initialize();
    }

    public SwitchChooserTable getNPVTable() {
        return this.npvTable;
    }

    public SwitchChooserTableModel getNPVTableModel() {
        return this.npvTm;
    }

    public void setNPVTm(SwitchChooserTableModel npvTm) {
        this.npvTm = npvTm;
        this.npvTable.setModel(npvTm);
    }

    @Override
    public boolean refresh() {
        this.getNPVTableModel().updateSwitchList(((NpvSetupWizard)this.getWizard()).getController().getNpvCapableSwList());
        return super.refresh();
    }

    @Override
    public String getTitle() {
        return StepTitle;
    }

    @Override
    public void doNext() {
        List<Switch> npvSelectSwList = this.getNPVTableModel().getSelectedSwitches();
        if (npvSelectSwList.size() > 0) {
            ((NpvSetupWizard)this.getWizard()).getController().setNpvSelectedSwList(npvSelectSwList);
            List<Switch> npvToEnableSwList = this.getNPVTableModel().getSwitchesToEnableFeature();
            ((NpvSetupWizard)this.getWizard()).getController().setNpvEnablingSwList(npvToEnableSwList);
            if (npvToEnableSwList.size() > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append("The following switch(es) are going to be configured as NPV devices:\n");
                int cnt = 0;
                for (Switch sw : npvToEnableSwList) {
                    if (cnt % 5 == 4) {
                        sb.append("\n");
                    }
                    sb.append(sw.getIpAddress());
                    sb.append(",");
                    ++cnt;
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append("\n\n");
                sb.append("Enabling NPV on the switch will cause the switch to reboot. \n");
                sb.append("Please verify that the switch boot variables are set before continuing.\n");
                int option = JOptionPane.showConfirmDialog(this.npvTable, sb.toString(), "Warning", 2, 2);
                if (option != 0) {
                    this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                    this.getWizard().getNavigator().getBackBtn().setEnabled(true);
                    return;
                }
            }
            this.setDataValid(false);
            super.doNext();
        } else {
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
            this.getWizard().getNavigator().getBackBtn().setEnabled(true);
            Util.errorMessage((Component)this.getWizard(), new Exception("There are no NPV devices selected."));
        }
    }

    private void initialize() {
        this.mp = new JPanel(new BorderLayout());
        this.mp.setBorder(DialogUtil._Margin);
        this.npvTm = new SwitchChooserTableModel(new ArrayList(), new String[]{"Select", "NPV Device", "IP Address", "NPV State"}){

            @Override
            public boolean isFeatureEnabled(Switch sw) {
                return sw.isNpvEnabled();
            }
        };
        this.npvTm.setEditable(new boolean[]{true, false, false, false, false});
        this.npvTable = new SwitchChooserTable(this.npvTm){};
        this.npvTable.setColumnWidth(new int[]{6, 25, 15, 6});
        JLabel noteLabel = new JLabel(bootNote, 2);
        noteLabel.setBorder(new EmptyBorder(5, 1, 1, 1));
        JScrollPane sc = new JScrollPane(this.npvTable);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        JButton selectAllBtn = new JButton("Select All");
        selectAllBtn.addActionListener(this);
        selectAllBtn.setActionCommand("A");
        buttonPanel.add(selectAllBtn);
        JButton clearAllBtn = new JButton("Clear All");
        clearAllBtn.addActionListener(this);
        clearAllBtn.setActionCommand("C");
        buttonPanel.add(clearAllBtn);
        this.mp.add((Component)buttonPanel, "North");
        this.mp.add((Component)sc, "Center");
        this.mp.add((Component)noteLabel, "South");
        this.add((Component)this.mp, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char cmd = ((AbstractButton)e.getSource()).getActionCommand().charAt(0);
        switch (cmd) {
            case 'A': {
                if (this.npvTm == null) break;
                this.npvTm.selectAllSwitches();
                break;
            }
            case 'C': {
                if (this.npvTm == null) break;
                this.npvTm.clearSwitchSelection();
            }
        }
    }
}

