/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.wizard;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.npv.controller.SwitchActionTracker;
import com.cisco.dcbu.sm.client.npv.view.BulkActionTable;
import com.cisco.dcbu.sm.client.npv.view.BulkActionTableModel;
import com.cisco.dcbu.sm.client.npv.view.ProgressPanel;
import com.cisco.dcbu.sm.client.npv.view.SwitchRenderer;
import com.cisco.dcbu.sm.client.npv.view.TaskRenderer;
import com.cisco.dcbu.sm.client.npv.view.TextAreaRenderer;
import com.cisco.dcbu.sm.client.npv.wizard.CompleteStep;
import com.cisco.dcbu.sm.client.npv.wizard.TEWizard;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class TECompleteStep
extends WizardPanel
implements CompleteStep {
    public static final Logger _Logger = Logger.getLogger(TECompleteStep.class);
    public static final String StepTitle = "Complete Traffic Map Setup";
    public static final String StepDesp = "Please review your configuration and click Finish to apply changes.";
    private JPanel mp;
    private ProgressPanel progressPanel;
    private JLabel finalStatus;
    private BulkActionTable swEnableTable;
    private CardLayout card;
    private JPanel bottomPanel;

    public TECompleteStep(TEWizard wizard) {
        super(StepTitle, StepDesp, (JWizard)((Object)wizard), wizard.getIcon());
        this.initialize();
    }

    @Override
    public BulkActionTableModel getBulkActionTableModel() {
        return this.swEnableTable.getBulkActionModel();
    }

    @Override
    public ProgressPanel getProgressPanel() {
        return this.progressPanel;
    }

    @Override
    public boolean refresh() {
        try {
            ((TEWizard)((Object)this.getWizard())).updateStepTitle(false);
            List<SwitchActionTracker> actions = ((TEWizard)((Object)this.getWizard())).getController().createTESetActions();
            this.swEnableTable.getBulkActionModel().setActionData(actions);
            this.card.last(this.bottomPanel);
            return super.refresh();
        }
        catch (Exception e) {
            Util.errorMessage((Component)this.getWizard(), e);
            return false;
        }
    }

    @Override
    public void doPrevious() {
        this.setDataValid(false);
        super.doPrevious();
    }

    @Override
    public String getTitle() {
        return StepTitle;
    }

    @Override
    public void doFinish() {
        try {
            super.doFinish();
            this.getWizard().getNavigator().getBackBtn().setEnabled(false);
            int actionCnt = this.getBulkActionTableModel().getActionCount();
            this.card.next(this.bottomPanel);
            this.progressPanel.setMaximum(actionCnt * 2);
            this.progressPanel.start();
            ((TEWizard)((Object)this.getWizard())).getController().runSetupApply(this);
            ClientController.getInstance().rediscover(((TEWizard)((Object)this.getWizard())).getController().getFabric());
        }
        catch (Exception e) {
            Util.errorMessage((Component)this.getWizard(), e);
        }
    }

    @Override
    public void actionFinished(boolean success) {
        try {
            if (success) {
                this.finalStatus.setText("All configurations have successfully applied");
            } else {
                this.finalStatus.setText("Cannot apply all configurations");
            }
            if (this.getWizard() != null && this.getWizard().isVisible()) {
                this.getWizard().getNavigator().getNextBtn().setVisible(false);
                this.getWizard().getNavigator().getBackBtn().setVisible(false);
                this.getWizard().getNavigator().getCancel().setText("Close");
                this.progressPanel.stop();
                if (!success) {
                    this.finalStatus.setForeground(Color.red);
                }
                this.card.last(this.bottomPanel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void doCancel() {
        if (((TEWizard)((Object)this.getWizard())).getController().isRunApply()) {
            String msg = "Wizard is applying new settings. Cancelling will stop making further changes but \nwill not roll back already applied configuration. \n\n\n Do you want to continue?";
            int option = JOptionPane.showConfirmDialog(this.getWizard(), msg, "Warning", 2, 3);
            if (option != 0) {
                return;
            }
            ((TEWizard)((Object)this.getWizard())).getController().setCanceled(true);
            _Logger.info((Object)"User interrupted Traffic Map Wizard from applying new configurations.");
        }
        super.doCancel();
    }

    private void initialize() {
        BulkActionTableModel swEnableTm = new BulkActionTableModel(new String[]{"Switch", "Action", "Status"});
        this.swEnableTable = new BulkActionTable(swEnableTm, true);
        this.swEnableTable.setColumnWidth(new int[]{12, 50, 5});
        TextAreaRenderer strRenderer = new TextAreaRenderer();
        this.swEnableTable.setDefaultRenderer(String.class, strRenderer);
        TaskRenderer tRenderer = new TaskRenderer();
        this.swEnableTable.setDefaultRenderer(BulkActionTableModel.Task.class, tRenderer);
        SwitchRenderer sRenderer = new SwitchRenderer();
        this.swEnableTable.setDefaultRenderer(SwitchBase.class, sRenderer);
        JPanel tableView = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        Component[] tables = new Component[]{new JScrollPane(this.swEnableTable)};
        for (int i = 0; i < tables.length; ++i) {
            DialogUtil.constrain(tableView, tables[i], gbc, 0, i, 1, 18);
        }
        this.progressPanel = new ProgressPanel("process");
        this.progressPanel.setBorder(new EmptyBorder(8, 1, 1, 1));
        this.finalStatus = new JLabel("", 0);
        Font lfont = this.finalStatus.getFont();
        lfont = new Font(lfont.getName(), 1, lfont.getSize() + 1);
        this.finalStatus.setFont(lfont);
        JPanel labelPanel = new JPanel(new FlowLayout(0));
        labelPanel.add(this.finalStatus);
        JPanel btnPanel = new JPanel(new FlowLayout(0));
        JPanel viewp = new JPanel(new GridLayout(2, 1));
        viewp.add(labelPanel);
        viewp.add(btnPanel);
        this.card = new CardLayout();
        this.bottomPanel = new JPanel(this.card);
        this.bottomPanel.add("progress", this.progressPanel);
        this.bottomPanel.add("viewnpv", viewp);
        this.card.last(this.bottomPanel);
        this.mp = new JPanel(new BorderLayout());
        this.mp.setBorder(DialogUtil._Margin);
        this.mp.add((Component)tableView, "Center");
        this.mp.add((Component)this.bottomPanel, "South");
        this.add((Component)this.mp, "Center");
    }

    private int calcMaxRowHeight(List<SwitchActionTracker> actions, int width) {
        String maxLine = "";
        int maxLen = 0;
        int maxIdx = -1;
        for (int i = 0; i < actions.size(); ++i) {
            SwitchActionTracker action = actions.get(i);
            if (action.getContent().length() <= maxLen) continue;
            maxIdx = i;
            maxLen = action.getContent().length();
        }
        if (maxIdx != -1) {
            maxLine = actions.get(maxIdx).getContent();
        }
        int h = TextAreaRenderer.estimateRowHeight(maxLine, width);
        return h;
    }
}

