/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.pref;

import com.cisco.dcbu.lib.jnm.LogWriter;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.event.EventLog;
import com.cisco.dcbu.sm.client.pref.PrefSm;
import com.cisco.dcbu.sm.common.dto.LunDiscOS;
import java.awt.FlowLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrefSMSnmp
extends PrefSm {
    protected JCheckBox _enablePoll;
    protected KTextField _retryCount;
    protected KTextField _timeout;
    protected FieldPanel _pollInterval;
    protected FieldPanel _logSize;
    protected JComboBox _lunDisOS;
    static final int SNMP_PANEL = 1;
    static final int TRACE_SNMP = 2;
    static final int AUDIBLE_ALERT = 3;
    static final int LOG_BUF_SIZE = 4;
    static final int LUN_DISC_OS = 5;
    static final int NEXT_GUI_ITEM = 6;

    public PrefSMSnmp() {
        String[] labels = new String[6];
        this._values = new JComponent[labels.length];
        this._values[1] = this.buildSnmpPanel();
        this._values[2] = new JCheckBox("Trace SNMP packets in Log");
        this._values[3] = new JCheckBox("Enable Audible Alert when Event Received");
        this._logSize = new FieldPanel(new JLabel("Log Buffer: "), 8);
        this._values[4] = this._logSize;
        this._logSize.setText(Integer.toString(LogWriter.getMaxLines()));
        this._logSize.addGap();
        this._logSize.add(new JLabel("lines"));
        this._values[5] = this.buildLunDiscOSPanel();
        this._values[5].setVisible(false);
        DialogUtil.buildPanel(this, DialogUtil.buildLabels(labels), this._values);
        this._retryCount.setText(Integer.toString(ClientController.getInstance().getRetries()));
        this._timeout.setText(Integer.toString(ClientController.getInstance().getTimeout() / 1000));
        ((JCheckBox)this._values[2]).setSelected(SnmpSession.isTrace());
        ((JCheckBox)this._values[3]).setSelected(EventLog.getAudibleAlert());
        this._lunDisOS.setSelectedItem((Object)ClientController.getInstance().getLunDiscOS());
    }

    protected JPanel buildSnmpPanel() {
        JPanel p1 = new JPanel(new FlowLayout(0, 0, 0));
        p1.add(new JLabel("Retry requests "));
        this._retryCount = new KTextField(2);
        p1.add(this._retryCount);
        p1.add(new JLabel(" time(s) after "));
        this._timeout = new KTextField(3);
        p1.add(this._timeout);
        p1.add(new JLabel(" sec timeout"));
        return p1;
    }

    protected JPanel buildLunDiscOSPanel() {
        JPanel p1 = new JPanel(new FlowLayout(0, 2, 0));
        p1.add(new JLabel("Discover LUN by Host OS: "));
        LunDiscOS[] avOs = LunDiscOS._EnumValueTable;
        LunDiscOS[] validOs = new LunDiscOS[avOs.length - 1];
        for (int i = 0; i < validOs.length; ++i) {
            validOs[i] = avOs[i + 1];
        }
        this._lunDisOS = new JComboBox<LunDiscOS>(validOs);
        p1.add(this._lunDisOS);
        return p1;
    }

    @Override
    protected void updateValue() throws NumberFormatException {
        int timeout = Integer.parseInt(this._timeout.getText());
        if (timeout < 3 || timeout > 30) {
            this._timeout.grabFocus();
            throw new NumberFormatException("Choose a value between 3 and 30 for timeout");
        }
        ClientController.getInstance().setTimeout(timeout * 1000);
        int retries = Integer.parseInt(this._retryCount.getText());
        if (retries < 0 || retries > 5) {
            this._retryCount.grabFocus();
            throw new NumberFormatException("Choose a value between 0 and 5 for retries");
        }
        ClientController.getInstance().setRetries(retries);
        SnmpSession.setTrace(((JCheckBox)this._values[2]).isSelected());
        EventLog.setAudibleAlert(((JCheckBox)this._values[3]).isSelected());
        ClientController.getInstance().setLunDiscOS((LunDiscOS)((Object)this._lunDisOS.getSelectedItem()));
        LogWriter.setMaxLines(Integer.parseInt(this._logSize.getText()));
    }
}

