/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.pref;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.LogWriter;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.map.common.MultipleLinkHandler;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.ui.IdleTimeOut;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmHostTableModel;
import com.cisco.dcbu.sm.client.event.EventLog;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmCfsUtil;
import com.cisco.dcbu.sm.client.gui.UIControls;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.SwitchNode;
import com.cisco.dcbu.sm.client.map.actions.DMMapAction;
import com.cisco.dcbu.sm.client.map.actions.LayoutAction;
import com.cisco.dcbu.sm.client.map.actions.MiscMapActions;
import com.cisco.dcbu.sm.client.map.actions.OverViewMapAction;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.common.dto.LunDiscOS;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class SmPreferences {
    public static final String CONFIRM_ROW_DELETION = "ConfirmRowDeletion";
    public static final String SHOW_DEVICE_NAME_BY = "ShowDeviceNameBy";
    public static final String SHOW_WWN_VENDOR_BY = "ShowWWNVendorBy";
    public static final String WWN_VENDOR_BY = "WWNVendorBy";
    public static final String WWN_ALIAS = "WWNAlias";
    public static final String SHOW_ENCLOSURE = "ShowEnclosure";
    public static final String SHORT_ISCSI_NAME = "ShortIscsiName";
    public static final String SHOW_TIMESTAPMS_AS_DATE = "ShowTimestampsAsDate";
    public static final String TELNET_PATH = "mds.telnetClient";
    public static final String USE_SSH = "UseSSH";
    public static final String SSH_PATH = "SSHPath";
    public static final String EXPORT_FORMAT = "ExportFormat";
    public static final String CFS_WARNING = "CFSWarning";
    public static final String ALIASENCL_WARN = "AliasEnclWarning";
    public static final String LIC_SERVER = "mds.licenseServer";
    public static final String UNIX_BROWSER = "UnixBrowser";
    public static final String ENABLE_ROLLOVER_DOCKED_JIDE_FRAMES = "EnableRolloverDockedJideFrames";
    public static final String LOG_BUFFER_SIZE = "LogBufferSize";
    public static final String IDLE_TIME_OUT = "IdleTimeOut";
    public static final String SNMP_RETRIES = "SnmpRetries";
    public static final String SNMP_TIMEOUT = "SnmpTimeout";
    public static final String ENABLE_STATUS_POLLING = "EnableStatusPolling";
    public static final String POLLING_INTERVAL = "PollingInterval";
    public static final String REGISTER_FOR_TRAPS = "RegisterForTraps";
    public static final String AUDIBLE_ALTER = "AudibleAlert";
    public static final String TRACE_SNMP_PACKETS = "TraceSNMPPackets";
    public static final String LUN_DISC_OS = "LunDiscOs";
    public static final String SAVE_DISCOVERED_DATA = "SaveDiscoveredData";
    public static final String PROMPT_TO_SAVE = "PromptToSave";
    public static final String TRACE_TOPOLOGY_DISCOVERY = "TraceTopologyDiscovery";
    public static final String NON_MDS_READ = "NonMDSReadCommunity";
    public static final String NON_MDS_WRITE = "NonMDSWriteCommunity";
    public static final String DISPLAY_UNSELECTED_VSAN = "DisplayUnselectedVsan";
    public static final String DISPLAY_UNSELECTED_GROUP_MEMBERS = "DisplayUnselectedGroupMembers";
    public static final String DISPLAY_END_DEVICES = "DisplayEndDevices";
    public static final String DISPLAY_ISCSI = "DisplayISCSI";
    public static final String DISPLAY_TARGETS = "DisplayTargets";
    public static final String DISPLAY_INITIATORS = "DisplayInitiators";
    public static final String DISPLAY_END_DEVICE_LABELS = "DisplayEndDeviceLabels";
    public static final String EXPAND_LOOPS = "ExpandLoops";
    public static final String EXPAND_MULTI_LINKS = "ExpandMultipleLinks";
    public static final String OPEN_NEW_DM_EACH_TIME = "OpenNewDMEachTime";
    public static final String DEVICE_MANAGER_PORT = "DeviceManagerPort";
    public static final String SELECT_DEVICE_FROM_TABLE = "SelectDeviceFromTable";
    public static final String SHOW_GRID = "ShowGrid";
    public static final String MULTIPLE_LINK_SPACING = "MultipleLinkSpacing";
    public static final String DISPLAY_DOMAIN_ID_AS = "DisplayDomainIdAs";
    public static final String SHOW_MINOR_ALARMS_ON_LINKS = "ShowMinorAlarmsOnLinks";
    public static final String DISPLAY_KUBRICK_ICONS = "DisplayKubrickIcons";
    public static final String MAP_NODE_LIMIT = "MapNodeLimit";
    public static final String DISPLAY_NPV_SWITCHES = "DisplayNpvSwitches";
    public static final String PERFORM_LAYOUT_ON_NEW = "PerformLayoutOnNew";
    public static final String QUICK_LAYOUT_NODE_COUNT = "QuickLayoutNodeCount";
    public static final String OVERRIDE_PREFERENCES = "OverridePreferences";
    public static final String AUTOMATICALLY_SAVE_LAYOUT = "AutomaticallySaveLayout";
    public static final String DETACH_OVERVIEW = "DetachOverviewWindow";
    public static final String SIMPLEMODE = "SimpleMode";
    static final String FILENAME = "smpref.dat";
    static final String EMPTY_STRING = "";
    private static Properties _Properties = null;

    public static void load() {
        _Properties = ClientController.getInstance().loadPropertiesFromServer(ClientController.getInstance().getLoginDialogUserName() + ".pref", true);
        if (_Properties != null && _Properties.size() > 0) {
            String str = _Properties.getProperty(MULTIPLE_LINK_SPACING);
            if (str != null && str.length() > 0) {
                try {
                    MultipleLinkHandler.setClassSpacing(Double.parseDouble(str));
                }
                catch (NumberFormatException ex) {
                    DefaultLogger._ExLogger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            Iterator<Map.Entry<Object, Object>> itr = _Properties.entrySet().iterator();
            while (itr.hasNext()) {
                try {
                    Map.Entry<Object, Object> entry = itr.next();
                    String key = (String)entry.getKey();
                    String val = (String)entry.getValue();
                    SmPreferences.setProperty(key, val);
                }
                catch (Exception ex) {
                    DefaultLogger._ExLogger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        } else {
            DefaultLogger._ExLogger.debug((Object)("loadPropertiesFromServer(" + ClientController.getInstance().getLoginDialogUserName() + ".pref" + ") load skipped, properties is null/empty"));
            if (ClientController.getInstance().isSAAdmin()) {
                ClientController.getInstance().getPerspective("hostServerAdmin");
                SmMap.setDimNodeDisplayPolicy(2);
            }
        }
    }

    public static void setProperty(String name, String value) {
        if (name == null || name.length() == 0 || value == null || value.length() == 0) {
            return;
        }
        switch (name.charAt(0)) {
            case 'A': {
                if (name.equals(AUDIBLE_ALTER)) {
                    EventLog.setAudibleAlert(Boolean.valueOf(value));
                    break;
                }
                if (name.equals(AUTOMATICALLY_SAVE_LAYOUT)) {
                    SmMap.setAutoSaveLayout(Boolean.valueOf(value));
                    break;
                }
                if (!name.equals(ALIASENCL_WARN)) break;
                SmHostTableModel.setPromptAliasEnclosureFlag(Boolean.valueOf(value));
                break;
            }
            case 'C': {
                if (name.equals(CONFIRM_ROW_DELETION)) {
                    DataView._ConfirmRowDeletion = Boolean.valueOf(value);
                }
                if (!name.equals(CFS_WARNING)) break;
                SmCfsUtil._PromptCFSWarning = Boolean.valueOf(value);
                break;
            }
            case 'D': {
                if (name.equals(DISPLAY_UNSELECTED_VSAN)) {
                    if (ClientController.getInstance().isSAAdmin()) {
                        SmMap.setDimNodeDisplayPolicy(2);
                        break;
                    }
                    SmMap.setDimNodeDisplayPolicy(Integer.parseInt(value));
                    break;
                }
                if (name.equals(DISPLAY_UNSELECTED_GROUP_MEMBERS)) {
                    SmMap.setGroupDimNodeDisplayPolicy(Integer.parseInt(value));
                    break;
                }
                if (name.equals(DISPLAY_END_DEVICES)) {
                    SmMap.setDisplayEndDevices(Boolean.valueOf(value));
                    break;
                }
                if (name.equals(DISPLAY_ISCSI)) {
                    SmMap.setClassDisplayISCSI(Boolean.valueOf(value));
                    break;
                }
                if (name.equals(DISPLAY_TARGETS)) {
                    SmMap.setClassDisplayTargets(Boolean.valueOf(value));
                    break;
                }
                if (name.equals(DISPLAY_INITIATORS)) {
                    SmMap.setClassDisplayInitiators(Boolean.valueOf(value));
                    break;
                }
                if (name.equals(DISPLAY_END_DEVICE_LABELS)) {
                    SmMap.setDisplayNodeLabels(Boolean.valueOf(value));
                    break;
                }
                if (name.equals(DETACH_OVERVIEW)) {
                    OverViewMapAction.getInstance().setDetached(Boolean.valueOf(value));
                    break;
                }
                if (name.equals(DEVICE_MANAGER_PORT)) {
                    DMMapAction.setDmSocket(Integer.parseInt(value));
                    break;
                }
                if (name.equals(DISPLAY_DOMAIN_ID_AS)) {
                    SwitchNode.setDisplayDomainIdAsD(Integer.parseInt(value));
                    break;
                }
                if (name.equals(DISPLAY_KUBRICK_ICONS)) {
                    SmMap.setClassUseKubrickIcons(Boolean.valueOf(value), true);
                    break;
                }
                if (!name.equals(DISPLAY_NPV_SWITCHES)) break;
                SmMap.setClassDisplayNpvSwitches(Boolean.valueOf(value));
                break;
            }
            case 'E': {
                if (name.equals(EXPORT_FORMAT)) {
                    KTable._ExportAsXML = Boolean.valueOf(value);
                    break;
                }
                if (name.equals(EXPAND_LOOPS)) {
                    SmMap.setClassLoopsCollapsed(Boolean.valueOf(value) == false);
                    break;
                }
                if (name.equals(EXPAND_MULTI_LINKS)) {
                    SmMap.setClassMultiLinksCollapsed(Boolean.valueOf(value) == false);
                    break;
                }
                if (!name.equals(ENABLE_ROLLOVER_DOCKED_JIDE_FRAMES)) break;
                BrowserFrame.setShowRolloverDockedJideFrames(Boolean.valueOf(value));
                break;
            }
            case 'I': 
            case 'i': {
                if (!name.equals(IDLE_TIME_OUT)) break;
                IdleTimeOut.setTimeOutInterval(Integer.parseInt(value));
                break;
            }
            case 'L': {
                if (name.equals(LUN_DISC_OS)) {
                    ClientController.getInstance().setLunDiscOS(LunDiscOS._EnumValueTable[Integer.parseInt(value)]);
                    break;
                }
                if (!name.equals(LOG_BUFFER_SIZE)) break;
                LogWriter.setMaxLines(Integer.parseInt(value));
                break;
            }
            case 'M': 
            case 'm': {
                if (name.equals(LIC_SERVER)) {
                    String setV = System.getProperty(LIC_SERVER, EMPTY_STRING);
                    if (setV != null && !setV.equals(EMPTY_STRING)) break;
                    System.setProperty(LIC_SERVER, value);
                    break;
                }
                if (name.equals(TELNET_PATH)) {
                    if (value.indexOf("host") == -1) {
                        value = value.concat(" $host");
                    }
                    ExternalTools._TelnetClient = value;
                    break;
                }
                if (!name.equals(MAP_NODE_LIMIT)) break;
                SmMap.setMapNodeLimit(Integer.parseInt(value));
                break;
            }
            case 'O': {
                if (name.equals(OPEN_NEW_DM_EACH_TIME)) {
                    DMMapAction.setNewWinDM(Boolean.valueOf(value));
                    break;
                }
                if (!name.equals(OVERRIDE_PREFERENCES)) break;
                SmMap.setOverridePreferences(Boolean.valueOf(value));
                break;
            }
            case 'P': {
                if (!name.equals(PERFORM_LAYOUT_ON_NEW)) break;
                SmMap.setLayoutNewDevices(Boolean.valueOf(value));
                break;
            }
            case 'Q': {
                if (!name.equals(QUICK_LAYOUT_NODE_COUNT)) break;
                LayoutAction.setQuickLayoutNodeCount(Integer.parseInt(value));
                break;
            }
            case 'R': {
                break;
            }
            case 'S': {
                if (name.equals(SHOW_DEVICE_NAME_BY)) {
                    SnmpPeer.setShowNameBy(Integer.parseInt(value));
                    break;
                }
                if (name.equals(SHOW_WWN_VENDOR_BY)) {
                    WwnDictionary.setEnabled(Boolean.valueOf(value));
                    break;
                }
                if (name.equals(SHOW_TIMESTAPMS_AS_DATE)) {
                    SnmpTimeticks._ShowDateTime = Boolean.valueOf(value);
                    break;
                }
                if (name.equals(SSH_PATH)) {
                    ExternalTools._SSHPath = value;
                    break;
                }
                if (name.equals(SNMP_RETRIES)) {
                    ClientController.getInstance().setRetries(Integer.parseInt(value));
                    break;
                }
                if (name.equals(SNMP_TIMEOUT)) {
                    ClientController.getInstance().setTimeout(Integer.parseInt(value));
                    break;
                }
                if (name.equals(SELECT_DEVICE_FROM_TABLE)) {
                    DataView._SelectMapFrmTable = Boolean.valueOf(value);
                    break;
                }
                if (name.equals(SHOW_GRID)) {
                    MiscMapActions.setGridEnabled(Boolean.valueOf(value));
                    break;
                }
                if (name.equals(SHOW_ENCLOSURE)) {
                    EndPort.setAppendEnclosure(Boolean.valueOf(value));
                    break;
                }
                if (name.equals(SHORT_ISCSI_NAME)) {
                    EndPort._ShowShortIscsiName = Boolean.valueOf(value);
                    break;
                }
                if (name.equals(SIMPLEMODE)) {
                    if (ClientController.getInstance().isSAAdmin()) {
                        ClientController.getInstance().getPerspective("hostServerAdmin");
                        BrowserFrame.getInstance().updatePerspectiveView();
                        break;
                    }
                    boolean savedSimpleMode = Boolean.valueOf(value);
                    if (UIControls.getInstance().getPerspectiveName().equalsIgnoreCase("simple") != savedSimpleMode) {
                        UIControls.getInstance().setSimpleMode(savedSimpleMode, true);
                        BrowserFrame.getInstance().updatePerspectiveView();
                        break;
                    }
                    UIControls.getInstance().setSimpleMode(savedSimpleMode, true);
                    break;
                }
                if (!name.equals(SHOW_MINOR_ALARMS_ON_LINKS)) break;
                SmMap.setDisplayMinorAlarmsOnLinks(Boolean.valueOf(value), true);
                break;
            }
            case 'T': {
                if (!name.equals(TRACE_TOPOLOGY_DISCOVERY)) break;
                ClientController.setTrace(Boolean.valueOf(value));
                break;
            }
            case 'W': {
                if (!name.equals(WWN_VENDOR_BY)) break;
                WwnDictionary.setPrepend(Boolean.valueOf(value));
                break;
            }
            case 'U': 
            case 'u': {
                if (name.equals(USE_SSH)) {
                    ExternalTools._UseSSH = Boolean.valueOf(value);
                    break;
                }
                if (!name.equals(UNIX_BROWSER)) break;
                ExternalTools._UnixBrowser = value;
                break;
            }
            default: {
                System.setProperty(name, value);
            }
        }
    }

    public static void save() {
        if (_Properties == null) {
            _Properties = new Properties();
        }
        try {
            _Properties.setProperty("SM.version", "6.3(1)");
            _Properties.setProperty(CONFIRM_ROW_DELETION, EMPTY_STRING + DataView._ConfirmRowDeletion);
            _Properties.setProperty(SHOW_DEVICE_NAME_BY, EMPTY_STRING + SnmpPeer.getShowNameBy());
            _Properties.setProperty(SHOW_WWN_VENDOR_BY, EMPTY_STRING + WwnDictionary.isEnabled());
            _Properties.setProperty(WWN_VENDOR_BY, EMPTY_STRING + WwnDictionary.isPrepend());
            _Properties.setProperty(SHORT_ISCSI_NAME, EMPTY_STRING + EndPort._ShowShortIscsiName);
            _Properties.setProperty(SHOW_ENCLOSURE, EMPTY_STRING + EndPort.appendEnclosure());
            _Properties.setProperty(SHOW_TIMESTAPMS_AS_DATE, EMPTY_STRING + SnmpTimeticks._ShowDateTime);
            _Properties.setProperty(TELNET_PATH, EMPTY_STRING + ExternalTools._TelnetClient);
            _Properties.setProperty(USE_SSH, EMPTY_STRING + ExternalTools._UseSSH);
            _Properties.setProperty(SSH_PATH, EMPTY_STRING + ExternalTools._SSHPath);
            _Properties.setProperty(EXPORT_FORMAT, EMPTY_STRING + KTable._ExportAsXML);
            _Properties.setProperty(LIC_SERVER, System.getProperty(LIC_SERVER, EMPTY_STRING));
            _Properties.setProperty(CFS_WARNING, EMPTY_STRING + SmCfsUtil._PromptCFSWarning);
            _Properties.setProperty(ALIASENCL_WARN, EMPTY_STRING + SmHostTableModel._PromptAliasEnclosureInfo);
            _Properties.setProperty(UNIX_BROWSER, EMPTY_STRING + ExternalTools._UnixBrowser);
            _Properties.setProperty(LOG_BUFFER_SIZE, EMPTY_STRING + LogWriter.getMaxLines());
            _Properties.setProperty(IDLE_TIME_OUT, EMPTY_STRING + IdleTimeOut.getTimeOutInterval());
            _Properties.setProperty(ENABLE_ROLLOVER_DOCKED_JIDE_FRAMES, EMPTY_STRING + BrowserFrame.getInstance().getShowRolloverDockedJideFrames());
            _Properties.setProperty(SNMP_RETRIES, EMPTY_STRING + ClientController.getInstance().getRetries());
            _Properties.setProperty(SNMP_TIMEOUT, EMPTY_STRING + ClientController.getInstance().getTimeout());
            _Properties.setProperty(AUDIBLE_ALTER, EMPTY_STRING + EventLog.getAudibleAlert());
            _Properties.setProperty(LUN_DISC_OS, EMPTY_STRING + ClientController.getInstance().getLunDiscOS().value());
            _Properties.setProperty(TRACE_TOPOLOGY_DISCOVERY, EMPTY_STRING + ClientController.isTrace());
            _Properties.setProperty(MULTIPLE_LINK_SPACING, Double.toString(MultipleLinkHandler.getClassSpacing()));
            _Properties.setProperty(DISPLAY_UNSELECTED_VSAN, EMPTY_STRING + SmMap.getDimNodeDisplayPolicy());
            _Properties.setProperty(DISPLAY_UNSELECTED_GROUP_MEMBERS, EMPTY_STRING + SmMap.getGroupDimNodeDisplayPolicy());
            _Properties.setProperty(DISPLAY_END_DEVICES, EMPTY_STRING + SmMap.isDisplayEndDevices());
            _Properties.setProperty(DISPLAY_ISCSI, EMPTY_STRING + SmMap.isClassDisplayISCSI());
            _Properties.setProperty(DISPLAY_TARGETS, EMPTY_STRING + SmMap.isClassDisplayTargets());
            _Properties.setProperty(DISPLAY_INITIATORS, EMPTY_STRING + SmMap.isClassDisplayInitiators());
            _Properties.setProperty(DISPLAY_END_DEVICE_LABELS, EMPTY_STRING + SmMap.isDisplayNodeLabels());
            _Properties.setProperty(EXPAND_LOOPS, EMPTY_STRING + !SmMap.isClassLoopsCollapsed());
            _Properties.setProperty(EXPAND_MULTI_LINKS, EMPTY_STRING + !SmMap.isClassMultiLinksCollapsed());
            _Properties.setProperty(OPEN_NEW_DM_EACH_TIME, EMPTY_STRING + DMMapAction.getNewWinDM());
            _Properties.setProperty(DEVICE_MANAGER_PORT, EMPTY_STRING + DMMapAction.DM_SOCKET);
            _Properties.setProperty(SELECT_DEVICE_FROM_TABLE, EMPTY_STRING + DataView._SelectMapFrmTable);
            _Properties.setProperty(SHOW_GRID, EMPTY_STRING + MiscMapActions.isGridEnabled());
            _Properties.setProperty(PERFORM_LAYOUT_ON_NEW, EMPTY_STRING + SmMap.isLayoutNewDevices());
            _Properties.setProperty(QUICK_LAYOUT_NODE_COUNT, EMPTY_STRING + LayoutAction.getQuickLayoutNodeCount());
            _Properties.setProperty(OVERRIDE_PREFERENCES, EMPTY_STRING + SmMap.isOverridePreferences());
            _Properties.setProperty(AUTOMATICALLY_SAVE_LAYOUT, EMPTY_STRING + SmMap.isAutoSaveLayout());
            _Properties.setProperty(DETACH_OVERVIEW, EMPTY_STRING + OverViewMapAction.getInstance().isDetached());
            _Properties.setProperty(DISPLAY_DOMAIN_ID_AS, EMPTY_STRING + SwitchNode.getDisplayDomainIdAs());
            _Properties.setProperty(SHOW_MINOR_ALARMS_ON_LINKS, EMPTY_STRING + SmMap.isDisplayMinorAlarmsOnLinks());
            _Properties.setProperty(DISPLAY_KUBRICK_ICONS, EMPTY_STRING + SmMap.isClassUseKubrickIcons());
            _Properties.setProperty(MAP_NODE_LIMIT, EMPTY_STRING + SmMap.getMapNodeLimit());
            _Properties.setProperty(DISPLAY_NPV_SWITCHES, EMPTY_STRING + SmMap.isClassDisplayNpvSwitches());
            _Properties.setProperty(SIMPLEMODE, EMPTY_STRING + UIControls.getInstance().getPerspectiveName().equalsIgnoreCase("simple"));
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        if (_Properties != null && _Properties.size() > 0) {
            ClientController.getInstance().storePropertiesToServer(ClientController.getInstance().getLoginDialogUserName() + ".pref", _Properties, EMPTY_STRING, true);
        }
    }
}

