/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.qos;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.qos.ClassMapMatchStmt;
import com.cisco.dcbu.sm.client.qos.DataObject;
import com.cisco.dcbu.sm.client.qos.PolicyClassPriority;
import com.cisco.dcbu.sm.client.qos.PolicyMapExistObject;
import com.cisco.dcbu.sm.client.qos.QoS;
import com.cisco.dcbu.sm.client.qos.QoSStatement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class QosConfigWizard
extends JWizard {
    static final String[] PRIORITY = new String[]{"low", "medium", "high"};
    boolean shouldRemoveInSwitch = true;
    boolean asked = false;
    Review _review;
    Define _define;
    Object lockObject = new Object();

    public QosConfigWizard(JFrame parent) {
        super(parent);
        this.setTitle("QoS Configuration Wizard" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.setSize(500, 450);
        this._define = new Define(this);
        this.addPanel("define", this._define);
        this._review = new Review(this);
        this.addPanel("review", this._review);
        this.first();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void setVisible(boolean b) {
        if (!b) {
            super.setVisible(b);
            return;
        }
        try {
            HashMap hashMap = null;
            if (this._define == null || this._define.map == null) {
                hashMap = new QoS().getVsans();
                if (this._define != null) {
                    this._define.map = hashMap;
                }
            } else {
                hashMap = this._define.map;
            }
            if (hashMap == null || hashMap.size() == 0) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "There is no zone in any unconfigured VSAN with a host-storage pair.");
                super.setVisible(false);
            } else {
                super.setVisible(b);
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            super.setVisible(false);
        }
    }

    private void updateTable(HashMap zone2Priority, Vsan vsan) throws Exception {
        this._review.updateTable(zone2Priority, vsan);
    }

    class Review
    extends WizardPanel
    implements ActionListener,
    ListSelectionListener {
        static final int PRIORITY_COL = 4;
        SnmpKTable _table;
        KTableModel _tableModel;
        JButton _remove;
        Vsan _vsan;
        QosConfigWizard caller;
        HashMap _policyExistsMap;
        HashMap _entryAddMap;
        ArrayList _removeList;
        HashMap _zoneNamesMap;
        JTextField policyNameField;

        public Review(QosConfigWizard wizard) {
            super("2 of 2: Review Detailed Priority", "Modify Priority for Host-Storage pair if needed.", wizard, Util.loadIcon("icons/qoswiz.gif"));
            this.caller = null;
            this._policyExistsMap = new HashMap();
            this._entryAddMap = new HashMap();
            this._removeList = new ArrayList();
            this._zoneNamesMap = new HashMap();
            this.policyNameField = new JTextField("PolicyMap-VSAN");
            JPanel center = new JPanel(new BorderLayout());
            JPanel policyNamePanel = new JPanel();
            policyNamePanel.add(new JLabel("Policy BaseName"));
            policyNamePanel.setLayout(new FlowLayout(0));
            policyNamePanel.add(this.policyNameField);
            center.add("North", policyNamePanel);
            this.caller = wizard;
            this._tableModel = new KTableModel();
            Array data = new Array();
            this._tableModel.setData(data);
            this._tableModel.setHeaders(new String[]{"Switch", "Zone", "Source", "Destination", "Priority", "Exists"});
            this._tableModel.setEditable(new boolean[]{false, false, false, false, true, false});
            this._table = new SnmpKTable(this._tableModel);
            this._table.getTableHeader().addMouseListener(new HeaderListener());
            this._table.setSortable(true);
            this._table.getSelectionModel().addListSelectionListener(this);
            JComboBox<String> combo = new JComboBox<String>(PRIORITY);
            combo.setEditable(false);
            this._table.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(combo));
            JScrollPane sp = new JScrollPane(this._table);
            center.add("Center", sp);
            this._remove = new JButton("Remove");
            this._remove.addActionListener(this);
            this._remove.setEnabled(false);
            JPanel buttonPanel = new JPanel(new FlowLayout(2, 2, 4));
            buttonPanel.add(this._remove);
            center.add("South", buttonPanel);
            this.add("Center", center);
        }

        @Override
        public void doCancel() {
            this.caller.dispose();
            super.doCancel();
        }

        void updateTable(HashMap zone2Priority, Vsan vsan) throws Exception {
            this._policyExistsMap.clear();
            this._entryAddMap.clear();
            this._removeList.clear();
            this._zoneNamesMap.clear();
            this._vsan = vsan;
            this.policyNameField.setText(" PolicyMap-VSAN" + this._vsan.getId());
            DataObject dObject = (DataObject)QosConfigWizard.this._define.map.get(vsan);
            EnforcedZone[] ez = vsan.getEnforcedZones();
            if (ez == null && dObject.pMapObject.length == 0) {
                throw new Exception("No Active QoS Configuration possible in " + vsan);
            }
            Array data = this._tableModel.getData();
            data.clear();
            for (int i = 0; i < ez.length; ++i) {
                int j;
                Array members = ez[i].getMembers();
                String priority = (String)zone2Priority.get(ez[i].toString());
                if (priority == null || priority.equals("")) {
                    priority = PRIORITY[0];
                }
                EndPort[] zoneTargets = null;
                EndPort[] zoneInits = null;
                HashMap<EndPort, EndPort> zoneInitsMap = new HashMap<EndPort, EndPort>();
                HashMap<EndPort, EndPort> zoneTargetsMap = new HashMap<EndPort, EndPort>();
                for (j = 0; j < members.size(); ++j) {
                    ArrayList ports;
                    EnforcedZoneMember ezm = (EnforcedZoneMember)members.elementAt(j);
                    EndPort ep = ezm.getEndPort(vsan.getFabric());
                    if (ep == null || !ep.getSwitch().isMDS() || !ep.getSwitch().isManageable() || ep.isVirtualized()) continue;
                    if ((ezm.getType() == 4 || ezm.getType() == 6 || ezm.getType() == 7) && null != (ports = ezm.getAttachedEndPorts())) {
                        for (int k = 0; k < ports.size(); ++k) {
                            zoneTargetsMap.put((EndPort)ports.get(k), (EndPort)ports.get(k));
                        }
                    }
                    if (ep.isTarget()) {
                        zoneTargetsMap.put(ep, ep);
                        continue;
                    }
                    zoneInitsMap.put(ep, ep);
                }
                zoneInits = zoneInitsMap.keySet().toArray(new EndPort[zoneInitsMap.size()]);
                zoneTargets = zoneTargetsMap.keySet().toArray(new EndPort[zoneTargetsMap.size()]);
                if (zoneTargets.length == 0 || zoneInits.length == 0) continue;
                for (j = 0; j < zoneInits.length; ++j) {
                    EndPort epHost = zoneInits[j];
                    for (int k = 0; k < zoneTargets.length; ++k) {
                        Object[] dataArr = new Object[]{"", ez[i], epHost, zoneTargets[k], priority, Boolean.FALSE, null};
                        this._zoneNamesMap.put(epHost.getPortWwn().toString() + ":" + zoneTargets[k].getPortWwn().toString(), ez[i]);
                        this._zoneNamesMap.put(zoneTargets[k].getPortWwn().toString() + ":" + epHost.getPortWwn().toString(), ez[i]);
                        if (dObject.pMapObject.length > 0) {
                            String entryKey = epHost.getPortWwn().toString() + ":" + zoneTargets[k].getPortWwn().toString();
                            PolicyMapExistObject[] objArr = new PolicyMapExistObject[dObject.pMapObject.length + 1];
                            System.arraycopy(dObject.pMapObject, 0, objArr, 0, dObject.pMapObject.length);
                            dObject.pMapObject = objArr;
                            dObject.pMapObject[dObject.pMapObject.length - 1] = new PolicyMapExistObject();
                            ClassMapMatchStmt cms = new ClassMapMatchStmt();
                            cms.dataArr = dataArr;
                            cms.key = entryKey;
                            cms.priority = priority.equals("high") ? 2 : (priority.equals("medium") ? 1 : 0);
                            dObject.pMapObject[dObject.pMapObject.length - 1].classMapMatchStmtList.add(cms);
                            continue;
                        }
                        data.addElement(dataArr);
                    }
                }
            }
            if (dObject.pMapObject.length > 0) {
                this.policyNameField.setEditable(false);
                VarBindList vbList = new VarBindList();
                int[] policyMapClassMap = MibNode.get("diffServClfrElementSpecific").getOid();
                int[] classMatchSrcStmt = MibNode.get("cdsmFCMultiFieldMatchSrcAddr").getOid();
                int[] classMatchDstStmt = MibNode.get("cdsmFCMultiFieldMatchDstAddr").getOid();
                SnmpOID classMapIDOID = new SnmpOID(MibNode.get("diffServClfrElementSpecific").getOid());
                for (int i = 0; i < dObject.pMapObject.length; ++i) {
                    vbList.clear();
                    PolicyMapExistObject pmapObj = dObject.pMapObject[i];
                    if (pmapObj == null) continue;
                    Switch sw = pmapObj.switchObject;
                    if (pmapObj.policyMapId == 0) {
                        for (int nullInt = 0; nullInt < pmapObj.classMapMatchStmtList.size(); ++nullInt) {
                            ClassMapMatchStmt cms = (ClassMapMatchStmt)pmapObj.classMapMatchStmtList.get(nullInt);
                            if (cms.key == null || this._policyExistsMap.get(cms.key) != null) continue;
                            this._entryAddMap.put(cms.key, cms.dataArr);
                        }
                        continue;
                    }
                    vbList.add(new SnmpVarBind(new SnmpOID(MibNode.get("cdsmClfrName").getOid(), pmapObj.policyMapId)));
                    SnmpPDU respGet = SnmpFetch.get(sw.getPeer(), vbList);
                    if (respGet.getVar(0) != null) {
                        this.policyNameField.setText(((SnmpString)respGet.getVar(0)).toString());
                    }
                    vbList.clear();
                    SnmpOID PolicyMapClassMapOID = new SnmpOID(policyMapClassMap, pmapObj.policyMapId);
                    vbList.add(new SnmpVarBind(PolicyMapClassMapOID));
                    SnmpPDU respBulk = SnmpFetch.getBulk(sw.getPeer(), vbList);
                    if (respBulk.getVariables().size() == 0) continue;
                    HashMap priorityMap = this.getPriority(pmapObj.policyMapId, classMapIDOID, sw);
                    VarBindList vbRespBulkList = respBulk.getVariables();
                    for (int j = 0; j < vbRespBulkList.size(); ++j) {
                        SnmpVarBind vb = vbRespBulkList.getVb(j);
                        vbList.clear();
                        if (!vb.getOid().startsWith(PolicyMapClassMapOID)) continue;
                        int classMapId = ((SnmpOID)vb.getVar()).getValue()[((SnmpOID)vb.getVar()).getValue().length - 1];
                        ClassMapMatchStmt cms = new ClassMapMatchStmt();
                        cms.classMapId = classMapId;
                        SnmpOID classMapMatchStmtSrc = new SnmpOID(classMatchSrcStmt, classMapId);
                        SnmpOID classMapMatchStmtDst = new SnmpOID(classMatchDstStmt, classMapId);
                        vbList.add(new SnmpVarBind(classMapMatchStmtSrc));
                        vbList.add(new SnmpVarBind(classMapMatchStmtDst));
                        SnmpPDU respmatchPDU = SnmpFetch.getBulk(sw.getPeer(), vbList);
                        if (respmatchPDU.getVariables().size() == 0) continue;
                        SnmpString sourceWWN = null;
                        SnmpString targetWWN = null;
                        boolean sourceFcId = false;
                        boolean destFcId = false;
                        for (int k = 0; k < respmatchPDU.getVariables().size(); ++k) {
                            EndPort dport;
                            EndPort sport;
                            SnmpVarBind vbK = respmatchPDU.getVariables().getVb(k);
                            if (vbK.getOid().getValue()[vbK.getOid().getValue().length - 2] != classMapId || !(vbK.getVar() instanceof SnmpString) || vbK.getVar() == null || vbK.getVar().toString().length() == 0) continue;
                            if (vbK.getOid().startsWith(classMapMatchStmtSrc)) {
                                sourceFcId = ((SnmpString)vbK.getVar()).getValue().length != 8;
                                sourceWWN = (SnmpString)vbK.getVar();
                                cms.sourceIndex = vbK.getOid().getIndex(2);
                            }
                            if (vbK.getOid().startsWith(classMapMatchStmtDst)) {
                                destFcId = ((SnmpString)vbK.getVar()).getValue().length != 8;
                                targetWWN = (SnmpString)vbK.getVar();
                                cms.targetIndex = vbK.getOid().getIndex(2);
                            }
                            if (sourceWWN == null || sourceWWN.toString().trim().length() <= 0 || targetWWN == null || targetWWN.toString().trim().length() <= 0) continue;
                            if (!sourceFcId) {
                                ClientController.getInstance();
                                sport = ClientController.findFabricEndPortByWwn(new Wwn(sourceWWN));
                            } else {
                                sport = ClientController.getInstance().findFabricEndPortByVsanFcId(vsan.getId(), sourceWWN.getValue());
                            }
                            if (!destFcId) {
                                ClientController.getInstance();
                                dport = ClientController.findFabricEndPortByWwn(new Wwn(targetWWN));
                            } else {
                                dport = ClientController.getInstance().findFabricEndPortByVsanFcId(vsan.getId(), targetWWN.getValue());
                            }
                            Object[] dataArr = new Object[]{sw, null, sport == null ? sourceWWN : sport, dport == null ? targetWWN : dport, "low", Boolean.TRUE, null};
                            pmapObj.classMapMatchStmtList.add(cms);
                            cms.dataArr = dataArr;
                            cms.priority = 0;
                            cms.key = sport != null && dport != null ? sport.getPortWwn().toString() + ":" + dport.getPortWwn().toString() : (sport == null && dport == null ? sourceWWN + ":" + targetWWN : (sport == null ? sourceWWN + ":" + dport.getPortWwn().toString() : sport.getPortWwn().toString() + ":" + targetWWN));
                            if (this._zoneNamesMap.get(cms.key) != null) {
                                cms.dataArr[1] = this._zoneNamesMap.get(cms.key);
                            }
                            this._policyExistsMap.put(cms.key, dObject);
                            PolicyClassPriority pcp = (PolicyClassPriority)priorityMap.get(Integer.toString(cms.classMapId));
                            if (pcp != null) {
                                cms.priority = pcp.priority;
                                cms.priorityIndex = pcp.priorityIndex;
                            }
                            cms.dataArr[4] = PRIORITY[cms.priority];
                            Object[] inMapArr = (Object[])this._entryAddMap.get(cms.key);
                            if (inMapArr == null) {
                                this._entryAddMap.put(cms.key, cms.dataArr);
                                break;
                            }
                            inMapArr[5] = Boolean.TRUE;
                            if (inMapArr[4].equals(cms.dataArr[4])) break;
                            if (inMapArr[3].equals("high")) continue;
                            if (cms.dataArr[4].equals("high")) {
                                this._entryAddMap.put(cms.key, cms.dataArr);
                                continue;
                            }
                            if (inMapArr[4].equals("medium")) continue;
                            if (!cms.dataArr[4].equals("medium")) break;
                            this._entryAddMap.put(cms.key, cms.dataArr);
                        }
                        sourceWWN = null;
                        targetWWN = null;
                    }
                }
            }
            if (this._policyExistsMap.size() > 0) {
                for (DataObject dObjectItr : this._policyExistsMap.values()) {
                    for (int i = 0; i < dObjectItr.pMapObject.length; ++i) {
                        PolicyMapExistObject pmapObj = dObjectItr.pMapObject[i];
                        if (pmapObj == null || pmapObj.policyMapId != 0 || pmapObj.classMapMatchStmtList.size() <= 0) continue;
                        ArrayList cmsList = pmapObj.classMapMatchStmtList;
                        ArrayList<String> myList = new ArrayList<String>();
                        for (int cmsItr = 0; cmsItr < cmsList.size(); ++cmsItr) {
                            ClassMapMatchStmt cms = (ClassMapMatchStmt)cmsList.get(cmsItr);
                            if (this._policyExistsMap.get(cms.key) == null) continue;
                            myList.add(Integer.toString(cmsItr));
                        }
                        for (int kl = myList.size() - 1; kl >= 0; --kl) {
                            pmapObj.classMapMatchStmtList.remove(Integer.parseInt((String)myList.get(kl)));
                        }
                    }
                }
            }
            if (this._entryAddMap.size() > 0) {
                Iterator it = this._entryAddMap.values().iterator();
                while (it.hasNext()) {
                    data.addElement((Object[])it.next());
                }
            }
            this._tableModel.fireTableDataChanged();
            this._table.colWidthToWidest();
            this.getWizard().setStatus(data.size() + " row(s)");
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this._remove.setEnabled(this._table.getSelectedRowCount() > 0);
        }

        private HashMap getPriority(int policyMapId, SnmpOID classMapIDOID, Switch switchObject) throws SnmpException {
            HashMap<String, PolicyClassPriority> prioMap = new HashMap<String, PolicyClassPriority>();
            SnmpOID prioOID = null;
            VarBindList vbList = new VarBindList();
            SnmpVarBind vb = null;
            vbList.add(new SnmpVarBind(new SnmpOID(classMapIDOID.getValue(), new int[]{policyMapId})));
            vbList.add(new SnmpVarBind(new SnmpOID(MibNode.get("diffServClfrElementNext").getOid(), new int[]{policyMapId})));
            SnmpPDU respPDU = SnmpFetch.getBulk(switchObject.getPeer(), vbList);
            if (respPDU.getVariables().size() == 0) {
                return prioMap;
            }
            vbList = respPDU.getVariables();
            for (int vbItr = 0; vbItr < vbList.size(); ++vbItr) {
                vb = vbList.getVb(vbItr);
                int classMap = ((SnmpOID)vb.getVar()).getIndexFromEnd(0);
                if (!((vb = vbList.getVb(++vbItr)).getVar() instanceof SnmpOID)) continue;
                prioOID = (SnmpOID)vb.getVar();
                int lastIndex = prioOID.getIndexFromEnd(0);
                int priorityString = 0;
                priorityString = lastIndex == 11 || lastIndex == 13 || lastIndex == 15 ? 2 : (lastIndex == 19 || lastIndex == 21 || lastIndex == 23 ? 1 : 0);
                PolicyClassPriority pcp = new PolicyClassPriority();
                pcp.priority = priorityString;
                pcp.priorityIndex = vb.getOid().getIndex(2);
                prioMap.put(Integer.toString(classMap), pcp);
            }
            return prioMap;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = this._table.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                Object twwn;
                Object swwn;
                String key = null;
                if (this._tableModel.getValueAt(rows[i], 2) instanceof EndPort) {
                    swwn = (EndPort)this._tableModel.getValueAt(rows[i], 2);
                    if (this._tableModel.getValueAt(rows[i], 3) instanceof EndPort) {
                        twwn = (EndPort)this._tableModel.getValueAt(rows[i], 3);
                        key = ((EndPort)swwn).getPortWwn().toString() + ":" + ((EndPort)twwn).getPortWwn().toString();
                    } else {
                        key = ((EndPort)swwn).getPortWwn().toString() + ":" + this._tableModel.getValueAt(rows[i], 3).toString();
                    }
                } else {
                    swwn = this._tableModel.getValueAt(rows[i], 2).toString();
                    if (this._tableModel.getValueAt(rows[i], 3) instanceof EndPort) {
                        twwn = (EndPort)this._tableModel.getValueAt(rows[i], 3);
                        key = (String)swwn + ":" + ((EndPort)twwn).getPortWwn().toString();
                    } else {
                        twwn = this._tableModel.getValueAt(rows[i], 3).toString();
                        key = (String)swwn + ":" + (String)twwn;
                    }
                }
                if (key != null && this._policyExistsMap.get(key) != null) {
                    if (!QosConfigWizard.this.asked) {
                        QosConfigWizard.this.shouldRemoveInSwitch = JOptionPane.showConfirmDialog(BrowserFrame.getInstance(), "Do you want the entries to be removed on the switch also (if they exist on the switch)? If no, then the entries will be removed from this view only", "Entries Deletion", 0) == 0;
                        QosConfigWizard.this.asked = true;
                    }
                    if (QosConfigWizard.this.shouldRemoveInSwitch) {
                        this._removeList.add(key);
                    }
                }
                this._tableModel.getData().removeElementAt(rows[i]);
            }
            this.getWizard().setStatus(this._tableModel.getData().size() + " rows");
            this._tableModel.fireTableDataChanged();
        }

        private void deleteEntries() throws SnmpException {
            if (this._removeList.size() > 0) {
                for (int i = 0; i < this._removeList.size(); ++i) {
                    String cmsKey = (String)this._removeList.get(i);
                    DataObject dObject = (DataObject)this._policyExistsMap.get(cmsKey);
                    if (dObject == null) continue;
                    for (int j = 0; j < dObject.pMapObject.length; ++j) {
                        if (dObject.pMapObject[j] == null) continue;
                        ArrayList al = dObject.pMapObject[j].classMapMatchStmtList;
                        if (dObject.pMapObject[j].switchObject == null) continue;
                        for (int k = 0; k < al.size(); ++k) {
                            ClassMapMatchStmt cms = (ClassMapMatchStmt)al.get(k);
                            if (!cms.key.equals(cmsKey)) continue;
                            VarBindList vbList = new VarBindList();
                            vbList.add(new SnmpVarBind(new SnmpOID(MibNode.get("cdsmFCMultiFieldClfrStatus").getOid(), cms.classMapId), new SnmpInt(6)));
                            try {
                                SnmpFetch.set(dObject.pMapObject[j].switchObject.getPeer(), vbList);
                                continue;
                            }
                            catch (SnmpException sse) {
                                if (sse.getMessage().indexOf("failed to find classmap") != -1) continue;
                                throw sse;
                            }
                        }
                    }
                }
            }
        }

        @Override
        public void doPrevious() {
            super.doPrevious();
            this.getWizard().setStatus(" ");
            if (QosConfigWizard.this._define.map.get(this._vsan) != null) {
                DataObject dObject = (DataObject)QosConfigWizard.this._define.map.get(this._vsan);
                if (dObject == null) {
                    return;
                }
                if (dObject.pMapObject.length > 0) {
                    this.getWizard().setStatus("Policy Map exists. Please proceed to the next step to change.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doFinish() {
            QosConfigWizard w;
            QoS qos = null;
            final QosConfigWizard wiz = w = (QosConfigWizard)this.getWizard();
            try {
                if (this._tableModel.getData().size() == 0 && this._removeList.size() == 0) {
                    Util.errorMessage((Component)w, "No data to config QoS!");
                } else {
                    qos = new QoS();
                    ArrayList<QoSStatement> priority1Eps = new ArrayList<QoSStatement>();
                    ArrayList<QoSStatement> priority2Eps = new ArrayList<QoSStatement>();
                    Array data = this._tableModel.getData();
                    if (this.policyNameField.isEditable()) {
                        qos._policyName = this.policyNameField.getText().trim();
                    }
                    for (int i = 0; i < data.size(); ++i) {
                        String key;
                        Object[] row = (Object[])data.elementAt(i);
                        QoSStatement qosStatement = new QoSStatement(row[2] instanceof EndPort ? row[2] : row[2], row[3] instanceof EndPort ? row[3] : row[3]);
                        if (((String)row[4]).equals(PRIORITY[1])) {
                            priority2Eps.add(qosStatement);
                            continue;
                        }
                        if (((String)row[4]).equals(PRIORITY[2])) {
                            priority1Eps.add(qosStatement);
                            continue;
                        }
                        if (!((String)row[4]).equals(PRIORITY[0]) || this._policyExistsMap.get(key = (row[2] instanceof EndPort ? ((EndPort)row[2]).getPortWwn() : row[2]) + ":" + (row[3] instanceof EndPort ? ((EndPort)row[3]).getPortWwn() : row[3])) == null) continue;
                        this._removeList.add(key);
                    }
                    this.deleteEntries();
                    w.getNavigator().getBackBtn().setEnabled(false);
                    w.getNavigator().getNextBtn().setEnabled(false);
                    w.getNavigator().getCancel().setEnabled(false);
                    this._remove.setEnabled(false);
                    priority1Eps.trimToSize();
                    priority2Eps.trimToSize();
                    int result = qos.build(this._vsan.getId(), priority1Eps, priority2Eps, w, QosConfigWizard.this.lockObject, (DataObject)QosConfigWizard.this._define.map.get(this._vsan), this._removeList.size());
                    if (result != 3) {
                        Thread t = new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    Object object = QosConfigWizard.this.lockObject;
                                    synchronized (object) {
                                        QosConfigWizard.this.lockObject.wait();
                                    }
                                    wiz.getNavigator().getCancel().setText("Close");
                                    wiz.getNavigator().getCancel().setEnabled(true);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        });
                        t.start();
                    } else {
                        wiz.setStatus("All modifications completed");
                        wiz.getNavigator().getCancel().setText("Close");
                        wiz.getNavigator().getCancel().setEnabled(true);
                    }
                }
            }
            catch (Exception ex) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                this.getWizard().getNavigator().getBackBtn().setEnabled(true);
                this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                this.getWizard().getNavigator().getCancel().setEnabled(true);
                this._remove.setEnabled(false);
                Util.errorMessage((Component)this, ex);
                if (SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            finally {
                qos = null;
                w = null;
            }
        }
    }

    class Define
    extends WizardPanel
    implements ActionListener {
        static final int PRIORITY_COL = 1;
        JComboBox _vsan;
        SnmpKTable _table;
        KTableModel _tableModel;
        QosConfigWizard caller;
        HashMap map;
        QoS qos;

        public Define(QosConfigWizard wizard) {
            super("1 of 2: Define Zone Priority", "Set Priority for Enforced Zones of the selected Vsan. As unconfigured traffic and low priority traffic are treated at the same QoS level, the wizard does not configure those items.", wizard, Util.loadIcon("icons/qoswiz.gif"));
            this.caller = null;
            this.map = null;
            this.qos = new QoS();
            JPanel center = new JPanel(new BorderLayout());
            this.caller = wizard;
            try {
                JPanel vsanPanel = new JPanel(new FlowLayout(0, 2, 2));
                vsanPanel.add(new JLabel("VSAN:"));
                this._vsan = new JComboBox();
                this._vsan.addActionListener(this);
                vsanPanel.add(this._vsan);
                center.add("North", vsanPanel);
                this._tableModel = new KTableModel();
                Array data = new Array();
                this._tableModel.setData(data);
                this._tableModel.setHeaders(new String[]{"Zone", "Priority"});
                this._tableModel.setEditable(new boolean[]{false, true});
                this._table = new SnmpKTable(this._tableModel);
                this._table.getTableHeader().addMouseListener(new HeaderListener());
                this._table.setSortable(true);
                JComboBox<String> combo = new JComboBox<String>(PRIORITY);
                combo.setEditable(false);
                this._table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(combo));
                JScrollPane sp = new JScrollPane(this._table);
                sp.setPreferredSize(this._table.getPreferredScrollableViewportSize());
                center.add(sp);
                this.initializeVsans();
            }
            catch (Exception ex) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                if (SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                Util.errorMessage((Component)this, ex);
            }
            this.add("Center", center);
        }

        private boolean initializeVsans() {
            try {
                if (this.map == null) {
                    this.map = this.qos.getVsans();
                    if (this.map == null || this.map.size() == 0) {
                        this.getWizard().setVisible(false);
                    }
                }
                Object[] vsans = new Vsan[this.map.size()];
                Iterator enums = this.map.values().iterator();
                int j = 0;
                while (enums.hasNext()) {
                    vsans[j++] = ((DataObject)enums.next()).vsan;
                }
                Arrays.sort(vsans);
                for (int i = 0; i < vsans.length; ++i) {
                    this._vsan.addItem(vsans[i]);
                }
                this.fillZoneData();
            }
            catch (Exception e) {
                DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
                if (SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
                }
                Util.errorMessage((Component)this.getParent(), e);
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.fillZoneData();
            }
            catch (Exception ex) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                Util.errorMessage((Component)this, ex);
            }
            this._tableModel.fireTableDataChanged();
            this._table.colWidthToWidest();
        }

        private void fillZoneData() throws Exception {
            this._tableModel.getData().clear();
            Vsan v = (Vsan)this._vsan.getSelectedItem();
            DataObject dObject = (DataObject)this.map.get(v);
            if (this.map.get(v) == null) {
                return;
            }
            if (!dObject.enforcedZoneObtained) {
                this.qos.add(v, this.map);
            }
            if (dObject.pMapObject.length > 0) {
                this.getWizard().setStatus("Policy Map exists. Please proceed to the next step to change.");
            } else {
                this.getWizard().setStatus("");
            }
            EnforcedZone[] ez = dObject.enfZone;
            if (ez == null && dObject.pMapObject.length == 0) {
                this.getWizard().setStatus("No Active QoS configuration possible in " + v);
                this.getWizard().getNavigator().getNextBtn().setEnabled(false);
                return;
            }
            if (ez == null) {
                ez = new EnforcedZone[]{};
            }
            Array data = this._tableModel.getData();
            for (int i = 0; i < ez.length; ++i) {
                if (ez[i] == null || ez[i].getMembers().size() <= 0) continue;
                boolean atleastOneHostexists = false;
                boolean atleastOneTargetexists = false;
                for (int j = 0; j < ez[i].getMembers().size(); ++j) {
                    EnforcedZoneMember ezm = (EnforcedZoneMember)ez[i].getMembers().elementAt(j);
                    EndPort ep = ezm.getEndPort(v.getFabric());
                    if (ep == null || !ep.getSwitch().isMDS() || !ep.getSwitch().isManageable() || ep.isVirtualized()) continue;
                    if ((ezm.getType() == 4 || ezm.getType() == 6 || ezm.getType() == 7) && ezm.getAttachedEndPorts().size() > 0) {
                        atleastOneTargetexists = true;
                        if (atleastOneHostexists) break;
                    }
                    if (ep.isTarget()) {
                        atleastOneTargetexists = true;
                        if (!atleastOneHostexists) continue;
                        break;
                    }
                    atleastOneHostexists = true;
                    if (atleastOneTargetexists) break;
                }
                if (!atleastOneHostexists || !atleastOneTargetexists) continue;
                data.addElement(new Object[]{ez[i], PRIORITY[0], null});
            }
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
        }

        @Override
        public void doCancel() {
            this.caller._define = null;
            this.caller._review = null;
            this.getWizard().dispose();
            this._tableModel = null;
        }

        @Override
        public void doNext() {
            try {
                QosConfigWizard w = (QosConfigWizard)this.getWizard();
                w.updateTable(this.getPriority(), (Vsan)this._vsan.getSelectedItem());
                super.doNext();
            }
            catch (Exception ex) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                Util.errorMessage((Component)this, ex);
            }
        }

        private HashMap getPriority() throws Exception {
            HashMap<String, String> zone2Priority = new HashMap<String, String>();
            Array data = this._tableModel.getData();
            for (int i = 0; i < data.size(); ++i) {
                Object[] row = (Object[])data.elementAt(i);
                zone2Priority.put(row[0].toString(), row[1].toString());
            }
            return zone2Priority;
        }
    }
}

