/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.rmon;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.AddRemovePanel;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.rmon.RmonWizard;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;

class SelectionPanel
extends WizardPanel {
    JFrame _parent;
    SnmpKTable _table;
    RmonWizard _wiz;
    Object[] _lastComponent;
    boolean _needTarget;
    JList _list;
    JList _resultList;
    DefaultListModel _listModel = new DefaultListModel();
    DefaultListModel _resultListModel = new DefaultListModel();

    public SelectionPanel(JFrame parent, RmonWizard wiz, ImageIcon icon) {
        super("Step 2 of 2 - Select Members and Speed Threshold.", "When there's existing RMON configured in the same interface,  the selection will be excluded and shown on the Excluded List box.", icon);
        this._wiz = wiz;
        this._parent = parent;
        this._list = new JList(this._listModel);
        new DefaultListModel();
        this._list.setCellRenderer(new rmonCellRenderer());
        JScrollPane sp = new JScrollPane(this._list);
        sp.setPreferredSize(new Dimension(300, 100));
        this._resultList = new JList(this._resultListModel);
        this._resultList.setCellRenderer(new rmonCellRenderer());
        JScrollPane sp1 = new JScrollPane(this._resultList);
        sp1.setPreferredSize(new Dimension(300, 100));
        SelectionRemovePanel center = new SelectionRemovePanel(sp, sp1);
        this.add("Center", center);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this._listModel = new DefaultListModel();
            this.getList(this._listModel);
            this._list.setModel(this._listModel);
        }
        super.setVisible(b);
    }

    private void getList(DefaultListModel listModel) {
        int j;
        ArrayList<EndPort> endPortList;
        boolean isISLSelected = SnmpString.getBit(this._wiz.getTypes(), 0);
        boolean isHostSelected = SnmpString.getBit(this._wiz.getTypes(), 1);
        boolean isStorageSelected = SnmpString.getBit(this._wiz.getTypes(), 2);
        Object[] isls = new Isl[]{};
        Object[] npvLinks = new NpvLink[]{};
        Object[] hosts = new EndPort[]{};
        Object[] storages = new EndPort[]{};
        if (isISLSelected) {
            isls = this._wiz.getVsan().getIsls();
            Arrays.sort(isls);
            npvLinks = this._wiz.getVsan().getNpvLinks();
            Arrays.sort(npvLinks);
        }
        if (isHostSelected) {
            endPortList = this._wiz.getVsan().getEndPorts(null, false);
            hosts = endPortList.toArray(new EndPort[endPortList.size()]);
            Arrays.sort(hosts);
        }
        if (isStorageSelected) {
            endPortList = this._wiz.getVsan().getEndPorts(null, true);
            storages = endPortList.toArray(new EndPort[endPortList.size()]);
            Arrays.sort(storages);
        }
        int i = 0;
        for (j = 0; j < isls.length; ++j) {
            listModel.addElement(isls[j]);
            ++i;
        }
        for (j = 0; j < npvLinks.length; ++j) {
            listModel.addElement(npvLinks[j]);
            ++i;
        }
        for (j = 0; j < hosts.length; ++j) {
            listModel.addElement(hosts[j]);
            ++i;
        }
        for (j = 0; j < storages.length; ++j) {
            listModel.addElement(storages[j]);
            ++i;
        }
    }

    @Override
    public void doPrevious() {
        this.getWizard().show("vsanPanel");
    }

    @Override
    public void doFinish() {
        this._wiz.setSelections(this._resultListModel);
        this.getWizard().show("finalPanel");
    }

    class SelectionRemovePanel
    extends AddRemovePanel {
        public SelectionRemovePanel(JScrollPane availableListPane, JScrollPane selectionListPane) {
            this.buildPanel(1, availableListPane, selectionListPane);
        }

        @Override
        public void removeAction() {
            super.removeAction();
            Object[] selected = SelectionPanel.this._resultList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                SelectionPanel.this._listModel.addElement(selected[i]);
                SelectionPanel.this._resultListModel.removeElement(selected[i]);
                SelectionPanel.this._resultList.clearSelection();
                SelectionPanel.this._resultList.setModel(SelectionPanel.this._resultListModel);
            }
        }

        @Override
        public void addAction() {
            super.addAction();
            Object[] selected = SelectionPanel.this._list.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                SelectionPanel.this._list.clearSelection();
                SelectionPanel.this._listModel.removeElement(selected[i]);
                SelectionPanel.this._list.setModel(SelectionPanel.this._listModel);
                SelectionPanel.this._resultListModel.addElement(selected[i]);
            }
        }
    }

    static class rmonCellRenderer
    extends DefaultListCellRenderer {
        rmonCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof EndPort) {
                EndPort dmEndPort = (EndPort)value;
                StringBuffer sb = new StringBuffer();
                sb.append(dmEndPort.toString());
                sb.append(" (");
                sb.append(dmEndPort.getSwitch().toString());
                sb.append(',');
                sb.append(dmEndPort.getIfIndexName());
                sb.append(')');
                this.setText(sb.toString());
            } else if (value instanceof NpvLink) {
                NpvLink link = (NpvLink)value;
                this.setText(link.getName());
            } else {
                Isl link = (Isl)value;
                this.setText(link.getName());
            }
            return retValue;
        }
    }
}

