/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.upgrade.u3_0_3;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.ImageSpec;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.Upgrade;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradePanel;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradeWizard;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;

public class AttrPanel
extends UpgradePanel
implements ActionListener,
ItemListener {
    static final int COPY_IMAGE_ONLY = 0;
    static final int VERSION_CHECK_ONLY = 1;
    static final int IGNORE_VERSION_CHECK = 2;
    static final int SERIALIZED = 0;
    static final int PARALLEL = 1;
    static final int ORDER_COLUMN = 0;
    static final int ORDER_COLUMN_CACHE = 5;
    boolean _isSwOrderEditable = true;
    static final String[] PARALLEL_CHOICE = new String[]{"Serialized", "Parallel"};
    static final String[] _optionLabels = new String[]{"Remote Image Files Copy Only", "Version Check Only", "Install without version check Prompting"};
    JComponent[] _options = new JComponent[_optionLabels.length];
    RadioButtonPanel _parallelOption;
    SnmpKTable _table;
    static final String _parallelLabels = "Parallel Install";
    JCheckBox _parallelCB = new JCheckBox();

    public AttrPanel(JFrame parent, UpgradeWizard wiz, Upgrade upgrade) {
        super("Step 4 of 4 - Start Install", "Press 'Finish' to start the install.\nNOTE: Please ensure the management interface on the standby supervisor is connected before proceeding.\n", parent, wiz, upgrade);
        Box box = new Box(1);
        JPanel p = new JPanel(new FlowLayout(0, 2, 0));
        this._parallelOption = new RadioButtonPanel(PARALLEL_CHOICE, PARALLEL_CHOICE.length, this);
        p.add(this._parallelOption);
        box.add(p);
        box.add(new DialogSeparator());
        for (int i = 0; i < _optionLabels.length; ++i) {
            p = new JPanel(new FlowLayout(0, 2, 0));
            this._options[i] = new JCheckBox(_optionLabels[i], false);
            p.add(this._options[i]);
            box.add(p);
        }
        ((JCheckBox)this._options[1]).addActionListener(this);
        ((JCheckBox)this._options[0]).addActionListener(this);
        ((JCheckBox)this._options[2]).addActionListener(this);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("North", box);
        String[] cols = new String[]{"Order", "Switch", "Model", "Running Software Version [Standby]"};
        boolean[] attrs = new boolean[]{true, false, false, false};
        this._table = this.buildTable(cols, attrs, new Array());
        this.setAllowedAddRemoveColumn(this._table, false);
        this._table.setRowSelectionAllowed(true);
        TableColumnModel cm = this._table.getColumnModel();
        cm.setColumnSelectionAllowed(true);
        cm.getColumn(0).setMaxWidth(60);
        JScrollPane sp = new JScrollPane(this._table);
        sp.setPreferredSize(this._table.calcPreferredSize());
        panel.add("Center", sp);
        this.add(panel);
    }

    @Override
    protected SnmpTableModel buildTableModel() {
        return new SnmpTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                if (col == 0) {
                    return AttrPanel.this._isSwOrderEditable;
                }
                return super.isCellEditable(row, col);
            }
        };
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            ((JCheckBox)this._options[0]).setVisible(!this._upgrade.skipDownload());
            if (this.getSwitches().length < 1) {
                this._parallelOption.getButton(1).setSelected(true);
            }
            this._parallelOption.getButton(0).setEnabled(this.getSwitches().length > 1);
            this._parallelOption.getButton(1).setEnabled(this.getSwitches().length > 1);
            boolean isSwOrderEditable = !((JCheckBox)this._options[0]).isSelected() && this._parallelOption.getSelected() != 1;
            Switch[] sws = this.getSwitches();
            Array data = AttrPanel.getData(this._table);
            data.clear();
            for (int i = 0; i < sws.length; ++i) {
                Switch sw = sws[i];
                String ver = sw.getVersion();
                if (sw.isHotStandby()) {
                    ver = ver + " [" + AttrPanel.getStandbyVersion(sw) + "]";
                }
                Object[] row = new Object[]{isSwOrderEditable ? Integer.toString(i + 1) : "1", sw, sw.getSupModel(), ver, null, Integer.toString(i + 1)};
                data.addElement(row);
            }
            AttrPanel.getModel(this._table).fireTableDataChanged();
            ImageSpec[] specs = this._upgrade.getImages();
            if (specs != null) {
                for (int i = 0; i < specs.length; ++i) {
                    boolean hasSsi = this.hasSSI(specs[i]);
                    if (!hasSsi || !((JCheckBox)this._options[0]).isSelected()) continue;
                    ((JCheckBox)this._options[0]).setSelected(false);
                    this.setCopyImageOnly(((JCheckBox)this._options[0]).isSelected());
                    ((JCheckBox)this._options[1]).setEnabled(true);
                    ((JCheckBox)this._options[2]).setEnabled(true);
                    break;
                }
            }
        }
        super.setVisible(b);
    }

    @Override
    public void doPrevious() {
        this.setSwitchOrderEditable(this._isSwOrderEditable);
        if (this.skipImageDownload()) {
            this.showBootVarPanel();
        } else {
            this.showFlashFilePanel();
        }
    }

    @Override
    public void doFinish() {
        Switch[] sws = this.getSwitches();
        Switch[] finalSws = new Switch[sws.length];
        if (this._table.isEditing()) {
            this._table.editingStopped(null);
        }
        try {
            boolean parallelInstall = this._parallelOption.getSelected() == 1;
            boolean isCopyImageOnly = ((JCheckBox)this._options[0]).isSelected();
            for (int i = 0; i < this._table.getRowCount(); ++i) {
                int val = Integer.parseInt((String)this._table.getValueAt(i, this._table.convertColumnIndexToView(0)));
                Switch sw = (Switch)this._table.getValueAt(i, this._table.convertColumnIndexToView(1));
                int order = val - 1;
                if (finalSws[order] == null) {
                    finalSws[order] = sw;
                    continue;
                }
                if (parallelInstall || isCopyImageOnly) {
                    boolean found = false;
                    for (int j = 0; j < finalSws.length; ++j) {
                        if (finalSws[j] != null) continue;
                        finalSws[j] = sw;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.error("Illegal order sequence.");
                    return;
                }
                this.error("Illegal order sequence.");
                return;
            }
        }
        catch (Exception ex) {
            this.error("Illegal sequence number.");
            return;
        }
        this.setSwitches(finalSws);
        this.setIgnoreInstall(((JCheckBox)this._options[1]).isSelected());
        this.setIgnoreVersion(((JCheckBox)this._options[2]).isSelected());
        this.setCopyImageOnly(((JCheckBox)this._options[0]).isSelected());
        this.setParallelInstall(this._parallelOption.getSelected() == 1);
        this.showFinalPanel();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        boolean parallel = this._parallelOption.getSelected() == 1;
        boolean isIgnoreVersionCheckApply = ((JCheckBox)this._options[2]).isEnabled();
        boolean IgnoreVersionCheck = ((JCheckBox)this._options[2]).isSelected();
        if (isIgnoreVersionCheckApply && !IgnoreVersionCheck && parallel) {
            JOptionPane.showMessageDialog(this._upgrade._parent, "<html>No Version Check Prompt support when parallel install is selected.<br>Please note the Install will go on in the disruptive case.", "UpgradeWizard Warning", 2);
            ((JCheckBox)this._options[2]).setSelected(true);
            this.setIgnoreVersion(true);
        }
        this.setParallelInstall(parallel);
        this.setSwitchOrderEditable(!parallel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            boolean isParalInstallApply;
            boolean copyImageOnly = ((JCheckBox)this._options[0]).isSelected();
            boolean versionCheckOnly = ((JCheckBox)this._options[1]).isSelected();
            boolean IgnoreVersionCheck = ((JCheckBox)this._options[2]).isSelected();
            boolean parallelInstall = this._parallelOption.getSelected() == 1;
            boolean bl = isParalInstallApply = this.getSwitches().length > 1;
            if (e.getSource() == (JCheckBox)this._options[0]) {
                ImageSpec[] specs = this._upgrade.getImages();
                if (specs != null) {
                    for (int i = 0; i < specs.length; ++i) {
                        boolean ssiOnly = this.hasSSI(specs[i]);
                        if (!ssiOnly) continue;
                        JOptionPane.showMessageDialog(this._upgrade._parent, "<html>Remote Image Files Copy Only is selected.<br>Remote Image Copy Files Copy is not supported for ssi images. Please provide only System/Kickstart images.", "UpgradeWizard Warning", 2);
                        ((JCheckBox)this._options[0]).setSelected(false);
                        return;
                    }
                }
                ((JCheckBox)this._options[1]).setEnabled(!copyImageOnly);
                ((JCheckBox)this._options[2]).setEnabled(!copyImageOnly && !versionCheckOnly);
                this._parallelOption.getButton(0).setEnabled(!copyImageOnly && this.getSwitches().length > 1);
                this._parallelOption.getButton(1).setEnabled(isParalInstallApply);
                if (!this._parallelOption.getButton(0).isEnabled() && this._parallelOption.getButton(0).isSelected()) {
                    this._parallelOption.getButton(1).setSelected(true);
                }
                if (this._parallelOption.getButton(0).isEnabled() && this._parallelOption.getButton(1).isEnabled() && this._parallelOption.getButton(1).isSelected() && !versionCheckOnly) {
                    this._parallelOption.getButton(0).setSelected(true);
                }
                this.setCopyImageOnly(((JCheckBox)this._options[0]).isSelected());
                this.setSwitchOrderEditable(!((JCheckBox)this._options[0]).isSelected());
            } else if (e.getSource() == (JCheckBox)this._options[1]) {
                ((JCheckBox)this._options[2]).setEnabled(!versionCheckOnly);
                IgnoreVersionCheck = ((JCheckBox)this._options[2]).isSelected();
                if (!IgnoreVersionCheck && parallelInstall && isParalInstallApply) {
                    ((JCheckBox)this._options[2]).setSelected(true);
                    this.setIgnoreVersion(((JCheckBox)this._options[2]).isSelected());
                }
                this.setIgnoreInstall(((JCheckBox)this._options[1]).isSelected());
            } else if (e.getSource() == (JCheckBox)this._options[2]) {
                if (!IgnoreVersionCheck && parallelInstall && isParalInstallApply) {
                    JOptionPane.showMessageDialog(this._upgrade._parent, "<html>No Version Check Prompt support when parallel install is selected.<br>Please note the Install will go on in the disruptive case.", "UpgradeWizard Warning", 2);
                    this._parallelOption.getButton(0).setSelected(true);
                    this.setParallelInstall(false);
                    this.setSwitchOrderEditable(true);
                }
                this.setIgnoreVersion(((JCheckBox)this._options[2]).isSelected());
            }
            if (!((JCheckBox)this._options[1]).isEnabled()) {
                ((JCheckBox)this._options[1]).setSelected(false);
                this.setIgnoreInstall(false);
            }
            if (!((JCheckBox)this._options[2]).isEnabled()) {
                ((JCheckBox)this._options[2]).setSelected(false);
                this.setIgnoreVersion(false);
            }
        }
    }

    void setSwitchOrderEditable(boolean isEditable) {
        if (this._table.isEditing()) {
            this._table.editingStopped(null);
            ((SnmpTableModel)this._table.getModel()).resetChanges(false);
        }
        boolean isChanged = this._isSwOrderEditable != isEditable;
        this._isSwOrderEditable = isEditable;
        AttrPanel.getModel(this._table).fireTableDataChanged();
        if (!isChanged) {
            return;
        }
        if (!isEditable) {
            Array data = ((SnmpTableModel)this._table.getModel()).getData();
            for (int i = 0; i < ((SnmpTableModel)this._table.getModel()).getData().size(); ++i) {
                Object[] row = (Object[])data.elementAt(i);
                row[5] = row[0];
                row[0] = "1";
            }
        } else {
            Array data = ((SnmpTableModel)this._table.getModel()).getData();
            for (int i = 0; i < ((SnmpTableModel)this._table.getModel()).getData().size(); ++i) {
                Object[] row = (Object[])data.elementAt(i);
                row[0] = row[5];
            }
        }
    }

    boolean hasSSI(ImageSpec spec) {
        boolean hasSsi = false;
        String[] vars = spec.getVars();
        String[] vals = spec.getVals();
        for (int j = 0; j < vars.length && j < vals.length; ++j) {
            if (!vars[j].equals("ssi") || vals[j] == null || vals[j].length() <= 0) continue;
            hasSsi = true;
            break;
        }
        return hasSsi;
    }
}

