/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.upgrade.u3_0_3;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.flash.FlashFileDialog;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.ImageSpec;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.Upgrade;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradePanel;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradeWizard;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public class FlashFilePanel
extends UpgradePanel
implements SnmpCallbackIf {
    SnmpKTable _table;
    JScrollPane _sp;
    int[] _deviceOid = MibNode.get("ciscoFlashDeviceName").getOid();
    int[] _partOid = MibNode.get("ciscoFlashPartitionName").getOid();
    int[] _sizeOldOid = MibNode.get("ciscoFlashPartitionSize").getOid();
    int[] _size4GOid = MibNode.get("ciscoFlashPartitionSizeExtended").getOid();
    int[] _freeOldOid = MibNode.get("ciscoFlashPartitionFreeSpace").getOid();
    int[] _free4GOid = MibNode.get("ciscoFlashPartitionFreeSpaceExtended").getOid();
    int[] _fnameOid = MibNode.get("ciscoFlashFileName").getOid();
    int[] _fsizeOid = MibNode.get("ciscoFlashFileSize").getOid();
    static final String ACTIVE = "active";
    static final String STANDBY = "standby";
    static final String CHECK_MSG = "Checking size";
    static final String OK_MSG = "Ok";
    static final String ERR_MSG = "No space";
    static Font _NormalFont = (Font)UIManager.getDefaults().get("Table.font");
    static Font _BoldFont = new Font(_NormalFont.getName(), 1, _NormalFont.getSize());

    public FlashFilePanel(JFrame parent, UpgradeWizard wiz, Upgrade upgrade) {
        super("Step 3 of 4 - Check Flash Free Space", "The table below shows the active (and standby, if applicable) bootflash space on each switch, and shows the status (whether there is enough space for the new images). If any switch has insufficient space, you cannot proceed. Free space by clicking the edit button (...), or deselect the switch by going back to the first screen and unchecking the checkbox.", parent, wiz, upgrade);
        String[] cols = new String[]{"Edit", "Switch", "Supervisor", "Size (MB)", "Free (MB)", "Required (MB)", "Status"};
        boolean[] attrs = new boolean[]{false, false, false, false, false, false, false};
        this._table = this.buildTable(cols, attrs, new Array());
        this.setAllowedAddRemoveColumn(this._table, false);
        this._table.addMouseListener(new TableMouseListener());
        this._table.setRowSelectionAllowed(true);
        TableColumnModel cm = this._table.getColumnModel();
        cm.setColumnSelectionAllowed(true);
        TableButtonRenderer brndr = new TableButtonRenderer();
        brndr.setHorizontalAlignment(0);
        brndr.setToolTipText("Click to edit/view flash files");
        cm.getColumn(0).setCellRenderer(brndr);
        cm.getColumn(0).setMaxWidth(30);
        this._sp = new JScrollPane(this._table);
        this._sp.setPreferredSize(this._table.calcPreferredSize());
        JPanel p = new JPanel(new BorderLayout());
        p.add("Center", this._sp);
        this.add(p);
    }

    @Override
    public void dispose() {
        Array data = FlashFilePanel.getData(this._table);
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            ((FileManager)row[0]).dispose();
        }
    }

    @Override
    public void setVisible(boolean b) {
        block5: {
            try {
                if (b) {
                    Switch[] sws = this.getSwitches();
                    Array data = FlashFilePanel.getData(this._table);
                    data.clear();
                    for (int i = 0; i < sws.length; ++i) {
                        Switch sw = sws[i];
                        FileManager fMgr = new FileManager(this._parent, sw, ACTIVE, this._upgrade._upgradeLogger);
                        int required = this.getRequired(sw);
                        Object[] row = new Object[]{fMgr, sw, ACTIVE, null, null, new Integer(required), CHECK_MSG, null};
                        data.addElement(row);
                        if (sw.isHotStandby() && !FlashFilePanel.isOlderThan12(sw)) {
                            fMgr = new FileManager(this._parent, sw, STANDBY, this._upgrade._upgradeLogger);
                            row = new Object[]{fMgr, sw, STANDBY, null, null, new Integer(required), CHECK_MSG, null};
                            data.addElement(row);
                        }
                        this.fetchPartitionInfo(sw);
                    }
                    FlashFilePanel.getModel(this._table).fireTableDataChanged();
                    this._sp.setPreferredSize(this._table.calcPreferredSize());
                }
            }
            catch (SnmpException se) {
                this._upgrade._upgradeLogger.error((Object)("FlashFilePanel: " + se));
                if (!SnmpSession.isTrace()) break block5;
                DefaultLogger._ExLogger.warn((Object)("FlashFilePanel " + se.getMessage()), (Throwable)se);
            }
        }
        super.setVisible(b);
    }

    @Override
    public void doPrevious() {
        this.showImagePanel();
    }

    boolean okRow(JTable table, int rowIndex) {
        return rowIndex >= 0 && rowIndex < table.getModel().getRowCount();
    }

    @Override
    public void doNext() {
        Array data = FlashFilePanel.getData(this._table);
        boolean allOk = true;
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            allOk = allOk && ((String)row[6]).startsWith(OK_MSG);
        }
        if (!allOk) {
            this.error("Please make sure all switches have space");
            return;
        }
        this.showAttrPanel();
    }

    int getRequired(Switch sw) {
        ImageSpec[] specs = this.getImages();
        String model = FlashFilePanel.getBareModel(sw);
        for (int i = 0; i < specs.length; ++i) {
            if (!FlashFilePanel.sameImage(model, specs[i].getModel())) continue;
            return specs[i].getRequiredSpace();
        }
        return 0;
    }

    void fetchPartitionInfo(Switch sw) {
        try {
            VarBindList vbl = new VarBindList();
            int[] index = new int[]{1, 1};
            boolean _is4GFlashSupport = sw.isVersionGreaterThanEqual("4.1(3)");
            int[] sizeOid = _is4GFlashSupport ? this._size4GOid : this._sizeOldOid;
            int[] freeOid = _is4GFlashSupport ? this._free4GOid : this._freeOldOid;
            vbl.add(new SnmpVarBind(new SnmpOID(sizeOid, index)));
            vbl.add(new SnmpVarBind(new SnmpOID(freeOid, index)));
            if (sw.isHotStandby()) {
                index[1] = 2;
                vbl.add(new SnmpVarBind(new SnmpOID(sizeOid, index)));
                vbl.add(new SnmpVarBind(new SnmpOID(freeOid, index)));
            }
            SnmpPDU pdu = new SnmpPDU(-96, vbl);
            pdu.setLogger(this._upgrade._upgradeLogger);
            sw.getPeer().send(pdu, this);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(pdu.getAddress());
        Array data = FlashFilePanel.getData(this._table);
        Object[] row1 = null;
        Object[] row2 = null;
        for (int i = 0; i < data.size(); ++i) {
            if (sw != (Switch)FlashFilePanel.getModel(this._table).getValueAt(i, this._table.convertColumnIndexToView(1))) continue;
            if (row1 == null) {
                row1 = (Object[])data.elementAt(i);
                continue;
            }
            row2 = (Object[])data.elementAt(i);
        }
        if (row1 == null) {
            return;
        }
        if (!ACTIVE.equals((String)row1[2])) {
            Object[] tmp = row1;
            row1 = row2;
            row2 = tmp;
        }
        int required = (Integer)row1[5];
        if (timedOut) {
            row1[6] = "SNMP Timeout";
            if (row2 != null) {
                row2[6] = "SNMP Timeout";
            }
        } else if (pdu.getError() != 0) {
            row1[6] = SnmpException.toError(pdu.getError());
            if (row2 != null) {
                row2[6] = SnmpException.toError(pdu.getError());
            }
        } else {
            VarBindList vbl = pdu.getVariables();
            this.checkSpace(row1, vbl.longValue(0), vbl.longValue(1), required);
            if (row2 != null && vbl.size() == 4) {
                this.checkSpace(row2, vbl.longValue(2), vbl.longValue(3), required);
            }
        }
        FlashFilePanel.getModel(this._table).fireTableDataChanged();
        this._sp.setPreferredSize(this._table.calcPreferredSize());
    }

    void checkSpace(Object[] row, long size, long free, int required) {
        if (size == 0L) {
            row[6] = "Cant read device";
            return;
        }
        row[3] = new Long(size /= 0x100000L);
        row[4] = new Long(free /= 0x100000L);
        row[6] = free > (long)required ? OK_MSG : ERR_MSG;
    }

    class FileManager
    extends FlashFileDialog {
        Switch _sw;

        FileManager(JFrame parent, Switch sw, String isActive, Logger log) throws SnmpException {
            super(sw.getPeer(), parent, isActive, FlashFilePanel.this._upgrade._upgradeLogger, sw.getVersion().compareTo("6.2(1)") >= 0, sw.getVersion().compareTo("6.2(1)") >= 0);
            this._sw = sw;
            this.setShowOKButton(false);
            this.setTitle("Flash Files - " + sw + " (Upgrade Wizard)");
            this.setLogger(log);
        }

        @Override
        public void setVisible(boolean isShow) {
            FlashFilePanel.this._upgrade._upgradeLogger.debug((Object)("FlashFilePanel:FilaManager isShow = " + isShow));
            if (!isShow) {
                FlashFilePanel.this.fetchPartitionInfo(this._sw);
            }
            super.setVisible(isShow);
        }
    }

    class TableButtonRenderer
    extends BorderCellRenderer {
        TableButtonRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            if (value != null) {
                this.setBorder(BorderFactory.createBevelBorder(0));
                this.setFont(_BoldFont);
                super.setValue("...");
            } else {
                this.setText("");
            }
        }
    }

    class TableMouseListener
    extends MouseInputAdapter {
        TableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            SnmpKTable t = (SnmpKTable)e.getSource();
            int row = t.rowAtPoint(p);
            int col = t.columnAtPoint(p);
            if (col == 0) {
                Object obj = UpgradePanel.getModel(FlashFilePanel.this._table).getValueAt(row, FlashFilePanel.this._table.convertColumnIndexToView(0));
                ((FileManager)obj).setVisible(true);
            }
        }
    }
}

