/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.upgrade.u3_0_3;

import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.jnm.SshUserInfo;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.TFTP;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.ImageSpec;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.Upgrade;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradePanel;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradeWizard;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.UserInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableColumnModel;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

class ImagePanel
extends UpgradePanel
implements ActionListener,
ItemListener {
    SnmpKTable _table;
    JScrollPane _sp;
    JCheckBox _cb;
    RadioButtonPanel _imgLoc;
    RadioButtonPanel _remoteProto;
    KTextField _server;
    KTextField _user;
    JPasswordField _pass;
    FieldPanel _space;
    KTextField _path;
    FieldPanel _versionString;
    JLabel[] _remoteLabels;
    JButton _verifyButton;
    JButton _autoDetectButton;
    private static final int SSH_CONNECT_TIMEOUT = 90000;
    private static final int SSH_INIT_READ_TIMEOUT = 10000;
    static final int DEFAULT_SIZE = 120;
    static final String[] LOCS = new String[]{"TFTP", "SFTP", "SCP", "FTP"};
    static final int[] LOC_VALUES = new int[]{1, 6, 5, 4, -1};
    static final String[] IMGLOCS = new String[]{"Local DCNM-SAN TFTP", "Remote"};
    static final String[] IMG_VARS_STR = new String[]{"system", "kickstart", "asm-sfn", "ssi"};
    static final String[] IMG_COL_STR = new String[]{"Model", "System", "Kickstart", "Asm-sfn", "Ssi"};
    static ImageMatrix[] IMG_MATRIX = new ImageMatrix[12];
    static final String IMAGE_NOT_ENTERED = "Please specify images for every model.\nChoose one of the following:\n1. System and Kickstart\n2. System, Kickstart and SSI\n3. SSI only";
    static final String PROPERTY_FILENAME = "upgrade.properties";
    static final String TRANS_FROM = "TRANS_FROM";
    static final String TRANS_PROTOCOL = "TRANS_PROTOCOL";
    static final String SERVER_NAME = "SERVER_NAME";
    static final String USER_NAME = "USER_NAME";
    static final String VERSION_STRING = "VERSION_STRING";
    static final String IMAGE_PATH = "IMAGE_PATH";
    static final String EMPTY_STRING = "";
    static final String DELIMIT_STRING = "~~~";
    static final int Tftp = 0;
    static final int Sftp = 1;
    static final int Scp = 2;
    static final int Ftp = 3;
    static final int MAX_MODEL_LEN = 100;
    static final int MODEL = 0;
    static final int SYSTEM_IMAGE = 1;
    static final int KICKSTART_IMAGE = 2;
    static final int ASM_IMAGE = 3;
    static final int SSI_IMAGE = 4;
    private static Properties _Properties;
    private String[][] _imageArray;
    private int BUTTON_IMAGE_CHECK = 1;
    private int PATH_IMAGE_CHECK = 2;
    private int DO_NEXT_IMAGE_CHECK = 3;
    JCheckBox useSavedCB;
    static Font _NormalFont;
    static Font _BoldFont;

    public ImagePanel(JFrame parent, UpgradeWizard wiz, Upgrade upgrade) {
        super("Step 2 of 4 - Specify Software Image(s) by Model", "For each switch model, specify the new images to use. You must specify at least one image for each model by double-clicking on the table cell. Or you can specify Version String and Image Path, then click on 'Find Image File and Update Table' button to have wizard find the image file based on the input for you. The total space required on the bootflash to copy the image is shown in the 'Required Flash Space' column.  To use images that are already downloaded, check 'Skip Image Download'. Press 'Verify' to validate remote server settings and filenames (SSHv2 only); be patient, this can take awhile. Please manually copy ssi image to switch.", parent, wiz, upgrade);
        Box box = new Box(1);
        this.useSavedCB = new JCheckBox("Use Saved Settings    (displayed settings will be saved when mouse click \"Next\" button)");
        JPanel p = new JPanel(new FlowLayout(0, 2, 0));
        p.add(this.useSavedCB);
        box.add(p);
        box.add(new DialogSeparator());
        this.useSavedCB.addActionListener(this);
        p = new JPanel(new FlowLayout(0, 2, 0));
        p.add(new JLabel("Transfer files from: "));
        this._imgLoc = new RadioButtonPanel(IMGLOCS, IMGLOCS.length, this);
        p.add(this._imgLoc);
        box.add(p);
        box.add(new DialogSeparator("Remote Options"));
        this._remoteLabels = DialogUtil.buildLabels(new String[]{"Copy Files Via:", "Server:", "UserName:", "Password:", "Flash Space:"});
        this._remoteLabels[4].setVisible(false);
        this._remoteProto = new RadioButtonPanel(LOCS, LOCS.length, this);
        this._server = new KTextField(20);
        this._user = new KTextField(20);
        this._pass = new JPasswordField(20);
        this._space = new FieldPanel(5, 120, 1, 512, "MB");
        this._verifyButton = new JButton("Verify Remote Server and Path");
        this._verifyButton.addActionListener(this);
        this._remoteProto.getButton(0).setVisible(false);
        this._remoteProto.setSelected(1);
        this._imgLoc.setSelected(1);
        p = DialogUtil.buildPanel(this._remoteLabels, new JComponent[]{this._remoteProto, this._server, this._user, this._pass, this._space});
        box.add(p);
        box.add(new DialogSeparator("Image(s)"));
        JPanel pathPanel = new JPanel(new FlowLayout(0, 0, 1));
        this._path = new KTextField(28);
        pathPanel.add(this._path);
        this._versionString = new FieldPanel(13, (JComponent)new JLabel("e.g. 4.2.1 for 4.2(1), 4.2.1a for 4.2(1a)..."));
        this._autoDetectButton = new JButton("Find Image File and Update Table");
        this._autoDetectButton.addActionListener(this);
        this._autoDetectButton.setActionCommand("Path");
        this._autoDetectButton.setToolTipText("Please fill out VersionString and Path first");
        p = new JPanel(new FlowLayout(0, 6, 0));
        p.add(this._autoDetectButton);
        pathPanel.add(p);
        JComponent[] _pathLabels = DialogUtil.buildLabels(new String[]{"Version String:", "Image Path:"});
        p = DialogUtil.buildPanel(_pathLabels, new JComponent[]{this._versionString, pathPanel});
        box.add(p);
        p = new JPanel(new FlowLayout(0, 2, 5));
        p.add(new JLabel("      "));
        box.add(p);
        p = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 2, 1, 2);
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        p.add((Component)this._verifyButton, gbc);
        gbc.weightx = 0.0;
        box.add(p);
        p = new JPanel(new BorderLayout());
        p.add("North", box);
        boolean[] attrs = new boolean[]{false, true, true, true, true};
        this._table = this.buildTable(IMG_COL_STR, attrs, new Array());
        this.setAllowedAddRemoveColumn(this._table, false);
        this._table.setRowSelectionAllowed(true);
        this._table.setRowHeight(20);
        TableColumnModel cm = this._table.getColumnModel();
        cm.setColumnSelectionAllowed(true);
        BaseRenderer rndr = new BaseRenderer();
        rndr.setToolTipText("Double-Click to edit");
        FileCellEditor editor = new FileCellEditor();
        cm.getColumn(0).setMaxWidth(100);
        cm.getColumn(1).setCellRenderer(rndr);
        cm.getColumn(2).setCellRenderer(rndr);
        cm.getColumn(3).setCellRenderer(rndr);
        cm.getColumn(4).setCellRenderer(rndr);
        cm.getColumn(1).setCellEditor(editor);
        cm.getColumn(2).setCellEditor(editor);
        cm.getColumn(3).setCellEditor(editor);
        cm.getColumn(4).setCellEditor(editor);
        this._sp = new JScrollPane(this._table);
        this._sp.setPreferredSize(this._table.calcPreferredSize());
        p.add("Center", this._sp);
        JPanel p2 = new JPanel(new FlowLayout(2, 2, 0));
        this._cb = new JCheckBox("Skip Image Download");
        this._cb.addActionListener(this);
        p2.add(this._cb);
        p.add("South", p2);
        this.add(p);
        this._table.removeColumn(cm.getColumn(3));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        boolean remote = this._imgLoc.getSelected() == 1;
        int proto = this._remoteProto.getSelected();
        this._remoteProto.setEnabled(remote);
        this._server.setEnabled(remote);
        this._user.setEnabled(remote);
        this._pass.setEnabled(remote);
        this._space.setVisible(remote && proto == 0);
        this._verifyButton.setEnabled(remote);
        for (int i = 0; i < this._remoteLabels.length; ++i) {
            if (i == this._remoteLabels.length - 1) {
                this._remoteLabels[i].setEnabled(remote && proto == 0);
                continue;
            }
            this._remoteLabels[i].setEnabled(remote);
        }
        if (this._remoteProto.isEnabled()) {
            Switch[] sws;
            boolean newProto;
            this._user.setEnabled(proto > 0);
            this._pass.setEnabled(proto > 0);
            this._pass.setBackground(proto > 0 ? UIManager.getColor("TextField.background") : UIManager.getColor("Label.background"));
            this._remoteLabels[2].setEnabled(proto > 0);
            this._remoteLabels[3].setEnabled(proto > 0);
            boolean bl = newProto = proto == 1 || proto == 2;
            if (newProto && (sws = this.getSwitches()) != null) {
                for (int i = 0; i < sws.length; ++i) {
                    Switch sw = sws[i];
                    if (sw.isVersionGreaterThanEqual("1.3(0)")) continue;
                    this.error(sw + " does not support this transfer\tmethod");
                    return;
                }
            }
        }
    }

    boolean skipDownload() {
        return this._cb.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            if (this._table.isEditing()) {
                this._table.editingStopped(null);
            }
            if (e.getActionCommand().charAt(0) == 'P') {
                String path = this._path.getText();
                String versionString = this._versionString.getText();
                if (path.equals(EMPTY_STRING) || versionString.equals(EMPTY_STRING)) {
                    this.error("Please provide both VersionString and Path.");
                    return;
                }
                try {
                    this.checkImages(this.PATH_IMAGE_CHECK, null);
                }
                catch (Exception ex) {
                    this.error(ex.getMessage());
                    return;
                }
            } else {
                try {
                    this.checkImages(this.BUTTON_IMAGE_CHECK, null);
                }
                catch (Exception ex) {
                    this.error(ex.getMessage());
                    return;
                }
            }
        } else if (e.getSource() == this.useSavedCB) {
            if (this.useSavedCB.isSelected()) {
                if (this._table.isEditing()) {
                    this._table.editingStopped(null);
                }
                this.load();
            }
        } else {
            ImagePanel.getModel(this._table).fireTableDataChanged();
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this._imgLoc.getButton(0).setEnabled(TFTP.canStartServer());
            this._imgLoc.setSelected(!this.isLocal() ? 1 : (TFTP.canStartServer() ? 0 : 1));
            Array data = ImagePanel.getData(this._table);
            Switch[] sws = this.getSwitches();
            this._upgrade._upgradeLogger.debug((Object)("ImagePanel::setVisible  sws = " + sws));
            HashMap<Object, Object[]> model2Row = new HashMap<Object, Object[]>();
            for (int i = 0; i < data.size(); ++i) {
                Object[] row = (Object[])data.elementAt(i);
                model2Row.put(row[0], row);
            }
            data.clear();
            HashSet<String> models = new HashSet<String>();
            for (int i = 0; i < sws.length; ++i) {
                Switch sw = sws[i];
                String model = ImagePanel.getBareModel(sw);
                this._upgrade._upgradeLogger.debug((Object)("ImagePanel::setVisible getModel sw/model= " + sw + " / " + model));
                if (models.contains(model)) continue;
                if (model2Row.containsKey(model)) {
                    data.addElement(model2Row.get(model));
                } else {
                    data.addElement(new Object[]{model, EMPTY_STRING, EMPTY_STRING, EMPTY_STRING, EMPTY_STRING, null, 0});
                }
                models.add(model);
            }
            ImagePanel.getModel(this._table).fireTableDataChanged();
            Dimension a = this._table.calcPreferredSize();
            this._sp.setPreferredSize(this._table.calcPreferredSize());
            this._sp.setPreferredSize(new Dimension(500, 1050));
            this.useSavedCB.setSelected(false);
            this.invalidate();
        }
        super.setVisible(b);
    }

    @Override
    public void doPrevious() {
        this.setLocal(this._imgLoc.getSelected() == 0);
        super.doPrevious();
    }

    @Override
    public void doNext() {
        InetAddress server;
        block9: {
            this.setLocal(this._imgLoc.getSelected() == 0);
            if (this.skipDownload()) {
                this.save();
                this.setImages(null);
                this.showBootVarPanel();
                return;
            }
            if (this._table.isEditing()) {
                this._table.editingStopped(null);
            }
            try {
                if (this._remoteProto.isEnabled()) {
                    if (this._server.getText() == null || this._server.getText().length() == 0) {
                        this.error("Server address empty");
                        return;
                    }
                    server = InetAddress.getByName(this._server.getText().trim());
                    break block9;
                }
                server = null;
                Switch[] sws = this.getSwitches();
                try {
                    server = NetUtil.detectSourceAddress(sws[0].getPeer().getAddress());
                }
                catch (Exception ex) {
                    UpgradeWizard wiz = (UpgradeWizard)this.getWizard();
                    String vpnAddr = wiz.getVpnAddress();
                    if (vpnAddr != null) {
                        server = InetAddress.getByName(vpnAddr);
                        break block9;
                    }
                    server = InetAddress.getLocalHost();
                }
            }
            catch (Exception ex) {
                this.error("Illegal server address");
                return;
            }
        }
        this.getWizard().setStatus("Validate image file/size and check flash space,  please wait...");
        SwingUtilities.invokeLater(new doNextWorker(server));
    }

    protected void load() {
        _Properties = ClientController.getInstance().loadPropertiesFromServer(PROPERTY_FILENAME, false);
        if (_Properties != null && _Properties.size() > 0) {
            String str = _Properties.getProperty(TRANS_FROM);
            if (str != null && str.length() > 0) {
                try {
                    boolean logSelect = this._imgLoc.getButton(0).isEnabled();
                    int val = Integer.parseInt(str);
                    if (!logSelect && val == 0) {
                        this.error("Cannot set \"Transfer files from\" as \"Local DCNM-SAN TFTP\". Please make sure tftp port is available");
                        this.useSavedCB.setSelected(false);
                        return;
                    }
                    this._imgLoc.setSelected(val);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if ((str = _Properties.getProperty(TRANS_PROTOCOL)) != null && str.length() > 0) {
                try {
                    int val = Integer.parseInt(str);
                    this._remoteProto.setSelected(val);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if ((str = _Properties.getProperty(SERVER_NAME)) != null && str.length() > 0) {
                this._server.setText(str);
            }
            if ((str = _Properties.getProperty(USER_NAME)) != null && str.length() > 0) {
                this._user.setText(str);
            }
            if ((str = _Properties.getProperty(VERSION_STRING)) != null && str.length() > 0) {
                this._versionString.setText(str);
            }
            if ((str = _Properties.getProperty(IMAGE_PATH)) != null && str.length() > 0) {
                this._path.setText(str);
            }
            SnmpTableModel model = (SnmpTableModel)this._table.getModel();
            int rowCount = model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                String modelName = (String)model.getValueAt(i, this._table.convertColumnIndexToView(0));
                for (int icol = 1; icol < IMG_COL_STR.length; ++icol) {
                    String strVal;
                    str = modelName + DELIMIT_STRING + IMG_COL_STR[icol];
                    if (str == null || (strVal = _Properties.getProperty(str)) == null) continue;
                    this.setValueAt(model, strVal, i, IMG_COL_STR[icol]);
                }
            }
            model.fireTableDataChanged();
        }
    }

    protected void setValueAt(SnmpTableModel model, Object value, int row, String colName) {
        int col = model.findColumn(colName);
        model.setValueAt(value, row, col);
    }

    protected void setDefault() {
        this._imgLoc.setSelected(0);
        this._remoteProto.setSelected(0);
        this._server.setText(EMPTY_STRING);
        this._user.setText(EMPTY_STRING);
        SnmpTableModel model = (SnmpTableModel)this._table.getModel();
        int rowCount = model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < 4; ++j) {
                model.setValueAt(EMPTY_STRING, i, j + 1);
            }
        }
        model.fireTableDataChanged();
    }

    protected void save() {
        if (_Properties == null) {
            _Properties = new Properties();
        }
        try {
            _Properties.setProperty(TRANS_FROM, EMPTY_STRING + this._imgLoc.getSelected());
            _Properties.setProperty(TRANS_PROTOCOL, EMPTY_STRING + this._remoteProto.getSelected());
            _Properties.setProperty(SERVER_NAME, EMPTY_STRING + this._server.getText());
            _Properties.setProperty(USER_NAME, EMPTY_STRING + this._user.getText());
            _Properties.setProperty(VERSION_STRING, EMPTY_STRING + this._versionString.getText());
            _Properties.setProperty(IMAGE_PATH, EMPTY_STRING + this._path.getText());
            for (int i = 0; i < this._imageArray.length; ++i) {
                if (this._imageArray[i][0] == null || this._imageArray[i][0].length() <= 0) continue;
                _Properties.setProperty(this._imageArray[i][0], this._imageArray[i][1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_Properties != null && _Properties.size() > 0) {
            ClientController.getInstance().storePropertiesToServer(PROPERTY_FILENAME, _Properties, EMPTY_STRING, false);
        }
    }

    long getFileTftp(String h, String f) throws Exception {
        InetAddress addr = InetAddress.getByName(h);
        TFTP tftp = TFTP.getInstance();
        try {
            tftp.get(f, "tempFile", addr, 69);
            File imageFile = new File("tempFile");
            long len = (int)imageFile.length();
            return len;
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkTftp(String h, String f, boolean showInfo) throws Exception {
        InetAddress addr = InetAddress.getByName(h);
        byte[] ib = new byte[516];
        byte[] ob = new byte[516];
        DatagramPacket ip = new DatagramPacket(ib, ib.length);
        DatagramPacket op = new DatagramPacket(ob, ob.length);
        sock.setSoTimeout(5000);
        try (DatagramSocket sock = new DatagramSocket();){
            int block;
            byte[] bmode = new byte[]{111, 99, 116, 101, 116};
            ob[0] = 0;
            ob[1] = 1;
            System.arraycopy(f.getBytes(), 0, ob, 2, f.length());
            ob[f.length() + 2] = 0;
            System.arraycopy(bmode, 0, ob, f.length() + 3, bmode.length);
            ob[f.length() + bmode.length + 3] = 0;
            op.setData(ob);
            op.setLength(f.length() + bmode.length + 4);
            op.setAddress(addr);
            op.setPort(69);
            sock.send(op);
            try {
                sock.receive(ip);
            }
            catch (SocketTimeoutException ex) {
                this._upgrade._upgradeLogger.error((Object)ex.getMessage(), (Throwable)ex);
                boolean bl = false;
                sock.close();
                return bl;
            }
            byte[] data = ip.getData();
            byte opcode = data[1];
            if (opcode == 3 && (block = (data[2] & 0xFF) << 8 | data[3] & 0xFF) == 1) {
                if (showInfo) {
                    this.info(f + " is verified.");
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteFile checkSftp(String h, String u, String p, String f, boolean showInfo) throws Exception {
        block10: {
            JSch jsch = new JSch();
            Session session = jsch.getSession(u, h, 22);
            session.setPassword(p);
            session.setUserInfo(new SshUserInfo(p));
            session.connect(90000, new String[]{Session.PUBLIC_KEY, Session.PASSWORD, Session.KEYBOARD_INTERACTIVE});
            Channel channel = session.openChannel("sftp");
            channel.connect();
            String msg = null;
            try {
                ChannelSftp c = (ChannelSftp)channel;
                boolean isDir = c.isDir(f);
                if (isDir) {
                    msg = showInfo ? "Inupt " + f + " is a path." : null;
                    RemoteFile remoteFile = new RemoteFile(false, -1L, msg);
                    return remoteFile;
                }
                Vector v = c.ls(f);
                if (v.size() <= 0) break block10;
                this._upgrade._upgradeLogger.error((Object)("sftp:" + v.elementAt(0).toString()));
                try {
                    String realLink = c.readlink(f);
                    int slash = f.lastIndexOf(47);
                    if (slash != -1) {
                        String path = f.substring(0, slash + 1);
                        f = path + realLink;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                SftpATTRS state = c.lstat(f);
                long len = state.getSize();
                msg = showInfo ? f + " is verified. The file size is " + DefaultSnmpNumberRenderer.formatLong(len) : null;
                RemoteFile remoteFile = new RemoteFile(true, len, msg);
                return remoteFile;
            }
            catch (Exception ex) {
                RemoteFile remoteFile = new RemoteFile(false, -1L);
                return remoteFile;
            }
            finally {
                channel.disconnect();
                session.disconnect();
            }
        }
        return new RemoteFile(false, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteFile checkScp(String h, String u, String p, String f, boolean showInfo) throws Exception {
        String msg = null;
        JSch jsch = new JSch();
        Session session = jsch.getSession(u, h, 22);
        session.setPassword(p);
        session.setUserInfo(new SshUserInfo(p));
        session.setTimeout(10000);
        session.connect(90000, new String[]{Session.PUBLIC_KEY, Session.PASSWORD, Session.KEYBOARD_INTERACTIVE});
        String cmd = "scp -f " + f;
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(cmd);
        OutputStream out = channel.getOutputStream();
        InputStream in = channel.getInputStream();
        channel.connect();
        try {
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            int b = in.read();
            if (b == 1 || b == 2) {
                int c;
                StringBuffer sb = new StringBuffer();
                do {
                    c = in.read();
                    sb.append((char)c);
                } while (c != 10);
                this._upgrade._upgradeLogger.error((Object)("ssh:" + sb.toString()));
            }
            if (b == 67) {
                in.read(buf, 0, 5);
                int filesize = 0;
                while (true) {
                    in.read(buf, 0, 1);
                    if (buf[0] == 32) break;
                    filesize = filesize * 10 + (buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                if (showInfo) {
                    msg = f + " is verified. File size is " + DefaultSnmpNumberRenderer.formatLong(filesize);
                }
                this._upgrade._upgradeLogger.error((Object)("filesize = " + filesize + ", file = " + file));
                RemoteFile remoteFile = new RemoteFile(true, filesize, msg);
                return remoteFile;
            }
        }
        finally {
            channel.disconnect();
            session.disconnect();
        }
        return new RemoteFile(false, -1L);
    }

    public RemoteFile checkFtp(String h, String u, String p, String f, boolean showInfo) throws Exception {
        String link;
        FTPFile[] linkFiles;
        this._upgrade._upgradeLogger.debug((Object)("checkFtp: h/u/p/f " + h + "/" + u + "/" + p + "/" + f));
        FTPClient ftp = new FTPClient();
        String msg = null;
        this._upgrade._upgradeLogger.debug((Object)"checkFtp  connect...");
        ftp.connect(h);
        this._upgrade._upgradeLogger.debug((Object)"checkFtp  login...");
        ftp.login(u, p);
        this._upgrade._upgradeLogger.debug((Object)("checkFtp  listFiles for " + f));
        FTPFile[] files = ftp.listFiles(f);
        if (files.length != 1) {
            return new RemoteFile(false, -1L);
        }
        if (files[0].isSymbolicLink() && (linkFiles = ftp.listFiles(link = files[0].getLink())).length == 1) {
            files = linkFiles;
        }
        this._upgrade._upgradeLogger.debug((Object)"checkFtp  verified");
        if (showInfo) {
            msg = f + " is verified. File size is " + DefaultSnmpNumberRenderer.formatLong(files[0].getSize());
        }
        return new RemoteFile(true, files[0].getSize(), msg);
    }

    void checkImages(int method, InetAddress server) throws Exception {
        boolean local = this._imgLoc.getSelected() == 0;
        int remoteProto = this._remoteProto.isEnabled() ? this._remoteProto.getSelected() : LOC_VALUES.length - 1;
        String host = this._server.getText().trim();
        String user = null;
        String pass = null;
        long space = 0L;
        int userInputSpace = 0;
        String path = this._path.getText();
        String versionString = this._versionString.getText();
        if (!local) {
            if (this._server.getText() == null || this._server.getText().length() == 0) {
                String errMsg = "Enter server address";
                if (method == this.DO_NEXT_IMAGE_CHECK) {
                    errMsg = errMsg + ". Image Verification failed, not able to go to next panel.";
                }
                throw new Exception(errMsg);
            }
            if (this._user.isEnabled()) {
                user = this._user.getText();
                pass = new String(this._pass.getPassword());
                if (user == null || user.length() == 0 || pass == null || pass.length() == 0) {
                    String errMsg = "Username and password need to be filled";
                    if (method == this.DO_NEXT_IMAGE_CHECK) {
                        errMsg = errMsg + ". Image Verification failed, not able to go to next panel.";
                    }
                    throw new Exception(errMsg);
                }
            }
            if (this._space.isEnabled() && this._space.isVisible()) {
                try {
                    userInputSpace = this._space.getInt();
                }
                catch (NumberFormatException ex) {
                    String errMsg = "Bad required\tfree space size";
                    if (method == this.DO_NEXT_IMAGE_CHECK) {
                        errMsg = errMsg + ". Image Verification failed, not able to go to next panel.";
                    }
                    throw new Exception(errMsg);
                }
            }
        }
        Array data = ImagePanel.getData(this._table);
        ImageSpec[] specs = new ImageSpec[data.size()];
        this._imageArray = new String[100 * IMG_COL_STR.length][2];
        int count = 0;
        boolean imageEntered = false;
        boolean imageVerifyOk = true;
        try {
            String displayText = EMPTY_STRING;
            ImagePanel.getModel(this._table).fireTableDataChanged();
            for (int i = 0; i < data.size(); ++i) {
                Object[] row = (Object[])data.elementAt(i);
                String[] vals = new String[IMG_VARS_STR.length];
                if (!(method == this.PATH_IMAGE_CHECK || row[1] != null && row[1].toString().length() != 0 && row[2] != null && row[2].toString().length() != 0 || row[4] != null && row[4].toString().length() != 0)) {
                    imageEntered = false;
                    imageVerifyOk = false;
                    break;
                }
                int[] pathCheck_cols = new int[]{1, 2};
                int[] imageCheck_cols = new int[]{1, 2, 4};
                int[] cols = method == this.PATH_IMAGE_CHECK ? pathCheck_cols : imageCheck_cols;
                space = 0L;
                for (int j = cols[0]; j <= cols[cols.length - 1]; ++j) {
                    String err;
                    String model;
                    int modelcol;
                    RemoteFile remoteFile = new RemoteFile(false, -1L);
                    String val = row[j].toString().trim();
                    int n = modelcol = method == this.PATH_IMAGE_CHECK ? this._table.convertColumnIndexToModel(j) : -1;
                    if (method == this.PATH_IMAGE_CHECK && (val = this.findImage(model = row[0].toString(), path, versionString, modelcol - 1)) == null) continue;
                    vals[j - 1] = val;
                    if (!local && val.length() > 0) {
                        boolean b = true;
                        imageEntered = true;
                        switch (remoteProto) {
                            case 0: {
                                b = this.checkTftp(host, val, method == this.BUTTON_IMAGE_CHECK);
                                break;
                            }
                            case 1: {
                                remoteFile = this.checkSftp(host, user, pass, val, method == this.BUTTON_IMAGE_CHECK);
                                b = remoteFile.isExist();
                                space += remoteFile.getSize();
                                break;
                            }
                            case 2: {
                                remoteFile = this.checkScp(host, user, pass, val, method == this.BUTTON_IMAGE_CHECK);
                                b = remoteFile.isExist();
                                space += remoteFile.getSize();
                                break;
                            }
                            case 3: {
                                remoteFile = this.checkFtp(host, user, pass, val, method == this.BUTTON_IMAGE_CHECK);
                                b = remoteFile.isExist();
                                space += remoteFile.getSize();
                            }
                        }
                        imageVerifyOk &= b;
                        if (!b) {
                            String msg;
                            err = "Model " + row[0] + " " + IMG_VARS_STR[j - 1];
                            String string = msg = method == this.PATH_IMAGE_CHECK ? " not found" : " verify failed";
                            if (method == this.PATH_IMAGE_CHECK) {
                                row[modelcol] = EMPTY_STRING;
                            }
                            String remoteMsg = remoteFile.getMessage() == null ? EMPTY_STRING : remoteFile.getMessage();
                            displayText = displayText + err + " " + msg + "\n" + "    " + remoteMsg + "\n";
                        } else if (b && method == this.PATH_IMAGE_CHECK) {
                            this._table.getModel().setValueAt(val, i, modelcol);
                            imageEntered = true;
                            if (remoteFile != null && remoteFile.getMessage() != null) {
                                displayText = displayText + remoteFile.getMessage() + "\n";
                            }
                        } else if (b && method == this.BUTTON_IMAGE_CHECK && remoteFile != null && remoteFile.getMessage() != null) {
                            displayText = displayText + remoteFile.getMessage() + "\n";
                        }
                    }
                    if (method != this.PATH_IMAGE_CHECK && method != this.DO_NEXT_IMAGE_CHECK || !local || val.length() <= 0) continue;
                    File f = new File(val);
                    if (f.exists()) {
                        space += f.length();
                        imageEntered = true;
                        if (method != this.PATH_IMAGE_CHECK) continue;
                        this._table.getModel().setValueAt(val, i, modelcol);
                        continue;
                    }
                    err = "Model " + row[0] + " " + IMG_VARS_STR[j - 1] + " not found";
                    if (method == this.PATH_IMAGE_CHECK) {
                        row[modelcol] = EMPTY_STRING;
                    }
                    displayText = displayText + err + "\n";
                }
                if (method != this.DO_NEXT_IMAGE_CHECK) continue;
                space = this._space.isEnabled() && this._space.isVisible() ? (long)userInputSpace : space / 0x100000L + 1L;
                specs[i] = new ImageSpec(row[0].toString(), server, LOC_VALUES[remoteProto], user, pass, local, IMG_VARS_STR, vals, (int)space);
                for (int icol = 0; icol < IMG_VARS_STR.length; ++icol) {
                    this._imageArray[count][0] = row[0].toString() + DELIMIT_STRING + IMG_COL_STR[icol + 1];
                    this._imageArray[count][1] = vals[icol];
                    ++count;
                }
            }
            if (displayText != null && displayText.length() > 0) {
                this.info(displayText, true);
            }
        }
        catch (Exception ex) {
            String errMsg = "Check server & credentials, it may be due to server unreachable. " + ex.getMessage();
            this._upgrade._upgradeLogger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new Exception(errMsg);
        }
        if (method != this.PATH_IMAGE_CHECK && !imageEntered) {
            throw new Exception(IMAGE_NOT_ENTERED);
        }
        if (method == this.DO_NEXT_IMAGE_CHECK && !imageVerifyOk) {
            throw new Exception("Image Verification failed, not able to go to next panel.\n Maybe due to timedout, please try again.");
        }
        if (method == this.DO_NEXT_IMAGE_CHECK) {
            this.setImages(specs);
        }
        if (method == this.PATH_IMAGE_CHECK) {
            ImagePanel.getModel(this._table).fireTableDataChanged();
        }
    }

    String findImage(String model, String path, String versionString, int imageCol) {
        this._upgrade._upgradeLogger.debug((Object)("findImage: model/path/versionString/imageCol = " + model + '/' + path + '/' + versionString + '/' + imageCol));
        int lastDot = versionString.lastIndexOf(46);
        String minorBuild = EMPTY_STRING;
        if (lastDot != -1 && lastDot != 0) {
            try {
                if (Character.toLowerCase(versionString.charAt(lastDot + 1)) == 's') {
                    minorBuild = versionString.substring(lastDot + 1, versionString.length());
                    versionString = versionString.substring(0, lastDot);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        for (int i = 0; i < IMG_MATRIX.length; ++i) {
            if (!ImagePanel.IMG_MATRIX[i]._model.equals(model)) continue;
            String val = ImagePanel.IMG_MATRIX[i]._imageNames[imageCol];
            if (val == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(path);
            if (path.charAt(path.length() - 1) != '/') {
                sb.append('/');
            }
            sb.append(val);
            if (path.endsWith("gdb") || path.endsWith("gdb/")) {
                sb.append("g");
            }
            sb.append('.');
            sb.append(versionString);
            sb.append(".bin");
            if (minorBuild.length() > 0) {
                sb.append('.');
                sb.append(minorBuild);
            }
            this._upgrade._upgradeLogger.debug((Object)("findImage: return " + sb.toString()));
            return sb.toString();
        }
        this._upgrade._upgradeLogger.debug((Object)"findImage: cannot find image model from IMG_MATRIX, return null !!");
        return null;
    }

    static {
        ImagePanel.IMG_MATRIX[0] = new ImageMatrix("DS-C9500", new String[]{"System", "Kickstart"}, new String[]{"m9500-sf1ek9-mz", "m9500-sf1ek9-kickstart-mz"});
        ImagePanel.IMG_MATRIX[1] = new ImageMatrix("DS-C9500-SF2", new String[]{"System", "Kickstart"}, new String[]{"m9500-sf2ek9-mz", "m9500-sf2ek9-kickstart-mz"});
        ImagePanel.IMG_MATRIX[2] = new ImageMatrix("DS-C9200", new String[]{"System", "Kickstart"}, new String[]{"m9200-ek9-mz", "m9200-ek9-kickstart-mz"});
        ImagePanel.IMG_MATRIX[3] = new ImageMatrix("DS-C9200-S2", new String[]{"System", "Kickstart"}, new String[]{"m9200-s2ek9-mz", "m9200-s2ek9-kickstart-mz"});
        ImagePanel.IMG_MATRIX[4] = new ImageMatrix("DS-C9100", new String[]{"System", "Kickstart"}, new String[]{"m9100-s1ek9-mz", "m9100-s1ek9-kickstart-mz"});
        ImagePanel.IMG_MATRIX[5] = new ImageMatrix("DS-C9100-S2", new String[]{"System", "Kickstart"}, new String[]{"m9100-s2ek9-mz", "m9100-s2ek9-kickstart-mz"});
        ImagePanel.IMG_MATRIX[6] = new ImageMatrix("DS-C9100-S3", new String[]{"System", "Kickstart"}, new String[]{"m9100-s3ek9-mz", "m9100-s3ek9-kickstart-mz"});
        ImagePanel.IMG_MATRIX[7] = new ImageMatrix("N5K", new String[]{"System", "Kickstart"}, new String[]{"n5000-uk9", "n5000-uk9-kickstart"});
        ImagePanel.IMG_MATRIX[8] = new ImageMatrix("DS-C9700-SF3", new String[]{"System", "Kickstart"}, new String[]{"m9700-sf3ek9-mz", "m9700-sf3ek9-kickstart-mz"});
        ImagePanel.IMG_MATRIX[9] = new ImageMatrix("DS-C9250-S5", new String[]{"System", "Kickstart"}, new String[]{"m9250-s5ek9-mz", "m9250-s5ek9-kickstart-mz"});
        ImagePanel.IMG_MATRIX[10] = new ImageMatrix("N6K", new String[]{"System", "Kickstart"}, new String[]{"n6000-uk9", "n6000-uk9-kickstart"});
        ImagePanel.IMG_MATRIX[11] = new ImageMatrix("N5K-C56", new String[]{"System", "Kickstart"}, new String[]{"n6000-uk9", "n6000-uk9-kickstart"});
        _Properties = null;
        _NormalFont = (Font)UIManager.getDefaults().get("Table.font");
        _BoldFont = new Font(_NormalFont.getName(), 1, _NormalFont.getSize());
    }

    static class ImageMatrix {
        String _model;
        String[] _imageVars;
        String[] _imageNames;

        ImageMatrix(String model, String[] imageVars, String[] imageNames) {
            this._model = model;
            this._imageVars = imageVars;
            this._imageNames = imageNames;
        }
    }

    class RemoteFile {
        boolean _isExist;
        long _size;
        String _msg = null;

        RemoteFile(boolean isExist, long size) {
            this(isExist, size, null);
        }

        RemoteFile(boolean isExist, long size, String msg) {
            this._isExist = isExist;
            this._size = size;
            this._msg = msg;
        }

        boolean isExist() {
            return this._isExist;
        }

        long getSize() {
            return this._size;
        }

        String getMessage() {
            return this._msg;
        }
    }

    class MyUserInfo
    implements UserInfo {
        String _p;

        MyUserInfo(String p) {
            this._p = p;
        }

        @Override
        public String getPassphrase() {
            return null;
        }

        @Override
        public String getPassword() {
            return this._p;
        }

        @Override
        public boolean promptPassword(String message) {
            return true;
        }

        @Override
        public boolean promptPassphrase(String message) {
            return false;
        }

        @Override
        public boolean promptYesNo(String message) {
            return true;
        }

        @Override
        public void showMessage(String message) {
            ImagePanel.this._upgrade._upgradeLogger.error((Object)("ssh userinfo showMessage: " + message));
        }
    }

    class FileCellEditor
    extends DefaultCellEditor {
        public FileCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (ImagePanel.this._imgLoc.getSelected() == 0) {
                String fname = Util.getFileName(ImagePanel.this._parent, "*.bin", 0, true);
                if (fname != null) {
                    int modelcol = table.convertColumnIndexToModel(column);
                    table.getModel().setValueAt(fname, row, modelcol);
                }
                return null;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    class BaseRenderer
    extends ChangedCellRenderer {
        BaseRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null && value.toString().length() > 0) {
                int slash = value.toString().lastIndexOf("/");
                if (slash == -1) {
                    slash = value.toString().lastIndexOf("\\");
                }
                if (slash != -1) {
                    this.setText(value.toString().substring(slash + 1));
                } else {
                    this.setText(value.toString());
                }
            }
            return c;
        }
    }

    class doNextWorker
    implements Runnable {
        InetAddress _server;

        public doNextWorker(InetAddress server) {
            this._server = server;
        }

        @Override
        public void run() {
            try {
                ImagePanel.this.checkImages(ImagePanel.this.DO_NEXT_IMAGE_CHECK, this._server);
            }
            catch (Exception ex) {
                ImagePanel.this.getWizard().setStatus(ImagePanel.EMPTY_STRING);
                ImagePanel.this.error(ex.getMessage());
                return;
            }
            ImagePanel.this.getWizard().setStatus(ImagePanel.EMPTY_STRING);
            ImagePanel.this.save();
            ImagePanel.this.showFlashFilePanel();
        }
    }
}

