/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.upgrade.u3_0_3;

import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.ImageSpec;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.Upgrade;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.Timer;
import org.apache.log4j.Logger;

class State
implements SnmpCallbackIf {
    static final String DUALSUP_MSG = "This dual supervisor switch is running an older software\n version. Hitless install through SNMP is not supported on\n the switch software. Please do a software install on this box\n via CLI.";
    static final String SUP_MSG = "This switch running an older software  version. Hitless\n install through SNMP is not supported on  the switch\n software. It is RECOMMENDED to do software install on this box  via\n CLI. If you still want to do a disruptive install of\n the active supervisor please click on yes.";
    static final String INIT_ACTION = "Initializing";
    static final String COPY_CONFIG_ACTION = "Copying running to startup config";
    static final String BACKUP_CONFIG_ACTION = "Downloading startup config to local file";
    static final String FLASH_COPY_ACTION = "Downloading images onto bootflash";
    static final String READ_BOOT_VARS_ACTION = "Reading boot variables";
    static final String WRITE_BOOT_VARS_ACTION = "Writing boot variables";
    static final String START_UPGRADE_ACTION = "Ready to start upgrade";
    static final String REBOOT_SWITCH_ACTION = "Rebooting switch";
    static final String DONE_REMOTE_COPY_IMAGE = "Done remote image Copy";
    static final String INIT_STATUS = "";
    static final String POLL_STATUS = "InProgress Polling ";
    static final String CANCEL_STATUS = "Cancelled ";
    static final String TIMEOUT_STATUS = "Timeout ";
    static final String INPROGRESS_STATUS = "InProgress ";
    static final String SUCCESS_STATUS = "Success ";
    static final String ERR_STATUS = "Failure ";
    static final String POLLERR_STATUS = "InProgress poll error ";
    static final String DIGERR_STATUS = "InProgress digest error ";
    static final String FETCH_GENERR = "fetching genError description";
    static final int INITIATE_ABORT = 1;
    static final int INPROGRESS_ABORT = 2;
    static final int DONE_ABORT = 3;
    static final int INIT_STATE = 0;
    static final int CC_FIRE_STATE = 1;
    static final int CC_POLL_STATE = 2;
    static final int BC_FIRE_STATE = 3;
    static final int BC_POLL_STATE = 4;
    static final int IMG_FIRE_STATE = 5;
    static final int IMG_NEXT_STATE = 6;
    static final int IMG_POLL_STATE = 7;
    static final int START_UPGRADE_STATE = 8;
    static final int BOOT_READ_STATE = 10;
    static final int BOOT_WRITE_STATE = 11;
    static final int CC2_FIRE_STATE = 12;
    static final int CC2_POLL_STATE = 13;
    static final int RELOAD_FIRE_STATE = 14;
    static final int RELOAD_POLL_STATE = 15;
    static final int DONE_STATE = 100;
    static final int ERR_STATE = 101;
    static final int FETCH_ERR_STATE = 102;
    static final int NETWORK_CFG = 1;
    static final int STARTUP_CFG = 3;
    static final int RUN_CFG = 4;
    static final int RF_UNIT_UNKNOWN = 0;
    static final int RF_ACTIVE = 14;
    boolean _NOOP = false;
    static final int[] ZEROINDEX = new int[]{0};
    static final String GENERR = SnmpException.toError(5);
    static int[] _ccRowStatusOid = State.getOids("ccCopyEntryRowStatus");
    static int[] _ccStateOid = State.getOids("ccCopyState");
    static int[] _flashRowStatusOid = State.getOids("ciscoFlashCopyEntryStatus");
    static int[] _flashStatusOid = State.getOids("ciscoFlashCopyStatus");
    static int[] _bootVarOid = State.getOids("ceExtSysBootImageList");
    static int[] _rebootOid = State.getOids("cRFCfgAdminAction");
    static int[] _rfOid = State.getOids("cRFStatusUnitId");
    static int[] _genErrOid = State.getOids("cseSnmpErrorDescription");
    static final SnmpCallbackIf DUMMY_CB = new SnmpCallbackIf(){

        @Override
        public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        }
    };
    Switch _sw;
    String _swName;
    PKIf _swPK;
    int _state;
    int _abortState;
    String _action;
    String _status;
    Logger _logger;
    int _snmpPending;
    boolean _pollMode;
    private Object _obj1;
    private Object _obj2;
    Upgrade _up;
    boolean _showStatus = true;
    int _snmpTimeouts;
    long _snmpTimeoutStamp;
    int _snmpTimeoutsFlashCopy;
    long _snmpUnknownUserTimeStamp;
    boolean _hotStandby;
    boolean _bootable = true;
    boolean _abortable = true;
    protected boolean _isDoneVersionCheck = false;
    static final int[] ciscoFlashCopyRemotePasswordOid_pre_6_2_1 = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 10, 1, 2, 1, 1, 12};

    public Object getObj1() {
        return this._obj1;
    }

    public void setObj1(Object obj1) {
        this._obj1 = obj1;
    }

    public Object getObj2() {
        return this._obj2;
    }

    public void setObj2(Object obj2) {
        this._obj2 = obj2;
    }

    String getAction() {
        return this._action;
    }

    void setAction(String action) {
        this._action = action;
    }

    void setShowStatus(boolean b) {
        this._showStatus = b;
    }

    void setLogger(Logger logger) {
        this._logger = logger;
    }

    Logger getLogger() {
        if (this._logger == null) {
            return this._up._upgradeLogger;
        }
        return this._logger;
    }

    String getStatus() {
        this.getLogger().debug((Object)(this.getSwName() + ": getStatus= " + this._status));
        return this._status;
    }

    void setStatus(String status) {
        this.getLogger().debug((Object)(this.getSwName() + ", setStatus _showStatus " + this._showStatus + "   (" + status + ")"));
        if (this._showStatus) {
            this._status = status;
        }
    }

    Array getMoreStatus() {
        return null;
    }

    void buildMiscInfoAllData() {
    }

    void buildIncompatInfoAllData() {
    }

    boolean isSnmpPending() {
        return this._snmpPending > 0;
    }

    void sentSnmpReq(boolean poll) {
        this._pollMode = poll;
        this.sentSnmpReq();
    }

    void sentSnmpReq() {
        ++this._snmpPending;
        this.getLogger().debug((Object)(this.getSwName() + ": _snmpPending++ = " + this._snmpPending));
    }

    void gotSnmpResp() {
        --this._snmpPending;
        if (this._snmpPending == 0) {
            this._pollMode = false;
        }
        this.getLogger().debug((Object)(this.getSwName() + ": _snmpPending-- = " + this._snmpPending));
    }

    void resetSnmpPending() {
        this._snmpPending = 0;
        this._pollMode = false;
        this.getLogger().debug((Object)(this.getSwName() + ", _snmpPending reset"));
    }

    boolean isPollMode() {
        return this._pollMode;
    }

    boolean isCommonState() {
        return this._state < 8;
    }

    boolean isInStartUpgradeState() {
        this.getLogger().debug((Object)(this.getSwName() + ": setStatus isInStartUpgradeState(), _state = " + this._state));
        return this._state == 8;
    }

    boolean isUp() {
        this.getLogger().debug((Object)(this.getSwName() + ": State isUp(), _state = " + this._state));
        return this._state != 100 && this._state != 101 && this._abortState != 3;
    }

    boolean isAbortable() {
        return this._abortable;
    }

    boolean isDoneVersionCheck() {
        return this._isDoneVersionCheck;
    }

    void resume() {
        this.getLogger().debug((Object)(this.getSwName() + ": State resume(), old _state = " + this._state));
        if (!this.isUp() && this._state == 100) {
            boolean isDoneVersionCheck = this._isDoneVersionCheck;
            this.setResumeState();
            if (isDoneVersionCheck) {
                this._state = 8;
            }
            this.getLogger().debug((Object)(this.getSwName() + ": resume to START_UPGRADE_STATE, State resume(), new _state = " + this._state));
        }
    }

    boolean isAbort() {
        return this._state == 1 || this._state == 2 || this._state == 3;
    }

    boolean genErrOccurred() {
        this.getLogger().debug((Object)(this.getSwName() + ": State genErrOccured()..."));
        if (this._state == 102 && this._obj1 != null && this._obj2 != null) {
            SnmpSession session = (SnmpSession)this._obj1;
            SnmpPDU pdu = (SnmpPDU)this._obj2;
            this.setObj1(null);
            this.setObj2(null);
            this.getGenError(session, pdu);
            this.getLogger().debug((Object)(this.getSwName() + ": State genErrOccured() TRUE"));
            return true;
        }
        this.getLogger().debug((Object)(this.getSwName() + ": State genErrOccured() FALSE"));
        return false;
    }

    void abort() {
        this._abortState = 1;
    }

    void err(String msg) {
        this.setStatus(ERR_STATUS + msg);
        this._state = 101;
    }

    void genErr(SnmpSession session, SnmpPDU pdu) {
        this._state = 102;
        this.setObj1(session);
        this.setObj2(pdu);
        this.setStatus("Failure fetching genError description");
    }

    void readyForUpgrade() {
        this.getLogger().debug((Object)(this.getSwName() + ", readyForUpgrade for sw,  copyImageOnly ? " + this._up.getCopyImageOnly()));
        this.setAction(this._up.getCopyImageOnly() ? DONE_REMOTE_COPY_IMAGE : START_UPGRADE_ACTION);
        this.setStatus(this._up.getCopyImageOnly() ? SUCCESS_STATUS : INIT_STATUS);
        this._state = this._up.getCopyImageOnly() ? 100 : 8;
        this.getLogger().debug((Object)(this.getSwName() + ", readyForUpgrade for sw,  _state " + this._state));
    }

    boolean abortOccurred() {
        if (this._abortState == 1) {
            this._abortState = 3;
            return true;
        }
        return false;
    }

    String[] getSysAndKick() {
        ImageSpec image = this._up.getImage(this._sw, this.getSwitch());
        String[] vars = image.getVars();
        String sys = null;
        String kick = null;
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i].equals("system")) {
                sys = image.getFlashUri(this.getSwitch(), i, this._up.skipDownload());
                continue;
            }
            if (!vars[i].equals("kickstart")) continue;
            kick = image.getFlashUri(this.getSwitch(), i, this._up.skipDownload());
        }
        return new String[]{sys, kick};
    }

    static int moduleToSlot(int mod) {
        if (mod != 0) {
            int slot = mod - 21;
            if (slot > 24) {
                slot /= 1000000;
            }
            return slot;
        }
        return mod;
    }

    static String getEnum(String name, int value) {
        MibNode mn = MibNode.get(name);
        return MibEnum.getLabel(mn.getEnums(), value);
    }

    static int[] getOids(String name) {
        return MibNode.get(name).getOid();
    }

    static SnmpOID getOid(String name) {
        return new SnmpOID(MibNode.get(name).getOid());
    }

    void getGenError(SnmpSession session, SnmpPDU pdu) {
        try {
            SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
            int[] oid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 305, 1, 2, 1, 1, 5, 1, 0, 0, 0, 0, 0};
            byte[] b = peer.getSession().getSnmpSourceAddress().getAddress();
            String vpnAddr = peer.getSession().getLocalVPNAddress();
            if (vpnAddr != null && vpnAddr.length() != 0) {
                try {
                    b = InetAddress.getByName(vpnAddr).getAddress();
                }
                catch (UnknownHostException uhe) {
                    // empty catch block
                }
            }
            for (int i = 0; i < b.length; ++i) {
                oid[oid.length - (5 - i)] = b[i] & 0xFF;
            }
            oid[oid.length - 1] = pdu.getReqid();
            SnmpPDU errPdu = new SnmpPDU(-96, new VarBindList(1));
            errPdu.setLogger(this.getLogger());
            errPdu.addNull(new SnmpOID(oid));
            peer.send(errPdu, this);
            this.getLogger().debug((Object)(this.getSwName() + ": getGenError   _snmpPending++"));
            this.sentSnmpReq();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void getGenErrorCb(VarBindList vbl) {
        this.getLogger().debug((Object)(this.getSwName() + ": State getGenErrorCb setShowStatus true"));
        this.setShowStatus(true);
        this._state = 101;
        if (!vbl.isNull(0)) {
            this.setStatus(ERR_STATUS + vbl.stringValue(0));
        } else {
            this.setStatus(ERR_STATUS + GENERR);
        }
    }

    static int random() {
        return (int)(Math.random() * 2.14748364E8) + 1;
    }

    static int getActiveSupIndex(Switch sw) {
        return sw.getActiveSupSlot() + 21;
    }

    static int getStandbySupIndex(Switch sw) {
        return sw.getStandBySupSlot() + 21;
    }

    State(Switch sw, Upgrade up) {
        this._sw = sw;
        this._swName = sw.toString();
        this._swPK = sw.getPK();
        this._hotStandby = this._sw.isHotStandby();
        this._up = up;
        this.setInitState();
    }

    void setInitState() {
        this._state = 0;
        this._action = INIT_ACTION;
        this._status = INIT_STATUS;
        this._showStatus = true;
        this._bootable = true;
        this._abortable = true;
        this._NOOP = false;
        this._isDoneVersionCheck = false;
        this.initCounters();
    }

    void setResumeState() {
        this.readyForUpgrade();
        this._showStatus = true;
        this._bootable = true;
        this._abortable = true;
        this._NOOP = false;
        this._isDoneVersionCheck = false;
        this.initCounters();
    }

    void initCounters() {
        this.getLogger().debug((Object)(this.getSwName() + ": initCounters"));
        this._snmpTimeouts = 0;
        this._snmpTimeoutStamp = 0L;
        this._snmpUnknownUserTimeStamp = 0L;
        this._snmpTimeoutsFlashCopy = 0;
        this.resetSnmpPending();
    }

    void tick() {
        try {
            this.getLogger().debug((Object)(this.getSwName() + ": State tick() _state : " + this._state + "    _NOOP = " + this._NOOP));
            if (this._snmpTimeouts == 0 && (this.isSnmpPending() || this.genErrOccurred() || this.abortOccurred() || !this.isUp())) {
                this.getLogger().debug((Object)(this.getSwName() + ": State tick() return : _snmpTimeouts=" + this._snmpTimeouts + " isSnmpPending=" + this.isSnmpPending() + " abortOccurred=" + this.abortOccurred()));
                return;
            }
            switch (this._state) {
                case 0: {
                    this._NOOP = false;
                }
                case 5: {
                    this._state = 5;
                    if (this._up.skipDownload()) {
                        this.readyForUpgrade();
                        break;
                    }
                    this._state = 6;
                }
                case 6: {
                    this.getLogger().debug((Object)(this.getSwName() + ", State  IMG_NEXT_STATE startFlashCopy..."));
                    try {
                        this.startFlashCopy();
                    }
                    catch (Exception ex) {
                        this.err(ex.getMessage());
                        break;
                    }
                    this.getLogger().debug((Object)(this.getSwName() + ", State IMG_NEXT_STATE if moreFlashCopy"));
                    if (!this.moreFlashCopy()) {
                        this.getLogger().debug((Object)(this.getSwName() + ", State IMG_NEXT_STATE no moreFlashCopy readyForUpgrade"));
                        this.readyForUpgrade();
                        break;
                    }
                    this._state = 7;
                    break;
                }
                case 7: {
                    this.getLogger().debug((Object)(this.getSwName() + ", State  IMG_POLL_STATE check if doneFlashCopy..."));
                    if (!this.doneFlashCopy()) {
                        this.getLogger().debug((Object)(this.getSwName() + ", State IMG_POLL_STATE not doneFlashCopy, pollFlashCopy..."));
                        this.pollFlashCopy();
                        break;
                    }
                    this.getLogger().debug((Object)(this.getSwName() + ", State IMG_POLL_STATE check if moreFlashCopy"));
                    if (this.moreFlashCopy()) {
                        this.getLogger().debug((Object)(this.getSwName() + ", State IMG_POLL_STATE  moreFlashCopy tick()"));
                        this._state = 6;
                        this.tick();
                        break;
                    }
                    this.getLogger().debug((Object)(this.getSwName() + ", State IMG_POLL_STATE not moreFlashCopy readyForUpgrade()"));
                    this.readyForUpgrade();
                    break;
                }
                case 8: {
                    if (this._hotStandby) {
                        this._up.showUser(DUALSUP_MSG, this.getSwName());
                        this._state = 100;
                        this.setStatus(CANCEL_STATUS);
                        break;
                    }
                    if (!this._up.askUser(SUP_MSG, this.getSwName())) {
                        this._state = 100;
                        this.setStatus(CANCEL_STATUS);
                        break;
                    }
                    this._state = 10;
                }
                case 10: {
                    this.readBootVars();
                    this._state = 11;
                    break;
                }
                case 11: {
                    this.writeBootVars();
                    this._state = 12;
                    break;
                }
                case 12: {
                    this.startCopyConfig(4, 3);
                    this._state = 13;
                    break;
                }
                case 13: {
                    if (!this.doneCopyConfig()) {
                        this.pollCopyConfig();
                        break;
                    }
                    this._state = 14;
                }
                case 14: {
                    this.startRebootSwitch();
                    this._state = 15;
                    break;
                }
                case 15: {
                    if (!this.doneRebootSwitch()) {
                        this._status = POLL_STATUS;
                        this.pollRebootSwitch();
                        break;
                    }
                    this._state = 100;
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error((Object)"State tick(), Exception ", (Throwable)ex);
        }
    }

    String snmpRequestTimedOut(SnmpPeer peer, int reqid, SnmpPDU pdu) {
        peer.checkSnmpConnection();
        return TIMEOUT_STATUS;
    }

    String snmpRequestOtherErr(SnmpPeer peer, int reqid, SnmpPDU pdu, String errMsg) {
        return errMsg;
    }

    /*
     * Enabled aggressive block sorting
     */
    synchronized boolean snmpRequestOk(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        String errMsg;
        block13: {
            SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
            if (timedOut) {
                ++this._snmpTimeouts;
                if (this._snmpTimeoutStamp == 0L) {
                    this._snmpTimeoutStamp = System.currentTimeMillis();
                    this.getLogger().debug((Object)(this.getSwName() + ": " + reqid + " timeout set timestamp " + this._snmpTimeoutStamp + " / _snmpTimeouts " + this._snmpTimeouts));
                }
            } else {
                this._snmpTimeouts = 0;
                this._snmpTimeoutStamp = 0L;
                this.getLogger().debug((Object)(this.getSwName() + ": " + reqid + " reset timeoutStamp"));
            }
            errMsg = SnmpException.toError(pdu.getError());
            this.getLogger().debug((Object)(this.getSwName() + ": " + reqid + "snmpRequestOk?  pdu.getError/timedOut/errMsg " + pdu.getError() + "/" + timedOut + "/" + errMsg));
            if (pdu.getError() == 26) {
                if (this._snmpUnknownUserTimeStamp == 0L) {
                    this._snmpUnknownUserTimeStamp = System.currentTimeMillis();
                    this.getLogger().debug((Object)(this.getSwName() + ": " + reqid + " unknownUser set timestamp " + this._snmpUnknownUserTimeStamp));
                }
                this.snmpRequestOtherErr(peer, reqid, pdu, errMsg);
                return false;
            }
            this._snmpUnknownUserTimeStamp = 0L;
            this.getLogger().debug((Object)(this.getSwName() + ": " + reqid + " reset unknownUserTimeStamp"));
            if (!timedOut && pdu.getError() == 0) {
                return true;
            }
            if (timedOut) {
                errMsg = this.snmpRequestTimedOut(peer, reqid, pdu);
                if (this._state != 102) return false;
                this.getLogger().debug((Object)(this.getSwName() + ": " + reqid + " fetch genErr timeout, dismiss this switch."));
                this._state = 101;
                return false;
            }
            this.snmpRequestOtherErr(peer, reqid, pdu, errMsg);
            if (pdu.getError() == 28 && peer.isV3()) {
                this.setStatus(DIGERR_STATUS + errMsg);
                WrongDigest wd = new WrongDigest(peer);
                this.getLogger().debug((Object)(this.getSwName() + ": " + reqid + " wrong digest, prompt for new password..."));
                wd.show();
                if (!wd.timedOut() && !wd.cancelled()) {
                    this.getLogger().debug((Object)(this.getSwName() + ": " + reqid + " user input new password"));
                    peer.setAuthPassword(wd.getPassword());
                    peer.setPrivPassword(null);
                    peer.calcLocalizedKey();
                    break block13;
                } else {
                    this.getLogger().debug((Object)(this.getSwName() + ": " + reqid + " user input new password timedout or cancelled, post WrongDigest error"));
                    if (this.getStatus().indexOf(DIGERR_STATUS) == -1) return false;
                    this.err(errMsg);
                    return false;
                }
            }
            if (pdu.getError() == 5 && !this.isPollMode()) {
                this.genErr(session, pdu);
                return false;
            }
            if (pdu.getError() == 24 && this.isPollMode()) {
                return false;
            }
            errMsg = SnmpException.toError(pdu.getError());
        }
        if (this.isPollMode()) {
            this.setStatus(POLLERR_STATUS + errMsg);
            return false;
        }
        this.err(errMsg);
        return false;
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        this.getLogger().debug((Object)(this.getSwName() + ": State callback  timeout " + timedOut + "   error " + pdu.getError()));
        this.getLogger().debug((Object)(this.getSwName() + ": State callback process pdu/vblNum " + pdu.getReqid() + "/" + pdu.getVariables().size()));
        if (this.snmpRequestOk(session, reqid, pdu, timedOut)) {
            this.handleCb(pdu.getVariables());
        }
        this.gotSnmpResp();
    }

    synchronized void handleCb(VarBindList vbl) {
        this.getLogger().debug((Object)(this.getSwName() + ", State handlCb --------- pollMode = " + this._pollMode));
        int[] firstOid = vbl.getVb(0).getOid().getValue();
        if (SnmpOID.startsWith(firstOid, _ccRowStatusOid)) {
            this.startCopyConfigCb(vbl);
        } else if (SnmpOID.startsWith(firstOid, _ccStateOid)) {
            this.pollCopyConfigCb(vbl);
        } else if (SnmpOID.startsWith(firstOid, _flashRowStatusOid)) {
            this._NOOP = false;
            this.getLogger().debug((Object)(this.getSwName() + ", startFlashCopyCb reset _NOOP = " + this._NOOP));
            this.startFlashCopyCb(vbl);
        } else if (SnmpOID.startsWith(firstOid, _flashStatusOid)) {
            this.pollFlashCopyCb(vbl);
        } else if (SnmpOID.startsWith(firstOid, _bootVarOid)) {
            this.bootVarsCb(vbl);
        } else if (SnmpOID.startsWith(firstOid, _rebootOid)) {
            this.startRebootSwitchCb(vbl);
        } else if (SnmpOID.startsWith(firstOid, _rfOid)) {
            this.genericSwitchCb(vbl, 0);
        } else if (SnmpOID.startsWith(firstOid, _genErrOid)) {
            this.getGenErrorCb(vbl);
        }
    }

    void startCopyConfig(int srcCfg, int destCfg) {
        this.startCopyConfig(srcCfg, destCfg, null, null);
    }

    void startCopyConfig(int srcCfg, String dir, String file) {
        this.startCopyConfig(srcCfg, 1, dir, file);
    }

    void startCopyConfig(int srcCfg, int destCfg, String dir, String file) {
        int[] index = new int[]{State.random()};
        SnmpPDU pollPdu = new SnmpPDU(-96, new VarBindList());
        pollPdu.setLogger(this.getLogger());
        pollPdu.addVar(new SnmpOID(_ccStateOid, index));
        pollPdu.addVar(new SnmpOID(State.getOids("ccCopyFailCause"), index));
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setLogger(this.getLogger());
        pdu.setIgnoreSetCount(true);
        pdu.addVar(new SnmpOID(_ccRowStatusOid, index), new SnmpInt(4));
        pdu.addVar(new SnmpOID(State.getOids("ccCopySourceFileType"), index), new SnmpInt(srcCfg));
        pdu.addVar(new SnmpOID(State.getOids("ccCopyDestFileType"), index), new SnmpInt(destCfg));
        if (dir != null) {
            this._up.getTftp().addFileMapping(file, dir + File.separator + file);
            pdu.addVar(new SnmpOID(State.getOids("ccCopyServerAddress"), index), new SnmpIpAddress(this._up.getTftp().getServerAddress().getAddress()));
            pdu.addVar(new SnmpOID(State.getOids("ccCopyFileName"), index), new SnmpString(file));
            pdu.addVar(new SnmpOID(State.getOids("ccCopyProtocol"), index), new SnmpInt(1));
        }
        try {
            if (dir == null) {
                this.setAction(COPY_CONFIG_ACTION);
            } else {
                this.setAction(BACKUP_CONFIG_ACTION);
            }
            this.setStatus(INIT_STATUS);
            this.setObj1(pollPdu);
            this.getSwitch().getPeer().send(pdu, this);
            this.getLogger().debug((Object)(this.getSwName() + ": startCopyConfig   _snmpPending++"));
            this.sentSnmpReq();
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    boolean doneCopyConfig() {
        return this._obj1 == null;
    }

    void startCopyConfigCb(VarBindList vbl) {
        this.setStatus(INPROGRESS_STATUS);
    }

    void pollCopyConfig() {
        try {
            this.setStatus(POLL_STATUS);
            this.getSwitch().getPeer().send((SnmpPDU)this._obj1, this);
            this.getLogger().debug((Object)(this.getSwName() + ": pollCopyConfig   _snmpPending++"));
            this.sentSnmpReq(true);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void pollCopyConfigCb(VarBindList vbl) {
        int state = vbl.intValue(0);
        int reason = vbl.intValue(1);
        if (state == 1 || state == 2) {
            this.setStatus(INPROGRESS_STATUS);
        } else if (state == 3) {
            this.setStatus(SUCCESS_STATUS);
            this.setObj1(null);
        } else {
            this.err(State.getEnum("ccCopyFailCause", reason));
        }
    }

    void startFlashCopy() throws Exception {
        int i;
        this.getLogger().debug((Object)(this.getSwName() + ", startFlashCopy..."));
        ImageSpec image = this._up.getImage(this._sw, this.getSwitch());
        String[] vars = image.getVars();
        String[] vals = image.getVals();
        int imageIndex = 0;
        if (this._obj1 != null) {
            imageIndex = (Integer)this._obj1 + 1;
        }
        for (i = imageIndex; i < vars.length && (vals[i] == null || vals[i].length() == 0); ++i) {
        }
        if (i >= vars.length) {
            this.setObj1(null);
            this.getLogger().debug((Object)(this.getSwName() + ", startFlashCopy  _obj1 null, no moreFlashCopy"));
            return;
        }
        this.setObj1(new Integer(i));
        this.getLogger().debug((Object)(this.getSwName() + ", startFlashCopy  _obj1=" + this._obj1));
        String src = vals[i];
        String dest = image.getFlashUri(this.getSwitch(), i, this._up.skipDownload());
        if (image.isLocal()) {
            try {
                src = ImageSpec.baseName(vals[i]);
                this._up.getTftp().addFileMapping(src, vals[i]);
            }
            catch (Exception ex) {
                this.getLogger().error((Object)"Exception caught in State::startFlashCopy()", (Throwable)ex);
                throw new Exception("flash copy failed - Local DCNM-SAN TFTP not available");
            }
        }
        SwitchVersion asmVer = new SwitchVersion("2.1(0)");
        SwitchVersion swVer = new SwitchVersion(this.getSwitch().getVersion());
        if (!vars[i].equals("ssi") || swVer.lessThanEqual(asmVer)) {
            int[] index = new int[]{State.random()};
            SnmpPDU pollPdu = new SnmpPDU(-96, new VarBindList());
            pollPdu.setLogger(this.getLogger());
            pollPdu.addVar(new SnmpOID(_flashStatusOid, index));
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            pdu.setLogger(this.getLogger());
            pdu.setIgnoreSetCount(true);
            pdu.addVar(new SnmpOID(_flashRowStatusOid, index), new SnmpInt(4));
            pdu.addVar(new SnmpOID(State.getOids("ciscoFlashCopyServerAddress"), index), new SnmpIpAddress(image.getServer().getAddress()));
            pdu.addVar(new SnmpOID(State.getOids("ciscoFlashCopySourceName"), index), new SnmpString(src));
            pdu.addVar(new SnmpOID(State.getOids("ciscoFlashCopyDestinationName"), index), new SnmpString(dest));
            pdu.addVar(new SnmpOID(State.getOids("ciscoFlashCopyCommand"), index), new SnmpInt(1));
            if (image.getProtocol() == -1) {
                pdu.addVar(new SnmpOID(State.getOids("ciscoFlashCopyProtocol"), index), new SnmpInt(1));
            } else {
                pdu.addVar(new SnmpOID(State.getOids("ciscoFlashCopyProtocol"), index), new SnmpInt(image.getProtocol()));
            }
            if (image.getProtocol() != 1 && image.getProtocol() != -1) {
                pdu.addVar(new SnmpOID(State.getOids("ciscoFlashCopyRemoteUserName"), index), new SnmpString(image.getUsername()));
                pdu.addVar(new SnmpOID(this._sw.isVersionGreaterThanEqual("6.2(0)") ? State.getOids("ciscoFlashCopyRemotePassword") : ciscoFlashCopyRemotePasswordOid_pre_6_2_1, index), new SnmpString(image.getPassword()));
                pdu.setVarBindMask(new int[]{pdu.getVariables().size() - 1});
            }
            try {
                this.setAction("Downloading images onto bootflash(" + dest + ")");
                this.setStatus(INIT_STATUS);
                this.setObj2(pollPdu);
                this._NOOP = true;
                this.getLogger().debug((Object)(this.getSwName() + ": startFlashCopy()  setVarBindMask at " + (pdu.getVariables().size() - 1)));
                this.getSwitch().getPeer().send(pdu, this);
                this.getLogger().debug((Object)(this.getSwName() + ": startFlashCopy   _snmpPending++"));
                this.sentSnmpReq();
            }
            catch (SnmpException ex) {
                // empty catch block
            }
        }
    }

    boolean moreFlashCopy() {
        return this._obj1 != null;
    }

    boolean doneFlashCopy() {
        return this._obj2 == null;
    }

    void pollFlashCopy() {
        try {
            this.setStatus(POLL_STATUS);
            ((SnmpPDU)this._obj2).setReqid(0);
            ((SnmpPDU)this._obj2).setRetries(0);
            this.getSwitch().getPeer().send((SnmpPDU)this._obj2, this);
            this.getLogger().debug((Object)(this.getSwName() + ": pollFlashCopy   _snmpPending++"));
            this.sentSnmpReq(true);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void startFlashCopyCb(VarBindList vbl) {
        this.setStatus(INPROGRESS_STATUS);
    }

    void pollFlashCopyCb(VarBindList vbl) {
        this._snmpTimeoutsFlashCopy = 0;
        int state = vbl.intValue(0);
        if (state == 1) {
            this.getLogger().debug((Object)(this.getSwName() + ": pollFlashCopyCb for sw " + this.getSwName() + ": state 1 set status " + INPROGRESS_STATUS));
            this.setStatus(INPROGRESS_STATUS);
        } else if (state == 2) {
            this.getLogger().debug((Object)(this.getSwName() + ": pollFlashCopyCb for sw " + this.getSwName() + ": state 2 set status " + SUCCESS_STATUS));
            String actMsg = this.getAction();
            if (actMsg.indexOf(START_UPGRADE_ACTION) == -1) {
                this.setStatus(SUCCESS_STATUS);
            }
            this.setObj2(null);
            this.resetSnmpPending();
        } else {
            this.getLogger().debug((Object)(this.getSwName() + ": pollFlashCopyCb for sw : copy error, state = " + state));
            this.err(State.getEnum("ciscoFlashCopyStatus", state));
        }
    }

    void readBootVars() {
        int[] index = new int[]{State.getActiveSupIndex(this.getSwitch())};
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.setLogger(this.getLogger());
        pdu.addVar(new SnmpOID(_bootVarOid, index));
        pdu.addVar(new SnmpOID(State.getOids("ceExtKickstartImageList"), index));
        try {
            this.setAction(READ_BOOT_VARS_ACTION);
            this.setStatus(INIT_STATUS);
            this.getSwitch().getPeer().send(pdu, this);
            this.getLogger().debug((Object)(this.getSwName() + ": readbootVar   _snmpPending++"));
            this.sentSnmpReq();
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void writeBootVars() {
        String oldSys = INIT_STATUS;
        String oldKick = INIT_STATUS;
        if (this._obj1 != null) {
            oldSys = (String)this._obj1;
        }
        if (this._obj2 != null) {
            oldKick = (String)this._obj2;
        }
        String[] vars = this.getSysAndKick();
        String sys = vars[0];
        String kick = vars[1];
        int[] index = new int[]{State.getActiveSupIndex(this.getSwitch())};
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setLogger(this.getLogger());
        pdu.setIgnoreSetCount(true);
        if (sys != null && sys.length() != 0) {
            pdu.addVar(new SnmpOID(_bootVarOid, index), new SnmpString(sys + ";" + oldSys));
        }
        if (kick != null && kick.length() != 0) {
            pdu.addVar(new SnmpOID(State.getOids("ceExtKickstartImageList"), index), new SnmpString(kick + ";" + oldKick));
        }
        if (this._hotStandby) {
            pdu.addVar(new SnmpOID(State.getOids("cseSysAutoSync"), ZEROINDEX), new SnmpInt(1));
        }
        try {
            this.setAction(WRITE_BOOT_VARS_ACTION);
            this.setStatus(INIT_STATUS);
            this.getSwitch().getPeer().send(pdu, this);
            this.getLogger().debug((Object)(this.getSwName() + ": writeBootVar   _snmpPending++"));
            this.sentSnmpReq();
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    void bootVarsCb(VarBindList vbl) {
        if (this._obj1 == null) {
            this.setObj1(vbl.stringValue(0));
            this.setObj2(vbl.stringValue(1));
        } else {
            this.setObj1(null);
            this.setObj2(null);
        }
        this.setStatus(SUCCESS_STATUS);
    }

    void startRebootSwitch() {
        int[] index = ZEROINDEX;
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.setLogger(this.getLogger());
        pdu.addVar(new SnmpOID(_rebootOid, index), new SnmpInt(2));
        pdu.setIgnoreSetCount(true);
        SnmpPDU pollPdu = new SnmpPDU(-96, new VarBindList());
        pollPdu.setLogger(this.getLogger());
        this.buildGenericSwitch(pollPdu);
        try {
            this.setAction(REBOOT_SWITCH_ACTION);
            this.setStatus(INIT_STATUS);
            this.setObj1(pollPdu);
            this.getSwitch().getPeer().send(pdu, this);
            this.getLogger().debug((Object)(this.getSwName() + ": startRebootSwitch   _snmpPending++"));
            this.sentSnmpReq();
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    boolean doneRebootSwitch() {
        return this._obj1 == null;
    }

    void pollRebootSwitch() {
        try {
            this.setAction(REBOOT_SWITCH_ACTION);
            this.setStatus(INIT_STATUS);
            this.getSwitch().getPeer().send((SnmpPDU)this._obj1, this);
            this.getLogger().debug((Object)(this.getSwName() + ": pollRebootSwitch   _snmpPending++"));
            this.sentSnmpReq(true);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void startRebootSwitchCb(VarBindList vbl) {
        this.setStatus(INPROGRESS_STATUS);
    }

    void buildGenericSwitch(SnmpPDU pdu) {
        int[] ix = new int[]{0};
        pdu.addVar(new SnmpOID(_rfOid, ix));
        pdu.addVar(new SnmpOID(State.getOids("cRFStatusUnitState"), ix));
        pdu.addVar(new SnmpOID(State.getOids("cRFStatusPeerUnitId"), ix));
        pdu.addVar(new SnmpOID(State.getOids("cRFStatusPeerUnitState"), ix));
        ix[0] = State.getActiveSupIndex(this.getSwitch());
        pdu.addVar(new SnmpOID(State.getOids("entPhysicalSoftwareRev"), ix));
        if (this.getSwitch().hasDualSupervisors()) {
            ix[0] = State.getStandbySupIndex(this.getSwitch());
            pdu.addVar(new SnmpOID(State.getOids("entPhysicalSoftwareRev"), ix));
        }
        pdu.setRetries(0);
    }

    void genericSwitchCb(VarBindList vbl, int start) {
        int activeUnit = vbl.intValue(start);
        int activeState = vbl.intValue(start + 1);
        int peerUnit = vbl.intValue(start + 2);
        if (activeUnit != 0 && activeState == 14) {
            String activeVer = INIT_STATUS;
            String standbyVer = INIT_STATUS;
            for (int i = 4; i < vbl.size() - start; ++i) {
                SnmpVarBind vb = vbl.getVb(start + i);
                int[] oids = vb.getOid().getValue();
                if (oids[oids.length - 1] == activeUnit) {
                    activeVer = vbl.stringValue(start + i);
                    continue;
                }
                if (peerUnit == 0) continue;
                standbyVer = vbl.stringValue(start + i);
            }
            String verStr = activeVer;
            if (standbyVer != null && standbyVer.length() != 0) {
                verStr = verStr + " [standby " + standbyVer + "]";
            }
            this.setStatus(SUCCESS_STATUS + verStr);
            this.setObj1(null);
        } else {
            this.setStatus(this.getStatus() + " version unknown");
            this.getLogger().error((Object)(this.getSwName() + ": Install can't obtain version, activeUnit " + activeUnit + " state " + activeState));
        }
    }

    String getSwName() {
        try {
            return this.getSwitch().toString();
        }
        catch (Exception ex) {
            this.getLogger().error((Object)"State getSwName, sw.toString() not available ", (Throwable)ex);
            return this._swName;
        }
    }

    Switch getSwitch() {
        if (this._sw.isDestoryed()) {
            this.getLogger().warn((Object)"State getSwitch, sw destoyed, rebuild sw object");
            this._sw = ClientController.getInstance().getFabric().findSwitchByPK(this._swPK);
            if (this._sw.isDestoryed()) {
                this.getLogger().error((Object)"State getSwName, rebuild sw object still not useable !!");
            }
        }
        return this._sw;
    }

    class WrongDigest
    implements ActionListener {
        Timer _Timer;
        int _timeLeft;
        JOptionPane _pane;
        JDialog _dlg;
        JPasswordField _pfield = new JPasswordField("");
        String _password;
        boolean _timedOut;
        boolean _cancelled;

        WrongDigest(SnmpPeer peer) {
            this._pane = new JOptionPane(this._pfield, 3, 2);
            this._dlg = this._pane.createDialog(State.this._up._parent, peer.toString() + " Wrong Password, Enter New?");
            this._dlg.setModal(true);
        }

        void show() {
            this._timeLeft = 250;
            this._Timer = new Timer(5000, this);
            this._Timer.start();
            this._dlg.setVisible(true);
            if (!this._timedOut) {
                Object answer = this._pane.getValue();
                if (answer != null && answer instanceof Integer && (Integer)answer == 0) {
                    this._password = new String(this._pfield.getPassword());
                } else {
                    this._cancelled = true;
                }
            }
        }

        String getPassword() {
            return this._password;
        }

        boolean timedOut() {
            return this._timedOut;
        }

        boolean cancelled() {
            return this._cancelled;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._timeLeft -= 5;
            if (this._timeLeft <= 0) {
                this._dlg.dispose();
                this._timedOut = true;
            }
        }
    }
}

