/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.upgrade.u3_0_3;

import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.Log4jUtil;
import com.cisco.dcbu.lib.util.TFTP;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.ImageSpec;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.State;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.State11;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.State12;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradePanel;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

class Upgrade {
    Switch[] _sws;
    String[] _swNames;
    ImageSpec[] _images;
    ImageSpec[] _bootVars;
    boolean _ignoreVersion;
    boolean _ignoreInstall;
    boolean _copyImageOnly;
    boolean _parallelInstall;
    JFrame _parent;
    boolean _local = true;
    Array _vercheckAllData = new Array();
    Array _incompatAllData = new Array();
    Array _miscInfoAllData = new Array();
    Logger _upgradeLogger = LogManager.getLogger((String)"com.cisco.dcbu.sm.client.upgrade.u3_0_3");
    Logger[] _loggers;
    final String NOLONGER_ABORT = "no longer be aborted";
    State[] _states;
    TFTP _tftp;
    int _swIndex;

    boolean isLocal() {
        return this._local;
    }

    void setLocal(boolean local) {
        this._local = local;
    }

    void setSwitches(Switch[] sws) {
        this._sws = sws;
        this._swNames = new String[sws.length];
        this._upgradeLogger.debug((Object)("Upgrade.setSwitches Paralle? " + this.getParallelInstall()));
        this._upgradeLogger.debug((Object)("Upgrade.setSwitches sws.length " + sws.length));
        if (this.getParallelInstall()) {
            this._loggers = new Logger[sws.length];
        }
        for (int i = 0; i < this._swNames.length; ++i) {
            this._swNames[i] = this.getSwNameInit(i);
            this._upgradeLogger.debug((Object)("sw " + i + " " + this._swNames[i]));
            if (!this.getParallelInstall()) continue;
            StringBuffer name = new StringBuffer();
            name.append(ClientCache.getLocation() + "logs" + File.separator);
            name.append("fm_upgrade_");
            name.append(this.getSwName(i));
            name.append(".log");
            this._upgradeLogger.debug((Object)("creating log: sw/log=" + this.getSwName(i) + '/' + name.toString() + "....."));
            this._loggers[i] = Log4jUtil.createNewLog(this.getSwName(i), name.toString(), "ALL", "15M", 20);
        }
    }

    String getSwNameInit(int index) {
        try {
            return this._sws[index].toString();
        }
        catch (Exception ex) {
            this._upgradeLogger.error((Object)("(init)Upgrade getSwName, sw.toString() " + index + " not available "), (Throwable)ex);
            return "swNull" + index;
        }
    }

    String getSwName(int index) {
        try {
            return this._sws[index].toString();
        }
        catch (Exception ex) {
            this._upgradeLogger.error((Object)("Upgrade getSwName, sw.toString() " + index + " not available "), (Throwable)ex);
            return this._swNames[index];
        }
    }

    void setImages(ImageSpec[] specs) {
        this._images = specs;
    }

    void setBootVars(ImageSpec[] specs) {
        this._bootVars = specs;
    }

    void setIgnoreVersion(boolean b) {
        this._ignoreVersion = b;
    }

    void setIgnoreInstall(boolean b) {
        this._ignoreInstall = b;
    }

    void setCopyImageOnly(boolean b) {
        this._copyImageOnly = b;
    }

    void setParallelInstall(boolean b) {
        this._parallelInstall = b;
    }

    TFTP getTftp() {
        return this._tftp;
    }

    Switch[] getSwitches() {
        return this._sws;
    }

    ImageSpec[] getImages() {
        return this._images;
    }

    ImageSpec[] getBootVars() {
        return this._bootVars;
    }

    boolean getIgnoreVersion() {
        return this._ignoreVersion;
    }

    boolean getIgnoreInstall() {
        return this._ignoreInstall;
    }

    boolean getCopyImageOnly() {
        return this._copyImageOnly;
    }

    boolean getParallelInstall() {
        return this._parallelInstall;
    }

    boolean skipDownload() {
        return this._images == null;
    }

    Upgrade(JFrame parent) {
        this._parent = parent;
        this._upgradeLogger.setAdditivity(SnmpSession.isTrace());
    }

    final void tick() {
        int i;
        this._upgradeLogger.debug((Object)("Upgrade tick _swIndex =" + this._swIndex));
        if (this.isFirstTime()) {
            this.init();
        }
        this._upgradeLogger.debug((Object)("Upgrade tick _swIndex =" + this._swIndex + "  initial if _swIndex == -1,  parallel upgrade ? " + this.getParallelInstall()));
        if (!this.getParallelInstall()) {
            if (this._swIndex == -1) {
                int countUp = 0;
                int readyUpgrade = 0;
                for (int i2 = 0; i2 < this._sws.length; ++i2) {
                    this._upgradeLogger.debug((Object)("serialized Upgrade tick countUp(switch " + this.getSwName(i2) + ") " + ", checking if _states.isUp() =" + this._states[i2].isUp()));
                    if (!this._states[i2].isUp()) continue;
                    this._upgradeLogger.debug((Object)("serialized Upgrade (switch" + i2 + " " + this.getSwName(i2) + ") " + ", isUp TRUE"));
                    ++countUp;
                    this._upgradeLogger.debug((Object)("serialized Upgrade tick countReadyUpgrade (switch " + this.getSwName(i2) + ") " + ", checking if _states.isInStartUpgradeState() =" + this._states[i2].isInStartUpgradeState()));
                    if (!this._states[i2].isInStartUpgradeState()) continue;
                    this._upgradeLogger.debug((Object)("serialized Upgrade (switch" + i2 + " " + this.getSwName(i2) + ") " + ", isInStartUpgradeState TRUE"));
                    ++readyUpgrade;
                }
                this._upgradeLogger.debug((Object)("serialized Upgrade tick countUp/readyUpgrade = " + countUp + "/" + readyUpgrade));
                if (countUp == readyUpgrade && countUp > 0) {
                    this._swIndex = 0;
                }
            }
            this._upgradeLogger.debug((Object)("serialized Upgrade tick _swIndex =" + this._swIndex + "  checking if in the upgrade cycle"));
            if (this._swIndex != -1) {
                for (i = this._swIndex; i < this._sws.length; ++i) {
                    if (i != this._swIndex) continue;
                    this._upgradeLogger.debug((Object)("serialized Upgrade tick (switch " + this.getSwName(i) + ") " + ", checking if _states.isUp() =" + this._states[i].isUp()));
                    if (this._states[i].isUp()) {
                        this._upgradeLogger.debug((Object)("serialized Upgrade tick calling (switch" + i + "" + this.getSwName(i) + ") " + "_states.tick()     initCounters() first ?"));
                        if (this._states[i].isInStartUpgradeState()) {
                            this._upgradeLogger.debug((Object)("serialized Upgrade tick calling (switch" + i + "" + this.getSwName(i) + ") " + "_states.tick(),begin to upgrade, initCounters() first"));
                            this._states[i].initCounters();
                        }
                        this._states[i].tick();
                        return;
                    }
                    ++this._swIndex;
                }
            }
        }
        this._upgradeLogger.debug((Object)("Upgrade tick _swIndex =" + this._swIndex + "  ,checking which switch to tick"));
        for (i = 0; i < this._sws.length; ++i) {
            this._upgradeLogger.debug((Object)("Upgrade tick sw" + i + "=" + this.getSwName(i) + "  ,checking if isUp(),  parallel ? " + this.getParallelInstall()));
            if (!this._states[i].isUp()) continue;
            if (this.getParallelInstall()) {
                this._upgradeLogger.debug((Object)("Parallel Upgrade tick calling (switch" + i + " " + this.getSwName(i) + ") " + "_states.tick()"));
                this._states[i].tick();
                continue;
            }
            if (this._states[i].isInStartUpgradeState()) continue;
            this._upgradeLogger.debug((Object)("serialized Upgrade tick calling (switch" + i + " " + this.getSwName(i) + ") " + "_states.tick()"));
            this._states[i].tick();
        }
    }

    boolean isFirstTime() {
        this._upgradeLogger.debug((Object)("Upgrade, isFirstTime _states==null " + this._states));
        return this._states == null;
    }

    void init() {
        this._swIndex = -1;
        this._states = new State[this._sws.length];
        for (int i = 0; i < this._sws.length; ++i) {
            Switch sw = this._sws[i];
            this._states[i] = !UpgradePanel.isOlderThan12(sw) ? new State12(sw, this) : (sw.getVersion() == null || sw.getVersion().length() == 0 || sw.getVersion().startsWith("1.0") ? new State(sw, this) : new State11(sw, this));
            this._states[i].setLogger(this.getParallelInstall() ? this._loggers[i] : this._upgradeLogger);
        }
        try {
            boolean startTftpServer;
            this._tftp = TFTP.getInstance();
            boolean bl = startTftpServer = TFTP.canStartServer() && !this.skipDownload();
            if (startTftpServer) {
                ImageSpec[] ispecs = this.getImages();
                startTftpServer = ispecs[0].isLocal();
            }
            if (startTftpServer) {
                this._tftp.setMaxConns(this._sws.length);
                for (int i = 0; i < this._sws.length; ++i) {
                    this._tftp.addIpAccess(this._sws[i].getPeer().getAddress().getHostAddress(), "true", "true", "true");
                }
                this._tftp.startServer(SnmpSession.isTrace());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        for (int i = 0; i < this._sws.length; ++i) {
            if (!this.isUp(i)) continue;
            this._states[i].tick();
        }
    }

    void dispose() {
        this._swIndex = -1;
        if (this._tftp != null) {
            this._tftp.stopServer();
            for (int i = 0; i < this._sws.length; ++i) {
                try {
                    this._tftp.delIpAccess(this._states[i].getSwitch().getPeer().getAddress().getHostAddress());
                    continue;
                }
                catch (Exception ex) {
                    this._upgradeLogger.debug((Object)("Upgrade dispose .....  ex= " + ex));
                }
            }
        }
    }

    boolean doCancel() {
        this._upgradeLogger.debug((Object)"Upgrade doCancel .....");
        if (!this.isFinished()) {
            String msg = "Upgrade has not completed. We recommend aborting each action before cancelling this wizard.\nDo you still want to cancel?";
            boolean answer = this.askUser("Upgrade has not completed. We recommend aborting each action before cancelling this wizard.\nDo you still want to cancel?", "Warning");
            if (answer && this._swIndex != -1) {
                this._states[this._swIndex]._state = 315;
                this._states[this._swIndex].tick();
                this._upgradeLogger.debug((Object)"User cancel wizard, set to 315 state");
            }
            return answer;
        }
        return true;
    }

    void abort(int index) {
        if (this._states != null) {
            this._states[index].abort();
        }
    }

    boolean isUp(int index) {
        return this._states != null && this._states[index] != null && this._states[index].isUp();
    }

    boolean isAbortable(int index) {
        return this._states != null && this._states[index] != null && this._states[index].isAbortable();
    }

    boolean isAbort(int index) {
        return this._states != null && this._states[index] != null && this._states[index].isAbort();
    }

    boolean isUp(Switch sw) {
        if (this._states != null) {
            for (int i = 0; i < this._states.length; ++i) {
                if (this._states[i]._sw != sw) continue;
                return this._states[i].isUp();
            }
        }
        return false;
    }

    String getAction(int index) {
        return this._states[index].getAction();
    }

    String getStatus(int index) {
        return this._states[index].getStatus();
    }

    Array getMoreStatus(int index) {
        return this._states[index].getMoreStatus();
    }

    boolean isFinished() {
        this._upgradeLogger.debug((Object)"Upgrade isFinished()...");
        try {
            if (this.isFirstTime()) {
                this._upgradeLogger.debug((Object)"Upgrade is Finished()...  isFirstTime true");
                return true;
            }
            for (int i = 0; i < this._sws.length; ++i) {
                if (!this._states[i].isUp()) continue;
                this._upgradeLogger.debug((Object)("Upgrade is Finished()... false, " + this._states[i].getSwName() + " is up"));
                return false;
            }
        }
        catch (Exception ex) {
            this._upgradeLogger.debug((Object)"Upgrade is Finished() ex - ", (Throwable)ex);
            return true;
        }
        this._upgradeLogger.debug((Object)"Upgrade is Finished()... true");
        return true;
    }

    boolean isDoneVersionCheck(int index) {
        return this._states[index].isDoneVersionCheck();
    }

    boolean isDoneVersionCheck() {
        this._upgradeLogger.debug((Object)"Upgrade isVersionCheckDone()...");
        for (int i = 0; i < this._sws.length; ++i) {
            this._upgradeLogger.debug((Object)("Upgrade isVersionCheckDone " + this._states[i].getSwName() + ".... " + this._states[i].isDoneVersionCheck()));
            if (!this._states[i].isDoneVersionCheck()) continue;
            return true;
        }
        return false;
    }

    void buildMiscInfoAllData() {
        this._upgradeLogger.debug((Object)"Upgrade buildMiscInfoAllData()...");
        for (int i = 0; i < this._sws.length; ++i) {
            this._states[i].buildMiscInfoAllData();
        }
    }

    void buildIncompatInfoAllData() {
        this._upgradeLogger.debug((Object)"Upgrade buildIncompatInfoAllData()...");
        for (int i = 0; i < this._sws.length; ++i) {
            this._states[i].buildIncompatInfoAllData();
        }
    }

    void resume() {
        this._upgradeLogger.debug((Object)"Upgrade resume()...");
        if (!this.getParallelInstall()) {
            this._swIndex = 0;
        }
        for (int i = 0; i < this._sws.length; ++i) {
            this._upgradeLogger.debug((Object)("Upgrade resume " + this._states[i].getSwName() + "...."));
            if (!this._states[i].isDoneVersionCheck()) continue;
            this._states[i].resume();
        }
    }

    boolean askUser(Object obj, String title) {
        int opt = JOptionPane.showConfirmDialog(this._parent, obj, title, 0);
        this._upgradeLogger.debug((Object)("Upgrade askUser " + title + "  user input " + opt));
        return opt == 0;
    }

    void showUser(Object obj, String title) {
        JOptionPane.showMessageDialog(this._parent, obj, title, 0);
    }

    ImageSpec getImage(Switch sw, Switch swByPk) {
        if (sw.isDestoryed()) {
            sw = swByPk;
            this._upgradeLogger.warn((Object)"Upgrade getImage, sw destoyed, rebuild sw object");
        }
        if (this.skipDownload()) {
            ImageSpec[] specs = this.getBootVars();
            for (int i = 0; i < specs.length; ++i) {
                if (specs[i].getSwitch() != sw) continue;
                return specs[i];
            }
        } else {
            String model = UpgradePanel.getBareModel(sw);
            ImageSpec[] specs = this.getImages();
            for (int i = 0; i < specs.length; ++i) {
                if (!UpgradePanel.sameImage(model, specs[i].getModel())) continue;
                return specs[i];
            }
        }
        return null;
    }

    void changeSwitchState12(Switch sw, String action, String status) {
        for (int i = 0; i < this._sws.length; ++i) {
            if (this._sws[i] != sw) continue;
            State12 st = new State12(sw, this);
            this._states[i] = st;
            st._state = 311;
            st._responseTime = System.currentTimeMillis();
            st.setAction(action);
            st.setStatus(status);
            st.setObj1(st.buildPollPdu());
        }
    }

    void changeSwitchState11(Switch sw, String action, String status, int[] index) {
        for (int i = 0; i < this._sws.length; ++i) {
            if (this._sws[i] != sw) continue;
            State11 st = new State11(sw, this);
            this._states[i] = st;
            st._state = 201;
            st.setAction(action);
            st.setStatus(status);
            st.setObj1(st.buildPollPdu(index));
            st.setObj2(null);
        }
    }
}

