/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.DragTableModel;
import com.cisco.dcbu.sm.client.zm.common.IvrEndPort;
import com.cisco.dcbu.sm.client.zm.common.SwitchPort;
import com.cisco.dcbu.sm.client.zm.common.afidVsanSwitches;
import java.util.ArrayList;
import java.util.HashMap;

public class EndPortsTableModel
extends DragTableModel {
    static final String[] LABELS = new String[]{"Type", "Switch Interface", "Name", "WWN", "FcId"};
    static final String[] LABELS_VSAN = new String[]{"Type", "VSAN", "Switch Interface", "Name", "WWN", "FcId", "AFID"};
    static final String[] LABELS_VSAN_WO_AFID = new String[]{"Type", "VSAN", "Switch Interface", "Name", "WWN", "FcId"};
    static final String[] PORT_TYPE = new String[]{"WWN", "iSCSI", "Host", "Storage"};
    static final int WWN = 0;
    static final int ISCSI = 1;
    static final int HOST = 2;
    static final int STORAGE = 3;
    static final int TYPE = 0;
    static final int SWITCHPORT = 1;
    public static final int PWWN = 3;
    public static final int NAME = 2;
    public static final int FCID = 4;
    static final int AFID = 5;
    static final int VSAN = 1;
    public static final int SHOW_ALL = 0;
    public static final int SHOW_UNZONED_HOST = 1;
    public static final int SHOW_UNZONED_TARGET = 2;
    public static final int SHOW_UNZONED_ALL = 3;
    public static final int SHOW_HOSTS_ALL = 4;
    public static final int SHOW_TARGETS_ALL = 5;
    private int _offset = 0;
    private Vsan _vsan;
    private Array _vsanList;
    private ArrayList _zonedPorts;
    private boolean _showIscsiOnly;
    private boolean _showIscsiForIVR;
    private HashMap _afidMap;
    private boolean _showAfid;
    private int _filterType;

    public EndPortsTableModel(Vsan v, Array vsanList, boolean showAfid) {
        this._vsan = v;
        this._vsanList = vsanList;
        this._showAfid = showAfid;
        if (v != null) {
            this.setHeaders(LABELS);
        } else {
            this.setHeaders(showAfid ? LABELS_VSAN : LABELS_VSAN_WO_AFID);
            this._offset = 1;
        }
    }

    public EndPortsTableModel(Vsan v, Array vsanList, boolean showAfid, boolean showIscsiForIVR) {
        this(v, vsanList, showAfid);
        this._showIscsiForIVR = showIscsiForIVR;
    }

    public void updateModelData(HashMap afidMap) {
        this._afidMap = afidMap;
        Array responseData = new Array();
        int headerCount = LABELS.length + 1;
        if (this._vsan != null) {
            this.populateData(responseData, this._vsan.getEndPorts(null), this._vsan, headerCount);
        } else {
            Vsan[] vsans = null;
            vsans = this._vsanList != null && this._vsanList.size() > 0 ? ((Vsan)this._vsanList.elementAt(0)).getFabric().getVsans() : ClientController.getInstance().getFabric().getVsans();
            headerCount = LABELS_VSAN.length + 1;
            for (int i = 0; i < vsans.length; ++i) {
                this.populateData(responseData, vsans[i].getEndPorts(null), vsans[i], headerCount);
            }
        }
        this.setData(responseData);
        this.sort(2 + this._offset, true);
    }

    @Override
    public void updateData(ArrayList endPorts) {
        Array responseData = new Array();
        int headerCount = this._vsan != null ? LABELS.length + 1 : LABELS_VSAN.length + 1;
        this.populateData(responseData, endPorts, this._vsan, headerCount);
        this.setData(responseData);
        this.sort(2 + this._offset, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void populateData(Array responseData, ArrayList memberList, Vsan v, int headerCount) {
        if (memberList != null) {
            block9: for (int i = 0; i < memberList.size(); ++i) {
                EndPort zmem = (EndPort)memberList.get(i);
                if (!zmem.isPresent() || this._vsan == null && zmem.isISCSI() && !this._showIscsiForIVR || this._showIscsiOnly && !zmem.isISCSI()) continue;
                switch (this._filterType) {
                    case 1: 
                    case 4: {
                        if (!zmem.isTarget()) break;
                        continue block9;
                    }
                    case 2: 
                    case 5: {
                        if (!zmem.isTarget()) continue block9;
                    }
                }
                if ((this._filterType == 1 || this._filterType == 2 || this._filterType == 3) && this._zonedPorts != null && this._zonedPorts.contains(zmem) || this._vsan == null && this._vsanList != null && this._vsanList.findEquals(v) == -1) continue;
                Object[] row = new Object[headerCount];
                String type = PORT_TYPE[0];
                type = zmem.isISCSI() ? PORT_TYPE[1] : (zmem.isTarget() ? PORT_TYPE[3] : PORT_TYPE[2]);
                row[0] = type;
                row[3 + this._offset] = SnmpString.toHexString(zmem.getPortWwn().getValue());
                row[2 + this._offset] = zmem;
                row[4 + this._offset] = v != null ? zmem.getFcIdAsString(zmem.getFcIdNum(v.getId())) : zmem.getFcIdAsString();
                row[1 + this._offset] = new SwitchPort(EnforcedZoneMember.getSwitchPort(zmem, 1, null, v), zmem.getIfIndex());
                if (this._vsan == null) {
                    row[1] = new Integer(v.getId());
                    if (this._showAfid) {
                        ArrayList obLs;
                        int afid = 1;
                        if (this._afidMap != null && (obLs = (ArrayList)this._afidMap.get(v)) != null && obLs.size() > 0) {
                            afid = ((afidVsanSwitches)obLs.get((int)0))._afId;
                        }
                        row[5 + this._offset] = Integer.toString(afid);
                    }
                }
                if (this.filterStr != null && this.filterStr.length() > 0) {
                    switch (this.filterType) {
                        case 3: {
                            boolean filterHasColon;
                            boolean bl = filterHasColon = this.filterStr.indexOf(":") != -1;
                            if (row[3 + this._offset] == null || !(filterHasColon ? !row[3 + this._offset].toString().matches(this.filterStr) : !row[3 + this._offset].toString().replaceAll(":", "").matches(this.filterStr))) break;
                            continue block9;
                        }
                        case 4: {
                            if (row[4 + this._offset] == null || row[4 + this._offset].toString().matches(this.filterStr)) break;
                            continue block9;
                        }
                        case 2: {
                            if (row[2 + this._offset] != null && !row[2 + this._offset].toString().matches(this.filterStr)) continue block9;
                        }
                    }
                }
                responseData.addElement(row);
            }
        }
    }

    public Object getRowObjectForEndPort(EndPort port) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            IvrEndPort ivrEp;
            if (!(this._vsan == null ? port.equals((ivrEp = (IvrEndPort)this.getDragObject(i)).getEndPort()) && port.isMemberOfVsan(ivrEp.getIvrVsan()) : port.equals((AbstractModelObject)this.getDragObject(i)))) continue;
            return this.getData().elementAt(i);
        }
        return null;
    }

    public EndPort getEndPort(int row) {
        return (EndPort)this.getValueAt(row, 2 + this._offset);
    }

    public EndPort[] getEndPorts(int[] rows) {
        EndPort[] endPorts = new EndPort[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            endPorts[i] = this.getEndPort(rows[i]);
        }
        return endPorts;
    }

    @Override
    public Object getDragObject(int row) {
        Object endP = ((Object[])this.getData().elementAt(row))[2 + this._offset];
        if (this._vsan == null) {
            return new IvrEndPort((EndPort)endP, (Integer)((Object[])this.getData().elementAt(row))[1]);
        }
        return endP;
    }

    public void setVsan(Vsan vsan) {
        this._vsan = vsan;
    }

    public void setZonedPorts(ArrayList ports, int filterType) {
        this._zonedPorts = ports;
        this._filterType = filterType;
    }

    public void setViewIscsiOnly(boolean b) {
        this._showIscsiOnly = b;
    }

    public void setViewIvrIscsi(boolean b, HashMap afidMap) {
        if (b != this._showIscsiForIVR) {
            this._showIscsiForIVR = b;
            this.updateModelData(afidMap);
            this.fireTableDataChanged();
        }
    }

    public void setShowAfid(boolean b) {
        if (this._vsan == null && this._showAfid != b) {
            this._showAfid = b;
            this.setHeaders(this._showAfid ? LABELS_VSAN : LABELS_VSAN_WO_AFID);
            this._offset = 1;
            this.fireTableStructureChanged();
        }
    }
}

