/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.MultiRowTable;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.zm.common.DifferenceDialog;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class SaveZoneConfigDialog
extends JDialog
implements ActionListener {
    private JButton[] _buttons;
    private JComponent[] _labels = new JComponent[]{null, null, null, null, new JLabel("File Name:")};
    private JCheckBox _saveConfigChkBox;
    private JCheckBox _saveFileConfigChkBox;
    private FieldPanel _configFile;
    private boolean _isCancelled = true;
    private boolean _ivr;
    private MultiRowTable _differenceTable;
    private Switch _sw;
    private JFrame _parent;
    private DialogSeparator _separator;
    private JCheckBox _forceActivate;

    public SaveZoneConfigDialog(JFrame parent, Switch sw, boolean chooseForceActivate, boolean ivr, MultiRowTable differenceTable) {
        super(parent);
        this.buildSaveConfigDialog(parent, sw, ivr, differenceTable, chooseForceActivate);
    }

    private void buildSaveConfigDialog(JFrame parent, Switch sw, boolean ivr, MultiRowTable differenceTable, boolean chooseForceActivate) {
        this._sw = sw;
        this._ivr = ivr;
        this._differenceTable = differenceTable;
        this._parent = parent;
        this.setDefaultCloseOperation(2);
        this.setTitle("Save Configuration - " + this._sw.getFabric().getPath('/'));
        JComponent[] values = new JComponent[this._labels.length];
        this._forceActivate = new JCheckBox("<html><div align=center>Create Active Zoneset if None Present <br>(Force activate)</div></html>");
        values[0] = this._forceActivate;
        this._forceActivate.setSelected(true);
        values[0].setVisible(chooseForceActivate && this._ivr);
        this._separator = new DialogSeparator("After Activation");
        values[1] = this._separator;
        this._saveConfigChkBox = new JCheckBox("Save Running to Startup Configuration");
        values[2] = this._saveConfigChkBox;
        this._saveConfigChkBox.setSelected(true);
        String tftpSrvr = "Unknown";
        try {
            tftpSrvr = NetUtil.detectSourceAddress(SmZoneUtil.getSwitchPeer(this._sw).getAddress()).getHostAddress();
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.debug((Object)"Unknown TFTP Server");
        }
        this._saveFileConfigChkBox = new JCheckBox("<html><div align=center>Save Proposed Zone Configuration to:<br>(Local TFTP Server:" + tftpSrvr + ")</div></html>");
        values[3] = this._saveFileConfigChkBox;
        this._saveFileConfigChkBox.setActionCommand("Save");
        this._saveFileConfigChkBox.addActionListener(this);
        JButton fileEllipsis = new JButton("...");
        fileEllipsis.setMargin(Util.getNoBorder());
        fileEllipsis.addActionListener(this);
        fileEllipsis.setActionCommand("F");
        this._configFile = new FieldPanel(20, (JComponent)fileEllipsis);
        values[4] = this._configFile;
        this._configFile.setText(sw + "_zone_cfg" + (sw.isQuail() ? "_9020_" : "") + ".txt");
        values[4].setEnabled(false);
        this._labels[4].setEnabled(false);
        String[] btnLbl = new String[]{"Continue Activation", "Proposed Changes...", "Cancel"};
        this._buttons = DialogUtil.buildButtons(btnLbl, (ActionListener)this);
        this._buttons[1].setVisible(differenceTable != null && this._differenceTable.getRowCount() > 0);
        this._buttons[0].setActionCommand("Continue");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < this._buttons.length; ++i) {
            buttonPanel.add(this._buttons[i]);
        }
        JPanel mainPnl = new JPanel(new BorderLayout());
        if (this._ivr) {
            JTextArea notes = new JTextArea();
            notes.setWrapStyleWord(true);
            notes.setEditable(false);
            notes.setLineWrap(true);
            notes.setOpaque(false);
            notes.setFont((Font)UIManager.getDefaults().get("Table.font"));
            notes.append("The IVR configuration on master switch (" + this._sw + ") will be copied to other IVR enabled switches.");
            mainPnl.add((Component)notes, "North");
        }
        mainPnl.add((Component)DialogUtil.buildPanel(this._labels, values), "Center");
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)mainPnl, buttonPanel);
        this.getRootPane().setDefaultButton(this._buttons[0]);
        this.setResizable(true);
        if (this._ivr) {
            this.setSize(this.getWidth() + 10, this.getHeight() + (differenceTable != null ? 30 : 35));
        }
        this.setDefaultCloseOperation(2);
        this.setModal(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char cmd = e.getActionCommand().charAt(0);
        switch (cmd) {
            case 'F': {
                String fName = Util.getFileName(this._parent, this.getTitle() + ", Save Zone Configuration", "*_cfg.txt", 0, ClientCache.getLocation(), true);
                if (fName == null) break;
                this._configFile.setText(fName);
                break;
            }
            case 'S': {
                this._configFile.setEnabled(this._saveFileConfigChkBox.isSelected());
                this._labels[4].setEnabled(this._saveFileConfigChkBox.isSelected());
                break;
            }
            case 'P': {
                new DifferenceDialog(this, this._differenceTable).setVisible(true);
                break;
            }
            case 'C': {
                if (e.getActionCommand().charAt(1) == 'a') {
                    this._saveConfigChkBox.setSelected(false);
                    this._saveFileConfigChkBox.setSelected(false);
                } else {
                    this._isCancelled = false;
                }
                this.dispose();
            }
        }
    }

    public String getZoneConfigName() {
        String fileName;
        if (this._saveFileConfigChkBox.isSelected() && (fileName = this._configFile.getText().trim()).length() > 0) {
            return fileName;
        }
        return null;
    }

    public boolean saveRunningToStartUp() {
        return this._saveConfigChkBox.isSelected();
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public boolean forceActivate() {
        return this._ivr && this._forceActivate.isSelected();
    }

    public void hideCopyRunningtoStartup(boolean b) {
        this._saveConfigChkBox.setSelected(!b);
        this._saveConfigChkBox.setVisible(!b);
        this._saveFileConfigChkBox.setSelected(b);
        this._saveFileConfigChkBox.setVisible(!b);
        this._configFile.setEnabled(b);
        this._labels[4].setEnabled(b);
        this._buttons[0].setText("OK");
        this._separator.setLabel("Save Proposed Zone Configuration to");
        this.pack();
    }
}

