/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.mds.SmlCommandsHandler;
import com.cisco.dcbu.lib.mds.zm.QlogicCommandHandler;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.SmZoneMember;
import java.io.IOException;
import java.util.ArrayList;

public class SmQlogicCommandHandler
extends QlogicCommandHandler {
    private Vsan _vsan;

    public SmQlogicCommandHandler(ZoneCapability cap, Vsan vsan, VersionPeer sw, StatusIf statusIf) throws IOException, SnmpException {
        super(cap, (int)vsan.getId(), sw, statusIf);
        this._smlCmd = new SmlCommandsHandler(BrowserFrame.getInstance(), sw.getSwitchPeer());
        this._vsan = vsan;
    }

    @Override
    protected ArrayList buildMembersList(String memList, int parentType, int parentId, ArrayList members) {
        ArrayList<String> aliasMem = new ArrayList<String>();
        String[] tokens = StringUtil.tokenize(memList, ",");
        ArrayList<SmZoneMember> zoneMembers = new ArrayList<SmZoneMember>();
        if (tokens != null && tokens.length > 0) {
            for (int i = 0; i < tokens.length; ++i) {
                int dashIndex = tokens[i].indexOf("-");
                String memTypeVal = tokens[i].substring(0, dashIndex);
                String memName = tokens[i].substring(dashIndex + 1);
                int type = Integer.parseInt(memTypeVal.trim(), 16);
                if (type == 4) {
                    aliasMem.add(memName.trim());
                    continue;
                }
                byte[] id = this.getMemberId(type, memName.trim());
                if (id == null) continue;
                zoneMembers.add(new SmZoneMember(this._vsan, this._vsan == null ? -1 : (int)this._vsan.getId(), i + 1, parentType, parentId, SmQlogicCommandHandler.convertToMDSType(type), id, new byte[0], -1, -1));
            }
            members.addAll(0, zoneMembers);
        }
        return aliasMem;
    }

    private byte[] getMemberId(int qlogicType, String val) {
        switch (qlogicType) {
            case 1: 
            case 2: 
            case 3: {
                return SnmpString.fromHexString(val, false);
            }
            case 10: {
                int card = Integer.parseInt(val.substring(0, 2).trim(), 16);
                int port = Integer.parseInt(val.substring(2, 4).trim(), 16);
                int ifIndex = IfIndexUtil.name2IfIndex("fc" + card + "/" + port);
                byte[] ifBytes = SnmpIntList.valueOf(new int[]{ifIndex});
                byte[] wwn = SnmpString.fromHexString(val.substring(4, 20), false);
                byte[] out = new byte[ifBytes.length + wwn.length];
                System.arraycopy(ifBytes, 0, out, 0, ifBytes.length);
                System.arraycopy(wwn, 0, out, ifBytes.length, wwn.length);
                return out;
            }
            case 11: {
                int card = Integer.parseInt(val.substring(3, 5).trim(), 16);
                int port = Integer.parseInt(val.substring(5, 7).trim(), 16);
                int ifIndex = IfIndexUtil.name2IfIndex("fc" + card + "/" + port);
                byte[] ifBytes = SnmpIntList.valueOf(new int[]{ifIndex});
                byte did = (byte)Integer.parseInt(val.substring(1, 3).trim(), 16);
                byte[] out = new byte[ifBytes.length + 1];
                out[0] = did;
                System.arraycopy(ifBytes, 0, out, 1, ifBytes.length);
                return out;
            }
        }
        return null;
    }
}

