/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.mds.zm.AbstractZone;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneAlias;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.mds.zm.ZoneData;
import com.cisco.dcbu.lib.mds.zm.ZoneMember;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.DeviceAlias;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.IvrDeviceAlias;
import com.cisco.dcbu.sm.client.zm.common.IvrEndPort;
import com.cisco.dcbu.sm.client.zm.common.LunPort;
import com.cisco.dcbu.sm.client.zm.common.SmZoneMember;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.client.zm.common.afidVsanSwitches;
import java.util.ArrayList;
import java.util.HashMap;

public class SmZoneData
extends ZoneData {
    private Switch _sw;
    private Vsan _vsan;

    public void setVsanSwitch(Switch sw, Vsan vsan, StatusIf statusIf) throws SnmpException {
        this._sw = sw;
        this._vsan = vsan;
        this.verPeer = SmZoneUtil.buildVersionnPeer(this._sw);
        super.setVsanSwitch(this.verPeer, vsan != null ? (int)vsan.getId() : -1, statusIf);
    }

    @Override
    protected void creteCommandHandler(StatusIf statusIf) throws SnmpException {
        this.cmdHandler = SmZoneUtil.getCommandHandler(this.capability, this._vsan, this.verPeer, statusIf);
    }

    public void modifySwitchWoInvalidation(Switch sw) {
        this._sw = sw;
        super.modifySwitchWoInvalidation(SmZoneUtil.buildVersionnPeer(this._sw));
    }

    public void setVsanPeer(SnmpPeer peer, Vsan vsan) {
        this._sw = vsan.getFabric().findSwitchByIpAddress(peer.getAddress());
        this._vsan = vsan;
        this.verPeer = SmZoneUtil.buildVersionnPeer(this._sw);
        this.capability = this._vsan == null ? this.verPeer.getIvrCapability() : this.verPeer.getNonIvrCapability();
        this.inValidateData();
    }

    ArrayList getTranslatedZoneMembers(Zone az) {
        ArrayList<EndPort> list = new ArrayList<EndPort>();
        byte[] aliases = az.getZoneAliases();
        for (int i = 0; i < this.zoneMembers.size(); ++i) {
            EndPort port;
            SmZoneMember mem = (SmZoneMember)this.zoneMembers.get(i);
            boolean validMember = false;
            if (mem.isZoneParent() && mem.getParentIndex() == az.getZoneIndex()) {
                validMember = true;
            } else {
                byte[] newByte = AbstractZone.testBit(aliases, mem.getParentIndex(), false);
                if (SnmpString.getBit(newByte, mem.getParentIndex())) {
                    validMember = true;
                }
            }
            if (!validMember) continue;
            ArrayList attPortList = mem.getAttachedEndPorts();
            if (null != attPortList) {
                list.addAll(attPortList);
            }
            if ((port = mem.getEndPort()) == null) continue;
            list.add(port);
        }
        return list;
    }

    ArrayList getTranslatedAliasMembers(ZoneAlias az) {
        ArrayList<EndPort> list = new ArrayList<EndPort>();
        for (int i = 0; i < this.zoneMembers.size(); ++i) {
            EndPort port;
            SmZoneMember mem = (SmZoneMember)this.zoneMembers.get(i);
            boolean validMember = false;
            if (mem.isAliasParent() && mem.getParentIndex() == az.getZoneIndex()) {
                validMember = true;
            }
            if (!validMember) continue;
            ArrayList attPortList = mem.getAttachedEndPorts();
            if (null != attPortList) {
                list.addAll(attPortList);
            }
            if ((port = mem.getEndPort()) == null) continue;
            list.add(port);
        }
        return list;
    }

    @Override
    protected AbstractZone[] buildZoneMemberObjects(Object[] child, AbstractZone parent, HashMap vsanAfid) {
        AbstractZone[] az = new AbstractZone[child.length];
        byte[] lunId = new byte[]{};
        int usedIndices = 0;
        int format = 1;
        int faId = 1;
        int ivrVsanId = 1;
        int devType = -1;
        for (int i = 0; i < child.length; ++i) {
            byte[] id;
            lunId = new byte[]{};
            if (child[i] instanceof EndPort || child[i] instanceof IvrEndPort) {
                EndPort port = null;
                if (child[i] instanceof EndPort) {
                    port = (EndPort)child[i];
                    ivrVsanId = parent.getZoneVsanId() != -1 ? parent.getZoneVsanId() : (int)port.getFirstVsanId();
                    ZoneCapability cap = this.cmdHandler.getSwitchCapability();
                    devType = !cap.isSmartZoningEnabled() ? 3 : (port.isTarget() ? 2 : 1);
                } else {
                    port = ((IvrEndPort)child[i]).getEndPort();
                    ivrVsanId = ((IvrEndPort)child[i]).getIvrVsan();
                }
                id = port.getPortWwn().getValue();
                format = 1;
                faId = SmZoneData.getAfidForIvr(vsanAfid, ivrVsanId, port);
            } else if (child[i] instanceof ZoneMember) {
                id = ((ZoneMember)child[i]).getMemId();
                lunId = ((ZoneMember)child[i]).getMemLunId();
                format = ((ZoneMember)child[i]).getMemFormat();
                ivrVsanId = ((ZoneMember)child[i]).getIvrVsanIndex();
                faId = ((ZoneMember)child[i]).getAfid();
                devType = ((ZoneMember)child[i]).getDeviceType();
            } else if (child[i] instanceof byte[]) {
                id = (byte[])child[i];
                format = 1;
            } else if (child[i] instanceof DeviceAlias || child[i] instanceof IvrDeviceAlias) {
                EndPort epp;
                if (child[i] instanceof DeviceAlias) {
                    id = ((DeviceAlias)child[i]).getAlias().getBytes();
                    epp = ((DeviceAlias)child[i]).getEndPortFromCache();
                    if (epp != null) {
                        ivrVsanId = parent.getZoneVsanId() != -1 ? parent.getZoneVsanId() : (int)epp.getFirstVsanId();
                        faId = SmZoneData.getAfidForIvr(vsanAfid, ivrVsanId, epp);
                    }
                } else {
                    id = ((IvrDeviceAlias)child[i]).getDeviceAlias().getAlias().getBytes();
                    ivrVsanId = ((IvrDeviceAlias)child[i]).getIvrVsan();
                    epp = ((IvrDeviceAlias)child[i]).getDeviceAlias().getEndPortFromCache();
                    if (epp != null) {
                        faId = SmZoneData.getAfidForIvr(vsanAfid, ivrVsanId, epp);
                    }
                }
                format = 10;
            } else {
                az[i] = (AbstractZone)child[i];
                continue;
            }
            int nextIndex = this.getNextZoneMemberId(parent.isZone() ? 1 : 2, parent.getZoneIndex(), usedIndices++);
            az[i] = new SmZoneMember(this._vsan, this._vsan == null ? -1 : (int)this._vsan.getId(), nextIndex, parent.isZone() ? 1 : 2, parent.getZoneIndex(), format, id, lunId, faId, ivrVsanId, devType);
        }
        return az;
    }

    @Override
    public ZoneSet createZoneSet(String zonesetName, String zoneName, int zoneIndex, boolean readOnly, Array members, boolean qos, int qospriority, boolean broadcast, HashMap vsanAfid, long sysUpTime) throws SnmpException {
        int i;
        ZoneSet zs = this.findZoneSet(zonesetName);
        Zone zn = this.findZone(zoneName);
        boolean smtzone = false;
        if (zn == null) {
            zn = this.createNewZone(null, zoneName, readOnly, zoneIndex, qos, qospriority, broadcast, smtzone, sysUpTime);
        }
        if (zs == null) {
            Zone[] znAray = new Zone[]{zn};
            zs = ZoneSet.createNewZoneset(this._vsan != null ? (int)this._vsan.getId() : -1, znAray, sysUpTime, this.getNextZoneSetId(), zonesetName, this.cmdHandler);
            this.insert(zs, this.zonesets);
        } else {
            zs.addMembers(this.cmdHandler, new Zone[]{zn});
        }
        byte[] lun = new byte[]{};
        ArrayList<SmZoneMember> zoneMembersToCreate = new ArrayList<SmZoneMember>();
        if (members != null) {
            for (i = 0; i < members.size(); ++i) {
                EndPort endPort = null;
                int ivrVsan = 0;
                if (members.elementAt(i) instanceof EndPort) {
                    endPort = (EndPort)members.elementAt(i);
                    ivrVsan = this._vsan != null ? this._vsan.getId() : endPort.getFirstVsanId();
                } else if (members.elementAt(i) instanceof LunPort) {
                    LunPort prt = (LunPort)members.elementAt(i);
                    endPort = prt._port;
                    ivrVsan = this._vsan != null ? this._vsan.getId() : endPort.getFirstVsanId();
                    lun = EnforcedZoneMember.convertLunNumberToByteArray(prt._lun.getIndex());
                } else if (members.elementAt(i) instanceof IvrEndPort) {
                    endPort = ((IvrEndPort)members.elementAt(i)).getEndPort();
                    ivrVsan = ((IvrEndPort)members.elementAt(i)).getIvrVsan();
                }
                int format = 1;
                byte[] id = null;
                if (members.elementAt(i) instanceof byte[]) {
                    byte[] data = (byte[])members.elementAt(i);
                    if (data == null || data.length != 8) continue;
                    id = data;
                    format = 1;
                } else {
                    id = endPort.getPortWwn().getValue();
                }
                int afId = SmZoneData.getAfidForIvr(vsanAfid, ivrVsan, endPort);
                zoneMembersToCreate.add(new SmZoneMember(this._vsan, this._vsan == null ? -1 : (int)this._vsan.getId(), i + 1, 1, zoneIndex, format, id, lun, afId, ivrVsan, -1));
            }
        }
        if (zoneMembersToCreate.size() > 0) {
            i = 0;
            while (i < zoneMembersToCreate.size()) {
                ArrayList modMembers = new ArrayList();
                while (modMembers.size() < 10 && i < zoneMembersToCreate.size()) {
                    modMembers.add(zoneMembersToCreate.get(i++));
                }
                this.cmdHandler.createNewMembers(modMembers, zn);
            }
            if (this.zoneMembers != null && zs != null) {
                this.zoneMembers.addAll(this.getMemberListLocation(1, zs.getZoneIndex()), zoneMembersToCreate);
            }
        }
        if (this.zonesList != null && !this.zonesList.contains(zn)) {
            this.insert(zn, this.zonesList);
        }
        return zs;
    }

    public static int getAfidForIvr(HashMap map, int vv, EndPort ep) {
        Vsan vSan;
        ArrayList ob;
        if (map != null && ep != null && (ob = (ArrayList)map.get(vSan = ep.getVsan((short)vv))) != null && ob.size() > 0) {
            return ((afidVsanSwitches)ob.get((int)0))._afId;
        }
        return 1;
    }

    public ZoneAlias createNewZoneAlias(String name, EndPort endPort, long sysUpTime) throws SnmpException {
        return this.createNewZoneAlias(name, endPort != null ? endPort.getPortWwn().getValue() : null, 1, sysUpTime);
    }

    public ArrayList getZoneMemberVsans(ZoneSet zs) {
        ArrayList<Vsan> vsans = new ArrayList<Vsan>();
        if (!zs.isIvr()) {
            return vsans;
        }
        ArrayList zones = this.getZoneSetMembers(zs);
        if (zones != null) {
            for (int j = 0; j < zones.size(); ++j) {
                for (int i = 0; i < this.zoneMembers.size(); ++i) {
                    Vsan[] ivrVsan;
                    ZoneMember mem = (ZoneMember)this.zoneMembers.get(i);
                    if (!mem.isZoneParent() || mem.getParentIndex() != ((Zone)zones.get(j)).getZoneIndex() || (ivrVsan = this._sw.getFabric().getVsansById(mem.getIvrVsanIndex())) == null) continue;
                    for (int vs = 0; vs < ivrVsan.length; ++vs) {
                        if (vsans.contains(ivrVsan[vs])) continue;
                        vsans.add(ivrVsan[vs]);
                    }
                }
            }
        }
        return vsans;
    }

    public static HashMap buidEnforcedZoneSetComparisonHashMap(Vsan v, int vsanId, Fabric fa, boolean filterIVRshadowZones, int regionId) throws SnmpException {
        return (HashMap)SmZoneData.buidEnforcedZoneSetCollection(v, vsanId, 0, fa, filterIVRshadowZones, regionId);
    }

    public static ArrayList buidEnforcedZoneSetList(Vsan v, int vsanId, Fabric fa, int regionId) throws SnmpException {
        return (ArrayList)SmZoneData.buidEnforcedZoneSetCollection(v, vsanId, 1, fa, regionId);
    }

    protected static Object buidEnforcedZoneSetCollection(Vsan v, int vsanId, int mode, Fabric fa, int regionId) throws SnmpException {
        return SmZoneData.buidEnforcedZoneSetCollection(v, vsanId, mode, fa, false, regionId);
    }

    protected static Object buidEnforcedZoneSetCollection(Vsan v, int vsanId, int mode, Fabric fa, boolean filterIVRshadowZones, int regionId) throws SnmpException {
        Cloneable map;
        block8: {
            map = null;
            map = mode == 0 ? new HashMap() : new ArrayList();
            if (v != null && v.getEnforcedZoneSetName() != null && v.getEnforcedZoneSetName().length() != 0 || v == null && fa.getAllIvrEnforcedZoneSetName() != null && fa.getAllIvrEnforcedZoneSetName().size() > 0) {
                try {
                    EnforcedZone[] enfZones;
                    EnforcedZone[] enforcedZoneArray = enfZones = v != null ? v.getEnforcedZones() : fa.getIvrEnforcedZones(regionId);
                    if (enfZones == null) break block8;
                    for (int i = 0; i < enfZones.length; ++i) {
                        if (filterIVRshadowZones && v != null && enfZones[i].getName().startsWith("IVRZ")) continue;
                        Zone newZn = new Zone(vsanId, enfZones[i].getIndex(), enfZones[i].getName(), null, -1L, enfZones[i].isReadOnly(), enfZones[i].isQosSupported(), enfZones[i].getQosPriority(), enfZones[i].isBrodcastSupported(), enfZones[i].isSmartZoningSupported());
                        ArrayList<SmZoneMember> zoneMembers = new ArrayList<SmZoneMember>();
                        for (int m = 0; m < enfZones[i].getMembers().size(); ++m) {
                            EnforcedZoneMember enfMem = (EnforcedZoneMember)enfZones[i].getMembers().elementAt(m);
                            byte[][] luns = enfMem.getLunId();
                            if (luns != null) {
                                for (int ln = 0; ln < luns.length; ++ln) {
                                    if (luns[ln] == null) continue;
                                    SmZoneMember newZoneMem = new SmZoneMember(v, v != null ? v.getVsanId() : -1, 0, 1, 1, enfMem.getType(), enfMem.getId(), luns[ln], enfMem.getAfId(), (int)enfMem.getIvrVsanId());
                                    zoneMembers.add(newZoneMem);
                                }
                                continue;
                            }
                            SmZoneMember newZoneMem = new SmZoneMember(v, v == null ? -1 : (int)v.getId(), 0, 1, 1, enfMem.getType(), enfMem.getId(), new byte[0], enfMem.getAfId(), (int)enfMem.getIvrVsanId());
                            zoneMembers.add(newZoneMem);
                        }
                        if (mode == 0) {
                            ((HashMap)map).put(newZn, zoneMembers);
                            continue;
                        }
                        ((ArrayList)map).add(new Object[]{newZn, zoneMembers});
                    }
                }
                catch (Exception ex) {
                    throw new SnmpException(ex.getMessage());
                }
            }
        }
        return map;
    }

    public Zone buildNewZoneVarBindList(String name, int zoneIndex, boolean readOnly, Array members, VarBindList vbLst, ArrayList zoneMembers, boolean qos, int qospriority, boolean broadcast, boolean smtzone, HashMap vsanAfid) throws SnmpException {
        byte[] lun = new byte[]{};
        EndPort endPort = null;
        int ivrVsan = 0;
        for (int i = 0; i < members.size(); ++i) {
            if (members.elementAt(i) instanceof EndPort) {
                endPort = (EndPort)members.elementAt(i);
                ivrVsan = this._vsan != null ? this._vsan.getVsanId() : endPort.getFirstVsanId();
            } else if (members.elementAt(i) instanceof LunPort) {
                LunPort prt = (LunPort)members.elementAt(i);
                endPort = prt._port;
                ivrVsan = this._vsan != null ? this._vsan.getVsanId() : endPort.getFirstVsanId();
                lun = EnforcedZoneMember.convertLunNumberToByteArray(prt._lun.getIndex());
            } else if (members.elementAt(i) instanceof IvrEndPort) {
                endPort = ((IvrEndPort)members.elementAt(i)).getEndPort();
                ivrVsan = ((IvrEndPort)members.elementAt(i)).getIvrVsan();
            }
            if (endPort == null) continue;
            int afId = SmZoneData.getAfidForIvr(vsanAfid, ivrVsan, endPort);
            int format = endPort.isISCSI() && this._vsan != null ? 5 : 1;
            byte[] id = endPort.isISCSI() && this._vsan != null ? endPort.getSymNodeName().getBytes() : endPort.getPortWwn().getValue();
            zoneMembers.add(new SmZoneMember(this._vsan, this._vsan == null ? -1 : (int)this._vsan.getId(), i + 1, 1, zoneIndex, format, id, lun, afId, ivrVsan));
        }
        return Zone.buildNewZoneVbList(this._vsan != null ? (int)this._vsan.getId() : -1, zoneIndex, readOnly, null, zoneMembers, name, vbLst, qos, qospriority, broadcast, smtzone, this.cmdHandler, this._sw.getSwitchUpTime());
    }
}

