/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SwitchMenuButton
extends MenuButton {
    boolean _showDID;
    Vsan _vsan;
    ActionListener _listener;
    HashMap nameToSwitchMap = new HashMap();

    public SwitchMenuButton(JMenu menu) {
        super(menu);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof MyMenuItem) {
            Switch sw = ((MyMenuItem)e.getSource())._sw;
            ((FieldPanel)this.getParent()).setText(this._showDID ? "0x" + Integer.toHexString(sw.getDomainId(this._vsan.getId())) : sw.getIpAddress());
            if (this._listener != null) {
                this._listener.actionPerformed(new ActionEvent(sw, 0, "Switch"));
            }
            return;
        }
        super.actionPerformed(e);
    }

    public void buildMenu(Object[] items, boolean showDID, Vsan v, ActionListener listener) {
        this._showDID = showDID;
        this._vsan = v;
        this._listener = listener;
        super.buildMenu(items);
    }

    @Override
    protected JMenuItem buildMenuItem(Object item) {
        Switch sw = (Switch)item;
        MyMenuItem mi = new MyMenuItem(sw);
        mi.addActionListener(this);
        return mi;
    }

    public Switch getSwitch(String swName) {
        return (Switch)this.nameToSwitchMap.get(swName);
    }

    class MyMenuItem
    extends JMenuItem {
        Switch _sw;

        public MyMenuItem(Switch sw) {
            this._sw = sw;
            this.setText(this.toString());
            SwitchMenuButton.this.nameToSwitchMap.put(sw.toString(), sw);
        }

        @Override
        public String toString() {
            if (SwitchMenuButton.this._showDID) {
                short domainId = this._sw.getDomainId(SwitchMenuButton.this._vsan.getId());
                return this._sw + ", DID:0x" + Integer.toHexString(0xFF & domainId);
            }
            return this._sw.toString();
        }
    }
}

