/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.common.type.WwnKey;

public class VHbaTableModel
extends KTableModel {
    static final String[] LABELS = new String[]{"Switch", "OS", "VHBA pWWN"};
    private static final String[] OS_TYPES = new String[]{"Windows", "AIX", "Solaris", "Linux", "HPUX"};
    private static int VHBA_BASE = 1169;

    public VHbaTableModel() {
        this.setHeaders(LABELS);
        this.updateData();
    }

    public void updateData() {
        Array<Object[]> responseData = new Array<Object[]>();
        Fabric fa = ClientController.getInstance().getFabric();
        Switch[] sw = fa.getSwitches();
        if (sw != null) {
            for (int i = 0; i < sw.length; ++i) {
                VersionPeer verPeer = SmZoneUtil.buildVersionnPeer(sw[i]);
                if (!verPeer.getIvrCapability().isOsBasedLunDiscoverySupported()) continue;
                byte[] swWwn = ((WwnKey)sw[i].getPK())._wwn.getValue();
                byte[] modWwn = new byte[swWwn.length];
                System.arraycopy(swWwn, 0, modWwn, 0, swWwn.length);
                int upperNum = modWwn[0] << 8 | modWwn[1] | VHBA_BASE & 0xFFFF;
                for (int j = 0; j < OS_TYPES.length; ++j) {
                    Object[] o = new Object[LABELS.length + 1];
                    o[0] = sw[i];
                    o[1] = OS_TYPES[j];
                    modWwn[0] = (byte)(upperNum + j >> 8 & 0xFF);
                    modWwn[1] = (byte)(upperNum + j & 0xFF);
                    o[2] = SnmpString.toHexString(modWwn);
                    responseData.addElement(o);
                }
            }
        }
        this.setData(responseData);
    }
}

