/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.merge;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.IfVshStatus;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.script.AbstractWorker;
import com.cisco.dcbu.lib.ui.script.Script;
import com.cisco.dcbu.lib.ui.script.ScriptHandler;
import com.cisco.dcbu.lib.ui.script.TFTPServer;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.SmZoneAction;
import com.cisco.dcbu.sm.client.zm.common.SmZoneActivationAction;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.client.zm.merge.ZModelKeys;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ZExecutePanel
extends WizardPanel
implements ZModelKeys {
    private String _workingDir = null;
    private String _desc = "Click on Finish button to start merge operation.";
    public static final ImageIcon ICON = Util.loadIcon("icons/zonemerge.gif");
    private Window _parent = null;
    private JButton _cancelButton = null;
    private String _newName = null;
    private SnmpPeer _source;
    private SnmpPeer _destination;
    private MergeWorker _worker1 = null;
    private MergeWorker _worker2 = null;
    private JPanel _core = new JPanel(new BorderLayout());
    private JLabel _lblVsan = new JLabel();
    private JPanel _srcPanel = new JPanel(new BorderLayout());
    private JPanel _dstPanel = new JPanel(new BorderLayout());
    private DialogSeparator _srcTitle = new DialogSeparator("Source");
    private DialogSeparator _dstTitle = new DialogSeparator("Destination");
    private JTextArea _srcOutput = new JTextArea();
    private JTextArea _dstOutput = new JTextArea();
    public static final String EMPTY_STRING = "";
    public static final String NEW_LINE = "\n";
    private static int _threads = 0;
    Component[] _block = null;

    public ZExecutePanel(String workingDir) {
        super("Step 4 of 4: Merge Zones", EMPTY_STRING, ICON);
        super.setDescription(this._desc);
        this._workingDir = workingDir;
        try {
            JPanel local = new JPanel(new GridLayout(1, 2));
            this._srcOutput.setEditable(false);
            this._dstOutput.setEditable(false);
            this._srcPanel.add((Component)this._srcTitle, "North");
            this._srcPanel.add((Component)new JScrollPane(this._srcOutput), "Center");
            local.add(this._srcPanel);
            this._dstPanel.add((Component)this._dstTitle, "North");
            this._dstPanel.add((Component)new JScrollPane(this._dstOutput), "Center");
            local.add(this._dstPanel);
            JPanel top = DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{"VSAN:"}), new JComponent[]{this._lblVsan});
            this._core.add((Component)top, "North");
            this._core.add((Component)local, "Center");
            this.add((Component)this._core, "Center");
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void doInitialize() {
        try {
            Component[] btns = new Component[]{this.getWizard().getNavigator().getBackBtn(), this.getWizard().getNavigator().getNextBtn()};
            this._source = (SnmpPeer)this.getModelValue("SOURCE_PEER");
            SnmpPeer[] switches = new SnmpPeer[]{this._source, this._destination = (SnmpPeer)this.getModelValue("TARGET_PEER")};
            StringBuffer s1 = (StringBuffer)this.getModelValue("SOURCE_CLI");
            StringBuffer s2 = (StringBuffer)this.getModelValue("TARGET_CLI");
            this._lblVsan.setText(this.getModelValue("VSAN").toString());
            this._srcTitle.setLabel("CLI Session - " + this._source.toString());
            this._dstTitle.setLabel("CLI Session - " + this._destination.toString());
            if (s1 != null) {
                this._source = switches[0];
                this._srcOutput.append("Script for: " + this._source + NEW_LINE);
                this._srcOutput.append(s1 + NEW_LINE);
                this._srcOutput.append("End\n");
                this._srcOutput.setCaretPosition(this._srcOutput.getText().length());
            } else {
                this._srcOutput.setText("No action to be taken for switch: " + this._source.toString());
            }
            if (s2 != null) {
                this._destination = switches[1];
                this._dstOutput.append("Script for: " + this._destination + NEW_LINE);
                this._dstOutput.append(s2 + NEW_LINE);
                this._dstOutput.append("End\n");
                this._dstOutput.setCaretPosition(this._dstOutput.getText().length());
            } else {
                this._dstOutput.setText("No action to be taken for switch: " + this._destination.toString());
            }
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void doFinish() {
        try {
            this.doApply();
        }
        catch (Exception ex) {
            this.getWizard().setStatus(ex.getMessage());
            Util.errorMessage((Component)this.getWizard(), ex);
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void doCancel() {
        this.getWizard().dispose();
    }

    public void doApply() throws Exception {
        this.getWizard().setStatus(EMPTY_STRING);
        this.go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void go() {
        Component[] btns = new JComponent[]{this.getWizard().getNavigator().getNextBtn(), this.getWizard().getNavigator().getBackBtn(), this.getWizard().getNavigator().getCancel()};
        SnmpPeer source = (SnmpPeer)this.getModelValue("SOURCE_PEER");
        SnmpPeer target = (SnmpPeer)this.getModelValue("TARGET_PEER");
        StringBuffer sourceCLI = (StringBuffer)this.getModelValue("SOURCE_CLI");
        StringBuffer targetCLI = (StringBuffer)this.getModelValue("TARGET_CLI");
        String[] devices = new String[]{source.toString(), target.toString()};
        Vsan vsan = (Vsan)this.getModelValue("VSAN");
        try {
            _threads = 0;
            this._worker1 = null;
            this._worker2 = null;
            this.getWizard().setCursor(Cursor.getPredefinedCursor(3));
            this.setBlockComponents(btns);
            this.setControlsEnabled(false);
            this.renameOnFinishTo(this.getWizard().getNavigator().getCancel(), "Close");
            TFTPServer.start(devices, this._workingDir);
            if (sourceCLI != null) {
                this._worker1 = new MergeWorker(sourceCLI, source, ExternalTools.isUseSSH(), vsan, this._srcOutput, this._srcTitle);
                this._worker1.setSaveFile("cliscript1");
                this._worker1.setZoneSet((String)this.getModelValue("NEW_NAME"));
                this._worker1.start();
            }
            if (targetCLI != null) {
                this._worker2 = new MergeWorker(targetCLI, target, ExternalTools.isUseSSH(), vsan, this._dstOutput, this._dstTitle);
                this._worker2.setSaveFile("cliscript2");
                this._worker2.setZoneSet((String)this.getModelValue("NEW_NAME"));
                this._worker2.start();
            }
            this.getWizard().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (ZExecutePanel.this._worker1 != null) {
                        ZExecutePanel.this._worker1.abort();
                    }
                    if (ZExecutePanel.this._worker2 != null) {
                        ZExecutePanel.this._worker2.abort();
                    }
                }
            });
        }
        catch (Exception ex) {
            this.setControlsEnabled(true);
            Util.errorMessage((Component)this._parent, ex.getMessage());
        }
        finally {
            this.getWizard().setCursor(new Cursor(0));
        }
    }

    private void allowReDo() {
        TFTPServer.stop();
        this.setControlsEnabled(false);
        if (this._cancelButton != null) {
            this._cancelButton.setText(this._newName);
            this._cancelButton.setEnabled(true);
        }
    }

    public void setBlockComponents(Component[] block) {
        this._block = block;
    }

    private void setControlsEnabled(boolean b) {
        if (this._block != null) {
            for (int i = 0; i < this._block.length; ++i) {
                if (this._block[i] == null) continue;
                this._block[i].setEnabled(b);
            }
        }
    }

    public void renameOnFinishTo(JButton btn, String name) {
        this._cancelButton = btn;
        this._newName = name;
    }

    class MergeAction
    extends SmZoneAction {
        public MergeAction(StatusIf dialog) {
            super(dialog, null, -1);
        }

        protected void buildActivationActions(Switch sw, ZoneSet zs, boolean b, PollerManager manager, boolean saveConfig, String fileName) throws SnmpException {
            VersionPeer verPeer = SmZoneUtil.buildVersionnPeer(sw);
            SmZoneActivationAction act = (SmZoneActivationAction)SmZoneActivationAction.createAction(SmZoneUtil.getCommandHandler(verPeer.getNonIvrCapability(), zs.getZoneVsanId(), verPeer, null), zs, b, manager, this, false, null);
            act.setDiscoverZoneSetIndexFlag(true);
        }
    }

    class MergeWorker
    extends AbstractWorker
    implements StatusIf,
    IfVshStatus {
        static final String _ABORTED = "Operation aborted";
        String _store;
        StringBuffer _script;
        SnmpPeer _device;
        JTextArea _output;
        DialogSeparator _statusComp;
        boolean _ssh;
        Vsan _vsan;
        String _zoneSet = null;
        ArrayList _newZones = null;
        Script _scr = null;
        boolean kontinue = true;

        public MergeWorker(StringBuffer script, SnmpPeer device, boolean ssh, Vsan vsan, JTextArea out, DialogSeparator statusComp) {
            this._script = script;
            this._device = device;
            this._output = out;
            this._ssh = ssh;
            this._vsan = vsan;
            this._statusComp = statusComp;
        }

        public void setSaveFile(String str) {
            this._store = str;
        }

        public void setZoneSet(String zoneSet) {
            this._zoneSet = zoneSet;
        }

        public void setClearZoneList(ArrayList newZones) {
            this._newZones = newZones;
        }

        public void abort() {
            this.kontinue = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object construct() {
            try {
                MergeWorker mergeWorker = this;
                synchronized (mergeWorker) {
                    _threads++;
                }
                ScriptHandler handler = new ScriptHandler(ZExecutePanel.this.getWizard(), ZExecutePanel.this._workingDir, this._ssh);
                handler.setStatusListener(this);
                String filename = handler.save(this._script.toString(), this._store);
                if (!this.kontinue) {
                    throw new Exception(_ABORTED);
                }
                this.clearNewZones();
                if (!this.kontinue) {
                    throw new Exception(_ABORTED);
                }
                this._scr = new Script(ZExecutePanel.EMPTY_STRING, ZExecutePanel.EMPTY_STRING, filename, this._device.getAddress().getHostAddress(), 2);
                this._output.append(Script.MESSAGE[this._scr.getStatus()] + ZExecutePanel.NEW_LINE);
                this._output.setCaretPosition(this._output.getText().length());
                if (!this.kontinue) {
                    throw new Exception(_ABORTED);
                }
                handler.apply(this._scr);
                if (!this.kontinue) {
                    throw new Exception(_ABORTED);
                }
                this._output.append(this._scr.getResult() + ZExecutePanel.NEW_LINE);
                this.setStatus(Script.MESSAGE[this._scr.getStatus()]);
                this._output.setCaretPosition(this._output.getText().length());
            }
            catch (Exception ex) {
                this.setStatus(ex.getMessage());
                Util.errorMessage((Component)ZExecutePanel.this.getWizard(), ex);
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            return null;
        }

        @Override
        public void finished() {
            try {
                ClientController.getInstance();
                Switch sw = ClientController.findFabricSwitchByIpAddress(this._device.getAddress());
                if (this._scr.getStatus() == 0) {
                    this.setStatus("Activating " + this._zoneSet + " on " + this._device);
                    this._scr.setStatus(2);
                    if (!this.kontinue) {
                        throw new Exception(_ABORTED);
                    }
                    MergeAction action = new MergeAction(this);
                    if (!this.kontinue) {
                        throw new Exception(_ABORTED);
                    }
                    action.setVsanSwitch(sw, this._vsan);
                    if (!this.kontinue) {
                        throw new Exception(_ABORTED);
                    }
                    action.activateAction(new ZoneSet(this._vsan.getId(), -1, this._zoneSet, null, 0L), true, false, null, false);
                    if (!this.kontinue) {
                        action.stopPolling();
                    }
                    if (!this.kontinue) {
                        throw new Exception(_ABORTED);
                    }
                    this._scr.setStatus(0);
                } else {
                    this.actionFinished();
                }
            }
            catch (Exception ex) {
                this._scr.setStatus(1);
                this.setStatus(ex.getMessage());
                Util.errorMessage((Component)ZExecutePanel.this.getWizard(), ex);
                this.actionFinished();
            }
        }

        private void copyActiveZonesetToLocal(SnmpPeer peer, Vsan vsan) {
            try {
                SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
                pdu.addVar(new SnmpOID(MibNode.get("zoneCopyActiveToFullOnVsan").getOid(), 0), new SnmpInt(vsan.getId()));
                peer.set(pdu);
            }
            catch (Exception ex) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }

        private void clearNewZones() {
            try {
                if (this._newZones != null && this._newZones.size() > 0) {
                    String[] zones = new String[this._newZones.size()];
                    for (int i = 0; i < this._newZones.size(); ++i) {
                        zones[i] = ((Zone)this._newZones.get(i)).getZoneName();
                        DefaultLogger._DefLogger.debug((Object)("Clearing zone " + zones[i] + " in " + this._device));
                    }
                    ClientController.getInstance();
                    Switch sw = ClientController.findFabricSwitchByIpAddress(this._device.getAddress());
                    VersionPeer verPeer = SmZoneUtil.buildVersionnPeer(sw);
                    Zone.clearAllZoneMembers(SmZoneUtil.getCommandHandler(verPeer.getNonIvrCapability(), this._vsan, verPeer, null), this._vsan.getId(), zones);
                }
            }
            catch (Exception ex) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }

        @Override
        public void setStatus(String status) {
            if (this._scr != null) {
                if (status.indexOf("Success") != -1) {
                    this._scr.setStatus(0);
                } else {
                    this._scr.setOtherStatus(status);
                }
                String res = this._scr.getResult();
                res = res + status + ZExecutePanel.NEW_LINE;
                this._scr.setResult(res);
                this._output.append(status + ZExecutePanel.NEW_LINE);
                this._output.setCaretPosition(this._output.getText().length());
                this._statusComp.setLabel("CLI Session - " + this._device + " - " + status);
            }
        }

        @Override
        public void handleError(Exception[] ex) {
            if (ex != null) {
                for (int i = 0; i < ex.length; ++i) {
                    DefaultLogger._ExLogger.warn((Object)ex[i].getMessage(), (Throwable)ex[i]);
                }
                this.setStatus("Failed to activate zoneset " + this._zoneSet);
                if (this._scr != null) {
                    this._scr.setStatus(1);
                }
            }
        }

        @Override
        public void dispose() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionFinished() {
            MergeWorker mergeWorker = this;
            synchronized (mergeWorker) {
                _threads--;
            }
            File file = this._scr.getScriptFile();
            if (!file.isDirectory() && file.exists()) {
                file.delete();
            }
            if (_threads == 0) {
                ZExecutePanel.this.allowReDo();
            }
        }
    }
}

