/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.merge;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.MultiLineTableCellRenderer;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.SmZoneData;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.client.zm.merge.MergeTableCellRenderer;
import com.cisco.dcbu.sm.client.zm.merge.RadioGroupButtonPanel;
import com.cisco.dcbu.sm.client.zm.merge.ZActionEditor;
import com.cisco.dcbu.sm.client.zm.merge.ZActionRenderer;
import com.cisco.dcbu.sm.client.zm.merge.ZMergeTableModel;
import com.cisco.dcbu.sm.client.zm.merge.ZModelKeys;
import com.cisco.dcbu.sm.client.zm.merge.ZSelectSwitch;
import com.cisco.dcbu.sm.client.zm.merge.ZStageZoneset;
import com.cisco.dcbu.sm.client.zm.merge.ZoneMergeTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class ZMergeReport
extends WizardPanel
implements ZModelKeys,
ActionListener {
    static final String SELECT_SOURCE = "<";
    static final String SELECT_TARGET = ">";
    static final String SELECT_BOTH = "+";
    static final String DEFAULT = "+";
    private String _desc = "The table shows the mismatched zone members which will cause the merge failure. Please select the zone members under Action column which should be present in the final Active zoneset on both switches. Selecting '<' will include the members of source switch and selecting '>' will include members of destination switch. Selecting '+' will include the members from both the switches in the final zoneset.";
    public static final ImageIcon ICON = Util.loadIcon("icons/zonemerge.gif");
    private JPanel _core = new JPanel(new BorderLayout());
    private JLabel _lblVsan = new JLabel();
    private JLabel _message = new JLabel();
    private JTextField _newName = new JTextField("StageZoneSet");
    private JScrollPane _sp = null;
    private ZMergeTableModel _model = null;
    private ZoneMergeTable _table = null;
    private final ZActionRenderer _actionRenderer = new ZActionRenderer();
    final RadioGroupButtonPanel _actionPanel = new RadioGroupButtonPanel();
    private final ZActionEditor _actionEditor = new ZActionEditor(this._actionPanel);
    private JToggleButton _left = this._actionPanel.getButton(0);
    private JToggleButton _action = this._actionPanel.getButton(1);
    private JToggleButton _right = this._actionPanel.getButton(2);
    private SnmpPeer _sourcePeer;
    private SnmpPeer _targetPeer;
    private String _sourceVersion;
    private String _targetVersion;
    private ZoneSet _sourceActive;
    private ZoneSet _targetActive;
    private Vsan _vsan;

    public ZMergeReport(String home) {
        super("Step 2 of 4: Select Zone Members To Merge", "", ICON);
        super.setDescription(this._desc);
        this._sp = new JScrollPane();
        JPanel top = DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{"VSAN:", "Staging Zoneset Name:"}), new JComponent[]{this._lblVsan, this._newName});
        this._core.add((Component)top, "North");
        this._core.add((Component)this._sp, "Center");
        this._core.add((Component)this._message, "South");
        this._left.addActionListener(this);
        this._action.addActionListener(this);
        this._right.addActionListener(this);
        this.add((Component)this._core, "Center");
    }

    public void doInitialize() {
        try {
            this._sourcePeer = (SnmpPeer)this.getModelValue("SOURCE_PEER");
            this._sourceVersion = (String)this.getModelValue("SOURCE_VER2");
            this._targetPeer = (SnmpPeer)this.getModelValue("TARGET_PEER");
            this._targetVersion = (String)this.getModelValue("TARGET_VER2");
            this._vsan = (Vsan)this.getModelValue("VSAN");
            this._sourceActive = (ZoneSet)this.getModelValue("SOURCE_ZONESET");
            this._targetActive = (ZoneSet)this.getModelValue("TARGET_ZONESET");
            this._model = (ZMergeTableModel)this.getModelValue("MODEL");
            this._table = new ZoneMergeTable(this._model);
            this._lblVsan.setText(this._vsan.toString());
            String[] colGroup1 = new String[]{this._sourcePeer.toString() + " (" + this._sourceActive.getZoneName() + ")", this._targetPeer.toString() + " (" + this._targetActive.getZoneName() + ")"};
            int[][] colGroupRanges1 = new int[][]{{1, 2}, {4, 5}};
            this._table.buildColGroups(colGroup1, colGroupRanges1);
            this._table.getColumnModel().getColumn(3).setCellRenderer(this._actionRenderer);
            this._table.getColumnModel().getColumn(3).setCellEditor(this._actionEditor);
            MultiLineTableCellRenderer multiLineRenderer = new MultiLineTableCellRenderer();
            MergeTableCellRenderer special = new MergeTableCellRenderer();
            this._table.getColumnModel().getColumn(0).setCellRenderer(special);
            this._table.getColumnModel().getColumn(1).setCellRenderer(multiLineRenderer);
            this._table.getColumnModel().getColumn(2).setCellRenderer(multiLineRenderer);
            this._table.getColumnModel().getColumn(4).setCellRenderer(multiLineRenderer);
            this._table.getColumnModel().getColumn(5).setCellRenderer(multiLineRenderer);
            this._sp.setViewportView(this._table);
            int status = this._model.getStatus();
            DefaultLogger._DefLogger.debug((Object)("Status : " + status));
            switch (status) {
                case 0: {
                    this._message.setText("No merge conflicts.");
                    break;
                }
                case 1: {
                    if (this._model.getRowCount() == 0) {
                        this._message.setText("Zones differ.");
                        break;
                    }
                    this._message.setText("Zone differ.");
                    break;
                }
                case 2: {
                    this._message.setText("Zone Members differ.");
                    break;
                }
                case 3: {
                    this._message.setText("Zones, Zone Members differ.");
                    break;
                }
                case 4: {
                    this._message.setText("Read-Only attributes differ.");
                    break;
                }
                case 5: {
                    this._message.setText("Zones, Read-Only attributes differ.");
                    break;
                }
                case 6: {
                    this._message.setText("Zone Members and Read-Only attributes differ.");
                    break;
                }
                case 7: {
                    this._message.setText("Zones, Zone Members and Read-Only attributes differ.");
                    break;
                }
                default: {
                    this._message.setText("Unknown conflict:" + status);
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.getWizard().setStatus(ex.getMessage());
            Util.errorMessage((Component)this.getWizard(), ex);
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void doPrevious() {
        JWizard wizard = this.getWizard();
        wizard.setCursor(Cursor.getPredefinedCursor(3));
        ((ZSelectSwitch)this.getModelValue("ZSelectSwitch")).doInitialize();
        super.doPrevious();
        wizard.setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doNext() {
        try {
            int v1 = SmZoneUtil.getVersion(this._sourceVersion);
            int v2 = SmZoneUtil.getVersion(this._targetVersion);
            String name = this._newName.getText();
            if (v1 != v2) {
                throw new SnmpException("The versions of the switches are different.\n" + this._sourcePeer + " version is " + this._sourceVersion + "\n" + this._targetPeer + " version is" + this._targetVersion);
            }
            if (name == null || name.trim().equals("")) {
                throw new SnmpException("Please enter a Staging Zoneset Name.");
            }
            SmZoneData zd = (SmZoneData)this.getModelValue("POOL");
            ZoneSet tmp = zd.findZoneSet(name);
            if (tmp != null) {
                throw new SnmpException("A Zoneset with the specified name already exists.");
            }
            this.setModelValue("NEW_NAME", name);
            this.getWizard().setCursor(new Cursor(3));
            this.getWizard().setStatus("");
            ((ZStageZoneset)this.getModelValue("ZStageZoneset")).doInitialize();
            super.doNext();
        }
        catch (Exception ex) {
            this.getWizard().setStatus(ex.getMessage());
            Util.errorMessage((Component)this.getWizard(), ex);
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.getWizard().setCursor(new Cursor(0));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JToggleButton btn = (JToggleButton)e.getSource();
        String value = "+";
        if (btn == this._left && this._left.isSelected()) {
            value = SELECT_SOURCE;
        }
        if (btn == this._right && this._right.isSelected()) {
            value = SELECT_TARGET;
        }
        if (btn == this._action && this._action.isSelected()) {
            value = "+";
        }
        this._actionEditor.setValue(value);
    }

    public void debugScript(String name, ArrayList script) {
        DefaultLogger._DefLogger.debug((Object)("#############################" + name + "#################"));
        if (script != null) {
            for (int i = 0; i < script.size(); ++i) {
                DefaultLogger._DefLogger.debug(script.get(i));
            }
        }
        DefaultLogger._DefLogger.debug((Object)"############################# END #################");
    }
}

