/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.migrate.panels;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.zm.MdsCommandHandler;
import com.cisco.dcbu.lib.mds.zm.ZoneMode;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KFilePanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.script.AbstractWorker;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ReadBrocadeSwitch;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ReadMcDataSwitch;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ReadOtherSwitch;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZonesetList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class LoginPanel
extends WizardPanel
implements ActionListener {
    private String[] _otherSwitches = new String[]{"Brocade", "McData"};
    private KTextField _tfUserName = new KTextField(12);
    private JPasswordField _tfPassword = new JPasswordField(12);
    private KTextField _tfSwitch = new KTextField(12);
    private JComboBox _cbMigrateFrom = new JComboBox<String>(this._otherSwitches);
    private JCheckBox _aliasMigrate = new JCheckBox("Migrate McData Alias?");
    private RadioButtonPanel _selectDB;
    private KFilePanel _aliasFileName = new KFilePanel("Alias File: ", 30, "Select Alias File", "");
    private boolean _aliasMigrateBool = false;
    private JLabel[] _labels = null;
    private JComboBox _cbVsan = new JComboBox();
    private Vsan[] _vsans = null;
    private String desc = "Generate MDS Zone config file from McData or Brocade.  McData zones are not stored on switch, the file format must be 'WWN=<aliasName>' - one entry per line.\nNOTE: Tested on Brocade version 3.1.1 and McData version 04.01.00 only.";
    public static final ImageIcon ICON = Util.loadIcon("icons/zonemigrate.gif");
    private AbstractWorker worker = null;
    public static final String EMPTY_STRING = "";

    public LoginPanel(String workingDir, Vsan[] v) {
        super("Step 1 of 5: Migrate Zones from Switch", EMPTY_STRING, ICON);
        super.setDescription(this.desc);
        this._vsans = v;
        this._cbMigrateFrom.addActionListener(this);
        this._aliasMigrate.addActionListener(this);
        this._cbVsan.setModel(new DefaultComboBoxModel<Vsan>(this._vsans));
        this._aliasFileName.setEnabled(false);
        this._aliasMigrate.setEnabled(false);
        this._selectDB = new RadioButtonPanel(new String[]{"Effective", "Defined"});
        this._selectDB.setSelected(0);
        JPanel migratePnl = new JPanel(new FlowLayout(0, 6, 3));
        migratePnl.add(this._cbMigrateFrom);
        migratePnl.add(this._selectDB);
        String[] strLabels = new String[]{"Switch:", "User:", "Password:", "VSAN Id:", "Migrate From:", null, null};
        JComponent[] comps = new JComponent[]{this._tfSwitch, this._tfUserName, this._tfPassword, this._cbVsan, migratePnl, this._aliasMigrate, this._aliasFileName};
        this._labels = DialogUtil.buildLabels(strLabels);
        JPanel core = DialogUtil.buildPanel(this._labels, comps);
        this.add((Component)core, "Center");
    }

    @Override
    public void doNext() {
        try {
            final String userName = this._tfUserName.getText();
            final String password = String.valueOf(this._tfPassword.getPassword());
            final String switchIP = this._tfSwitch.getText();
            final short vsan = this._vsans[this._cbVsan.getSelectedIndex()].getId();
            final int migrateFrom = this._cbMigrateFrom.isEnabled() ? this._cbMigrateFrom.getSelectedIndex() : -1;
            String migrate = migrateFrom + EMPTY_STRING;
            this.validateFields(userName, switchIP, (Vsan)this._cbVsan.getSelectedItem());
            final boolean nowAliasMigrate = this._aliasMigrate.isEnabled() && this._aliasMigrate.isSelected();
            String modelUserName = (String)this.getModelValue("LoginPanel.UserName");
            String modelPassword = (String)this.getModelValue("LoginPanel.Password");
            String modelSwitchIP = (String)this.getModelValue("LoginPanel.Switch");
            String modelMigrateFrom = (String)this.getModelValue("LoginPanel.MigrateFrom");
            String modelVsan = (String)this.getModelValue("LoginPanel.VSAN");
            Boolean wasSuccess = (Boolean)this.getModelValue("LoginPanel.proceed");
            Boolean fullDBMigrateCache = (Boolean)this.getModelValue("LoginPanel.FullDBMigrate");
            if (!nowAliasMigrate && modelUserName != null && userName.equals(modelUserName) && modelPassword != null && password.equals(modelPassword) && modelSwitchIP != null && switchIP.equals(modelSwitchIP) && modelMigrateFrom != null && migrate.equals(modelMigrateFrom) && modelVsan != null && Integer.parseInt(modelVsan) == vsan && wasSuccess != null && wasSuccess.booleanValue() && fullDBMigrateCache != null && fullDBMigrateCache.equals(this._selectDB.getSelected() == 1)) {
                this.goNext();
                return;
            }
            this.setDataValid(false);
            super.setModelValue("LoginPanel.UserName", userName);
            super.setModelValue("LoginPanel.Password", password);
            super.setModelValue("LoginPanel.Switch", switchIP);
            super.setModelValue("LoginPanel.VSAN", vsan + EMPTY_STRING);
            super.setModelValue("LoginPanel.MigrateFrom", migrate);
            super.setModelValue("LoginPanel.AliasMigrate", this._aliasMigrate.isSelected());
            super.setModelValue("LoginPanel.AliasFile", this._aliasFileName.getText());
            super.setModelValue("LoginPanel.AliasFileContent", null);
            super.setModelValue("TranslatePanel.output", null);
            super.setModelValue("WWNPanel.output", null);
            super.setModelValue("LoginPanel.FullDBMigrate", this._selectDB.getSelected() == 1);
            this.worker = new AbstractWorker(){
                private boolean proceed = false;
                private String message = "";
                private JWizard wizard = LoginPanel.this.getWizard();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object construct() {
                    try {
                        this.wizard.setStatus(LoginPanel.EMPTY_STRING);
                        this.wizard.setCursor(Cursor.getPredefinedCursor(3));
                        this.wizard.getNavigator().getNextBtn().setEnabled(false);
                        if (nowAliasMigrate) {
                            BufferedReader reader = new BufferedReader(new FileReader(LoginPanel.this._aliasFileName.getText()));
                            String readLine = null;
                            String aliasFileContent = LoginPanel.EMPTY_STRING;
                            while ((readLine = reader.readLine()) != null) {
                                aliasFileContent = aliasFileContent + readLine + "\n";
                            }
                            StringBuffer aliasBuffer = ReadMcDataSwitch.getAliasCLI(aliasFileContent, vsan);
                            LoginPanel.this.setModelValue("LoginPanel.AliasFileContent", aliasBuffer);
                            if (aliasBuffer == null || aliasBuffer.length() == 0) {
                                this.message = "There are no aliases to migrate";
                                this.proceed = false;
                            } else {
                                this.proceed = true;
                            }
                            LoginPanel.this._aliasMigrateBool = true;
                        } else {
                            LoginPanel.this._aliasMigrateBool = false;
                            this.wizard.setStatus("Connecting  to " + switchIP + ". Please wait...");
                            ReadOtherSwitch readConfiguration = null;
                            if (migrateFrom == 0) {
                                readConfiguration = new ReadBrocadeSwitch();
                            } else if (migrateFrom == 1) {
                                readConfiguration = new ReadMcDataSwitch();
                            }
                            if (readConfiguration == null) {
                                Object readLine = null;
                                return readLine;
                            }
                            LoginPanel.this.setModelValue("LoginPanel.configuration", readConfiguration);
                            ZonesetList threadData = null;
                            threadData = readConfiguration.getZoneSets(switchIP, userName, password, vsan, migrateFrom, LoginPanel.this._selectDB.getSelected() == 1);
                            if (threadData == null || threadData.getZonesetList() == null || threadData.getZonesetList().length == 0) {
                                throw new Exception("No zonesets are available for migration in switch : " + LoginPanel.this.getModelValue("LoginPanel.Switch"));
                            }
                            threadData = readConfiguration.getDomainIdsUnDecoded(migrateFrom);
                            LoginPanel.this.setModelValue("LoginPanel.output", threadData);
                            LoginPanel.this.setModelValue("LoginPanel.AliasFileContent", null);
                            ArrayList mds = readConfiguration.getTargetDomains(vsan);
                            LoginPanel.this.setModelValue("LoginPanel.mds", mds);
                            this.proceed = true;
                        }
                    }
                    catch (Exception ex) {
                        this.proceed = false;
                        this.message = ex.getMessage();
                        DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                    finally {
                        LoginPanel.this.setModelValue("LoginPanel.proceed", this.proceed);
                    }
                    return null;
                }

                @Override
                public void finished() {
                    this.wizard.getNavigator().getNextBtn().setEnabled(true);
                    this.wizard.setStatus(this.message);
                    if (this.proceed) {
                        LoginPanel.this.goNext();
                    }
                    this.wizard.setCursor(Cursor.getDefaultCursor());
                }
            };
            this.worker.start();
        }
        catch (Exception ex) {
            this.getWizard().setStatus(ex.getMessage());
        }
    }

    private void goNext() {
        if (this._aliasMigrateBool) {
            this.setModelValue("Execute.Script", ((StringBuffer)super.getModelValue("LoginPanel.AliasFileContent")).toString());
            super.setDataValid(false);
            super.getWizard().show("3");
        } else {
            super.doNext();
        }
    }

    private void validateFields(String user, String switchIP, Vsan vsan) throws Exception {
        ZoneMode mode;
        if (this._aliasMigrate.isEnabled() && this._aliasMigrate.isSelected()) {
            if (this._aliasFileName.getText() == null || this._aliasFileName.getText().trim().equals(EMPTY_STRING)) {
                throw new Exception("Please choose an alias file");
            }
            return;
        }
        if (user == null || user.trim().equals(EMPTY_STRING)) {
            throw new Exception("Please enter a valid user.");
        }
        if (switchIP == null || switchIP.trim().equals(EMPTY_STRING)) {
            throw new Exception("Please enter a valid switch IP address.");
        }
        SnmpPeer[] peers = vsan.getSnmpPeers();
        if (peers != null && peers.length > 0 && (mode = MdsCommandHandler.getZoneMode(vsan.getId(), peers[0])).isEnhanced()) {
            throw new Exception("Enhanced Zoning is configured for VSAN " + vsan + ". Please change mode to Basic Zoning and rerun the wizard.");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComboBox) {
            if (((JComboBox)e.getSource()).getSelectedItem().toString().indexOf("McData") > -1) {
                if (!this._aliasMigrate.isSelected()) {
                    this._aliasMigrate.setEnabled(true);
                    this._labels[0].setEnabled(true);
                    this._labels[1].setEnabled(true);
                    this._labels[2].setEnabled(true);
                } else {
                    this._aliasMigrate.setEnabled(true);
                    this._aliasFileName.setEnabled(true);
                    this._labels[0].setEnabled(false);
                    this._labels[1].setEnabled(false);
                    this._labels[2].setEnabled(false);
                    this._tfSwitch.setEnabled(false);
                    this._tfUserName.setEnabled(false);
                    this._tfPassword.setEnabled(false);
                }
                this._selectDB.setEnabled(false);
            } else {
                this._aliasMigrate.setEnabled(false);
                this._aliasFileName.setEnabled(false);
                this._tfSwitch.setEnabled(true);
                this._tfUserName.setEnabled(true);
                this._tfPassword.setEnabled(true);
                this._labels[0].setEnabled(true);
                this._labels[1].setEnabled(true);
                this._labels[2].setEnabled(true);
                this._selectDB.setEnabled(true);
            }
        } else if (e.getSource() instanceof JCheckBox) {
            if (((JCheckBox)e.getSource()).isSelected()) {
                this._aliasFileName.setEnabled(true);
                this._labels[0].setEnabled(false);
                this._labels[1].setEnabled(false);
                this._labels[2].setEnabled(false);
                this._tfSwitch.setEnabled(false);
                this._tfUserName.setEnabled(false);
                this._tfPassword.setEnabled(false);
            } else {
                this._aliasFileName.setEnabled(false);
                this._labels[0].setEnabled(true);
                this._labels[1].setEnabled(true);
                this._labels[2].setEnabled(true);
                this._tfSwitch.setEnabled(true);
                this._tfUserName.setEnabled(true);
                this._tfPassword.setEnabled(true);
            }
        }
    }
}

