/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.migrate.transfer;

import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.protocol.McDataWrapper;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.EndPortInfo;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ReadOtherSwitch;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.StoreConfigurationInMDS;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.Zone;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZoneMember;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZoneSet;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZonesetList;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZonesetZone;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ReadMcDataSwitch
extends ReadOtherSwitch {
    private ZonesetList zsList = new ZonesetList();
    private ZonesetList parsedList = new ZonesetList();
    private ZonesetList mcDataDomainIdList = new ZonesetList();
    private ZonesetList mcDataWWNList = new ZonesetList();
    private int vsanId = 1;

    public ReadMcDataSwitch() {
        this._mcDataSwitch = this;
    }

    public static StringBuffer getAliasCLI(String inString, int vsanId) {
        StringBuffer returnBuffer = new StringBuffer();
        String[] inArray = inString.split("\n");
        for (int i = 0; i < inArray.length; ++i) {
            byte[] bArray;
            String nowString = inArray[i].trim();
            if (nowString == null || nowString.length() == 0) continue;
            StringTokenizer tokenizer = new StringTokenizer(nowString, "=");
            if (tokenizer.countTokens() != 2) {
                DefaultLogger._DefLogger.debug((Object)("Skipping Line No:: " + (i + 1) + " String ::  " + nowString + " as it is not in correct format. Expected Format example is 2000000000000001=alias1 "));
                continue;
            }
            String wwnString = tokenizer.nextToken().trim();
            String aliasName = tokenizer.nextToken().trim();
            try {
                bArray = SnmpWWN.parse(wwnString, false);
            }
            catch (Exception e) {
                if (SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
                }
                DefaultLogger._DefLogger.error((Object)("Cannot parse Line No: " + (i + 1) + " String:: " + nowString));
                continue;
            }
            String wwnWithColon = SnmpWWN.toHexString(bArray);
            returnBuffer.append("fcalias name " + aliasName + " vsan " + vsanId + " \n");
            returnBuffer.append("member pwwn " + wwnWithColon + " \n");
        }
        if (returnBuffer.length() > 0) {
            returnBuffer = new StringBuffer("config terminal \n").append(returnBuffer).append("exit \n");
        }
        return returnBuffer;
    }

    @Override
    protected StringBuffer getCLI() {
        StoreConfigurationInMDS storeConfiguration = new StoreConfigurationInMDS();
        ZonesetList inList = this.getZonesetListFromZonesetZone(this.parsedList._zonesetList);
        StringBuffer buffer = storeConfiguration.generateZonesetCLIForMDS(inList, this.vsanId);
        DefaultLogger._DefLogger.debug((Object)("getCLI  - Buffer is " + buffer));
        return buffer;
    }

    @Override
    protected ZonesetList getZoneSets(String switchIp, String userName, String password, int vsan) throws ConnectException, Exception {
        this.vsanId = vsan;
        this.vsanId = vsan;
        String infoFromSwitch = this.getFromMcData(switchIp, userName, password);
        this.zsList = this.returnZoneTable(infoFromSwitch, "Active Zone Set");
        return this.zsList;
    }

    @Override
    protected ZonesetList getDomanIdsUnDecoded() {
        ZonesetList returnList = new ZonesetList();
        if (this.zsList._zonesetList.size() == 0) {
            return returnList;
        }
        if (this.mcDataDomainIdList._zonesetList.size() > 0) {
            returnList = this.mcDataDomainIdList;
        } else {
            ArrayList zonesetZoneList = this.getZonesetZoneFormat(this.zsList._zonesetList);
            for (int i = 0; i < zonesetZoneList.size(); ++i) {
                ZonesetZone zonesetZone = (ZonesetZone)zonesetZoneList.get(i);
                if (!ReadMcDataSwitch.isDomain(zonesetZone._zoneMemberOrig)) continue;
                returnList._zonesetList.add(zonesetZone);
                this.mcDataDomainIdList._zonesetList.add(zonesetZone.cloneThis());
            }
        }
        returnList = this.getZonesetListFromZonesetZone(returnList._zonesetList);
        return returnList;
    }

    @Override
    protected ZonesetList getWWNUnDecoded() {
        ZonesetList returnList = new ZonesetList();
        EndPortInfo eportInfo = new EndPortInfo();
        if (this.zsList._zonesetList.size() == 0) {
            return returnList;
        }
        if (this.mcDataWWNList._zonesetList.size() > 0) {
            returnList = this.mcDataWWNList;
        } else {
            ArrayList zonesetZoneList = this.getZonesetZoneFormat(this.zsList._zonesetList);
            for (int i = 0; i < zonesetZoneList.size(); ++i) {
                ZonesetZone zonesetZone = (ZonesetZone)zonesetZoneList.get(i);
                zonesetZone._zoneMemberNew = zonesetZone._zoneMemberOrig;
                if (zonesetZone == null || zonesetZone._zoneType != 0 || !ReadMcDataSwitch.isPort(zonesetZone._zoneMemberOrig)) continue;
                String zoneMemberValue = zonesetZone._zoneMemberOrig;
                if (eportInfo.isNWWN(zoneMemberValue)) {
                    ArrayList pwwnList = eportInfo.getPWWNs(zoneMemberValue);
                    for (int l = 0; l < pwwnList.size(); ++l) {
                        ZonesetZone zszone = new ZonesetZone();
                        zszone._zonesetName = zonesetZone._zonesetName;
                        zszone._zoneName = zonesetZone._zoneName;
                        zszone._zoneMemberOrig = (String)pwwnList.get(l);
                        zszone._zoneMemberNew = (String)pwwnList.get(l);
                        zszone._zoneType = 2;
                        this.parsedList._zonesetList.add(zszone);
                    }
                    continue;
                }
                if (eportInfo.isPWWN(zoneMemberValue)) {
                    ZonesetZone zszone = new ZonesetZone();
                    zszone._zonesetName = zonesetZone._zonesetName;
                    zszone._zoneName = zonesetZone._zoneName;
                    zszone._zoneMemberOrig = zoneMemberValue;
                    zszone._zoneMemberNew = zoneMemberValue;
                    zszone._zoneType = 2;
                    this.parsedList._zonesetList.add(zszone);
                    continue;
                }
                returnList._zonesetList.add(zonesetZone);
            }
        }
        returnList = this.getZonesetListFromZonesetZone(returnList._zonesetList);
        return returnList;
    }

    @Override
    protected void putDecodedInfo(ZonesetList zonesetList) {
        ArrayList decodedWWNs = this.getZonesetZoneFormat(zonesetList._zonesetList);
        for (int i = 0; i < decodedWWNs.size(); ++i) {
            ZonesetZone zonesetZone = (ZonesetZone)decodedWWNs.get(i);
            if (zonesetZone._zoneType == 0) continue;
            int presentValue = ReadMcDataSwitch.isPresent(this.parsedList._zonesetList, zonesetZone);
            if (presentValue != -1) {
                this.parsedList._zonesetList.remove(presentValue);
                this.parsedList._zonesetList.add(zonesetZone);
                continue;
            }
            this.parsedList._zonesetList.add(zonesetZone);
        }
    }

    private String getFromMcData(String switchIP, String userName, String password) throws ConnectException, Exception {
        McDataWrapper mcWrapper = null;
        try {
            String returnValue;
            mcWrapper = new McDataWrapper(switchIP, userName, password, "TELNET");
            String string = returnValue = mcWrapper.sendCommand("show Zoning");
            return string;
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (mcWrapper != null) {
                mcWrapper.disconnect();
            }
        }
    }

    private ZonesetList returnZoneTable(String infoFromSwitch, String configuration) {
        if (configuration == null || "".equalsIgnoreCase(configuration.trim())) {
            configuration = "Active Zone Set";
        }
        ArrayList<ZoneSet> table = new ArrayList<ZoneSet>();
        String[] individualStrings = infoFromSwitch.split("\n");
        boolean configStarted = false;
        boolean configEnded = false;
        String[] endString = null;
        ZoneSet zoneSet = new ZoneSet();
        Zone zone = new Zone();
        if (configuration.equalsIgnoreCase("Active Zone Set")) {
            endString = new String[]{"Root>"};
        }
        for (int i = 0; i < individualStrings.length; ++i) {
            String individualString = individualStrings[i];
            individualString = individualString.trim();
            if (endString != null && !"".equalsIgnoreCase(endString[0])) {
                for (int j = 0; j < endString.length; ++j) {
                    String thisEndString = endString[j];
                    if (thisEndString == null || "".equalsIgnoreCase(thisEndString.trim()) || !individualString.equalsIgnoreCase(thisEndString)) continue;
                    configEnded = true;
                    break;
                }
                if (configEnded) break;
            }
            if (individualString == null || "".equalsIgnoreCase(individualString = individualString.trim()) || individualString.indexOf(">") > -1) continue;
            if (individualString.toLowerCase().indexOf(configuration.toLowerCase()) > -1) {
                configStarted = true;
            } else if (individualString.startsWith("Zone Set:")) {
                configStarted = true;
            }
            if (!configStarted) continue;
            if (individualString.startsWith("Zone Set:")) {
                String zoneSetName = individualString.substring("Zone Set:".length()).trim();
                if (zoneSet._zoneSetName != null) {
                    if (zone != null) {
                        Zone[] myArr = new Zone[zoneSet._zones.length + 1];
                        System.arraycopy(zoneSet._zones, 0, myArr, 0, zoneSet._zones.length);
                        myArr[zoneSet._zones.length] = zone;
                        zoneSet._zones = myArr;
                        zone = new Zone();
                    }
                    table.add(zoneSet);
                    zoneSet = new ZoneSet();
                }
                zoneSet._zoneSetName = zoneSetName;
                continue;
            }
            if (individualString.startsWith("Zone:")) {
                individualString = individualString.substring("zone:".length() + 1);
                StringTokenizer tokenizer = new StringTokenizer(individualString);
                String zoneName = null;
                String zoneMember = null;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (null == token || "".equalsIgnoreCase(token.trim())) continue;
                    if (zoneName == null) {
                        zoneName = token;
                        continue;
                    }
                    zoneMember = token;
                }
                if (zone._zoneName != null) {
                    if (zoneSet == null) continue;
                    Zone[] zoneArr = new Zone[zoneSet._zones.length + 1];
                    System.arraycopy(zoneSet._zones, 0, zoneArr, 0, zoneSet._zones.length);
                    zoneArr[zoneSet._zones.length] = zone;
                    zoneSet._zones = zoneArr;
                    zone = new Zone();
                }
                zone._zoneName = zoneName;
                if (zoneMember == null) continue;
                zone._zoneMembers = new ZoneMember[1];
                ZoneMember zm = new ZoneMember();
                zm._zoneMemberOrig = zoneMember;
                zm._zoneMemberType = 0;
                zone._zoneMembers[0] = zm;
                continue;
            }
            if (!individualString.startsWith("Zone Member:")) continue;
            individualString = individualString.substring("Zone Member:".length() + 1);
            if (zone._zoneName == null) continue;
            ZoneMember[] memberArr = new ZoneMember[zone._zoneMembers.length + 1];
            System.arraycopy(zone._zoneMembers, 0, memberArr, 0, zone._zoneMembers.length);
            ZoneMember zm = new ZoneMember();
            zm._zoneMemberOrig = individualString;
            zm._zoneMemberType = 0;
            memberArr[zone._zoneMembers.length] = zm;
            zone._zoneMembers = memberArr;
        }
        if (zoneSet._zoneSetName != null) {
            if (zone != null) {
                Zone[] zoneArr = new Zone[zoneSet._zones.length + 1];
                System.arraycopy(zoneSet._zones, 0, zoneArr, 0, zoneSet._zones.length);
                zoneArr[zoneSet._zones.length] = zone;
                zoneSet._zones = zoneArr;
                zone = new Zone();
            }
            table.add(zoneSet);
            zoneSet = new ZoneSet();
        }
        ZonesetList zonesetList = new ZonesetList();
        zonesetList._zonesetList = table;
        return zonesetList;
    }
}

