/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.mds.zm.AbstractZone;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.ui.UITransferHandler;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.zm.common.DragTableModel;
import com.cisco.dcbu.sm.client.zm.common.EndPortsTableModel;
import com.cisco.dcbu.sm.client.zm.common.ZoneDragTable;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneAddDlg;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneDialogAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class AvailablePortsTable
extends ZoneDragTable {
    private ZoneDialogAction _action = null;

    public AvailablePortsTable(KTableModel dataModel, UITransferHandler dndTransferData, ZoneDialogAction action) {
        super(dataModel, dndTransferData);
        this._action = action;
    }

    public EndPort[] getSelectedEndPorts() {
        int[] rows = this.getSelectedRows();
        if (rows != null && rows.length > 0 && this.getModel() instanceof EndPortsTableModel) {
            EndPortsTableModel model = (EndPortsTableModel)this.getModel();
            return model.getEndPorts(rows);
        }
        return null;
    }

    @Override
    protected void buildPopupMenu() {
        super.buildPopupMenu();
        this._popup.addSeparator();
        this._popup.add(Util.createMenuItem("Add To Zones...", "Add To Zones", this));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Add To Zones")) {
            int[] selRows = this.getSelectedRows();
            ArrayList availableZs = this._action.getAvailableZones();
            if (availableZs.size() == 0) {
                Util.errorMessage((Component)this._action.getDialog(), "No zones available.");
            } else {
                StringBuffer buf1 = new StringBuffer("If selected member is already a member, then it will be ignored");
                StringBuffer buf2 = new StringBuffer("Selct Zones");
                ZoneAddDlg selectZns = new ZoneAddDlg((JFrame)SwingUtilities.windowForComponent(this._action.getDialog()), new StringBuffer[]{buf1, buf2}, availableZs.toArray());
                selectZns.setVisible(true);
                Object[] dstO = selectZns.getSelectedZns();
                if (dstO != null && dstO.length > 0) {
                    AbstractZone[] dst = new AbstractZone[dstO.length];
                    System.arraycopy(dstO, 0, dst, 0, dstO.length);
                    int[] rows = this.getSelectedRows();
                    Object[] src = null;
                    if (rows != null && rows.length > 0) {
                        src = new Object[rows.length];
                        for (int i = 0; i < rows.length; ++i) {
                            src[i] = ((DragTableModel)this.getModel()).getDragObject(rows[i]);
                        }
                    }
                    if (src == null || src.length == 0) {
                        Util.errorMessage((Component)this._action.getDialog(), "Please select members");
                    }
                    if (dst == null || dst.length == 0) {
                        Util.errorMessage((Component)this._action.getDialog(), "Please select destination members");
                    }
                    try {
                        this._action.addMultipleMembersToMultipleParents(dst, src);
                    }
                    catch (SnmpException exx) {
                        Util.errorMessage((Component)this._action.getDialog(), exx.getMessage());
                    }
                }
            }
        } else {
            super.actionPerformed(e);
        }
    }
}

