/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.MdsPortChooser;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.zm.ZoneAlias;
import com.cisco.dcbu.lib.mds.zm.ZoneData;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneDialogAction;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

class InsertAliasDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final String[] _Selector = new String[]{"WWN", "Switch & Port"};
    private String[] _labels = new String[]{"Alias By:", "Name:", "Port WWN:", "Switch:", "Switch Interface:"};
    private FieldPanel _aliasName;
    private FieldPanel _aliasMember;
    private WwnMenuButton _menuBtn;
    private WwnMenuButton _switchBtn;
    private ZoneDialogAction _action;
    private RadioButtonPanel _select;
    private FieldPanel _switch;
    private MdsPortChooser _switchPort;
    private ArrayList _switches;
    private EndPort[] _ePorts;
    private JLabel[] _nameLabels;
    private ZoneData _zoneData;
    private ZoneAlias _alias;
    private PortEditorCardAttribute[] _slotMembers;
    private boolean _clone;

    InsertAliasDialog(JDialog parent, ZoneAlias alias, boolean isClone, ZoneDialogAction action, ZoneData zoneData) {
        super(parent);
        this._zoneData = zoneData;
        this.setDefaultCloseOperation(2);
        this._action = action;
        this._clone = isClone;
        this._alias = alias;
        this.setTitle((alias != null && !isClone ? "Add Member" : "Create Alias") + " - " + action.getVsan().getPath('/'));
        this._nameLabels = DialogUtil.buildLabels(this._labels);
        this._aliasName = new FieldPanel(20);
        this._aliasName.setText(alias != null ? (isClone ? "Clone" : "") + alias.getZoneName() : "Alias" + zoneData.getNextZoneAliasId());
        this._aliasName.getField().setSelectionStart(0);
        this._aliasName.getField().setSelectionEnd(this._aliasName.getText().length());
        this._aliasName.setEnabled(alias == null || isClone);
        this._menuBtn = new WwnMenuButton(null);
        ArrayList<EndPort> endPorts = action.getVsan().getEndPorts(null);
        this._ePorts = endPorts.toArray(new EndPort[endPorts.size()]);
        if (this._ePorts != null) {
            Arrays.sort(this._ePorts);
            this._aliasMember = new FieldPanel(20, (JComponent)this._menuBtn);
            this._menuBtn.buildMenu(this._ePorts);
        }
        this._switchBtn = new WwnMenuButton(null);
        this._switch = new FieldPanel(20, (JComponent)this._switchBtn);
        this._select = new RadioButtonPanel(_Selector, 2);
        this._select.setSelected(0);
        this._select.addChangeListener(this);
        this._switchPort = new MdsPortChooser(this.getTitle(), 1, true);
        this._switchPort.setFilters(new PortEditorFilter(new int[]{1, 153, 152}));
        this._switchPort.setIfIndexIf(action.getSwitch());
        this._nameLabels[3].setEnabled(false);
        this._nameLabels[4].setEnabled(false);
        this._switchPort.setEnabled(false);
        this._switch.setEnabled(false);
        this._switch.getField().setEditable(false);
        Switch[] sw = action.getVsan().getFabric().getSwitches();
        this._switches = new ArrayList();
        for (int i = 0; i < sw.length; ++i) {
            if (!sw[i].isMDS() || !sw[i].isManageable()) continue;
            this._switches.add(sw[i]);
        }
        Collections.sort(this._switches);
        this._menuBtn.buildMenu(this._ePorts);
        this._switchBtn.buildMenu(this._switches.toArray());
        this._switch.setVisible(false);
        this._select.setVisible(false);
        this._switchPort.setVisible(false);
        this._nameLabels[0].setVisible(false);
        this._nameLabels[3].setVisible(false);
        this._nameLabels[4].setVisible(false);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)DialogUtil.buildPanel(this._nameLabels, new JComponent[]{this._select, this._aliasName, this._aliasMember, this._switch, this._switchPort}), (AbstractButton[])DialogUtil.buildButtons(new String[]{"OK", "Cancel"}, (ActionListener)this));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block14: {
            try {
                if (e.getActionCommand().charAt(0) == 'O') {
                    ZoneAlias alias = this._action.findZoneAlias(this._aliasName.getText().trim());
                    if (this._select.getSelected() == 0) {
                        String aliasWwn = this._aliasMember.getText().trim();
                        byte[] obWwn = null;
                        try {
                            obWwn = new Wwn(aliasWwn, aliasWwn.indexOf(":") != -1).getValue();
                            if (obWwn != null && obWwn.length > 0 && obWwn.length != 8) {
                                throw new SnmpException("Invalid port wwn " + aliasWwn + ".");
                            }
                        }
                        catch (NumberFormatException exx) {
                            throw new SnmpException("Invalid port wwn " + aliasWwn + ".");
                        }
                        int devType = -1;
                        if (alias == null) {
                            alias = this._action.createZoneAlias(this._aliasName.getText().trim(), obWwn, 1, this._clone || this._alias == null || !this._alias.getZoneName().equals(this._aliasName), devType);
                        } else {
                            this._action.addPreconfiguredZoneMembers(this._action.getTreeNodeForUserObject(alias), 1, obWwn, null, -1, 1, -1);
                        }
                    } else {
                        String switchName = this._switch.getText().trim();
                        InetAddress address = null;
                        try {
                            address = InetAddress.getByName(switchName);
                        }
                        catch (UnknownHostException ex) {
                            throw new SnmpException("Could not find switch " + switchName + " in fabric.");
                        }
                        Switch sw = this._action.getVsan().getFabric().findSwitchByIpAddress(address);
                        if (sw == null) {
                            throw new SnmpException("Switch " + switchName + " is not present in this fabric.");
                        }
                        int ifIndex = sw.nameToIfIndex(this._switchPort.getText().trim());
                        byte[] memId = sw.ifIndex2wwn(ifIndex, sw.getWwn().getValue());
                        if (memId == null) {
                            throw new SnmpException("Invalid port " + this._switchPort.getText().trim());
                        }
                        alias = this._action.createZoneAlias(this._aliasName.getText(), memId, 4, this._clone || this._alias == null, -1);
                    }
                    this._alias = alias;
                    break block14;
                }
                this.dispose();
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this, ex.getMessage());
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this._switchPort.setText("");
            this._aliasMember.setText("");
            this._switchPort.setEnabled(this._select.getSelected() != 0);
            this._switch.setEnabled(this._select.getSelected() != 0);
            this._aliasMember.setEnabled(this._select.getSelected() == 0);
            this._nameLabels[4].setEnabled(this._select.getSelected() != 0);
            this._nameLabels[3].setEnabled(this._select.getSelected() != 0);
            this._nameLabels[2].setEnabled(this._select.getSelected() == 0);
            this._nameLabels[1].setEnabled(this._select.getSelected() == 0);
        }
    }

    ZoneAlias getNewOrEditedAlias() {
        return this._alias;
    }

    private void updatePortPicker(SnmpPeer peer) {
        this.findSlotInfo(peer);
        this._switchPort.setPeer(peer);
        this._switchPort.getButton().setEnabled(this._slotMembers != null && this._slotMembers.length > 0);
        if (this._slotMembers == null) {
            return;
        }
        this._switchPort.setSlotMembers(this._slotMembers);
    }

    private void findSlotInfo(SnmpPeer peer) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        Card[] cards = sw.getCards();
        if (cards == null) {
            return;
        }
        this._slotMembers = new PortEditorCardAttribute[sw.getNumSlots()];
        for (int i = 0; i < cards.length; ++i) {
            if (cards[i] == null || cards[i].isFex() || FRUConstants.isInternalModule(cards[i].getType())) continue;
            int nOfPortonCard = cards[i].getNumPorts();
            int[] ifTypes = new int[nOfPortonCard];
            for (int j = 0; j < nOfPortonCard; ++j) {
                ifTypes[j] = cards[i].getIfType(j + 1);
            }
            if (cards[i].getSlotId() - 1 >= this._slotMembers.length) continue;
            this._slotMembers[cards[i].getSlotId() - 1] = new PortEditorCardAttribute(cards[i].getType(), nOfPortonCard, ifTypes, 0, Integer.toString(cards[i].getSlotId()));
        }
    }

    class SwitchMenuItem
    extends JMenuItem {
        protected Switch _userObject;

        SwitchMenuItem(Switch userObject) {
            this._userObject = userObject;
            this.setText(this.toString());
        }

        Switch getUserObject() {
            return this._userObject;
        }

        @Override
        public String toString() {
            return this._userObject.getIpAddress();
        }
    }

    class EndPortMenuItem
    extends JMenuItem {
        protected EndPort _userObject;

        EndPortMenuItem(EndPort userObject) {
            this._userObject = userObject;
            this.setText(this.toString());
        }

        EndPort getUserObject() {
            return this._userObject;
        }

        @Override
        public String toString() {
            return this._userObject.getPortWwn().toString();
        }
    }

    class WwnMenuButton
    extends MenuButton {
        WwnMenuButton(JMenu menu) {
            super(menu);
        }

        @Override
        protected JMenuItem buildMenuItem(Object item) {
            JMenuItem mi = null;
            mi = item instanceof EndPort ? new EndPortMenuItem((EndPort)item) : new SwitchMenuItem((Switch)item);
            mi.addActionListener(this);
            return mi;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Switch sww;
            if (e.getSource() instanceof EndPortMenuItem) {
                EndPort source = ((EndPortMenuItem)e.getSource()).getUserObject();
                ((FieldPanel)this.getParent()).setText(SnmpString.toHexString(source.getPortWwn().getValue()));
                return;
            }
            if (e.getSource() instanceof SwitchMenuItem && (sww = ((SwitchMenuItem)e.getSource()).getUserObject()).getPeer() != null) {
                InsertAliasDialog.this.updatePortPicker(sww.getPeer());
            }
            if (this._menu.getItemCount() == 0) {
                JOptionPane.showMessageDialog(this, "No end ports are available for VSAN " + InsertAliasDialog.this._action.getVsan() + ".", "Warning", 2);
                return;
            }
            super.actionPerformed(e);
        }
    }
}

