/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.PortChooser;
import com.cisco.dcbu.lib.mds.PortChooserIf;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.zm.CommandHandler;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneAlias;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.mds.zm.ZoneMemberFormat;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.tree.DndTreeNode;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.DeviceAlias;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.EndPortSelector;
import com.cisco.dcbu.sm.client.zm.common.IscsiProxy;
import com.cisco.dcbu.sm.client.zm.common.SmZoneData;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.client.zm.common.SwitchMenuButton;
import com.cisco.dcbu.sm.client.zm.zoneconfig.DeviceAliasSelector;
import com.cisco.dcbu.sm.client.zm.zoneconfig.FcAliasSelector;
import com.cisco.dcbu.sm.client.zm.zoneconfig.IscsiProxyPortSelector;
import com.cisco.dcbu.sm.client.zm.zoneconfig.IsnsPortSelector;
import com.cisco.dcbu.sm.client.zm.zoneconfig.LunSelector;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneDialogAction;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class MemberAdditionDialog
extends JDialog
implements ActionListener,
ItemListener {
    static final int ALIAS_MEMBER_FORMAT = 100;
    private static final String WARNING_LABEL = "Warning :";
    private static final int FC_TE_PORT = 12;
    private static final int FC_E_PORT = 4;
    private static final int PWWN_RADIO = 0;
    private static final int FCID_RADIO = 1;
    private static final int SWITCH_PORT_INTERFACE_RADIO = 2;
    private static final int SWITCH_PORT_WWN_RADIO = 3;
    private static final int DOMAIN_PORT_RADIO = 4;
    private static final int ISCSI_RADIO = 5;
    private static final int IPADDRESS_PORT_RADIO = 6;
    private static final int ISCSI_PROXY_RADIO = 7;
    private static final int ISNS_RADIO = 8;
    private static final int ALIAS_RADIO = 9;
    private static final int DEVICE_ALIAS_RADIO = 10;
    private static final int NPV_VIRTUAL_PORT_RADIO = 11;
    private static final int DEV_TYPE_VALUE_HOST = 1;
    private static final int DEV_TYPE_VALUE_STORAGE = 2;
    private static final int DEV_TYPE_VALUE_BOTH = 3;
    private static final int DEV_TYPE_DISP_HOST = 0;
    private static final int DEV_TYPE_DISP_STORAGE = 1;
    private static final int DEV_TYPE_DISP_BOTH = 2;
    private static final int SWITCH_LABEL = 1;
    private static final int PORT_LABEL = 3;
    private static final int DEV_TYPE_LABEL = 7;
    private static final String LABEL_NAME = "Port Name:";
    private static final String LABEL_SWITCH_PORT = "Switch Interface:";
    private static final String LABEL_SWITCH_PORT_WWN = "Port WWN:";
    private static final String LABEL_SWITCH_ADD = "Switch Address:";
    private static final String LABEL_SWITCH_DID = "Domain Id:";
    private static final String LABEL_SWITCH_PORT_IP = "IP Address/Mask:";
    private static final String LABEL_ALIAS_NAME = "FC-Alias:";
    private static final String LABEL_DEVICE_ALIAS_NAME = "Device Alias:";
    private static final String LABEL_NPV_NAME = "NPV Virtual Port:";
    private static final String NON_MDS_DID_HELP = "0..255";
    private static final String MDS_DID_HELP = "0..255 or fc1/2-fc1/11,fc2/2-2/12,fc1/15,ext1,bay1";
    private static final String[] NAME_HELP = new String[]{"e.g. 21:21:22:22:22:22:22:22,..", "0x123abc,0xabc123,..", "fc1/2-fc1/11,fc2/2-2/12,fc1/15,ext1,bay1", "e.g. 21:21:22:22:22:22:22:22", "0..255 or fc1/2-fc1/11,fc2/2-2/12,fc1/15,ext1,bay1", "iqn.t1,iqn.t2,..", "10.0.0.1/24,10.1.1.2/16,..,", "e.g. 21:21:22:22:22:22:22:22,...", "isns.entity.mds9000,..", "", "Host-123", "21:21:22:22:22:22:22:22"};
    private static final String SWITCH_IP_HELP = "10.0.0.1";
    private static final String SWITCH_IPV4OR6_HELP = "10.0.0.1/24 or 2aff:::1011:::1111/120";
    private static final String SWITCH_DID_HELP = "0x4a or 1..239";
    private static final String LUN_HELP = "(1-1a,1f, 65, ,21:21:..,22:22:..)";
    private static final String[] DEVICE_TYPES = new String[]{"Host (Initiator)", "Storage (Target)", "Both"};
    private static final String[] _Selector = new String[]{"WWN", "FcId", "Switch & Port", "Switch Port WWN", "Domain & Port", "iSCSI Name", "iSCSI IP Address/Subnet", "iSCSI Proxy", "iSNS Host", "FC-Alias", "deviceAlias", "NPV Virtual Port"};
    private static final String[] _Blabels = new String[]{"Add", "Close"};
    private Vsan _vsan;
    private ZoneDialogAction _action;
    private RadioButtonPanel _select;
    private FieldPanel _useNxPortWWNFPanel;
    private FieldPanel _useLunPanel;
    private FieldPanel _switchPanel;
    private FieldPanel _vsanIndexPanel;
    private FieldPanel _afidPanel;
    private JLabel _status;
    private JLabel[] _labels;
    private JLabel _nameLabelHelp;
    private JLabel _switchLabelHelp;
    private JCheckBox _lunCheckBox;
    private SwitchMenuButton _swMenuBtn;
    private DndTreeNode _parentNode;
    private JButton _portEllipsis;
    private ZonePortChooser _portChooser;
    private Integer[] _selectionMap;
    private String[] _radioSelector;
    private RadioButtonPanel _devTypePnl;
    private boolean _smartZoningEnabled = false;
    private int _selectDevType = -1;

    MemberAdditionDialog(JDialog parent, ZoneDialogAction action, DndTreeNode parentNode) {
        super(parent);
        JComponent[] values;
        String[] labels;
        this.setDefaultCloseOperation(2);
        this._action = action;
        this._vsan = action.getVsan();
        this._parentNode = parentNode;
        this._portEllipsis = new JButton("...");
        this._portEllipsis.setToolTipText("Select End Device");
        this._portEllipsis.setActionCommand("EndPorts");
        this._portEllipsis.setMargin(Util.getNoBorder());
        this._portEllipsis.addActionListener(this);
        this._useNxPortWWNFPanel = new FieldPanel(21, (JComponent)this._portEllipsis);
        this._lunCheckBox = new JCheckBox("LUN(s)");
        this._lunCheckBox.setVisible(action.getZoneCapability().isLunZoningSupported());
        this.buildRadioSelectionMap(action.getZoneCapability(), parentNode);
        this._select = new RadioButtonPanel(this._radioSelector, 2);
        this._select.setSelected(0);
        this._select.addChangeListener(this);
        Object userObj = this._parentNode.getUserObject();
        this._smartZoningEnabled = action.getZoneCapability().isSmartZoningEnabled();
        if (this._vsan != null) {
            labels = new String[]{"Zoned By:", LABEL_SWITCH_ADD, null, LABEL_NAME, null, null, null, "Device Type:"};
            this._labels = DialogUtil.buildLabels(labels);
            values = new JComponent[labels.length];
            values[0] = this._select;
            this._swMenuBtn = new SwitchMenuButton(null);
            this._switchPanel = new FieldPanel(21, (JComponent)this._swMenuBtn);
            values[1] = this._switchPanel;
            this._switchLabelHelp = new JLabel(SWITCH_IP_HELP);
            values[2] = this._switchLabelHelp;
            this._switchLabelHelp.setFont(ChangedCellRenderer.getItalicFont());
            values[1].setVisible(!this._action.getSwitch().isQuail() || this._action.getSwitch().isQuail() && this._action.getZoneCapability().isSwitchPortInterfaceSupported());
            values[2].setVisible(!this._action.getSwitch().isQuail() || this._action.getSwitch().isQuail() && action.getZoneCapability().isSwitchPortInterfaceSupported());
            this._labels[1].setVisible(!this._action.getSwitch().isQuail() || this._action.getSwitch().isQuail() && action.getZoneCapability().isSwitchPortInterfaceSupported());
            values[3] = this._useNxPortWWNFPanel;
            this._nameLabelHelp = new JLabel(NAME_HELP[0]);
            values[4] = this._nameLabelHelp;
            this._nameLabelHelp.setFont(ChangedCellRenderer.getItalicFont());
            this.buidLunControls(values, 5, 6);
            values[5].setVisible(action.getZoneCapability().isLunZoningSupported());
            values[6].setVisible(action.getZoneCapability().isLunZoningSupported());
            MemberAdditionDialog.NAME_HELP[4] = action.getSwitch().isMDSOrQuail() ? MDS_DID_HELP : NON_MDS_DID_HELP;
            MenuButton devBtn = new MenuButton(new JMenu());
            devBtn.buildMenu(DEVICE_TYPES);
            this._devTypePnl = new RadioButtonPanel(DEVICE_TYPES, 4);
            this._devTypePnl.setSelected(2);
            values[7] = this._devTypePnl;
            this._labels[7].setVisible(this._smartZoningEnabled);
            values[7].setVisible(this._smartZoningEnabled);
        } else {
            labels = new String[]{"Zoned By:", "WWN:", "Port VSAN Id:", "AFID:", null, null};
            this._labels = DialogUtil.buildLabels(labels);
            values = new JComponent[labels.length];
            values[0] = this._select;
            values[1] = this._useNxPortWWNFPanel;
            this._vsanIndexPanel = new FieldPanel(15, 1, 1, 4093);
            values[2] = this._vsanIndexPanel;
            this._afidPanel = new FieldPanel(15, 1, 1, 64);
            values[3] = this._afidPanel;
            values[3].setVisible(action.getZoneCapability().isNatAutoTopoAfidSupported());
            this._labels[3].setVisible(action.getZoneCapability().isNatAutoTopoAfidSupported());
            this.buidLunControls(values, 4, 5);
            values[4].setVisible(action.getZoneCapability().isLunZoningSupported());
            values[5].setVisible(action.getZoneCapability().isLunZoningSupported());
        }
        JComponent[] comp = new JComponent[this._labels.length];
        System.arraycopy(this._labels, 0, comp, 0, this._labels.length);
        comp[this._labels.length - 3] = this._lunCheckBox;
        JPanel mainPanel = DialogUtil.buildPanel(comp, values);
        JButton[] buttons = DialogUtil.buildButtons(_Blabels, (ActionListener)this);
        buttons[0].setDefaultCapable(true);
        this._status = new JLabel("");
        JPanel lowerPnl = DialogUtil.buildStatusPanel(buttons, this._status);
        this.updateRadioSelection();
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)mainPanel, lowerPnl);
        this.setResizable(true);
        this.setSize(this.getWidth() + 15, this.getHeight() + 25);
        this.setTitle("Add Member to " + parentNode.getUserObject() + ClientController.getInstance().getDialogFabricTitlePostfix());
    }

    private void buildRadioSelectionMap(ZoneCapability cap, DndTreeNode parentNode) {
        ArrayList<String> selRadio = new ArrayList<String>();
        selRadio.add(_Selector[0]);
        ArrayList<Integer> radioMap = new ArrayList<Integer>();
        radioMap.add(new Integer(0));
        for (int i = 1; i < _Selector.length; ++i) {
            boolean addItem = false;
            switch (i) {
                case 1: {
                    if (!cap.isFcidSupported()) break;
                    addItem = true;
                    break;
                }
                case 2: {
                    if (!cap.isSwitchPortInterfaceSupported()) break;
                    addItem = true;
                    break;
                }
                case 3: {
                    if (!cap.isSwitchPortWWNSupported()) break;
                    addItem = true;
                    break;
                }
                case 4: {
                    if (!cap.isBrcdDIDSupported()) break;
                    addItem = true;
                    break;
                }
                case 5: {
                    if (!cap.isIscsiSupported()) break;
                    addItem = true;
                    break;
                }
                case 6: {
                    if (!cap.isMdsDIDOrIscsiSubnetSupported()) break;
                    addItem = true;
                    break;
                }
                case 7: {
                    if (!cap.isIscsiSupported()) break;
                    addItem = true;
                    break;
                }
                case 8: {
                    if (!cap.isIscsiSupported()) break;
                    addItem = true;
                    break;
                }
                case 10: {
                    if (!cap.isDeviceAliasZoneSupported() || !this._action.isEnhancedDeviceAliaseEnabled()) break;
                    addItem = true;
                    break;
                }
                case 9: {
                    if (this._vsan == null || parentNode.getUserObject() instanceof ZoneAlias) break;
                    addItem = true;
                    break;
                }
                case 11: {
                    if (this._vsan == null) break;
                    addItem = true;
                }
            }
            if (!addItem) continue;
            selRadio.add(_Selector[i]);
            radioMap.add(new Integer(i));
        }
        this._radioSelector = selRadio.toArray(new String[selRadio.size()]);
        this._selectionMap = radioMap.toArray(new Integer[selRadio.size()]);
    }

    private void buidLunControls(JComponent[] values, int lunIndex, int lunHelpIndex) {
        JButton lunEllipsis = new JButton("...");
        lunEllipsis.setToolTipText("Select Luns");
        lunEllipsis.setActionCommand("MoreLuns");
        lunEllipsis.setMargin(Util.getNoBorder());
        lunEllipsis.addActionListener(this);
        this._useLunPanel = new FieldPanel(21, (JComponent)lunEllipsis);
        this._lunCheckBox.setActionCommand("L");
        this._lunCheckBox.addActionListener(this);
        values[lunIndex] = this._useLunPanel;
        JLabel lunHelp = new JLabel(LUN_HELP);
        lunHelp.setFont(ChangedCellRenderer.getItalicFont());
        values[lunHelpIndex] = lunHelp;
    }

    private void populateSwitchMenuBtn() {
        if (this._vsan == null) {
            return;
        }
        this._switchPanel.setText("");
        if (this.getSelectedRadioFormatId(this._select.getSelected()) == 2 || this.getSelectedRadioFormatId(this._select.getSelected()) == 3) {
            Object[] sw = this._vsan.getFabric().getSwitches();
            Arrays.sort(sw);
            ArrayList<Object> switches = new ArrayList<Object>();
            for (int i = 0; i < sw.length; ++i) {
                if (!((AbstractSwitch)sw[i]).isMDS() && !((AbstractSwitch)sw[i]).isQuail() || !((Switch)sw[i]).isManageable()) continue;
                switches.add(sw[i]);
            }
            Collections.sort(switches);
            this._swMenuBtn.buildMenu(switches.toArray(), false, null, this);
        } else if (this.getSelectedRadioFormatId(this._select.getSelected()) == 4) {
            Switch[] sw = this._vsan.getFabric().getSwitches();
            ArrayList<Switch> swList = new ArrayList<Switch>();
            boolean quailSw = this._action.getSwitch().isQuail();
            for (int i = 0; i < sw.length; ++i) {
                if ((!quailSw || sw[i].isMDS()) && (quailSw || sw[i].isQuail() || !sw[i].isMemberOfVsan(this._vsan))) continue;
                swList.add(sw[i]);
            }
            Collections.sort(swList);
            this._swMenuBtn.buildMenu(swList.toArray(), true, this._vsan, this);
        } else if (this.getSelectedRadioFormatId(this._select.getSelected()) == 11) {
            Switch[] sw = this._vsan.getFabric().getSwitches();
            ArrayList<Switch> swList = new ArrayList<Switch>();
            boolean quailSw = this._action.getSwitch().isQuail();
            for (int i = 0; i < sw.length; ++i) {
                if (!sw[i].isNpvEnabled() || !sw[i].isMemberOfVsan(this._vsan)) continue;
                swList.add(sw[i]);
            }
            Collections.sort(swList);
            this._swMenuBtn.buildMenu(swList.toArray(), false, this._vsan, this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block27: {
            try {
                char cmd = e.getActionCommand().charAt(0);
                switch (cmd) {
                    case 'C': {
                        this.dispose();
                        break;
                    }
                    case 'M': {
                        this.setLun();
                        break;
                    }
                    case 'E': {
                        if (this._vsan != null && this.getSelectedRadioFormatId(this._select.getSelected()) == 7) {
                            IscsiProxyPortSelector iProxy = new IscsiProxyPortSelector(this, this._action.getIscsiProxyData(), this._action.getSwitch());
                            iProxy.setVisible(true);
                            this.setPortName(iProxy.getSelectedIscsiProxy(), null);
                            break;
                        }
                        if (this._vsan != null && this.getSelectedRadioFormatId(this._select.getSelected()) == 8) {
                            IsnsPortSelector iSns = new IsnsPortSelector(this, this._action.getIsnsData());
                            iSns.setVisible(true);
                            this.setPortName(iSns.getSelectedIsnsHosts(), null);
                            break;
                        }
                        if (this.getSelectedRadioFormatId(this._select.getSelected()) == 10) {
                            DeviceAlias[] availDevAliases = ClientController.getInstance().getFabric().getDeviceAliases();
                            if (availDevAliases == null || availDevAliases.length <= 0) {
                                throw new SnmpException("Warning :No Device Aliases are available for " + ClientController.getInstance().getFabric() + ".");
                            }
                            DeviceAliasSelector dlg = new DeviceAliasSelector((JFrame)SwingUtilities.windowForComponent(this.getParent()), ClientController.getInstance().getFabric().getDeviceAliases(), this._vsan);
                            dlg.setVisible(true);
                            this.setPortName(dlg.getSelectedAliases(), dlg.getSelectedAliasVsan());
                            this.setDeviceType(dlg.getSelectedType());
                            break;
                        }
                        if (this._vsan != null && this.getSelectedRadioFormatId(this._select.getSelected()) == 9) {
                            FcAliasSelector dlg = new FcAliasSelector(this, this._vsan, this._action.getDetailedAliases());
                            if (dlg.getAvailableAliases() <= 0) {
                                throw new SnmpException("Warning :No Aliases are available for VSAN " + this._vsan + ".");
                            }
                            dlg.setVisible(true);
                            this.setPortName(dlg.getSelectedAliases(), null);
                            break;
                        }
                        if (this._vsan != null && (this.getSelectedRadioFormatId(this._select.getSelected()) == 2 || this.getSelectedRadioFormatId(this._select.getSelected()) == 4 || this.getSelectedRadioFormatId(this._select.getSelected()) == 3) || this.getSelectedRadioFormatId(this._select.getSelected()) == 11) {
                            int selRadioFormat;
                            Switch sw = this.getSelectedSwitch(-1);
                            if (!sw.isMDS() && !sw.isQuail()) {
                                Util.errorMessage((Component)this, "The port information is not available for " + sw + ".");
                                return;
                            }
                            if (this._portChooser != null) {
                                this._portChooser.dispose();
                            }
                            int showFormat = (selRadioFormat = this.getSelectedRadioFormatId(this._select.getSelected())) == 3 ? 1 : (selRadioFormat == 11 ? 3 : 2);
                            this._portChooser = new ZonePortChooser(this, sw, showFormat);
                            this._portChooser.setTitle(this.getTitle());
                            ClientController.getInstance();
                            Switch sww = ClientController.findFabricSwitchByIpAddress(sw.getPeer().getAddress());
                            if (sww != null) {
                                this._portChooser.setIfIndexIf(sww);
                            }
                            if (sw.isN5K() && this.getSelectedRadioFormatId(this._select.getSelected()) == 3) {
                                this._portChooser.setType(3);
                                this._portChooser.setIsFICON(false, sw.getPeer());
                                this._portChooser.setLogicalInterfaceType(15);
                            } else {
                                this._portChooser.setType(3);
                                this._portChooser.setIsFICON(false, sw.getPeer());
                                this._portChooser.setLogicalInterfaceType(7);
                            }
                            this._portChooser.setFilters(new PortEditorFilter(new int[]{1}));
                            this.updatePortPicker(sw.getPeer(), this._portChooser);
                            this._portChooser.showPortDialog((JComponent)e.getSource());
                            break;
                        }
                        if (this._vsan != null && this._vsan.getEndPorts(null).size() == 0) {
                            throw new SnmpException("Warning :No end device ports are available for VSAN " + this._vsan + ".");
                        }
                        EndPortSelector end = new EndPortSelector((JFrame)SwingUtilities.windowForComponent(this.getParent()), this._vsan, this._action.getPwwnZonedPorts(), this._vsan != null && this.getSelectedRadioFormatId(this._select.getSelected()) == 5, this._action.getZoneCapability().isNatAutoTopoAfidSupported() ? this._action.getAfidMap() : null);
                        end.setVisible(true);
                        this.setPortName(end.getSelectedEndPort(), end.getSelectedEndPortVsanId());
                        this.setDeviceType(end.getSelectedEndPort());
                        break;
                    }
                    case 'L': {
                        this._useLunPanel.setEnabled(this._lunCheckBox.isSelected());
                        break;
                    }
                    case 'A': {
                        this._status.setText(" ");
                        if (this._vsan != null && (this.getSelectedRadioFormatId(this._select.getSelected()) == 10 || this.getSelectedRadioFormatId(this._select.getSelected()) == 0 || this.getSelectedRadioFormatId(this._select.getSelected()) == 1)) {
                            this._selectDevType = this._devTypePnl.getSelected() + 1;
                        }
                        this.addMembers();
                        break;
                    }
                    case 'S': {
                        Switch sw = (Switch)e.getSource();
                        if (sw == null) break;
                        this._portEllipsis.setEnabled(sw.isMDS() || sw.isQuail());
                    }
                }
            }
            catch (Exception ex) {
                if (ex.getMessage() == null && SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)"Exception Caught", (Throwable)ex);
                    return;
                }
                int warning = ex.getMessage().indexOf(WARNING_LABEL);
                if (warning == -1) {
                    Util.errorMessage((Component)this, ex);
                } else {
                    Util.errorMessage((Component)this, ex.getMessage().substring(warning + WARNING_LABEL.length()));
                }
                if (!SnmpSession.isTrace()) break block27;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.updateRadioSelection();
        }
    }

    private void updateRadioSelection() {
        boolean isDevType;
        boolean isLunAvailable = this._action.getZoneCapability().isLunZoningSupported();
        isLunAvailable = isLunAvailable && (this.getSelectedRadioFormatId(this._select.getSelected()) == 0 || this.getSelectedRadioFormatId(this._select.getSelected()) == 1 || this.getSelectedRadioFormatId(this._select.getSelected()) == 10);
        boolean isPortMember = this.getSelectedRadioFormatId(this._select.getSelected()) == 2 || this.getSelectedRadioFormatId(this._select.getSelected()) == 4 || this.getSelectedRadioFormatId(this._select.getSelected()) == 3 || this.getSelectedRadioFormatId(this._select.getSelected()) == 11;
        boolean bl = isDevType = this.getSelectedRadioFormatId(this._select.getSelected()) == 0 || this.getSelectedRadioFormatId(this._select.getSelected()) == 1 || this.getSelectedRadioFormatId(this._select.getSelected()) == 10;
        if (this._vsan != null) {
            this._devTypePnl.setEnabled(isDevType);
            this._labels[7].setEnabled(isDevType);
            this._labels[1].setEnabled(isPortMember);
            this._switchPanel.setEnabled(isPortMember);
            this._switchPanel.getComponent1().setEnabled(isPortMember && this._select.getSelected() == 4);
            this._labels[3].setText(isPortMember ? (this.getSelectedRadioFormatId(this._select.getSelected()) == 3 ? LABEL_SWITCH_PORT_WWN : LABEL_SWITCH_PORT) : LABEL_NAME);
            this._labels[1].setText(this.getSelectedRadioFormatId(this._select.getSelected()) == 4 ? LABEL_SWITCH_DID : LABEL_SWITCH_ADD);
            if (this._labels[this._labels.length - 2] != null) {
                this._labels[this._labels.length - 2].setEnabled(isLunAvailable);
            }
            this._portEllipsis.setVisible(this.getSelectedRadioFormatId(this._select.getSelected()) != 6);
            if (this.getSelectedRadioFormatId(this._select.getSelected()) == 6) {
                this._labels[3].setText(LABEL_SWITCH_PORT_IP);
                this._labels[1].setEnabled(false);
                this._switchPanel.setEnabled(false);
                this._swMenuBtn.setEnabled(false);
            } else if (this.getSelectedRadioFormatId(this._select.getSelected()) == 9) {
                this._labels[3].setText(LABEL_ALIAS_NAME);
            } else if (this.getSelectedRadioFormatId(this._select.getSelected()) == 10) {
                this._labels[3].setText(LABEL_DEVICE_ALIAS_NAME);
            } else if (this.getSelectedRadioFormatId(this._select.getSelected()) == 11) {
                this._labels[3].setText(LABEL_NPV_NAME);
            }
            this._switchLabelHelp.setText(this.getSelectedRadioFormatId(this._select.getSelected()) == 4 ? SWITCH_DID_HELP : SWITCH_IP_HELP);
            this._nameLabelHelp.setText(NAME_HELP[this.getSelectedRadioFormatId(this._select.getSelected())]);
            if (this.getSelectedRadioFormatId(this._select.getSelected()) == 6) {
                this._nameLabelHelp.setText(this._action.getZoneCapability().isIPv6ZoneMemberSupported() ? SWITCH_IPV4OR6_HELP : NAME_HELP[this.getSelectedRadioFormatId(this._select.getSelected())]);
            }
            this.populateSwitchMenuBtn();
            this._useNxPortWWNFPanel.setText("");
            this._useLunPanel.setText("");
            this._switchPanel.setText("");
            this._devTypePnl.setSelected(2);
        } else {
            this._labels[1].setText(this.getSelectedRadioFormatId(this._select.getSelected()) == 10 ? LABEL_DEVICE_ALIAS_NAME : LABEL_NAME);
        }
        this._lunCheckBox.setEnabled(isLunAvailable);
        this._useLunPanel.setEnabled(isLunAvailable && this._lunCheckBox.isSelected());
        this._lunCheckBox.setSelected(false);
        this._useLunPanel.setText("");
    }

    private void setPortName(Object[] port, int[] vsanIds) {
        if (port == null || port.length == 0) {
            return;
        }
        String text = "";
        for (int k = 0; k < port.length; ++k) {
            if (k > 0) {
                text = text + ", ";
            }
            if (this.getSelectedRadioFormatId(this._select.getSelected()) == 10) {
                text = text + ((DeviceAlias)port[k]).getAlias();
                if (this._vsan != null || vsanIds == null) continue;
                this._vsanIndexPanel.setText(Integer.toString(vsanIds[k]));
                continue;
            }
            if (this._vsan == null) {
                text = text + SnmpString.toHexString(((EndPort)port[k]).getPortWwn().getValue());
                if (k == 0) {
                    this._vsanIndexPanel.setText(Integer.toString(vsanIds[k]));
                }
                if (!this._action.getZoneCapability().isNatAutoTopoAfidSupported()) continue;
                this._afidPanel.setText(Integer.toString(SmZoneData.getAfidForIvr(this._action.getAfidMap(), vsanIds[k], (EndPort)port[k])));
                continue;
            }
            if (this.getSelectedRadioFormatId(this._select.getSelected()) == 7) {
                IscsiProxy ip = (IscsiProxy)port[k];
                text = text + SnmpString.toHexString(ip._pWWN);
                continue;
            }
            if (this.getSelectedRadioFormatId(this._select.getSelected()) == 9) {
                text = text + ((ZoneAlias)port[k]).getZoneName();
                continue;
            }
            if (this.getSelectedRadioFormatId(this._select.getSelected()) == 8) {
                text = text + port[k];
                continue;
            }
            EndPort ep = (EndPort)port[k];
            if (this.getSelectedRadioFormatId(this._select.getSelected()) == 0) {
                text = text + SnmpString.toHexString(ep.getPortWwn().getValue());
                continue;
            }
            if (this.getSelectedRadioFormatId(this._select.getSelected()) == 1) {
                text = text + ep.getFcIdAsString(ep.getFcIdNum(this._vsan.getVsanId()));
                continue;
            }
            if (this.getSelectedRadioFormatId(this._select.getSelected()) != 5) continue;
            if (ep.isISCSI()) {
                text = text + ep.getSymNodeName();
                continue;
            }
            JOptionPane.showMessageDialog(this, "The selected end device port " + port[k] + " is not iSCSI type.", "Wrong port type", 0);
            return;
        }
        this._useNxPortWWNFPanel.setText(text);
    }

    private void setDeviceType(Object[] port) {
        EndPort ep;
        if (this._vsan == null || port == null || port.length == 0) {
            return;
        }
        if (!(port[0] instanceof Zone) && !(port[0] instanceof EndPort)) {
            return;
        }
        if (port.length > 1) {
            DefaultLogger._DefLogger.warn((Object)"Zone member dialog should not select more than 1 port");
        }
        if (!this._smartZoningEnabled) {
            this._selectDevType = 3;
        } else if (this.getSelectedRadioFormatId(this._select.getSelected()) == 10) {
            EndPort ep2 = ((DeviceAlias)port[0]).getEndPort();
            if (ep2 != null) {
                this._selectDevType = ep2.isTarget() ? 2 : 1;
            }
        } else if (this.getSelectedRadioFormatId(this._select.getSelected()) == 1) {
            EndPort ep3 = (EndPort)port[0];
            if (ep3 != null) {
                this._selectDevType = ep3.isTarget() ? 2 : 1;
            }
        } else if (this.getSelectedRadioFormatId(this._select.getSelected()) == 0 && (ep = (EndPort)port[0]) != null) {
            this._selectDevType = ep.isTarget() ? 2 : 1;
        }
        this._devTypePnl.setSelected(this._selectDevType - 1);
    }

    private void setDeviceType(int[] type) {
        if (this._devTypePnl != null) {
            this._devTypePnl.setSelected(type[0] - 1);
        }
    }

    private EndPort findEndPort() {
        EndPort port = null;
        try {
            boolean hasColon;
            String wwnData = this._useNxPortWWNFPanel.getText().trim();
            boolean bl = hasColon = wwnData.indexOf(":") != -1;
            if (this.getSelectedRadioFormatId(this._select.getSelected()) == 10) {
                DeviceAlias da = ClientController.getInstance().getFabric().findDeviceAliasByName(wwnData);
                if (da != null) {
                    port = da.getEndPortFromCache();
                }
            } else if (this._vsan == null) {
                ClientController.getInstance();
                port = ClientController.findFabricEndPortByWwn(new Wwn(wwnData, hasColon));
            } else if (this.getSelectedRadioFormatId(this._select.getSelected()) == 0) {
                port = this._vsan.getFabric().findEndPortByWwn(new Wwn(wwnData, hasColon), this._vsan);
            } else if (this.getSelectedRadioFormatId(this._select.getSelected()) == 1) {
                port = this._vsan.getFabric().findEndPortByVsanFcId((int)this._vsan.getId(), this.extract3ByteId(wwnData));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    private byte[] extract3ByteId(String fcidPort) throws SnmpException {
        int value = 0;
        if (fcidPort.charAt(1) == 'x' || fcidPort.charAt(1) == 'X') {
            if (fcidPort.length() != 8) {
                throw new SnmpException("The fcid must be 3 bytes long (" + fcidPort + ").");
            }
            try {
                value = Integer.parseInt(fcidPort.substring(2), 16);
            }
            catch (NumberFormatException ex) {
                if (fcidPort.length() > 0) {
                    throw new SnmpException("Please type a valid port (" + fcidPort + ").");
                }
                throw new SnmpException("Please type a valid port (" + fcidPort + ").");
            }
        } else {
            if (fcidPort.length() != 6) {
                throw new SnmpException("The fcid must be 3 bytes long (" + fcidPort + ").");
            }
            value = Integer.parseInt(fcidPort, 16);
        }
        byte[] fcid = new byte[3];
        fcid[2] = (byte)(value & 0xFF);
        fcid[1] = (byte)(value >> 8 & 0xFF);
        fcid[0] = (byte)(value >> 16 & 0xFF);
        return fcid;
    }

    private void setLun() throws SnmpException {
        EndPort port = this.findEndPort();
        if (port != null) {
            if (!this._action.getZoneCapability().isOsBasedLunDiscoverySupported()) {
                Util.errorMessage((Component)this, "OS based lun discovery is supported\nfor switch software version " + (this._vsan != null ? "1.3" : "2.1 (IVR) ") + " or higher.");
                return;
            }
            LunSelector lun = new LunSelector(this, port, SmZoneUtil.getSwitchPeer(this._action.getSwitch()), this._vsan);
            lun.setVisible(true);
            this._useLunPanel.setText(lun.getSelLuns());
        } else {
            String[] ports = StringUtil.tokenize(this._useNxPortWWNFPanel.getText(), ",");
            String message = "Please specify storage device end port.";
            message = ports.length > 1 ? "Please specify a single storage device end port for LUN zoning." : "The fabric does not contain selected end device port.\n(" + this._useNxPortWWNFPanel.getText().trim() + ")";
            Util.errorMessage((Component)this, message);
        }
    }

    private ArrayList getMembers(int format) throws Exception {
        ArrayList<byte[]> members = new ArrayList<byte[]>();
        String[] ids = StringUtil.tokenize(this._useNxPortWWNFPanel.getText().trim(), ",");
        byte[] data = null;
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                data = null;
                switch (format) {
                    case 1: {
                        data = SnmpWWN.parse(ids[i].trim(), true);
                        if (data != null && data.length == 8) break;
                        throw new SnmpException("Invalid pWWN " + ids[i] + ".");
                    }
                    case 3: {
                        data = this.extract3ByteId(ids[i].trim());
                        break;
                    }
                    case 5: {
                        data = ids[i].trim().getBytes();
                        if (data != null && data.length != 0) break;
                        throw new SnmpException("Invalid iSCSI name " + ids[i] + ".");
                    }
                    case 8: 
                    case 9: {
                        byte[] add = null;
                        byte[] mask = null;
                        try {
                            String maskStr;
                            int maskIndex = ids[i].indexOf(47);
                            String ipAddStr = maskIndex != -1 ? ids[i].substring(0, maskIndex) : ids[i];
                            String string = maskStr = maskIndex != -1 ? ids[i].substring(maskIndex + 1) : null;
                            if (maskStr != null && maskStr.trim().length() == 0) {
                                throw new SnmpException("Invalid Mask");
                            }
                            add = new SnmpIpAddress(ipAddStr.trim()).getValue();
                            if (!this._action.getZoneCapability().isIPv6ZoneMemberSupported() && add.length == 16) {
                                throw new SnmpException("Invalid IP Address");
                            }
                            data = new byte[add.length + (maskStr != null ? 4 : 0)];
                            if (maskStr != null) {
                                int maskPrefix = Integer.parseInt(maskStr.trim());
                                byte[] byArray = mask = add.length == 16 ? SnmpIntList.valueOf(new int[]{maskPrefix}) : SnmpIpAddress.getMaskFromPrefix(maskPrefix, false);
                                if (mask == null) {
                                    throw new SnmpException("Invalid Mask");
                                }
                                System.arraycopy(mask, 0, data, add.length, mask.length);
                            }
                            System.arraycopy(add, 0, data, 0, add.length);
                            break;
                        }
                        catch (SnmpException ex) {
                            throw new SnmpException("Invalid IP address or mask " + ids[i] + " " + (mask == null ? this._switchPanel.getText() : ""));
                        }
                    }
                    case 100: {
                        if (this._action.getZoneAlias(ids[i].trim()) == null) {
                            throw new SnmpException("Zone Alias " + ids[i] + " does not exist.");
                        }
                        data = ids[i].trim().getBytes();
                        break;
                    }
                    case 10: {
                        data = ids[i].trim().getBytes();
                    }
                }
                if (data == null) continue;
                members.add(data);
            }
        }
        return members;
    }

    private boolean confirmSubnetAddition(ArrayList members) {
        if (members != null && members.size() > 0) {
            byte[] mem = (byte[])members.get(0);
            byte[][] addMsk = ZoneMemberFormat.getIpAddressMask(mem);
            byte[] subnet = ZoneMemberFormat.getSubnet(addMsk);
            byte[] mask = addMsk[1];
            if (mask != null && mask.length > 0) {
                String msg = "Do you want to add subnet " + SnmpIpAddress.toString(subnet) + " to zone " + this._parentNode.getUserObject() + "?\n" + "All hosts in this subnet will be members of selected zone.";
                return JOptionPane.showConfirmDialog(this, msg, "Zone Subnet", 0, 3) == 0;
            }
        }
        return true;
    }

    private int getZoneMemberFormat() {
        switch (this.getSelectedRadioFormatId(this._select.getSelected())) {
            case 0: 
            case 7: 
            case 11: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 5: 
            case 8: {
                return 5;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 4;
            }
            case 4: {
                int format = 7;
                try {
                    Switch sw = this.getSelectedSwitch(-1);
                    int[] ifIndices = SnmpIntList.parse(this._useNxPortWWNFPanel.getText().trim(), sw);
                }
                catch (SnmpException er) {
                    format = 2;
                }
                return format;
            }
            case 6: {
                try {
                    String[] ids = StringUtil.tokenize(this._useNxPortWWNFPanel.getText().trim(), ",");
                    int maskIndex = ids[0].indexOf(47);
                    byte[] add = new SnmpIpAddress(maskIndex != -1 ? ids[0].substring(0, maskIndex) : ids[0]).getValue();
                    if (this._action.getZoneCapability().isIPv6ZoneMemberSupported() && add.length == 16) {
                        return 9;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return 8;
            }
            case 9: {
                return 100;
            }
            case 10: {
                return 10;
            }
        }
        return 0;
    }

    private void addMembers() throws SnmpException {
        byte[] memId = null;
        ArrayList members = new ArrayList();
        ArrayList lunList = null;
        int format = 0;
        int ivrVsanId = -1;
        try {
            if (this._vsan == null) {
                ivrVsanId = this._vsanIndexPanel.getInt();
            }
            switch (this.getSelectedRadioFormatId(this._select.getSelected())) {
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    format = this.getZoneMemberFormat();
                    members = this.getMembers(format);
                    if (this.getSelectedRadioFormatId(this._select.getSelected()) != 6 || this.confirmSubnetAddition(members)) break;
                    return;
                }
                case 2: {
                    format = 6;
                    Switch sw = this.getSelectedSwitch(-1);
                    int[] ifIndices = SnmpIntList.parse(this._useNxPortWWNFPanel.getText().trim(), sw);
                    if (!this.validateSwitchPort(sw, ifIndices)) {
                        return;
                    }
                    for (int ifIn = 0; ifIn < ifIndices.length; ++ifIn) {
                        memId = this.buildSwitchInterfacememberId(format, ifIndices[ifIn], sw);
                        members.add(memId);
                    }
                    break;
                }
                case 3: {
                    format = 4;
                    memId = SnmpWWN.parse(this._useNxPortWWNFPanel.getText().trim(), false);
                    members.add(memId);
                    break;
                }
                case 4: {
                    int[] ifIndices;
                    int didVal = this.getDIDValue();
                    Switch sw = this.getSelectedSwitch(didVal);
                    byte[] port = new byte[4];
                    try {
                        format = 7;
                        ifIndices = SnmpIntList.parse(this._useNxPortWWNFPanel.getText().trim(), sw);
                        for (int ifIn = 0; ifIn < ifIndices.length; ++ifIn) {
                            memId = this.buildSwitchInterfacememberId(format, ifIndices[ifIn], sw);
                            members.add(memId);
                        }
                        break;
                    }
                    catch (Exception er) {
                        format = 2;
                        try {
                            int portNum = Integer.parseInt(this._useNxPortWWNFPanel.getText().trim());
                            if (portNum < 0 || portNum > 255) {
                                throw new SnmpException("The port must be between 0 and 255.");
                            }
                            memId = new byte[]{(byte)(didVal & 0xFF), (byte)(portNum & 0xFF)};
                            members.add(memId);
                            break;
                        }
                        catch (NumberFormatException ex) {
                            if (this._useNxPortWWNFPanel.getText().trim().length() > 0) {
                                throw new SnmpException("Please type a valid port (" + this._useNxPortWWNFPanel.getText().trim() + ").");
                            }
                            throw new SnmpException("Please type a valid port.");
                        }
                    }
                }
            }
        }
        catch (Throwable ex) {
            throw new SnmpException(WARNING_LABEL + ex.getMessage());
        }
        try {
            if (this._lunCheckBox.isSelected()) {
                lunList = LunSelector.getSelectedLuns(this._useLunPanel.getText().trim());
            }
        }
        catch (Throwable ex) {
            throw new SnmpException(WARNING_LABEL + ex.getMessage());
        }
        if (members == null || members.size() == 0) {
            throw new SnmpException("Please enter a valid zone member.");
        }
        int afId = 1;
        if (this._action.getZoneCapability().isNatAutoTopoAfidSupported()) {
            try {
                afId = this._afidPanel.getInt();
            }
            catch (NumberFormatException ex) {
                throw new SnmpException("Invalid AFID " + this._afidPanel.getField().getText() + ".");
            }
        }
        for (int k = 0; k < members.size(); ++k) {
            this._action.addPreconfiguredZoneMembers(this._parentNode, format, (byte[])members.get(k), lunList, ivrVsanId, afId, this._selectDevType);
        }
        this._status.setText("Success.");
    }

    private byte[] buildSwitchInterfacememberId(int format, int ifIndex, Switch sw) throws SnmpException {
        byte[] memId = null;
        byte[] ifBytes = null;
        ifBytes = SnmpIntList.valueOf(new int[]{ifIndex});
        if (format == 6) {
            memId = new byte[12];
            System.arraycopy(ifBytes, 0, memId, 0, ifBytes.length);
            byte[] swWWN = sw.getWwn().getValue();
            System.arraycopy(swWWN, 0, memId, 4, swWWN.length);
        } else if (format == 7) {
            memId = new byte[5];
            System.arraycopy(ifBytes, 0, memId, 1, ifBytes.length);
            memId[0] = (byte)this.getDIDValue();
        }
        return memId;
    }

    private boolean validateSwitchPort(Switch sw, int[] ifIndices) throws Exception {
        StringBuffer buf1 = new StringBuffer();
        SnmpPeer peer = null;
        if (sw != null && sw.getPeer() != null) {
            peer = sw.getPeer();
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
            for (int k = 0; k < ifIndices.length; ++k) {
                int ifIndex = ifIndices[k];
                if (IfIndexUtil.getType(ifIndex) != 1 && IfIndexUtil.getType(ifIndex) != 4) {
                    Util.errorMessage((Component)this, "You must select a FC interface.");
                    return false;
                }
                if (IfIndexUtil.getType(ifIndex) != 4 || sw.isVersionGreaterThanEqual("4.1(1)")) continue;
                Util.errorMessage((Component)this, "Port Channel port zone member is supported for switch version 4.1(2) and above.");
                return false;
            }
            if (sw.isQuail()) {
                return true;
            }
            ArrayList resp = CommandHandler.getInterFaceVsanAndOperMode(peer, ifIndices);
            if (resp != null) {
                StringBuffer bufNotAcc = new StringBuffer();
                int bufNotAccCount = 60;
                StringBuffer bufNotInVsan = new StringBuffer();
                int bufNotInVsanAccCount = 60;
                StringBuffer bufIsl = new StringBuffer();
                int bufIslCount = 60;
                for (int i = 0; i < resp.size(); ++i) {
                    int[] respData = (int[])resp.get(i);
                    String ifName = sw.ifIndexToName(respData[0]);
                    if (respData[1] == -1 || respData[2] == -1) {
                        if (bufNotAcc.length() >= bufNotAccCount) {
                            bufNotAcc.append("\n");
                            bufNotAccCount *= 2;
                        }
                        bufNotAcc.append((bufNotAcc.length() > 0 ? " ," : "") + ifName);
                        continue;
                    }
                    if (respData[1] != this._vsan.getId()) {
                        if (bufNotInVsan.length() >= bufNotInVsanAccCount) {
                            bufNotInVsan.append("\n");
                            bufNotInVsanAccCount *= 2;
                        }
                        bufNotInVsan.append((bufNotInVsan.length() > 0 ? " ," : "") + ifName);
                        continue;
                    }
                    if (respData[2] != 12 && respData[2] != 4) continue;
                    if (bufIsl.length() >= bufIslCount) {
                        bufIsl.append("\n");
                        bufIslCount *= 2;
                    }
                    bufIsl.append((bufIsl.length() > 0 ? " ," : "") + ifName);
                }
                if (bufIsl.length() > 0) {
                    buf1.append("ISL interface(s):" + bufIsl.toString() + ".\n");
                }
                if (bufNotInVsan.length() > 0) {
                    buf1.append(bufNotInVsan.toString() + "\n  Interface(s) not in VSAN " + this._vsan.getName() + ".\n");
                }
                if (bufNotAcc.length() > 0) {
                    buf1.append(bufNotAcc.toString() + "\n  Interface(s) not accessible.");
                }
            }
        } else if (this.getSelectedRadioFormatId(this._select.getSelected()) == 4) {
            buf1.append("Switch with domain Id " + this._switchPanel.getText().trim() + " is not reachable.");
        } else {
            buf1.append(this._switchPanel.getText().trim() + " is not reachable.");
        }
        if (buf1.length() > 0) {
            buf1.append("\nWould you like to add selected switch interface to " + this._parentNode.getUserObject() + "?\n");
            if (JOptionPane.showConfirmDialog(this, buf1, "Switch Interfaces" + ClientController.getInstance().getDialogFabricTitlePostfix(), 0, 2) != 0) {
                return false;
            }
        }
        return true;
    }

    private void updatePortPicker(SnmpPeer peer, PortChooser chooser) {
        PortEditorCardAttribute[] slotMembers = this.findSlotInfo(peer);
        if (slotMembers == null) {
            return;
        }
        ClientController.getInstance();
        Switch sww = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sww != null) {
            chooser.setIfIndexIf(sww);
            chooser.setSlotMembers(slotMembers);
        }
    }

    private PortEditorCardAttribute[] findSlotInfo(SnmpPeer peer) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        Card[] cards = sw.getCards();
        if (cards == null) {
            return null;
        }
        PortEditorCardAttribute[] slotMembers = new PortEditorCardAttribute[sw.getNumSlots()];
        for (int i = 0; i < cards.length; ++i) {
            if (cards[i] == null || cards[i].isFex() || FRUConstants.isInternalModule(cards[i].getType())) continue;
            int nOfPortonCard = cards[i].getNumPorts();
            int[] ifTypes = new int[nOfPortonCard];
            for (int j = 0; j < nOfPortonCard; ++j) {
                ifTypes[j] = cards[i].getIfType(j + 1);
            }
            if (cards[i].getSlotId() - 1 >= slotMembers.length) continue;
            slotMembers[cards[i].getSlotId() - 1] = new PortEditorCardAttribute(cards[i].getType(), nOfPortonCard, ifTypes, 0, Integer.toString(cards[i].getSlotId()));
        }
        return slotMembers;
    }

    private Switch getSelectedSwitch(int didVal) throws SnmpException {
        String switchId = this._switchPanel.getText().trim();
        Switch sw = null;
        if (this.getSelectedRadioFormatId(this._select.getSelected()) == 2 || this.getSelectedRadioFormatId(this._select.getSelected()) == 3 || this.getSelectedRadioFormatId(this._select.getSelected()) == 11) {
            if (switchId.length() == 0) {
                throw new SnmpException("Please enter switch IP Address.");
            }
            InetAddress address = null;
            try {
                address = InetAddress.getByName(this._switchPanel.getText().trim());
            }
            catch (UnknownHostException ex) {
                throw new SnmpException("Could not find switch " + this._switchPanel.getText().trim() + " in fabric.");
            }
            sw = this._vsan.getFabric().findSwitchByIpAddress(address);
        } else if (this.getSelectedRadioFormatId(this._select.getSelected()) == 4) {
            if (didVal == -1) {
                didVal = this.getDIDValue();
            }
            sw = this._vsan.getFabric().findSwitchByVsanDomainId(this._vsan.getId(), didVal);
        }
        if (sw == null) {
            throw new SnmpException("Switch " + this._switchPanel.getText().trim() + " is not present in this Fabric.");
        }
        if (this.getSelectedRadioFormatId(this._select.getSelected()) != 4 && !sw.isMDS() && !sw.isQuail()) {
            throw new SnmpException(this._switchPanel.getText().trim() + " is not a MDS switch.");
        }
        return sw;
    }

    private int getDIDValue() throws SnmpException {
        String switchId = this._switchPanel.getText().trim();
        int didVal = -1;
        if (this.getSelectedRadioFormatId(this._select.getSelected()) == 4) {
            if (switchId.length() == 0) {
                throw new SnmpException("Please enter a valid Domain Id.");
            }
            if (switchId.length() > 1 && switchId.charAt(1) == 'x') {
                if (switchId.length() > 4) {
                    throw new SnmpException("The did must be 1 byte long.");
                }
                switchId = switchId.substring(2);
                didVal = Integer.valueOf(switchId, 16);
            } else {
                if (switchId.length() > 3) {
                    throw new SnmpException("The Domain Id must be between 1 and 239.");
                }
                didVal = Integer.valueOf(switchId);
            }
            if (didVal < 1 || didVal > 239) {
                throw new SnmpException("The Domain Id must be between 1 and 239.");
            }
            return didVal;
        }
        throw new SnmpException("Please enter a valid Domain Id.");
    }

    private int getSelectedRadioFormatId(int sel) {
        if (sel < this._selectionMap.length) {
            return this._selectionMap[sel];
        }
        return this._selectionMap[0];
    }

    class ZonePortChooser
    extends PortChooser
    implements PortChooserIf {
        static final int SHOW_WWN = 1;
        static final int SHOW_NAME = 2;
        static final int SHOW_VIRTUAL_PORT = 3;
        int _showAs;
        Switch _sw;

        public ZonePortChooser(JDialog dlg, Switch sw, int showAs) {
            super(Util.getFrameAncestor(dlg));
            this._showAs = showAs;
            this._sw = sw;
            this.setTarget(this);
        }

        @Override
        public void portChooserCB(String ifName, Object context) {
            try {
                String nameToShow = "";
                switch (this._showAs) {
                    case 3: {
                        VarBindList virtPortList = new VarBindList();
                        virtPortList.add(MibNode.get("cfaIfVirtualWwnPwwn").getOid(), new int[]{0, this._sw.nameToIfIndex(ifName)});
                        try {
                            VarBindList vList = SnmpFetch.get(this._sw.getSnmpPeer(), virtPortList).getVariables();
                            if (vList.byteValue(0) != null && vList.byteValue(0).length == 8) {
                                nameToShow = SnmpWWN.toHexString(vList.byteValue(0));
                                break;
                            }
                            Util.errorMessage((Component)this, "No virtual Port WWN is available");
                        }
                        catch (SnmpException ex) {
                            Util.errorMessage((Component)this, ex.getMessage());
                        }
                        break;
                    }
                    case 2: {
                        nameToShow = ifName;
                        break;
                    }
                    case 1: {
                        nameToShow = SnmpWWN.toHexString(this._sw.ifIndex2wwn(this._sw.nameToIfIndex(ifName), this._sw.getWwn().getValue()));
                    }
                }
                MemberAdditionDialog.this._useNxPortWWNFPanel.setText(nameToShow);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

