/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class NewZone
extends JDialog
implements ActionListener {
    static final String IVR_ZN_PREFIX = "IVRZ";
    static final String IVR_ZONE_WARNING = "The zone name begining with 'IVRZ' is used by the system for IVR zones.";
    static final MibEnum[] _qosPriorityEnums = MibNode.get("zoneQosPriority").getEnums();
    private static final String[] _names = new String[]{"Zone Name:"};
    private JLabel[] _labels;
    private JCheckBox _readOnlyChkBox;
    private JCheckBox _qosChkBox;
    private JComboBox _qosPriority;
    private JCheckBox _BroadCastChkBox;
    private FieldPanel _zoneName;
    private JCheckBox _smartZoneChkBox;
    private String _selName;
    private boolean _isIvr;
    private ZoneCapability _capability;

    NewZone(JFrame parent, String defVal, boolean isReadOnly, boolean isIvr, boolean qos, int qosPriority, boolean broadcast, boolean smtzone, ZoneCapability capability, boolean showSmartZone, boolean isClone) {
        super(parent);
        this._capability = capability;
        this.setDefaultCloseOperation(2);
        this._isIvr = isIvr;
        this._labels = DialogUtil.buildLabels(_names);
        this.setTitle("Create " + (isIvr ? "IVR Zone" : "Zone") + ClientController.getInstance().getDialogFabricTitlePostfix());
        JComponent[] values = new JComponent[this._labels.length];
        this._zoneName = new FieldPanel(20);
        values[0] = this._zoneName;
        this._zoneName.setText(defVal);
        this._zoneName.getField().setSelectionStart(0);
        this._zoneName.getField().setSelectionEnd(this._zoneName.getText().length());
        this._readOnlyChkBox = new JCheckBox("Read Only");
        this._readOnlyChkBox.setSelected(isReadOnly);
        this._qosChkBox = new JCheckBox("Permit QoS Traffic with Priority: ");
        this._qosChkBox.setSelected(qos);
        this._qosChkBox.setActionCommand("QOS");
        this._qosChkBox.addActionListener(this);
        this._qosPriority = new JComboBox<MibEnum>(_qosPriorityEnums);
        if (this._capability.isQosSupported() && qosPriority > 0 && qosPriority - 1 < this._qosPriority.getItemCount()) {
            this._qosPriority.setSelectedIndex(qosPriority - 1);
        }
        this._qosPriority.setEnabled(qos);
        this._BroadCastChkBox = new JCheckBox("Restrict Broadcast Frames to Zone Members");
        this._readOnlyChkBox.setVisible(this._capability.isROSupported());
        this._qosChkBox.setVisible(this._capability.isQosSupported());
        this._qosPriority.setVisible(this._capability.isQosSupported());
        this._BroadCastChkBox.setVisible(this._capability.isBroadcastSupported());
        this._BroadCastChkBox.setSelected(broadcast);
        this._smartZoneChkBox = new JCheckBox("Smart Zoning");
        this._smartZoneChkBox.setVisible(showSmartZone);
        this._smartZoneChkBox.setSelected(smtzone);
        if (isClone) {
            this._readOnlyChkBox.setEnabled(false);
            this._qosChkBox.setEnabled(false);
            this._qosPriority.setEditable(false);
            this._BroadCastChkBox.setEnabled(false);
            this._smartZoneChkBox.setEnabled(false);
        }
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this._readOnlyChkBox, "North");
        JPanel pnl1 = new JPanel(new BorderLayout());
        pnl1.add((Component)this._qosChkBox, "West");
        JPanel pnl11 = new JPanel(new BorderLayout());
        pnl11.add((Component)this._qosPriority, "West");
        pnl1.add((Component)pnl11, "Center");
        pnl1.add((Component)this._BroadCastChkBox, "South");
        pnl.add((Component)pnl1, "Center");
        JPanel pnl2 = new JPanel(new BorderLayout());
        pnl2.add((Component)new JLabel("   "), "North");
        pnl2.add((Component)this._smartZoneChkBox, "South");
        pnl.add((Component)pnl2, "South");
        JPanel pnl3 = DialogUtil.buildPanel(this._labels, values);
        JPanel mainpnl = new JPanel(new BorderLayout());
        mainpnl.add((Component)pnl3, "North");
        mainpnl.add((Component)pnl, "Center");
        DialogUtil.buildDialog(this, parent, mainpnl);
        this.setModal(true);
        this.setResizable(true);
    }

    NewZone(JFrame parent, String defVal, boolean isReadOnly, boolean isIvr, boolean qos, int qosPriority, boolean broadcast, boolean smtzone, ZoneCapability capability, boolean showSmartZone) {
        this(parent, defVal, isReadOnly, isIvr, qos, qosPriority, broadcast, smtzone, capability, showSmartZone, false);
    }

    String getZoneName() {
        return this._selName;
    }

    boolean isReadOnly() {
        return this._readOnlyChkBox.isSelected();
    }

    boolean isQos() {
        return this._isIvr ? this._qosChkBox.isSelected() && this._qosPriority.getSelectedIndex() > 0 : this._qosChkBox.isSelected();
    }

    int getQosPriority() {
        return this._qosPriority.getSelectedIndex() + 1;
    }

    boolean isBroadCast() {
        return this._BroadCastChkBox.isSelected();
    }

    boolean isSmartZone() {
        return this._smartZoneChkBox.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char cmd = e.getActionCommand().charAt(0);
        if (cmd == 'O') {
            this._selName = this._zoneName.getText().trim();
            if (this._selName.length() == 0) {
                Util.errorMessage((Component)this, "Please type a valid name.");
                return;
            }
            if (!this._isIvr && this._selName.startsWith(IVR_ZN_PREFIX) && JOptionPane.showConfirmDialog((JFrame)SwingUtilities.windowForComponent(this), "The zone name begining with 'IVRZ' is used by the system for IVR zones.\nDo you still want to use the name " + this._selName + "?", this.getTitle(), 0, 2) != 0) {
                return;
            }
            if (this._capability.isQosSupported() && this._qosChkBox.isSelected() && this._qosPriority.getSelectedIndex() == 0) {
                Util.errorMessage((Component)this, "Please Specify QoS Priority.");
                return;
            }
        } else {
            if (cmd == 'Q') {
                this._qosPriority.setEnabled(this._qosChkBox.isSelected());
                return;
            }
            this._selName = null;
        }
        this.dispose();
    }
}

