/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.zm.AbstractZone;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneAlias;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.UITransferHandler;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.tree.DndTree;
import com.cisco.dcbu.lib.ui.tree.DndTreeNode;
import com.cisco.dcbu.sm.client.map.actions.HighlightAction;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.IvrEndPort;
import com.cisco.dcbu.sm.client.zm.common.SmZoneMember;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneControls;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneDialog;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneDialogAction;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneTreeCellRenderer;
import com.jidesoft.tree.FilterableTreeModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class ZoneTree
extends DndTree
implements TreeSelectionListener {
    static final String ZONESETS = "Zonesets";
    static final String ZONES = "Zones";
    static final String ALIASES = "FC-Aliases";
    private DefaultMutableTreeNode _root;
    private ZoneDialogAction _zoneAction;
    private ZoneControls _control;
    private JPopupMenu _popup;

    ZoneTree(DefaultMutableTreeNode tn, ZoneDialogAction action, UITransferHandler dndTransferData, ZoneControls control, ZoneTreeCellRenderer treeRenderer) {
        super((TreeNode)tn, dndTransferData);
        this.setRootVisible(false);
        this._zoneAction = action;
        this._control = control;
        this.getSelectionModel().addTreeSelectionListener(this);
        this._root = tn;
        this.setShowsRootHandles(true);
        this.setCellRenderer(treeRenderer);
        this.setCellEditor(new MyDefaultTreeCellEditor(this, treeRenderer));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TreePath path;
                if ((e.getKeyCode() == 38 || e.getKeyCode() == 37 || e.getKeyCode() == 40 || e.getKeyCode() == 39) && (path = ZoneTree.this.getSelectionPath()) != null) {
                    DndTreeNode node = (DndTreeNode)path.getLastPathComponent();
                    ZoneTree.this._zoneAction.showTreeNodeMembers(node.getUserObject());
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                ZoneTree.this.checkMouseEvent(me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                ZoneTree.this.checkMouseEvent(me);
            }
        });
    }

    void refreshAliases(DefaultTreeModel model, Object[] aliases, int location) {
        if (this._zoneAction.getVsan() != null) {
            DndTreeNode aliasNode = new DndTreeNode(ALIASES, true, 0L);
            model.insertNodeInto(aliasNode, this._root, location);
            for (int i = 0; i < aliases.length; ++i) {
                model.insertNodeInto(new DndTreeNode(aliases[i], true, true, ((AbstractZone)aliases[i]).getLastModifiedAsLong()), aliasNode, i);
            }
        }
    }

    void refresh(Object[] data) {
        this._root.removeAllChildren();
        FilterableTreeModel filterModel = (FilterableTreeModel)this.getModel();
        DefaultTreeModel model = (DefaultTreeModel)filterModel.getActualModel();
        model.reload();
        DndTreeNode zonesetNode = new DndTreeNode(ZONESETS, true, 0L);
        model.insertNodeInto(zonesetNode, this._root, 0);
        ArrayList zoneSetCollection = (ArrayList)data[0];
        DndTreeNode selNode = null;
        for (int i = 0; i < zoneSetCollection.size(); ++i) {
            Object[] obZs = (Object[])zoneSetCollection.get(i);
            ArrayList zoneMembers = (ArrayList)obZs[1];
            long timeStamp = 0L;
            if (obZs[0] instanceof AbstractZone) {
                timeStamp = ((AbstractZone)obZs[0]).getLastModifiedAsLong();
            }
            DndTreeNode node = new DndTreeNode(obZs[0], false, true, timeStamp);
            Vsan vv = this._zoneAction.getVsan();
            if (((ZoneSet)obZs[0]).isActive(vv != null ? vv.getEnforcedZoneSetName() : this._zoneAction.getSwitch().getFabric().getIvrEnforcedZoneSetName(this._zoneAction.getIvrRegionID()))) {
                selNode = node;
            }
            for (int k = 0; k < zoneMembers.size(); ++k) {
                AbstractZone abZn = (AbstractZone)zoneMembers.get(k);
                model.insertNodeInto(new DndTreeNode(abZn, true, true, abZn.getLastModifiedAsLong()), node, k);
            }
            model.insertNodeInto(node, zonesetNode, i);
        }
        model.reload();
        this.expandRow(0);
        if (selNode == null) {
            selNode = zoneSetCollection.size() > 0 ? (DndTreeNode)zonesetNode.getChildAt(0) : zonesetNode;
        }
        this.setEditable(this._zoneAction.getZoneCapability().isZoneRenameupported());
        this.setSelectionPath(new TreePath(model.getPathToRoot(zonesetNode)));
        this._zoneAction.showTreeNodeMembers(ZONESETS);
    }

    void refreshZoneData(Object[] data) {
        this._root.removeAllChildren();
        FilterableTreeModel filterModel = (FilterableTreeModel)this.getModel();
        DefaultTreeModel model = (DefaultTreeModel)filterModel.getActualModel();
        model.reload();
        DndTreeNode zoneNode = new DndTreeNode(ZONES, true, 0L);
        model.insertNodeInto(zoneNode, this._root, 0);
        Object[] zones = (Object[])data[1];
        for (int i = 0; i < zones.length; ++i) {
            model.insertNodeInto(new DndTreeNode(zones[i], true, true, ((AbstractZone)zones[i]).getLastModifiedAsLong()), zoneNode, i);
        }
        model.reload();
        this.expandRow(0);
        this.refreshAliases(model, (Object[])data[2], 1);
        this.setEditable(this._zoneAction.getZoneCapability().isZoneRenameupported());
    }

    private void resetTimeStampForAllChildren(DndTreeNode parent) {
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            DndTreeNode nd = (DndTreeNode)parent.getChildAt(i);
            Object obb = nd.getUserObject();
            if (obb instanceof AbstractZone) {
                nd.setTimeStamp(((AbstractZone)obb).getLastModifiedAsLong());
            }
            if (nd.getChildCount() <= 0) continue;
            this.resetTimeStampForAllChildren(nd);
        }
    }

    private void sortAllChildren(DndTreeNode parent, ArrayList expandPaths) {
        DndTreeNode nd;
        int i;
        FilterableTreeModel filterModel = (FilterableTreeModel)this.getModel();
        DefaultTreeModel model = (DefaultTreeModel)filterModel.getActualModel();
        TreePath path = new TreePath(model.getPathToRoot(parent));
        if (expandPaths != null && !this.isCollapsed(path)) {
            expandPaths.add(path);
        }
        int count = parent.getChildCount();
        ArrayList<DndTreeNode> ndLst = new ArrayList<DndTreeNode>();
        for (i = 0; i < count; ++i) {
            nd = (DndTreeNode)parent.getChildAt(i);
            ndLst.add(nd);
            if (nd.getChildCount() <= 0) continue;
            this.sortAllChildren(nd, expandPaths);
        }
        for (i = 0; i < count; ++i) {
            nd = (DndTreeNode)ndLst.get(i);
            model.removeNodeFromParent(nd);
        }
        Collections.sort(ndLst);
        for (i = 0; i < count; ++i) {
            DndTreeNode ndOld = (DndTreeNode)ndLst.get(i);
            model.insertNodeInto(ndOld, parent, i);
        }
        this.repaint();
    }

    public void resortChildNode(DndTreeNode parent) {
        this.resetTimeStampForAllChildren(parent);
        TreePath[] selPaths = this.getSelectionPaths();
        ArrayList expandPaths = new ArrayList();
        this.sortAllChildren(parent, expandPaths);
        for (int i = 0; i < expandPaths.size(); ++i) {
            this.expandPath((TreePath)expandPaths.get(i));
        }
        if (selPaths != null && selPaths.length > 0) {
            this.setSelectionPaths(selPaths);
        }
    }

    void selectTreePaths(TreePath[] paths) {
        HighlightAction.getInstance().clearHighlight();
        if (paths.length > 1) {
            return;
        }
        TreePath path = paths[0];
        Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        if (userObject instanceof AbstractZone) {
            AbstractZone az = (AbstractZone)userObject;
            if (az.isZone()) {
                Vsan v = this._root.getUserObject() instanceof Vsan ? (Vsan)this._root.getUserObject() : null;
                ZoneDialog.markZoneMembers(v, this._zoneAction.getTranslatedZoneMembers((Zone)az));
            } else if (az.isAlias()) {
                Vsan v = this._root.getUserObject() instanceof Vsan ? (Vsan)this._root.getUserObject() : null;
                ZoneDialog.markZoneMembers(v, this._zoneAction.getTranslatedZoneAliasMembers((ZoneAlias)az));
            }
        } else if (userObject instanceof Vsan) {
            ZoneDialog.markVsan((Vsan)userObject);
        }
    }

    public void checkMouseEvent(MouseEvent e) {
        TreePath menuPath;
        if (e.isPopupTrigger()) {
            TreePath menuPath2 = this.getPathForLocation(e.getX(), e.getY());
            if (menuPath2 != null) {
                boolean rowAlreadySelected = this.isRowSelected(this.getRowForPath(menuPath2));
                if (!rowAlreadySelected) {
                    this.setSelectionPath(menuPath2);
                }
                this.getPopupMenu(menuPath2).show(this, e.getX(), e.getY());
            }
        } else if (e.getID() == 501 && e.getButton() == 1 && (menuPath = this.getPathForLocation(e.getX(), e.getY())) != null) {
            DndTreeNode node = (DndTreeNode)menuPath.getLastPathComponent();
            this._zoneAction.showTreeNodeMembers(node.getUserObject());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null && paths.length > 0) {
            this.selectTreePaths(paths);
        }
    }

    void insertNodes(DndTreeNode parent, AbstractZone[] child) {
        for (int i = 0; i < child.length; ++i) {
            long timeStamp = 0L;
            if (child[i] instanceof AbstractZone) {
                timeStamp = child[i].getLastModifiedAsLong();
            }
            this.insertNode(parent, new DndTreeNode(child[i], child[i].isZone() || child[i].isAlias(), true, timeStamp));
        }
    }

    private void insertNode(DndTreeNode parent, DndTreeNode child) {
        if (parent == null) {
            return;
        }
        FilterableTreeModel filterModel = (FilterableTreeModel)this.getModel();
        DefaultTreeModel model = (DefaultTreeModel)filterModel.getActualModel();
        if (parent.getChildCount() == 0) {
            model.insertNodeInto(child, parent, 0);
        } else {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                DndTreeNode node = (DndTreeNode)parent.getChildAt(i);
                if (node.compareTo(child) < 0) continue;
                model.insertNodeInto(child, parent, i);
                return;
            }
            model.insertNodeInto(child, parent, parent.getChildCount());
        }
        parent.setTimeStamp(child.getTimeStamp());
    }

    DndTreeNode createNode(DndTreeNode parentNode, AbstractZone zs, DndTreeNode nodeToClone) {
        if (zs != null) {
            DndTreeNode newNode = new DndTreeNode(zs, zs.isZone() || zs.isAlias(), true, zs.getLastModifiedAsLong());
            DndTreeNode.setCompareMode(nodeToClone.getCompareMode());
            this.insertNode(parentNode, newNode);
            if (nodeToClone != null && zs.isZoneset()) {
                for (int i = 0; i < nodeToClone.getChildCount(); ++i) {
                    DndTreeNode child = (DndTreeNode)nodeToClone.getChildAt(i);
                    long timeStamp = 0L;
                    if (child.getUserObject() instanceof AbstractZone) {
                        timeStamp = ((AbstractZone)child.getUserObject()).getLastModifiedAsLong();
                    }
                    this.insertNode(newNode, new DndTreeNode(child.getUserObject(), true, true, timeStamp));
                }
            }
            return newNode;
        }
        return null;
    }

    void insertMembers(DndTreeNode parentNode, Object[] az) {
        if (az == null || az.length == 0) {
            return;
        }
        Object parentUserObject = parentNode.getUserObject();
        if (parentUserObject instanceof AbstractZone && ((AbstractZone)parentUserObject).isZoneset()) {
            AbstractZone[] azz = new AbstractZone[az.length];
            System.arraycopy(az, 0, azz, 0, az.length);
            this.insertNodes(parentNode, azz);
        }
        this.repaint();
    }

    void deleteMember(Object[] removedNodes) {
        if (removedNodes != null && removedNodes.length > 0) {
            FilterableTreeModel filterModel = (FilterableTreeModel)this.getModel();
            DefaultTreeModel model = (DefaultTreeModel)filterModel.getActualModel();
            for (int i = 0; i < removedNodes.length; ++i) {
                if (((DefaultMutableTreeNode)removedNodes[i]).getParent() == null) continue;
                model.removeNodeFromParent((DefaultMutableTreeNode)removedNodes[i]);
            }
        }
        this.repaint();
    }

    void deleteMember(Object[] userOb, Object parent) {
        DndTreeNode pNode = this.getTreeNodeForUserObject(parent);
        if (pNode == null) {
            return;
        }
        ArrayList<DndTreeNode> removedNodes = new ArrayList<DndTreeNode>();
        block0: for (int k = 0; k < userOb.length; ++k) {
            for (int j = 0; j < pNode.getChildCount(); ++j) {
                DndTreeNode usrNd = (DndTreeNode)pNode.getChildAt(j);
                if (usrNd.getUserObject() != userOb[k]) continue;
                removedNodes.add(usrNd);
                continue block0;
            }
        }
        this.deleteMember(removedNodes.toArray());
    }

    public ArrayList getzoneLinkNodes(Object[] userOb) {
        ArrayList<DndTreeNode> removedNodes = new ArrayList<DndTreeNode>();
        DndTreeNode zonesetNode = (DndTreeNode)this._root.getChildAt(0);
        for (int i = 0; i < zonesetNode.getChildCount(); ++i) {
            DndTreeNode node = (DndTreeNode)zonesetNode.getChildAt(i);
            for (int j = 0; j < node.getChildCount(); ++j) {
                DndTreeNode linkNode = (DndTreeNode)node.getChildAt(j);
                if (linkNode.getUserObject() != userOb[j]) continue;
                removedNodes.add(linkNode);
            }
        }
        return removedNodes;
    }

    ArrayList getParentTreeNodes(Zone zn) {
        DndTreeNode zonesetNode = (DndTreeNode)this._root.getChildAt(0);
        ArrayList<DndTreeNode> removedNodes = new ArrayList<DndTreeNode>();
        for (int i = 0; i < zonesetNode.getChildCount(); ++i) {
            DndTreeNode node = (DndTreeNode)zonesetNode.getChildAt(i);
            for (int j = 0; j < node.getChildCount(); ++j) {
                DndTreeNode linkNode = (DndTreeNode)node.getChildAt(j);
                if (linkNode.getUserObject() != zn) continue;
                removedNodes.add(linkNode);
            }
        }
        return removedNodes;
    }

    DndTreeNode getTreeNodeForParentUserObject(Object parent) {
        if (parent == ZONESETS || parent instanceof ZoneSet) {
            return (DndTreeNode)this._root.getChildAt(0);
        }
        if (parent == ZONES || parent instanceof Zone) {
            return (DndTreeNode)this._root.getChildAt(0);
        }
        if (parent == ALIASES || parent instanceof ZoneAlias) {
            return (DndTreeNode)this._root.getChildAt(1);
        }
        return null;
    }

    DndTreeNode getTreeNodeForUserObject(Object userObject) {
        if (userObject == null) {
            return null;
        }
        DndTreeNode parentNode = null;
        if (userObject == ZONESETS) {
            return (DndTreeNode)this._root.getChildAt(0);
        }
        if (userObject == ZONES) {
            return (DndTreeNode)this._root.getChildAt(0);
        }
        if (userObject == ALIASES) {
            return (DndTreeNode)this._root.getChildAt(1);
        }
        if (!(userObject instanceof AbstractZone)) {
            return null;
        }
        AbstractZone uZone = (AbstractZone)userObject;
        parentNode = uZone.isZoneset() ? (DndTreeNode)this._root.getChildAt(0) : (uZone.isZone() ? (DndTreeNode)this._root.getChildAt(0) : (DndTreeNode)this._root.getChildAt(1));
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DndTreeNode node = (DndTreeNode)parentNode.getChildAt(i);
            if (!node.getUserObject().equals(uZone)) continue;
            return node;
        }
        return null;
    }

    DndTreeNode getAliasesNode() {
        return this._root.getChildCount() == 2 ? (DndTreeNode)this._root.getChildAt(1) : null;
    }

    @Override
    protected boolean okToDrop(Object[] dragObject, DndTreeNode dropNd) {
        if (super.okToDrop(dragObject, dropNd)) {
            AbstractZone drop = (AbstractZone)dropNd.getUserObject();
            if (dragObject[0] instanceof AbstractZone) {
                AbstractZone drag = (AbstractZone)dragObject[0];
                return (drag.isZoneMember() || drag.isAlias()) && drop.isZone() || drag.isZone() && drop.isZoneset() || drag.isZoneMember() && drop.isAlias();
            }
            return !(!(dragObject[0] instanceof EndPort) && !(dragObject[0] instanceof IvrEndPort) || !drop.isZone() && !drop.isAlias());
        }
        return false;
    }

    @Override
    public void dropAction(DropTargetDropEvent e) {
        try {
            Point p = e.getLocation();
            TreePath path = this.getPathForLocation(p.x, p.y);
            if (null == path) {
                return;
            }
            e.acceptDrop(e.getDropAction());
            DndTreeNode dropNode = (DndTreeNode)path.getLastPathComponent();
            if (!(dropNode.getUserObject() instanceof AbstractZone)) {
                return;
            }
            AbstractZone az = (AbstractZone)dropNode.getUserObject();
            Object[] azDrag = this.getDataTransferObject();
            for (int i = 0; i < azDrag.length; ++i) {
                if (az.isAlias() && azDrag[i] instanceof ZoneAlias) {
                    Util.errorMessage((Component)this, "Cannot add Zone Alias " + azDrag[i] + " to another Zone Alias " + az + ".");
                    return;
                }
                if (az.isAlias() && azDrag[i] instanceof Zone) {
                    Util.errorMessage((Component)this, "Cannot add Zone " + azDrag[i] + " to Zone Alias " + az + ".");
                    return;
                }
                if (az != azDrag[i]) continue;
                e.dropComplete(true);
                return;
            }
            if (!(azDrag[0] instanceof EndPort || azDrag[0] instanceof IvrEndPort || azDrag[0] instanceof SmZoneMember || azDrag[0] instanceof ZoneAlias || !(az instanceof Zone))) {
                e.dropComplete(true);
                return;
            }
            if (az instanceof ZoneSet && !(azDrag[0] instanceof Zone)) {
                e.dropComplete(true);
                return;
            }
            this._zoneAction.insertMembers(dropNode, azDrag, true);
            this.insertMembers(dropNode, azDrag);
            TreePath newPath = new TreePath(dropNode.getPath());
            this.clearSelection();
            this.setSelectionPath(newPath);
            this.expandPath(path);
            this._zoneAction.showTreeNodeMembers(((DndTreeNode)newPath.getLastPathComponent()).getUserObject());
            e.dropComplete(true);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, ex.getMessage());
            if (SnmpSession.isTrace()) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            return;
        }
    }

    ZoneSet getSelectedZoneset() {
        Object ob;
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null && paths.length == 1 && (ob = ((DndTreeNode)this.getLastSelectedPathComponent()).getUserObject()) instanceof ZoneSet) {
            return (ZoneSet)ob;
        }
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        super.getToolTipText(event);
        if (event != null) {
            Object ob;
            TreePath path;
            Point p = event.getPoint();
            int selRow = this.getRowForLocation(p.x, p.y);
            if (selRow != -1 && (path = this.getPathForRow(selRow)) != null && (ob = ((DndTreeNode)path.getLastPathComponent()).getUserObject()) instanceof ZoneSet) {
                ZoneSet zs = (ZoneSet)ob;
                if (this._zoneAction.getActiveZoneSet() != null && this._zoneAction.getActiveZoneSet().getZoneName().equals(zs.getZoneName())) {
                    if (ZoneSet.isModifiedActive(this._zoneAction.getActiveZoneSet(), zs)) {
                        return "Active & Modified";
                    }
                    return "Active";
                }
            }
        }
        return null;
    }

    private JPopupMenu getPopupMenu(TreePath menuPath) {
        int i;
        if (this._popup == null) {
            this._popup = new JPopupMenu();
        }
        this._popup.removeAll();
        JMenuItem[] std = this._control.getStandardMenus();
        JMenuItem[] act = this._control.getActivationMenus();
        for (i = 0; i < std.length; ++i) {
            this._popup.add(std[i]);
        }
        this._popup.addSeparator();
        for (i = 0; i < act.length; ++i) {
            this._popup.add(act[i]);
        }
        boolean canConvert = this._zoneAction.getZoneCapability().isSwitchPortWWNSupported();
        boolean canCopy = false;
        boolean canClone = false;
        Object userObjectEdited = ((DefaultMutableTreeNode)menuPath.getLastPathComponent()).getUserObject();
        if (userObjectEdited instanceof AbstractZone) {
            DefaultMutableTreeNode parent;
            canCopy = ((AbstractZone)userObjectEdited).isZoneset();
            canClone = ((AbstractZone)userObjectEdited).isZone() ? (parent = (DefaultMutableTreeNode)menuPath.getPathComponent(menuPath.getPathCount() - 2)).getUserObject() == ZONES : true;
        }
        this._control.showMenuItems(canClone, canCopy, canConvert, this._zoneAction.isEnhancedDeviceAliaseEnabled(), this.canRenameNode(menuPath));
        return this._popup;
    }

    private boolean canRenameNode(TreePath menuPath) {
        if (!this.isEditable() || menuPath == null) {
            return false;
        }
        Object userObjectEdited = ((DefaultMutableTreeNode)menuPath.getLastPathComponent()).getUserObject();
        if (userObjectEdited instanceof AbstractZone) {
            AbstractZone zz = (AbstractZone)userObjectEdited;
            return zz.isAlias() && this._zoneAction.getZoneCapability().isAliasRenameSupported() || zz.isZoneset() && this._zoneAction.getZoneCapability().isZoneSetRenameSupported() || zz.isZone() && this._zoneAction.getZoneCapability().isZoneRenameupported();
        }
        return false;
    }

    @Override
    public void startEditingAtPath(TreePath path) {
        TreeCellEditor obb = this.getCellEditor();
        if (obb != null && path != null && obb instanceof MyDefaultTreeCellEditor) {
            ((MyDefaultTreeCellEditor)obb).setUserObjectEdited(((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject());
        }
        super.startEditingAtPath(path);
    }

    public DefaultMutableTreeNode getRootNode() {
        return this._root;
    }

    class MyDefaultTreeCellEditor
    extends DefaultTreeCellEditor
    implements CellEditorListener {
        Object _userObjectEdited;
        TreePath _editingPath;

        public MyDefaultTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
            this.addCellEditorListener(this);
        }

        @Override
        protected void prepareForEditing() {
            Object obb = this.getCellEditorValue();
            this._editingPath = this.tree.getSelectionPath();
            if (obb != null && this._editingPath != null) {
                this.setUserObjectEdited(((DefaultMutableTreeNode)this._editingPath.getLastPathComponent()).getUserObject());
            }
            super.prepareForEditing();
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            Object obb = this.getCellEditorValue();
            FilterableTreeModel filterModel = (FilterableTreeModel)ZoneTree.this.getModel();
            DefaultTreeModel model = (DefaultTreeModel)filterModel.getActualModel();
            DefaultMutableTreeNode node = null;
            try {
                if (this._editingPath != null) {
                    DefaultLogger._DefLogger.debug((Object)("User Object to be renamed:" + (this._userObjectEdited != null ? this._userObjectEdited : "Null")));
                    node = (DefaultMutableTreeNode)this._editingPath.getLastPathComponent();
                    if (this._userObjectEdited instanceof AbstractZone) {
                        ZoneTree.this._zoneAction.applyTreeChanges((AbstractZone)this._userObjectEdited, obb.toString());
                        ((DndTreeNode)node).setTimeStamp(((AbstractZone)this._userObjectEdited).getLastModifiedAsLong());
                    }
                    this._editingPath = null;
                }
            }
            catch (SnmpException ex) {
                Util.errorMessage(null, ex.getMessage());
            }
            if (node != null) {
                DndTreeNode nddC;
                node.setUserObject(this._userObjectEdited);
                if (ZoneTree.this._zoneAction != null) {
                    ZoneTree.this._zoneAction.resortRenamedNode((DndTreeNode)node);
                }
                if ((nddC = ZoneTree.this.getTreeNodeForUserObject(this._userObjectEdited)) != null) {
                    ZoneTree.this.setSelectionPath(new TreePath(model.getPathToRoot(nddC)));
                    ZoneTree.this.scrollRowToVisible(ZoneTree.this.getMinSelectionRow());
                }
            }
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            this._editingPath = null;
        }

        public void setUserObjectEdited(Object objectEdited) {
            this._userObjectEdited = objectEdited;
        }
    }
}

