/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zonewizard;

import com.cisco.dcbu.lib.mds.zm.CopyFullZoneAction;
import com.cisco.dcbu.lib.mds.zm.PollerCallbackIf;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.mds.zm.SaveConfigAction;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneActivationAction;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.zm.common.FabricBindingActivationAction;
import com.cisco.dcbu.sm.client.zm.common.SmZoneAction;
import com.cisco.dcbu.sm.client.zm.common.SmZoneData;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.client.zm.zonewizard.WizardCopyTopologyAction;
import com.cisco.dcbu.sm.client.zm.zonewizard.ZoneMemWizard;
import java.util.ArrayList;
import java.util.HashMap;

class WizardZoneAction
extends SmZoneAction {
    private VarBindList _topology;
    private ArrayList _transitionSwitches;
    static int ZONE_ACTIVATION_ACTION = 1;
    static int ZONE_COPY_FULL_ZONES_ACTION = 2;
    static int ZONE_CREATE_TOPOLOGY_ACTION = 3;
    static int ZONE_SAVE_RUNNING_ACTION = 4;
    static int ZONE_COPY_RUNNING_FILE_ACTION = 5;
    static int FABRIC_ACTIVATION_ACTION = 6;

    WizardZoneAction(ZoneMemWizard dialog, ArrayList ivrSwLst, int regionId) {
        super(dialog, ivrSwLst, regionId);
    }

    @Override
    public void buildAction(VersionPeer sw, ZoneSet zs, boolean activate, PollerManager manager, boolean saveConfig, String fileName, boolean enhanced) throws SnmpException {
        if (this._topology != null) {
            WizardCopyTopologyAction copyTop = new WizardCopyTopologyAction((PollerCallbackIf)this, this._dialog, (Object)sw.getSwitchPeer(), this._topology);
            copyTop.setOutputStream(this._out);
            copyTop.enableTopologyActivation();
            manager.addTask(copyTop);
        }
        super.buildAction(sw, zs, activate, manager, saveConfig, fileName, enhanced);
    }

    @Override
    public ZoneSet findZoneSet(String zsName) {
        return this._zoneData.findZoneSet(zsName);
    }

    public void addNewZoneToZoneList(ArrayList zoneList, boolean readOnly, String zoneName, Array members, HashMap vsanAfid) throws SnmpException {
        VarBindList vbLst = new VarBindList();
        ArrayList zoneMem = new ArrayList();
        Zone zn = ((SmZoneData)this._zoneData).buildNewZoneVarBindList(zoneName, this._zoneData.getNextZoneId(), readOnly, members, vbLst, zoneMem, false, -1, false, false, vsanAfid);
        zoneList.add(new Object[]{zn, zoneMem});
    }

    @Override
    public ArrayList buildIvrEnabledSwitches() {
        ArrayList sws = super.buildIvrEnabledSwitches();
        if (this._transitionSwitches != null) {
            ArrayList transitionVerPeer = SmZoneUtil.buildVerPeerLFromSwitchList(this._transitionSwitches);
            for (int i = 0; i < transitionVerPeer.size(); ++i) {
                if (sws.contains(transitionVerPeer.get(i))) continue;
                sws.add(transitionVerPeer.get(i));
            }
        }
        return sws;
    }

    void setTransitSwitches(ArrayList switches) {
        this._transitionSwitches = switches;
    }

    void setTopology(VarBindList topology) {
        this._topology = topology;
    }

    @Override
    public void success(PollerManager manager, StringBuffer status) {
        if (this._vsanId == -1) {
            ((ZoneMemWizard)this._dialog).setProgressBar();
        }
        super.success(manager, status);
    }

    int getCompletedActions(int actionId) {
        int completed = 0;
        block0: for (int k = 0; k < this._manager.length; ++k) {
            ArrayList finish = this._manager[k].getFinishedTasks();
            for (int i = 0; i < finish.size(); ++i) {
                if (actionId == ZONE_ACTIVATION_ACTION && finish.get(i) instanceof ZoneActivationAction) {
                    ++completed;
                    continue block0;
                }
                if (actionId == ZONE_COPY_FULL_ZONES_ACTION && finish.get(i) instanceof CopyFullZoneAction) {
                    ++completed;
                    continue block0;
                }
                if (actionId == ZONE_CREATE_TOPOLOGY_ACTION && finish.get(i) instanceof WizardCopyTopologyAction) {
                    ++completed;
                    continue block0;
                }
                if (actionId == FABRIC_ACTIVATION_ACTION && finish.get(i) instanceof FabricBindingActivationAction) {
                    ++completed;
                    continue block0;
                }
                if (actionId == ZONE_SAVE_RUNNING_ACTION && finish.get(i) instanceof SaveConfigAction && !((SaveConfigAction)finish.get(i)).isSaveConfigFileAction()) {
                    ++completed;
                    continue block0;
                }
                if (actionId != ZONE_COPY_RUNNING_FILE_ACTION || !(finish.get(i) instanceof SaveConfigAction) || !((SaveConfigAction)finish.get(i)).isSaveConfigFileAction()) continue;
                completed = this._manager.length;
                continue block0;
            }
        }
        return completed;
    }

    int getActionsSize() {
        return this._manager != null ? this._manager.length : 0;
    }

    void modifySwitchWoInvalidation(Switch sw) {
        this.swVesionrPeer = SmZoneUtil.buildVersionnPeer(sw);
        ((SmZoneData)this._zoneData).modifySwitchWoInvalidation(sw);
    }
}

