/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.cfgdiffEngine;

import com.cisco.dcbu.sm.common.cfgdiffEngine.CfgCommand;
import com.cisco.dcbu.sm.common.cfgdiffEngine.CfgDiffEngine;
import com.cisco.dcbu.sm.common.cfgdiffEngine.CommandState;
import com.cisco.dcbu.sm.common.cfgdiffEngine.ConfigCmdRow;
import com.cisco.dcbu.sm.common.cfgdiffEngine.ConfigFile;
import com.cisco.dcbu.sm.common.cfgdiffEngine.Pair;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CfgDiffHelper {
    public static String[][] CONFIGS = new String[][]{{"All", null, null}, {"aaa", "aaa", "TwoTokenCompare"}, {"boot", "boot", "TwoTokenCompare"}, {"callhome", "callhome", "TwoTokenCompare"}, {"cdp", "cdp", "TwoTokenCompare"}, {"cert-enroll", "cert-enroll", "TwoTokenCompare"}, {"cfs", "cfs", "TwoTokenCompare"}, {"device-alias", "device-alias", "TwoTokenCompare"}, {"dpvm", "dpvm", "TwoTokenCompare"}, {"eem", "eem", "TwoTokenCompare"}, {"fcdomain", "fcdomain", "TwoTokenCompare"}, {"fcsp", "fcsp", "TwoTokenCompare"}, {"fctimer", "fctimer", "TwoTokenCompare"}, {"feature", "feature", "TwoTokenCompare"}, {"interface", "interface", "TwoTokenCompare"}, {"ip", "ip", "TwoTokenCompare"}, {"iscsi", "iscsi", "TwoTokenCompare"}, {"ivr", "ivr", "TwoTokenCompare"}, {"license", "license", "TwoTokenCompare"}, {"logging", "logging", "TwoTokenCompare"}, {"npiv", "npiv", "TwoTokenCompare"}, {"ntp", "ntp", "TwoTokenCompare"}, {"port-security", "port-security", "TwoTokenCompare"}, {"radius", "radius", "TwoTokenCompare"}, {"role", "role", "TwoTokenCompare"}, {"security", "security", "TwoTokenCompare"}, {"snmp-server", "snmp-server", "TwoTokenCompare"}, {"tacacs", "tacacs", "TwoTokenCompare"}, {"username", "username", null}, {"version", "version", "TwoTokenCompare"}, {"vsan", "vsan database", "TwoTokenCompare"}, {"Zone Configurations", "zoneset", "zone", "fcalias", "TwoTokenCompare"}};
    private LinkedHashMap<Integer, Pair<Integer, CommandState>> aDiffPreviewMap = new LinkedHashMap();
    private LinkedHashMap<Integer, Pair<Integer, CommandState>> bDiffPreviewMap = new LinkedHashMap();
    private LinkedList<Integer> diffList = new LinkedList();
    private Vector<ConfigCmdRow> srcVector = new Vector();
    private Vector<ConfigCmdRow> dstVector = new Vector();

    public static String[] getCategories() {
        String[] categories = new String[CONFIGS.length];
        for (int i = 0; i < CONFIGS.length; ++i) {
            categories[i] = CONFIGS[i][0];
        }
        return categories;
    }

    public void checkforPositionChange(List<CfgCommand> srcList, List<CfgCommand> dstList) {
        boolean reOrdered;
        int idx;
        CfgCommand aPrevCmd = null;
        CfgCommand aNextCmd = null;
        CfgCommand bPrevCmd = null;
        CfgCommand bNextCmd = null;
        List<CfgCommand> aList = this.filterCmds(srcList);
        List<CfgCommand> bList = this.filterCmds(dstList);
        int aSize = aList.size();
        int bSize = bList.size();
        for (idx = 0; idx < aSize; ++idx) {
            CfgCommand aCmd = aList.get(idx);
            aPrevCmd = this.getPreviousCmd(aList, idx);
            aNextCmd = this.getNextCmd(aList, idx);
            reOrdered = false;
            if (aPrevCmd != null && aPrevCmd.getMappedCmdRef().getPosition() > aCmd.getMappedCmdRef().getPosition()) {
                reOrdered = true;
            }
            if (aNextCmd != null && aNextCmd.getMappedCmdRef().getPosition() < aCmd.getMappedCmdRef().getPosition()) {
                reOrdered = true;
            }
            aCmd.setReOrdered(reOrdered);
            aCmd.getMappedCmdRef().setReOrdered(reOrdered);
        }
        for (idx = 0; idx < bSize; ++idx) {
            CfgCommand bCmd = bList.get(idx);
            reOrdered = false;
            bPrevCmd = this.getPreviousCmd(bList, idx);
            bNextCmd = this.getNextCmd(bList, idx);
            if (bPrevCmd != null && bPrevCmd.getMappedCmdRef().getPosition() > bCmd.getMappedCmdRef().getPosition()) {
                reOrdered = true;
            }
            if (bNextCmd != null && bNextCmd.getMappedCmdRef().getPosition() < bCmd.getMappedCmdRef().getPosition()) {
                reOrdered = true;
            }
            bCmd.setReOrdered(reOrdered);
            bCmd.getMappedCmdRef().setReOrdered(reOrdered);
        }
    }

    private CfgCommand getPreviousCmd(List<CfgCommand> list, int idx) {
        CfgCommand prevcmd = null;
        if (idx > 0) {
            CfgCommand cmd = list.get(idx - 1);
            prevcmd = cmd.isReOrdered() == false ? cmd : this.getPreviousCmd(list, idx - 1);
        }
        return prevcmd;
    }

    private CfgCommand getNextCmd(List<CfgCommand> list, int idx) {
        CfgCommand nextCmd = null;
        if (idx < list.size() - 1) {
            CfgCommand cmd = list.get(idx + 1);
            nextCmd = cmd.isReOrdered() == false ? cmd : this.getNextCmd(list, idx + 1);
        }
        return nextCmd;
    }

    private List<CfgCommand> filterCmds(List<CfgCommand> list) {
        ArrayList<CfgCommand> newList = new ArrayList<CfgCommand>();
        for (CfgCommand cmd : list) {
            if (cmd.getState().equals(CommandState.ADDED) || cmd.getState().equals(CommandState.DELETED)) continue;
            newList.add(cmd);
        }
        return newList;
    }

    private boolean isEmptyPaddingReq(CfgCommand cmd) {
        CommandState state = cmd.getState();
        return CommandState.DELETED.equals(state) || CommandState.ADDED.equals(state) || CommandState.REORDERED.equals(state) || cmd.isReOrdered() != false;
    }

    public static boolean isMatchCmd(CfgCommand cmd) {
        CommandState state = cmd.getState();
        if (!CommandState.MATCHED.equals(state)) {
            return false;
        }
        return !CfgDiffHelper.isParentCmdAdditionReq(cmd);
    }

    private static boolean isParentCmdAdditionReq(CfgCommand cmd) {
        boolean flag = false;
        for (CfgCommand subCmd : cmd.getSubCommandsCol()) {
            if (!subCmd.getState().equals(CommandState.MATCHED) && !subCmd.getState().equals(CommandState.EMPTYLINE)) {
                flag = true;
                break;
            }
            flag = CfgDiffHelper.isParentCmdAdditionReq(subCmd);
            if (!flag) continue;
            break;
        }
        return flag;
    }

    public void constructModelData(List<CfgCommand> srcList, List<CfgCommand> dstList, boolean showDiff) {
        this.clearData();
        this.addCommands(srcList, dstList, showDiff);
    }

    private void addCommands(List<CfgCommand> srcList, List<CfgCommand> dstList, boolean showDiff) {
        CfgCommand cmd;
        int srcIdx = 0;
        int dstIdx = 0;
        int srcSize = srcList.size();
        int dstSize = dstList.size();
        while (srcIdx < srcSize && dstIdx < dstSize) {
            CfgCommand aCmd = srcList.get(srcIdx);
            CfgCommand bCmd = dstList.get(dstIdx);
            if (this.isEmptyPaddingReq(aCmd)) {
                this.addToDiffPreviewMap(aCmd, this.srcVector.size());
                this.addToVector(aCmd);
                this.checkAndAddSubCmds(null, aCmd, showDiff);
                this.addEmptyCommandPadding(aCmd);
                ++srcIdx;
                continue;
            }
            if (this.isEmptyPaddingReq(bCmd)) {
                this.addToDiffPreviewMap(bCmd, this.dstVector.size());
                this.addToVector(bCmd);
                this.checkAndAddSubCmds(null, bCmd, showDiff);
                this.addEmptyCommandPadding(bCmd);
                ++dstIdx;
                continue;
            }
            this.addToDiffPreviewMap(aCmd, this.srcVector.size());
            this.addToVector(aCmd);
            this.addToDiffPreviewMap(bCmd, this.dstVector.size());
            this.addToVector(bCmd);
            List<CfgCommand> aSubCmdCol = aCmd.getSubCommandsCol();
            List<CfgCommand> bSubCmdCol = bCmd.getSubCommandsCol();
            if (CommandState.MATCHED.equals(aCmd.getState()) && CommandState.MATCHED.equals(bCmd.getState())) {
                CfgCommand emptyCmd;
                if (aSubCmdCol.size() < bSubCmdCol.size()) {
                    emptyCmd = new CfgCommand();
                    emptyCmd.setCommandLine("");
                    emptyCmd.setState(CommandState.EMPTYLINE);
                    emptyCmd.setFileInfo(ConfigFile.LEFT);
                    aSubCmdCol.add(emptyCmd);
                } else if (aSubCmdCol.size() > bSubCmdCol.size()) {
                    emptyCmd = new CfgCommand();
                    emptyCmd.setCommandLine("");
                    emptyCmd.setState(CommandState.EMPTYLINE);
                    emptyCmd.setFileInfo(ConfigFile.RIGHT);
                    bSubCmdCol.add(emptyCmd);
                }
            }
            this.addCommands(aSubCmdCol, bSubCmdCol, showDiff);
            ++srcIdx;
            ++dstIdx;
        }
        while (srcIdx < srcSize) {
            cmd = srcList.get(srcIdx++);
            this.addToDiffPreviewMap(cmd, this.srcVector.size());
            this.addToVector(cmd);
            this.checkAndAddSubCmds(null, cmd, showDiff);
            if (!this.isEmptyPaddingReq(cmd)) continue;
            this.addEmptyCommandPadding(cmd);
        }
        while (dstIdx < dstSize) {
            cmd = dstList.get(dstIdx++);
            this.addToDiffPreviewMap(cmd, this.dstVector.size());
            this.addToVector(cmd);
            this.checkAndAddSubCmds(null, cmd, showDiff);
            if (!this.isEmptyPaddingReq(cmd)) continue;
            this.addEmptyCommandPadding(cmd);
        }
    }

    private void addCommandsOri(List<CfgCommand> srcList, List<CfgCommand> dstList, boolean showDiff) {
        CfgCommand cmd;
        int srcIdx = 0;
        int dstIdx = 0;
        int srcSize = srcList.size();
        int dstSize = dstList.size();
        while (srcIdx < srcSize && dstIdx < dstSize) {
            CfgCommand aCmd = srcList.get(srcIdx);
            CfgCommand bCmd = dstList.get(dstIdx);
            if (this.isEmptyPaddingReq(aCmd)) {
                this.addToDiffPreviewMap(aCmd, this.srcVector.size());
                this.addToVector(aCmd);
                this.checkAndAddSubCmds(null, aCmd, showDiff);
                this.addEmptyCommandPadding(aCmd);
                ++srcIdx;
                continue;
            }
            if (this.isEmptyPaddingReq(bCmd)) {
                this.addToDiffPreviewMap(bCmd, this.dstVector.size());
                this.addToVector(bCmd);
                this.checkAndAddSubCmds(null, bCmd, showDiff);
                this.addEmptyCommandPadding(bCmd);
                ++dstIdx;
                continue;
            }
            this.addToDiffPreviewMap(aCmd, this.srcVector.size());
            this.addToVector(aCmd);
            this.addToDiffPreviewMap(bCmd, this.dstVector.size());
            this.addToVector(bCmd);
            List<CfgCommand> aSubCmdCol = aCmd.getSubCommandsCol();
            List<CfgCommand> bSubCmdCol = bCmd.getSubCommandsCol();
            if (CommandState.MATCHED.equals(aCmd.getState()) && CommandState.MATCHED.equals(bCmd.getState())) {
                CfgCommand emptyCmd;
                if (aSubCmdCol.size() < bSubCmdCol.size()) {
                    emptyCmd = new CfgCommand();
                    emptyCmd.setCommandLine("");
                    emptyCmd.setState(CommandState.EMPTYLINE);
                    emptyCmd.setFileInfo(ConfigFile.LEFT);
                    aSubCmdCol.add(emptyCmd);
                } else if (aSubCmdCol.size() > bSubCmdCol.size()) {
                    emptyCmd = new CfgCommand();
                    emptyCmd.setCommandLine("");
                    emptyCmd.setState(CommandState.EMPTYLINE);
                    emptyCmd.setFileInfo(ConfigFile.RIGHT);
                    bSubCmdCol.add(emptyCmd);
                }
            }
            this.addCommands(aSubCmdCol, bSubCmdCol, showDiff);
            ++srcIdx;
            ++dstIdx;
        }
        while (srcIdx < srcSize) {
            cmd = srcList.get(srcIdx++);
            this.addToDiffPreviewMap(cmd, this.srcVector.size());
            this.addToVector(cmd);
            this.checkAndAddSubCmds(null, cmd, showDiff);
            if (!this.isEmptyPaddingReq(cmd)) continue;
            this.addEmptyCommandPadding(cmd);
        }
        while (dstIdx < dstSize) {
            cmd = dstList.get(dstIdx++);
            this.addToDiffPreviewMap(cmd, this.dstVector.size());
            this.addToVector(cmd);
            this.checkAndAddSubCmds(null, cmd, showDiff);
            if (!this.isEmptyPaddingReq(cmd)) continue;
            this.addEmptyCommandPadding(cmd);
        }
    }

    private void addEmptyCommandPadding(CfgCommand cmd) {
        int size;
        ConfigFile source = ConfigFile.LEFT;
        if (cmd.getFileInfo().equals(ConfigFile.LEFT)) {
            source = ConfigFile.RIGHT;
        }
        size = (size = cmd.getSize().intValue()) == 0 ? 1 + cmd.getSubCommandsCol().size() : size;
        for (int x = 0; x < size; ++x) {
            this.addToVector(this.getEmptyCfgCommand(source, cmd));
        }
    }

    private void checkAndAddSubCmds(CfgCommand topCmd, CfgCommand cmd, boolean showDiff) {
        if (topCmd == null) {
            topCmd = cmd;
        }
        for (CfgCommand subCmd : cmd.getSubCommandsCol()) {
            if (topCmd.isReOrdered().booleanValue()) {
                subCmd.setReOrdered(true);
            }
            if (!CommandState.MATCHED.equals(subCmd.getState()) && (CommandState.MATCHED.equals(cmd.getState()) || CommandState.MODIFIED.equals(cmd.getState()))) {
                if (subCmd.getFileInfo().equals(ConfigFile.LEFT)) {
                    this.addToDiffPreviewMap(subCmd, this.srcVector.size());
                } else {
                    this.addToDiffPreviewMap(subCmd, this.dstVector.size());
                }
            }
            if (!showDiff || showDiff && !CommandState.MATCHED.equals(subCmd.getState())) {
                this.addToVector(subCmd);
            }
            if (CommandState.MATCHED.equals(topCmd.getState()) && !topCmd.isReOrdered().booleanValue()) {
                this.addEmptyCommandPadding(subCmd);
            }
            this.checkAndAddSubCmds(topCmd, subCmd, showDiff);
        }
    }

    private CfgCommand getEmptyCfgCommand(ConfigFile fileSource, CfgCommand cmd) {
        CfgCommand emptyCmd = new CfgCommand();
        emptyCmd.setCommandLine(cmd.getCommandLine());
        emptyCmd.setCommandLine("");
        emptyCmd.setState(CommandState.EMPTYLINE);
        emptyCmd.setFileInfo(fileSource);
        return emptyCmd;
    }

    private void addToVector(CfgCommand cmd) {
        ConfigCmdRow row = new ConfigCmdRow(cmd);
        switch (cmd.getState()) {
            case ADDED: {
                row.setState("+");
                break;
            }
            case MODIFIED: {
                row.setState("!");
                break;
            }
            case DELETED: {
                row.setState("-");
                break;
            }
            default: {
                row.setState("");
            }
        }
        if (cmd.getFileInfo().equals(ConfigFile.LEFT)) {
            this.srcVector.add(row);
        } else {
            this.dstVector.add(row);
        }
    }

    private void addToDiffPreviewMap(CfgCommand cmd, int vectorPos) {
        int size = cmd.getLastCmdPosition() - cmd.getPosition();
        CommandState state = cmd.getState();
        Pair<Integer, CommandState> pair = new Pair<Integer, CommandState>(size, cmd.getState());
        if (!CommandState.MATCHED.equals(state) && !CommandState.EMPTYLINE.equals(state)) {
            if (cmd.getFileInfo().equals(ConfigFile.LEFT)) {
                this.aDiffPreviewMap.put(vectorPos, pair);
            } else {
                this.bDiffPreviewMap.put(vectorPos, pair);
            }
            if (state.equals(CommandState.MODIFIED) || state.equals(CommandState.REORDERED)) {
                int bPos;
                int aPos = cmd.getPosition();
                if (aPos <= (bPos = cmd.getMappedCmdRef().getPosition().intValue())) {
                    if (cmd.getFileInfo().equals(ConfigFile.LEFT)) {
                        this.addToDiffList(this.srcVector.size());
                    } else {
                        this.addToDiffList(this.dstVector.size());
                    }
                }
            } else {
                this.addToDiffList(vectorPos);
            }
        }
    }

    private void addToDiffList(int vectorPos) {
        if (!this.diffList.contains(vectorPos)) {
            this.diffList.add(vectorPos);
        }
    }

    public Vector<ConfigCmdRow> getSrcVector() {
        return this.srcVector;
    }

    public Vector<ConfigCmdRow> getDstVector() {
        return this.dstVector;
    }

    public LinkedHashMap<Integer, Pair<Integer, CommandState>> getADiffPreviewMap() {
        return this.aDiffPreviewMap;
    }

    public LinkedHashMap<Integer, Pair<Integer, CommandState>> getBDiffPreviewMap() {
        return this.bDiffPreviewMap;
    }

    public LinkedList<Integer> getDiffList() {
        return this.diffList;
    }

    public void clearData() {
        this.diffList.clear();
        this.aDiffPreviewMap.clear();
        this.bDiffPreviewMap.clear();
        this.srcVector.clear();
        this.dstVector.clear();
    }

    public static CfgCommand cloneCmd(CfgCommand cmd, Integer cmdPos) {
        CfgCommand clone = new CfgCommand();
        clone.setPosition(cmdPos);
        clone.setLastCmdPosition(cmdPos + cmd.getSize());
        clone.setCommandLine(cmd.getCommandLine());
        clone.setFileInfo(ConfigFile.RIGHT);
        clone.setState(CommandState.MATCHED);
        cmd.setMappedCmdRef(clone);
        clone.setMappedCmdRef(cmd);
        clone.setReOrdered(cmd.isReOrdered());
        CfgDiffHelper.copySubCmds(cmd, clone);
        return clone;
    }

    private static void copySubCmds(CfgCommand sourceCmd, CfgCommand destCmd) {
        int pos = destCmd.getPosition();
        for (int idx = 0; idx < sourceCmd.getSubCommandsCol().size(); ++idx) {
            CfgCommand aCmd = sourceCmd.getSubCommandsCol().get(idx);
            CfgCommand bCmd = new CfgCommand();
            bCmd.setCommandLine(aCmd.getCommandLine());
            bCmd.setFileInfo(ConfigFile.RIGHT);
            aCmd.setMappedCmdRef(bCmd);
            bCmd.setMappedCmdRef(aCmd);
            bCmd.setPosition(++pos);
            bCmd.setLastCmdPosition(pos + aCmd.getSize());
            bCmd.setReOrdered(aCmd.isReOrdered());
            bCmd.setState(CommandState.MATCHED);
            destCmd.getSubCommandsCol().add(bCmd);
            CfgDiffHelper.copySubCmds(aCmd, bCmd);
        }
    }

    public static boolean isParentCommand(CfgCommand cmd) {
        return !cmd.getCommandLine().startsWith(" ");
    }

    public static boolean isUndoEditRequired(CfgCommand cmd) {
        boolean isUndoEditReq = false;
        boolean isParentCmd = CfgDiffHelper.isParentCommand(cmd);
        switch (cmd.getState()) {
            case MODIFIED: {
                isUndoEditReq = true;
            }
            case EMPTYLINE: {
                if (isParentCmd) {
                    isUndoEditReq = true;
                }
            }
            case DELETED: {
                if (!isParentCmd) break;
                isUndoEditReq = true;
                break;
            }
            default: {
                isUndoEditReq = false;
            }
        }
        return isUndoEditReq;
    }

    public static void updateSourceCommandState(CfgCommand source, CfgCommand oldValue) {
        CommandState state = null;
        switch (oldValue.getState()) {
            case MODIFIED: {
                state = CommandState.MODIFIED;
                break;
            }
            case EMPTYLINE: {
                state = CommandState.DELETED;
                break;
            }
            case MATCHED: {
                state = CommandState.MATCHED;
                break;
            }
            case ADDED: {
                state = CommandState.EMPTYLINE;
                break;
            }
        }
        source.setState(state);
    }

    private static void updateSubCmds(List<CfgCommand> cmdList, CfgCommand cmd) {
        for (CfgCommand subCmd : cmd.getSubCommandsCol()) {
            subCmd.setState(cmd.getState());
            CfgDiffHelper.updateSubCmds(cmdList, subCmd);
        }
    }

    public static Object[] compare(InputStream stream1, InputStream stream2, Object[] selOption, boolean showDiff) {
        Object[][] filter = null;
        if (selOption != null) {
            filter = new String[selOption.length][1];
            block0: for (int k = 0; k < selOption.length; ++k) {
                for (int i = 0; i < CONFIGS.length; ++i) {
                    if (!selOption[k].equals(CONFIGS[i][0])) continue;
                    filter[k] = CONFIGS[i];
                    continue block0;
                }
            }
        }
        Map<ConfigFile, List<List<CfgCommand>>> finfo = new CfgDiffEngine().compare(stream1, stream2, filter);
        CfgDiffHelper helper = new CfgDiffHelper();
        helper.clearData();
        List<List<CfgCommand>> srcCmdList = finfo.get(ConfigFile.LEFT);
        List<List<CfgCommand>> destCmdList = finfo.get(ConfigFile.RIGHT);
        Vector<ConfigCmdRow> srcVAll = new Vector<ConfigCmdRow>();
        Vector<ConfigCmdRow> dstVAll = new Vector<ConfigCmdRow>();
        for (int i = 0; i < srcCmdList.size(); ++i) {
            List<CfgCommand> aList = CfgDiffHelper.filterTableData(null, srcCmdList.get(i), showDiff);
            List<CfgCommand> bList = CfgDiffHelper.filterTableData(null, destCmdList.get(i), showDiff);
            helper.constructModelData(aList, bList, showDiff);
            Vector<ConfigCmdRow> srcV = helper.getSrcVector();
            Vector<ConfigCmdRow> dstV = helper.getDstVector();
            int diffCmds = srcV.size() - dstV.size();
            if (diffCmds != 0) {
                Vector<ConfigCmdRow> vectToaddCmd;
                Vector<ConfigCmdRow> vector = vectToaddCmd = diffCmds > 0 ? dstV : srcV;
                if (diffCmds < 0) {
                    diffCmds = 0 - diffCmds;
                }
                for (int k = 0; k < diffCmds; ++k) {
                    vectToaddCmd.add(new ConfigCmdRow(new CfgCommand()));
                }
            }
            srcVAll.addAll(srcV);
            dstVAll.addAll(dstV);
        }
        return new Object[]{srcVAll, dstVAll};
    }

    private static List<CfgCommand> filterTableData(Object[] key, List<CfgCommand> cmdList, boolean showDiff) {
        if (!(key != null && key.length >= 2 && key[1] != null || showDiff)) {
            return cmdList;
        }
        Vector<CfgCommand> modDataList = new Vector<CfgCommand>(10);
        int dataLength = cmdList.size();
        for (int i = 0; i < dataLength; ++i) {
            boolean isFilteredCmd;
            CfgCommand cfgCmd = cmdList.get(i);
            String topCommand = cfgCmd.getCommandLine();
            boolean isSubCommand = true;
            CfgCommand parentCfgCmd = cfgCmd;
            while (isSubCommand) {
                String parentCmd = (parentCfgCmd = parentCfgCmd.getParentCmd()) != null ? parentCfgCmd.getCommandLine().trim() : null;
                isSubCommand = parentCmd != null && parentCmd.length() > 0;
                if (!isSubCommand) continue;
                topCommand = parentCmd;
            }
            if (key.length <= 1) continue;
            boolean bl = isFilteredCmd = key[1] == null;
            if (key[1] != null) {
                for (int k = 1; k < key.length - 1; ++k) {
                    if (!topCommand.trim().startsWith((String)key[k])) continue;
                    isFilteredCmd = true;
                    break;
                }
            }
            if (!isFilteredCmd) continue;
            if (showDiff) {
                CfgCommand matchCmd = cfgCmd.getMappedCmdRef();
                if (matchCmd != null) {
                    if (!CfgDiffHelper.isMatchCmd(cfgCmd) || !CfgDiffHelper.isMatchCmd(matchCmd)) {
                        modDataList.add(cfgCmd);
                        continue;
                    }
                    System.out.println("matchCmd:" + matchCmd + "  cfgCmd:" + cfgCmd);
                    continue;
                }
                if (CommandState.EMPTYLINE.equals(cfgCmd.getState()) || cfgCmd.getPosition() == 0) continue;
                modDataList.add(cfgCmd);
                continue;
            }
            modDataList.add(cfgCmd);
        }
        return modDataList;
    }
}

