/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.cfgdiffEngine;

import com.cisco.dcbu.sm.common.cfgdiffEngine.KeywordEnumKind;

public enum CommandState implements KeywordEnumKind
{
    DELETED("Deleted", "Deleted"),
    ADDED("Added", "Added"),
    MODIFIED("Modified", "Modified"),
    MATCHED("Matched", "Matched"),
    REORDERED("Reordered", "Reordered"),
    EMPTYLINE("EmptyLine", "EmptyLine"),
    NONE("None", "None");

    private static final long serialVersionUID = 1L;
    private final transient String keyValue;
    private final transient String keyWord;

    private CommandState(String aName, String aKeyword) {
        this.keyValue = aName;
        this.keyWord = aKeyword;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal();
    }

    public static int minOrdinal() {
        return 0;
    }

    public static int maxOrdinal() {
        return CommandState.values().length - 1;
    }

    public static CommandState minEnum() {
        return CommandState.values()[0];
    }

    public static CommandState maxEnum() {
        return CommandState.values()[CommandState.values().length - 1];
    }

    public static CommandState getInstance(int aOrdinal) {
        if (aOrdinal >= CommandState.minOrdinal() && aOrdinal <= CommandState.maxOrdinal()) {
            return CommandState.values()[aOrdinal];
        }
        throw new IllegalArgumentException("CommandState ordinal must be between [" + CommandState.minOrdinal() + "," + CommandState.maxOrdinal() + "], but was " + aOrdinal);
    }

    public static CommandState getInstance(String aKeyword) {
        for (CommandState a : CommandState.values()) {
            if (!a.getKeyword().equals(aKeyword)) continue;
            return a;
        }
        throw new IllegalArgumentException("CommandState keyword name [" + aKeyword + "] does not exist");
    }

    @Override
    public final String getKeyword() {
        return this.keyWord;
    }

    public final String toString() {
        return this.getName() + "(" + this.getOrdinal() + ", " + this.getKeyword() + ")";
    }

    @Override
    public final String getName() {
        return this.keyValue;
    }
}

