/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.dto;

import java.io.Serializable;
import java.net.InetAddress;

public class CfsStaticPeerDto
implements Serializable {
    InetAddress _address;
    Integer _discoverStatus;
    byte[] _addrByteArray;
    int _addrType;

    public CfsStaticPeerDto(InetAddress address, int addrType, byte[] addr, Integer status) {
        this._address = address;
        this._discoverStatus = status;
        this._addrByteArray = addr;
        this._addrType = addrType;
    }

    public CfsStaticPeerDto(InetAddress address, Integer status) {
        this._discoverStatus = status;
        this.setAddress(address);
    }

    public InetAddress getAddress() {
        return this._address;
    }

    public void setAddress(InetAddress address) {
        this._address = address;
        String addrStr = address.toString();
        this._addrByteArray = address.getAddress();
        this._addrType = addrStr.indexOf(46) != -1 && addrStr.indexOf(58) != -1 ? 16 : (this._addrByteArray.length == 16 ? 2 : (this._addrByteArray.length == 4 ? 1 : 0));
    }

    public byte[] getAddrByteArray() {
        return this._addrByteArray;
    }

    public void setAddrByteArray(byte[] addrByteArray) {
        this._addrByteArray = addrByteArray;
    }

    public int getAddrType() {
        return this._addrType;
    }

    public void setAddrType(int addrType) {
        this._addrType = addrType;
    }

    public Integer getDiscoverStatus() {
        return this._discoverStatus;
    }

    public void setDiscoverStatus(Integer discoverStatus) {
        this._discoverStatus = discoverStatus;
    }

    public String getDiscoveryStatusString() {
        String result;
        if (this._discoverStatus == null) {
            result = "Not Available";
        } else {
            switch (this._discoverStatus) {
                case 1: {
                    result = "Unknown";
                    break;
                }
                case 2: {
                    result = "Reachable";
                    break;
                }
                case 3: {
                    result = "Unreachable";
                    break;
                }
                case 4: {
                    result = "Discovery In Progress";
                    break;
                }
                case 5: {
                    result = "Re-Discovering In Progress - previously timed out";
                    break;
                }
                case 6: {
                    result = "Local";
                    break;
                }
                case 7: {
                    result = "No Local Address";
                    break;
                }
                case 8: {
                    result = "CFS Distribution Disabled";
                }
                default: {
                    result = "Unknown";
                }
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CfsStaticPeerDto) {
            CfsStaticPeerDto objCast = (CfsStaticPeerDto)obj;
            if (this._address == null && objCast == null) {
                return true;
            }
            return this._address != null && this._address.equals(objCast.getAddress());
        }
        return false;
    }
}

