/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.dto;

import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import java.io.Serializable;

public class PossibleFCFlowTrafficDto
implements Serializable {
    public static final long serialVersionUID = 1L;
    private SwitchBase sw;
    private VsanBase vsan;
    private EndPortBase src;
    private EndPortBase dest;
    private double peakRx;
    private double peakTx;
    private double averRx;
    private double averTx;
    private String peakRxStr;
    private String peakTxStr;
    private String averRxStr;
    private String averTxStr;

    public PossibleFCFlowTrafficDto(SwitchBase sw, VsanBase vsan, EndPortBase src, EndPortBase dest, double peakRx, double peakTx, double averRx, double averTx) {
        this.sw = sw;
        this.vsan = vsan;
        this.src = src;
        this.dest = dest;
        this.peakRx = peakRx;
        this.peakTx = peakTx;
        this.averRx = averRx;
        this.averTx = averTx;
        this.peakRxStr = !Double.isNaN(peakRx) ? DefaultSnmpNumberRenderer.formatLong((long)peakRx) + "B" : "n/a";
        this.peakTxStr = !Double.isNaN(peakTx) ? DefaultSnmpNumberRenderer.formatLong((long)peakTx) + "B" : "n/a";
        this.averRxStr = !Double.isNaN(averRx) ? DefaultSnmpNumberRenderer.formatLong((long)averRx) + "B" : "n/a";
        this.averTxStr = !Double.isNaN(averTx) ? DefaultSnmpNumberRenderer.formatLong((long)averTx) + "B" : "n/a";
    }

    public SwitchBase getSw() {
        return this.sw;
    }

    public VsanBase getVsan() {
        return this.vsan;
    }

    public EndPortBase getSrc() {
        return this.src;
    }

    public EndPortBase getDest() {
        return this.dest;
    }

    public double getPeakRx() {
        return this.peakRx;
    }

    public double getPeakTx() {
        return this.peakTx;
    }

    public double getAverRx() {
        return this.averRx;
    }

    public double getAverTx() {
        return this.averTx;
    }

    public String getPeakRxStr() {
        return this.peakRxStr;
    }

    public String getPeakTxStr() {
        return this.peakTxStr;
    }

    public String getAverRxStr() {
        return this.averRxStr;
    }

    public String getAverTxStr() {
        return this.averTxStr;
    }
}

