/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.event;

import com.cisco.dcbu.sm.common.event.PtoPEventHandler;
import com.cisco.dcbu.sm.common.event.QueueListener;
import com.cisco.dcbu.sm.common.event.SimplePtoPEventHandler;
import javax.jms.JMSException;
import javax.naming.NamingException;

public class PtoPEventFactory {
    private static PtoPEventFactory _eventHandlerFactory = null;
    private static final String FM_STANDALONE = "fm.standalone";

    private PtoPEventFactory() {
    }

    public synchronized PtoPEventHandler getPtoPHandler(String queueName, QueueListener l) throws Exception {
        PtoPEventHandler handler = null;
        if (System.getProperty(FM_STANDALONE) != null && "true".equalsIgnoreCase(System.getProperty(FM_STANDALONE))) {
            handler = new SimplePtoPEventHandler(queueName);
            handler.setListener(l);
        } else {
            try {
                handler = new PtoPEventHandler(queueName, l);
            }
            catch (JMSException jex) {
                throw jex;
            }
            catch (NamingException ex) {
                throw ex;
            }
        }
        return handler;
    }

    public static PtoPEventFactory getInstance() {
        if (_eventHandlerFactory == null) {
            _eventHandlerFactory = new PtoPEventFactory();
        }
        return _eventHandlerFactory;
    }
}

