/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.event;

import com.cisco.dcbu.sm.common.event.QueueListener;
import java.io.EOFException;
import java.net.SocketException;
import java.util.Properties;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class PtoPEventHandler
implements MessageListener,
ExceptionListener {
    private static final long serialVersionUID = 1L;
    private final int _port;
    protected static final Logger _logger = Logger.getLogger(PtoPEventHandler.class);
    private QueueConnection _conn = null;
    private QueueSession _session = null;
    private Queue _queue = null;
    private QueueReceiver _recv = null;
    private String _queueName;
    private boolean _connectionIsUp = false;
    private String _server;
    protected QueueListener _listener;

    protected PtoPEventHandler() {
        this._port = Integer.getInteger("server.port", new Integer(4447));
    }

    public PtoPEventHandler(String queueName, QueueListener l) throws Exception {
        this._queueName = queueName;
        this._port = Integer.getInteger("server.port", new Integer(4447));
        this._listener = l;
        this.setupQueue();
    }

    public void setupQueue() throws Exception {
        if (this._connectionIsUp) {
            return;
        }
        try {
            this._server = System.getProperty("server.bindaddrs", "localhost");
            if (this._server == null || this._server.equals("")) {
                this._server = "localhost";
            }
            String serverUrl = "remote://" + this._server + ":" + this._port;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("settting up queue to serverURL: " + serverUrl + " and queueName: " + this._queueName));
            }
            this.stop();
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "org.jboss.naming.remote.client.InitialContextFactory");
            properties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
            properties.put("java.naming.provider.url", serverUrl);
            properties.put("java.naming.security.principal", "admin");
            properties.put("java.naming.security.credentials", "nbv_12345");
            InitialContext _context = new InitialContext(properties);
            Object tmp = _context.lookup("jms/RemoteConnectionFactory");
            QueueConnectionFactory tcf = (QueueConnectionFactory)tmp;
            this._conn = tcf.createQueueConnection();
            this._queue = (Queue)_context.lookup(this._queueName);
            this._session = this._conn.createQueueSession(false, 1);
            this._recv = this._session.createReceiver(this._queue);
            this._recv.setMessageListener((MessageListener)this);
            this._conn.start();
            this._conn.setExceptionListener((ExceptionListener)this);
            this._connectionIsUp = true;
        }
        catch (Exception ex) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"can not init queue handler", (Throwable)ex);
            }
            throw new Exception(ex.getMessage());
        }
    }

    public void setListener(QueueListener l) {
        this._listener = l;
    }

    public Object getCommunicationObject() {
        return this._queue;
    }

    public void onException(JMSException ex) {
        if (this._connectionIsUp && (ex.getCause() instanceof SocketException || ex.getCause() instanceof EOFException)) {
            this._connectionIsUp = false;
        }
    }

    public void onMessage(Message msg) {
        Object ojb = null;
        if (msg instanceof ObjectMessage) {
            try {
                ObjectMessage om = (ObjectMessage)msg;
                ojb = om.getObject();
            }
            catch (JMSException jme) {}
        } else if (msg instanceof TextMessage) {
            try {
                TextMessage tm = (TextMessage)msg;
                ojb = tm.getText();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        if (this._listener != null && ojb != null) {
            this._listener.onMessage(ojb);
        } else {
            _logger.error((Object)("message not sent to client as the listener or the ojb was null, listener - " + this._listener + " obj - " + ojb));
        }
    }

    public void stop() {
        try {
            if (this._recv != null) {
                this._recv.close();
                this._recv = null;
            }
            if (this._conn != null) {
                this._conn.stop();
            }
            if (this._session != null) {
                this._session.close();
                this._session = null;
            }
            if (this._conn != null) {
                this._conn.close();
                this._conn = null;
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this._connectionIsUp = false;
    }

    public void dispose() {
        this._listener = null;
    }

    public void finallize() {
        this.stop();
        this._listener = null;
    }
}

