/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.event;

import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.io.Serializable;
import java.net.InetAddress;

public class SnmpTrapEntry
implements Serializable {
    static final long serialVersionUID = 1L;
    private InetAddress _addr;
    private SnmpVarBind[] _vbs;
    private transient SnmpPDU _pdu;

    public SnmpTrapEntry(SnmpPDU pdu) {
        this._addr = pdu.getAddress();
        this._vbs = new SnmpVarBind[pdu.getVariables().size()];
        pdu.getVariables().toArray(this._vbs);
        this._pdu = pdu;
    }

    public InetAddress getAddr() {
        return this._addr;
    }

    public VarBindList getVarBindList() {
        return new VarBindList(this._vbs);
    }

    public int getLength() {
        return this._vbs.length;
    }

    public SnmpOID getOid(int i) {
        return this._vbs[i].getOid();
    }

    public SnmpVar getVar(int i) {
        return this._vbs[i].getVar();
    }

    public String toString() {
        if (this._pdu != null) {
            return this._pdu.toString();
        }
        return super.toString();
    }

    public SnmpPDU getPDU() {
        return this._pdu;
    }
}

