/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.util.HashMap;
import java.util.TreeSet;

public class Card<E extends PKIf>
extends HwInventoryComponent<E> {
    static final long serialVersionUID = 1L;
    protected int _modelType;
    protected int _adminStatus;
    protected int _operStatus;
    protected String _resetReason;
    protected long _statusLastChangeTime;
    protected int _powerAdminStatus;
    protected int _powerOperStatus;
    protected int _powerCurrent;
    protected int _dmmState;
    protected int _ioaState;
    protected int _seState;
    protected int _santapState;
    protected int _numEthPorts;
    protected HashMap<Integer, TreeSet<Integer>> _portByIfType;
    protected String _descr;
    protected boolean _active = false;

    public Card(E swPK, int phyIndex, int[] vendorType, int slot, String name, String hwRev, String fwRev, String swRev, String serialNum, String model, String mfg, String assetId, int adminStatus, int operStatus, String statusDescr, String resetReason, long changeTime, int powerAdminStatus, int powerOperStatus, int current, int dmmState, int ioaState, int seState, int santapState) {
        super(swPK, phyIndex, name, vendorType, HwInventoryType.MODULE.value(), slot, hwRev, fwRev, swRev, serialNum, mfg, model, assetId, statusDescr, "n/a");
        if (this._vendorType != null && this._vendorType.length != 0) {
            this._modelType = FRUConstants.getModuleType(this._vendorType);
        }
        this._adminStatus = adminStatus;
        this._operStatus = operStatus;
        this._resetReason = resetReason;
        this._statusLastChangeTime = changeTime;
        this._powerAdminStatus = powerAdminStatus;
        this._powerOperStatus = powerOperStatus;
        this._powerCurrent = current;
        this._dmmState = dmmState;
        this._ioaState = ioaState;
        this._seState = seState;
        this._santapState = santapState;
    }

    public void update(int phyIndex, int[] vendorType, String name, String hwRev, String fwRev, String swRev, String serialNum, String model, String mfg, String assetId, int adminStatus, int operStatus, String statusDescr, String resetReason, long chgTime, int powerAdminStatus, int powerOperStatus, int current) {
        int modelType;
        super.update(phyIndex, name, vendorType, HwInventoryType.MODULE.value(), hwRev, fwRev, swRev, serialNum, mfg, model, assetId, statusDescr, "n/a");
        if (this._vendorType != null && this._vendorType.length != 0 && this._modelType != (modelType = FRUConstants.getModuleType(this._vendorType))) {
            this._modelType = modelType;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        this.update(adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current);
    }

    public void update(int phyIndex, int[] vendorType, String name, String hwRev, String fwRev, String swRev, String serialNum, String model, String mfg, String assetId, int adminStatus, int operStatus, String statusDescr, String resetReason, long chgTime, int powerAdminStatus, int powerOperStatus, int current, int dmmState, int ioaState, int seState, int santapState, int numEthPorts, HashMap<Integer, TreeSet<Integer>> portByIfType) {
        this.update(phyIndex, vendorType, name, hwRev, fwRev, swRev, serialNum, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current);
        this.setDmmState(dmmState);
        this.setIoaState(ioaState);
        this.setSeState(seState);
        this.setSantapState(santapState);
        this.setNumEthPorts(numEthPorts);
        this.setPortByIfType(portByIfType);
    }

    public void update(int adminStatus, int operStatus, String statusDescr, String resetReason, long chgTime, int powerAdminStatus, int powerOperStatus, int current) {
        if (this._adminStatus != adminStatus) {
            this._adminStatus = adminStatus;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (this._operStatus != operStatus) {
            this._operStatus = operStatus;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!GenUtil.equals(this._statusDescr, statusDescr)) {
            this._statusDescr = statusDescr;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!GenUtil.equals(this._resetReason, resetReason)) {
            this._resetReason = resetReason;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (this._statusLastChangeTime != chgTime) {
            this._statusLastChangeTime = chgTime;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (this._powerAdminStatus != powerAdminStatus) {
            this._powerAdminStatus = powerAdminStatus;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (this._powerOperStatus != powerOperStatus) {
            this._powerOperStatus = powerOperStatus;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (this._powerCurrent != current) {
            this._powerCurrent = current;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        this.updateLastScanTime();
    }

    public void update(Card card) {
        this.update(card._physicalIndex, card._vendorType, card._name, card._hardwareRevision, card._firmwareRevision, card._softwareRevision, card._serialNumber, card._modelName, card._manufacturer, card._assetId, card._adminStatus, card._operStatus, card._statusDescr, card._resetReason, card._statusLastChangeTime, card._powerAdminStatus, card._powerOperStatus, card._powerCurrent, card._dmmState, card._ioaState, card._seState, card._santapState, card._numEthPorts, card._portByIfType);
    }

    public void setStatus(int operStatus, String statusDescr, long chgTime) {
        if (this._operStatus != operStatus) {
            this._operStatus = operStatus;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!GenUtil.equals(this._statusDescr, statusDescr)) {
            this._statusDescr = statusDescr;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (this._statusLastChangeTime != chgTime) {
            this._statusLastChangeTime = chgTime;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        this.updateLastScanTime();
    }

    public void setPortByIfType(HashMap<Integer, TreeSet<Integer>> portByIfType) {
        this._portByIfType = portByIfType;
    }

    public void setNumEthPorts(int num) {
        if (this._numEthPorts != num) {
            this._numEthPorts = num;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
    }

    public void setIoaState(int ioaState) {
        if (this._ioaState != ioaState) {
            this._ioaState = ioaState;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
    }

    public void setSeState(int seState) {
        if (this._seState != seState) {
            this._seState = seState;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
    }

    public void setSantapState(int santapState) {
        if (this._santapState != santapState) {
            this._santapState = santapState;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
    }

    public void setDmmState(int dmmState) {
        if (this._dmmState != dmmState) {
            this._dmmState = dmmState;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
    }

    public void setPhysicalDescr(String descr) {
        this._descr = descr;
    }

    public String getPhysicalDescr() {
        return this._descr;
    }

    public int getType() {
        return this._modelType;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public boolean isActive() {
        return this._active;
    }

    public int getAdminStatus() {
        return this._adminStatus;
    }

    public int getOperStatus() {
        return this._operStatus;
    }

    public String getResetReason() {
        return this._resetReason;
    }

    public long getStatusLastChangeTime() {
        return this._statusLastChangeTime;
    }

    public int getPowerAdminStatus() {
        return this._powerAdminStatus;
    }

    public int getPowerOperStatus() {
        return this._powerOperStatus;
    }

    public int getPowerCurrent() {
        return this._powerCurrent;
    }

    public int getIoaState() {
        return this._ioaState;
    }

    public int getSeState() {
        return this._seState;
    }

    public int getSantapState() {
        return this._santapState;
    }

    public int getDmmState() {
        return this._dmmState;
    }

    public boolean isDmmReady() {
        return this._dmmState == 2;
    }

    public boolean isDmmReady4Set() {
        return this._dmmState == 1;
    }

    public int getNumPorts() {
        return FRUConstants.getNumPorts(this._modelType);
    }

    public int getNumEthPorts() {
        if (FRUConstants.isNexusOrUCSCard(this._modelType) && this._portByIfType != null) {
            return this._numEthPorts;
        }
        return FRUConstants.getNumEthPorts(this._modelType);
    }

    public int getNumGigEPorts() {
        TreeSet<Integer> gigEPorts;
        if (FRUConstants.isNexusOrUCSCard(this._modelType) && this._portByIfType != null && (gigEPorts = this._portByIfType.get(2)) != null && gigEPorts.size() > 0) {
            return gigEPorts.size();
        }
        return FRUConstants.getNumGigEPorts(this._modelType);
    }

    public boolean hasEthernetPorts() {
        return this.getNumEthPorts() > 0;
    }

    public boolean hasGigEPorts() {
        return this.getNumGigEPorts() > 0;
    }

    public boolean hasSup() {
        return FRUConstants.hasSup(this._modelType);
    }

    public boolean isSup2() {
        return FRUConstants.isSup2(this._modelType);
    }

    public boolean isSup3() {
        return FRUConstants.isSup3(this._modelType);
    }

    public boolean isSupervisor() {
        boolean supervior = this.hasSup();
        if (!supervior) {
            supervior = this.isSup2();
        }
        if (!supervior && this._descr != null) {
            supervior = this._descr.toLowerCase().indexOf("supervisor") >= 0;
        }
        return supervior;
    }

    public boolean isMixedCard() {
        return FRUConstants.isMixedCard(this._modelType);
    }

    public boolean isAutodromoCard() {
        return FRUConstants.isAutodromoCard(this._modelType);
    }

    public boolean isAuto40() {
        return FRUConstants.isAuto40(this._modelType);
    }

    public boolean isAuto100() {
        return FRUConstants.isAuto100(this._modelType);
    }

    public int getIfType() {
        return FRUConstants.getIfType(this._modelType);
    }

    public int getIfType(int port) {
        if (FRUConstants.isNexusOrUCSCard(this._modelType) && this._portByIfType != null) {
            Integer[] ifTypes;
            Integer[] arr$ = ifTypes = this._portByIfType.keySet().toArray(new Integer[this._portByIfType.keySet().size()]);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int ifType = arr$[i$];
                if (!this._portByIfType.get(ifType).contains(port)) continue;
                return ifType;
            }
            return -1;
        }
        return FRUConstants.getPortIfType(this._modelType, port);
    }

    @Override
    public String toString() {
        return new StringBuffer("slot ").append(this._relativePosition).append(" ").append(this.getModelName()).append(" ").append(this._softwareRevision).append(" ").append(this._operStatus == 2 ? "up" : "down").append(this.isActive() ? "(active)" : "").append(" status last change time: ").append(this._statusLastChangeTime).toString();
    }
}

