/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.type.CfsRegionPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;

public class CfsRegion
extends BaseModelObject {
    static final long serialVersionUID = 1L;
    public static final short REGION_ATTR = 4096;
    public static final short ATTR_ISPRESENT = 4097;
    public static final short ATTR_FEATURE = 4098;
    public static final short ATTR_FABRICPK = 4099;
    public static final short ATTR_IVRSEED = 4100;
    public static final short ATTR_ALIASSEED = 4101;
    public static final short ATTR_IVRENFZONESETNAME = 4102;
    public static final short ATTR_IVRENFZONESETTIME = 4103;
    public static final String[] _Attrs = new String[]{"isPresent", "name", "adminState", "operState", "interOperMode", "MTU", "loadBalancingType", "isInorderDelivery", "dropLatency", "ficonState", "segmented", "fabricPK", "vsanSeed", "fcAliasSeed", "enforcedZonesetName", "enforcedZonesetActivateTime", "enforcedZones", "fcAlias"};
    protected CfsRegionPK _pkey;
    protected String _feature;
    protected WwnKey _ivrSeed;
    protected WwnKey _aliasSeed;
    protected String _ivrEnfZoneSetName;
    protected long _ivrEnfZoneSetActivateTime = 0L;
    protected ZoneBase[] _ivrEnfZones;

    public CfsRegion(FabricPK fpk, int id) {
        this._pkey = new CfsRegionPK(fpk, id);
    }

    public CfsRegion(FabricPK fpk, int id, String feature) {
        this._pkey = new CfsRegionPK(fpk, id);
        this._feature = feature;
    }

    public CfsRegion(FabricPK fpk, int id, WwnKey ivrSeed, WwnKey aliasSeed) {
        this._pkey = new CfsRegionPK(fpk, id);
        this._ivrSeed = ivrSeed;
        this._aliasSeed = aliasSeed;
    }

    public CfsRegion(FabricPK fpk, int id, WwnKey ivrSeed, WwnKey aliasSeed, String ivrEnfZoneSetName) {
        this._pkey = new CfsRegionPK(fpk, id);
        this._ivrSeed = ivrSeed;
        this._aliasSeed = aliasSeed;
        this._ivrEnfZoneSetName = ivrEnfZoneSetName;
    }

    public CfsRegion(FabricPK fpk, int id, String feature, String ivrEnfZoneSetName) {
        this._pkey = new CfsRegionPK(fpk, id);
        this._feature = feature;
        this._ivrEnfZoneSetName = ivrEnfZoneSetName;
    }

    public CfsRegion(FabricPK fpk, int id, ZoneBase[] ivrEnfZones, String feature) {
        this._pkey = new CfsRegionPK(fpk, id);
        this._feature = feature;
        this._ivrEnfZones = ivrEnfZones;
    }

    public CfsRegion(FabricPK fpk, int id, long ivrEnfZoneSetActivateTime, String feature) {
        this._pkey = new CfsRegionPK(fpk, id);
        this._feature = feature;
        this._ivrEnfZoneSetActivateTime = ivrEnfZoneSetActivateTime;
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    public CfsRegionPK getCfsRegionPK() {
        return this._pkey;
    }

    public FabricPK getFabricPK() {
        return this._pkey._fabricPK;
    }

    public int getRegionId() {
        return this._pkey._id;
    }

    public String getFeature() {
        return this._feature;
    }

    public void setFeature(String feature) {
        this._feature = feature;
    }

    public WwnKey getIvrSeed() {
        return this._ivrSeed;
    }

    public void setIvrSeed(WwnKey ivrSeed) {
        this._ivrSeed = ivrSeed;
    }

    public WwnKey getAliasSeed() {
        return this._aliasSeed;
    }

    public void setAliasSeed(WwnKey aliasSeed) {
        this._aliasSeed = aliasSeed;
    }

    public String getIvrEnfZoneSetName() {
        return this._ivrEnfZoneSetName;
    }

    public void setIvrEnfZoneSetName(String ivrEnfZoneSetName) {
        this._ivrEnfZoneSetName = ivrEnfZoneSetName;
    }

    public long getIvrEnfZoneSetActivateTime() {
        return this._ivrEnfZoneSetActivateTime;
    }

    public long setIvrEnfZoneSetActivateTime(long time) {
        long oldTime = this._ivrEnfZoneSetActivateTime;
        this._ivrEnfZoneSetActivateTime = time;
        return oldTime;
    }

    public ZoneBase[] getIvrEnfZones() {
        return this._ivrEnfZones;
    }

    public void setIvrEnfZones(ZoneBase[] ivrEnfZones) {
        this._ivrEnfZones = ivrEnfZones;
    }

    @Override
    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (x == null || !(x instanceof CfsRegion)) {
            return false;
        }
        return ((CfsRegion)x)._pkey.equals(this._pkey);
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        CfsRegion v1 = (CfsRegion)o1;
        CfsRegion v2 = (CfsRegion)o2;
        return v1._feature.compareTo(v2._feature);
    }

    @Override
    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    @Override
    public String toString() {
        return this._pkey.toString();
    }
}

