/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.model.AbstractFcLinkBase;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EdgeLinkBase
extends AbstractFcLinkBase<SwitchIntKey> {
    static final long serialVersionUID = 1L;
    protected Wwn _fwwn;
    protected List<Wwn> _pwwns;

    public EdgeLinkBase(SwitchIntKey pkey, Wwn fwwn) {
        super(pkey);
        this._vsanIds = Collections.synchronizedList(new ArrayList(1));
        this._fwwn = fwwn;
    }

    public SwitchIntKey getFPortPK() {
        return (SwitchIntKey)this._pkey;
    }

    public int getFPortIfIndex() {
        return ((SwitchIntKey)this._pkey)._index;
    }

    public Wwn getFPortWwn() {
        return this._fwwn;
    }

    public WwnKey getSwitchPK() {
        return ((SwitchIntKey)this._pkey)._swPK;
    }

    public Wwn getNPortWwn() {
        return this._pwwns.get(0);
    }

    public void setNPortWwn(Wwn pwwn) {
        this._pwwns.set(0, pwwn);
    }

    public List<Wwn> getNLPortWwns() {
        return this._pwwns;
    }

    public void setNLPortWwns(List<Wwn> pwwns) {
        this._pwwns = pwwns;
    }

    public short getVsanId() {
        return this._vsanIds.size() != 0 ? (Short)this._vsanIds.get(0) : (short)0;
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSwitchPK()).append(',').append(this.getFPortIfIndex()).append(" <-> ");
        for (Wwn pwwn : this._pwwns) {
            sb.append(pwwn).append(", ");
        }
        return sb.charAt(sb.length() - 2) == ',' ? sb.substring(0, sb.length() - 2) : sb.toString();
    }

    @Override
    public boolean isEdgeLink() {
        return true;
    }

    @Override
    public boolean isIsl() {
        return false;
    }

    @Override
    public boolean isNpvLink() {
        return false;
    }

    @Override
    public boolean isPortChannel() {
        return false;
    }

    @Override
    public boolean isTrunk() {
        return this._operMode == 17 || this._operMode == 18 || this.getNumVsans() > 1;
    }
}

