/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.Hba;
import com.cisco.dcbu.sm.common.model.ScsiTarget;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.vi.model.HostSystem;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EnclosureBase
extends BaseModelObject {
    static final long serialVersionUID = 1L;
    public static final short ENCL_ATTR = 1792;
    public static final short ATTR_ISPRESENT = 1793;
    public static final short ATTR_NAME = 1794;
    public static final short ATTR_TYPE = 1795;
    public static final short ATTR_IPADDRESS = 1796;
    public static final short ATTR_VENDOR = 1797;
    public static final short ATTR_MODEL = 1798;
    public static final short ATTR_VERSION = 1799;
    public static final short ATTR_DMPATH = 1800;
    public static final short ATTR_OSINFO = 1801;
    public static final short ATTR_NXPORTPK = 1802;
    public static final short ATTR_TARGET = 1803;
    public static final short ATTR_HBAS = 1804;
    public static final short ATTR_VDC = 1805;
    public static final short ATTR_VMCOUNT = 1806;
    public static final short ATTR_SPROFILE = 1807;
    public static final short ATTR_SERVBLADE = 1808;
    public static final short ATTR_VHOST = 1809;
    public static final String[] _Attrs = new String[]{"isPresent", "name", "type", "ipAddress", "vendor", "model", "version", "path", "OSInfo", "NxPort PK", "lun0", "HBAs", "Vdcs", "vmCount", "serviceProfile", "serverBlade", "vHost"};
    public static final int TYPE_STORAGE = 0;
    public static final int TYPE_UNKNOWN = 31;
    public static final int TYPE_HOST = 47;
    public static final String TYPE_UNKNOWN_NAME = "Unknown";
    public static final String TYPE_HOST_NAME = "Host";
    public static final String TYPE_STORAGE_NAME = "Storage";
    protected NameKey _pkey;
    protected int _type = 31;
    protected String _ipAddress;
    protected String _vendor;
    protected String _model;
    protected String _version;
    protected String _osInfo;
    protected String _dmPath;
    protected boolean _isVirtual;
    protected List<WwnKey> _epPKs = Collections.synchronizedList(new ArrayList(5));
    protected ScsiTarget _target;
    protected Hba[] _hbas;
    protected boolean _isVmHost;
    protected HostSystem _vhost;
    protected int _numVms;
    protected String _serviceProfile;
    protected String _serverBlade;

    public EnclosureBase(String name, InetAddress ipAddress, boolean isVirtual) {
        this._pkey = new NameKey(name);
        this._ipAddress = ipAddress == null ? null : ipAddress.getHostAddress();
        this._isVirtual = isVirtual;
    }

    public EnclosureBase(String name, String ipAddress, boolean isVirtual) {
        this._pkey = new NameKey(name);
        this._ipAddress = ipAddress;
        this._isVirtual = isVirtual;
    }

    public EnclosureBase(NameKey nameKey, String ipAddress, boolean isVirtual) {
        this._pkey = nameKey;
        this._ipAddress = ipAddress;
        this._isVirtual = isVirtual;
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    public NameKey getEnclosurePK() {
        return this._pkey;
    }

    public String getEnclosureName() {
        return this._pkey._name;
    }

    public boolean setEnclosureName(String newName) {
        boolean changed;
        boolean bl = changed = !this._pkey._name.equals(newName);
        if (changed) {
            this._pkey = new NameKey(newName);
            this.setModified(true);
        }
        return changed;
    }

    public String getDMPath() {
        return this._dmPath;
    }

    public boolean setDMPath(String dmPath) {
        boolean changed;
        boolean bl = !(this._dmPath != null ? this._dmPath.equals(dmPath) : dmPath == null) ? true : (changed = false);
        if (changed) {
            this._dmPath = dmPath;
            this.setModified(true);
        }
        return changed;
    }

    public String getIpAddress() {
        return this._ipAddress;
    }

    public boolean setIpAddress(String ipAddr) {
        boolean changed;
        boolean bl = changed = !GenUtil.equals(this._ipAddress, ipAddr);
        if (changed) {
            this._ipAddress = ipAddr;
            this.setModified(true);
        }
        return changed;
    }

    public String getVendor() {
        return this._vendor;
    }

    public void setVendor(String vendor) {
        boolean changed;
        boolean bl = changed = !GenUtil.equals(this._vendor, vendor);
        if (changed) {
            this.setModified(true);
            this._vendor = vendor;
        }
    }

    public String getServiceProfile() {
        return this._serviceProfile;
    }

    public boolean setServiceProfile(String serviceProfile) {
        boolean changed;
        boolean bl = changed = !GenUtil.equals(this._serviceProfile, serviceProfile);
        if (changed) {
            this._serviceProfile = serviceProfile;
            this.setModified(true);
        }
        return changed;
    }

    public String getServerBlade() {
        return this._serverBlade;
    }

    public boolean setServerBlade(String serverBlade) {
        boolean changed;
        boolean bl = changed = !GenUtil.equals(this._serverBlade, serverBlade);
        if (changed) {
            this._serverBlade = serverBlade;
            this.setModified(true);
        }
        return changed;
    }

    public String getModel() {
        return this._model;
    }

    public void setModel(String model) {
        boolean changed;
        boolean bl = changed = !GenUtil.equals(this._model, model);
        if (changed) {
            this.setModified(true);
            this._model = model;
        }
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        boolean changed;
        boolean bl = changed = !GenUtil.equals(this._version, version);
        if (changed) {
            this.setModified(true);
            this._version = version;
        }
    }

    public int getType() {
        return this._type;
    }

    public String getTypeName() {
        if (this._type == 47) {
            return TYPE_HOST_NAME;
        }
        if (this._type == 0) {
            return TYPE_STORAGE_NAME;
        }
        return TYPE_UNKNOWN_NAME;
    }

    public boolean setType(int type) {
        if (this._type == type || this._type != 31 && type == 31) {
            return false;
        }
        this._type = type;
        this.setModified(true);
        return true;
    }

    public boolean isStorage() {
        return this._type == 0;
    }

    public boolean isHost() {
        return this._type == 47;
    }

    public boolean isVirtual() {
        return this._isVirtual;
    }

    public String getOSInfo() {
        return this._osInfo;
    }

    public void setOSInfo(String osInfo) {
        boolean changed;
        boolean bl = changed = !GenUtil.equals(this._osInfo, osInfo);
        if (changed) {
            this.setModified(true);
            this._osInfo = osInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEndPort(WwnKey epPK) {
        List<WwnKey> list = this._epPKs;
        synchronized (list) {
            if (!this._epPKs.contains(epPK)) {
                this._epPKs.add(epPK);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEndPort(WwnKey epPK) {
        List<WwnKey> list = this._epPKs;
        synchronized (list) {
            return this._epPKs.remove(epPK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEndPort(WwnKey epPK) {
        List<WwnKey> list = this._epPKs;
        synchronized (list) {
            return this._epPKs.contains(epPK);
        }
    }

    public List<WwnKey> getEndPortPKs() {
        return this._epPKs;
    }

    public int getNumOfEndPorts() {
        return this._epPKs == null ? 0 : this._epPKs.size();
    }

    public ScsiTarget getScsiTarget() {
        return this._target;
    }

    public void setScsiTarget(ScsiTarget target) {
        this._target = target;
    }

    public synchronized boolean addHba(Hba hba) {
        if (this._hbas == null) {
            this._hbas = new Hba[]{hba};
            return true;
        }
        if (GenUtil.linearSearch(this._hbas, hba) == -1) {
            Hba[] hbas = new Hba[this._hbas.length + 1];
            System.arraycopy(this._hbas, 0, hbas, 0, this._hbas.length);
            hbas[this._hbas.length] = hba;
            this._hbas = hbas;
            return true;
        }
        return false;
    }

    public Hba[] getHbas() {
        return this._hbas;
    }

    public void setHbas(Hba[] hbas) {
        this._hbas = hbas;
    }

    public String getName() {
        if (SnmpPeer.getShowNameBy() == 0 && this._ipAddress != null && this._ipAddress.length() > 0) {
            return this._ipAddress;
        }
        if (SnmpPeer.getShowNameBy() == 1 && this._ipAddress != null && this._ipAddress.length() > 0) {
            int dot;
            String name = this._ipAddress;
            if (Character.isLetter(name.charAt(0)) && (dot = name.indexOf(46)) != -1) {
                name = name.substring(0, dot);
            }
            return name;
        }
        return this._pkey._name;
    }

    public boolean isManageable() {
        return true;
    }

    public String getLocation() {
        return null;
    }

    public String getContact() {
        return null;
    }

    public long getSysUpTime() {
        return 0L;
    }

    public String[] getIpAddresses() {
        return this._vhost.getIpAddresses().toArray(new String[this._vhost.getIpAddresses().size()]);
    }

    public long getMemorySize() {
        if (this._vhost == null) {
            return 0L;
        }
        return this._vhost.getMemorySize();
    }

    public void setMemorySize(long memorySize) {
        this._vhost.setMemorySize(memorySize);
    }

    public short getCpuCount() {
        if (this._vhost == null) {
            return 0;
        }
        return this._vhost.getCpuCount();
    }

    public void setCpuCount(short cpuCount) {
        this._vhost.setCpuCount(cpuCount);
    }

    public long getCpuSpeedAvg() {
        if (this._vhost == null) {
            return 0L;
        }
        return this._vhost.getCpuSpeedAvg();
    }

    public void setCpuSpeedAvg(long cpuSpeedAvg) {
        this._vhost.setCpuSpeedAvg(cpuSpeedAvg);
    }

    public boolean isVmHost() {
        return this._isVmHost;
    }

    public void setVmHost(boolean isVmHost) {
        this.setModified(this._isVmHost != isVmHost);
        this._isVmHost = isVmHost;
    }

    public String getHostName() {
        if (this._vhost == null) {
            return null;
        }
        return this._vhost.getHostName();
    }

    public void setHostName(String hostName) {
        this._vhost.setHostName(hostName);
    }

    public List<NameKey> getVmPKs() {
        if (this._vhost == null) {
            return null;
        }
        return this._vhost.getVmPKs();
    }

    public int getNumVms() {
        return this._numVms;
    }

    public boolean setNumVms(int numVms) {
        boolean changed;
        boolean bl = changed = this._numVms != numVms;
        if (changed) {
            this._numVms = numVms;
            this.setModified(true);
        }
        return changed;
    }

    public void setVms(List<NameKey> vmPKs) {
        this._vhost.setVms(vmPKs);
    }

    public boolean removeVm(NameKey vmPK) {
        return this._vhost.removeVm(vmPK);
    }

    public String getClusterName() {
        if (this._vhost == null) {
            return null;
        }
        return this._vhost.getClusterName();
    }

    public void setClusterName(String clusterName) {
        this._vhost.setClusterName(clusterName);
    }

    public String getMultiPath() {
        if (this._vhost == null) {
            return null;
        }
        return this._vhost.getMultiPath();
    }

    public void setMultiPath(String multiPath) {
        this._vhost.setMultiPath(multiPath);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean hasVm(NameKey vmPK) {
        if (this._vhost == null) {
            return false;
        }
        return this._vhost.hasVm(vmPK);
    }

    public void addVm(NameKey vmPK) {
        this._vhost.addVm(vmPK);
    }

    public void setVHost(HostSystem vhost) {
        this.setModified(true);
        this._vhost = vhost;
    }

    public HostSystem getVHost() {
        return this._vhost;
    }
}

