/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.Fc4Decoder;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.jnm.WwnVendor;
import com.cisco.dcbu.sm.common.dto.FcPortRNIDInfo;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.VsanFcIdKey;
import com.cisco.dcbu.sm.common.type.VsanFportKey;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.util.ArrayList;
import java.util.Arrays;

public class EndPortBase
extends BaseModelObject {
    static final long serialVersionUID = 1L;
    public static final int TARGET = 1;
    public static final int INITIATOR = 2;
    static final int FC4_FEATURE_TARGET = 1;
    static final int FC4_FEATURE_INIT = 2;
    static final int FC4_FEATURE_FICON_CUP = 4;
    static final int FC4_FEATURE_FICON_CU = 8;
    static final int FC4_FEATURE_FICON_CH = 16;
    static final int FC4_FEATURE_VIRT_TRAP = 32;
    static final int FC4_FEATURE_VIRT_VEP = 64;
    static final int FC4_FEATURE_VIRT_VOL = 128;
    static final int FC4_FEATURE_VIRT_IPFC = 256;
    static final int FC4_FEATURE_VIRT_INT_DPP = 512;
    static final int FC4_FEATURE_VIRT_INT_CPP = 1024;
    static final int FC4_FEATURE_VIRT_INT_REDIRECT = 2048;
    public static final short NXPORT_ATTR = 1536;
    public static final short ATTR_ISPRESENT = 1537;
    public static final short ATTR_NWWN = 1538;
    public static final short ATTR_FWWN = 1539;
    public static final short ATTR_SYMPORTNAME = 1540;
    public static final short ATTR_SYMNODENAME = 1541;
    public static final short ATTR_NODEIPADDR = 1542;
    public static final short ATTR_FPORTPK = 1543;
    public static final short ATTR_VSANFCIDS = 1544;
    public static final short ATTR_ENCLOSUREPK = 1545;
    public static final short ATTR_AUTOALIAS = 1546;
    public static final short ATTR_OPERSTATUSCAUSE = 1547;
    public static final short ATTR_ISLOOP = 1548;
    public static final short ATTR_FC4TYPE = 1549;
    public static final short ATTR_FC4FEATURE = 1550;
    public static final short ATTR_FICONADDR = 1551;
    public static final short ATTR_IFNAME = 1552;
    public static final short ATTR_SPEED = 1553;
    public static final short ATTR_RNIDINFO = 1554;
    public static final short ATTR_VSANFPORTS = 1555;
    public static final short ATTR_VFCBINDTO = 1556;
    public static final short ATTR_SERVICEPROFILE = 1557;
    public static final short ATTR_DEVICEALIAS = 1558;
    public static final short ATTR_FCALIAS = 1559;
    public static final String[] _Attrs = new String[]{"isPresent", "nodeWwn", "fWwn", "symPortName", "symNodeName", "nodeIpAddress", "fportPK", "VsanFCIDs", "enclosurePK", "autoAlias", "operStatusCause", "isLoop", "FC4Type", "FC4Feature", "ficonAddr", "ifName", "speed", "RNIDInfo", "VsanFPorts", "VfcBindTo", "ServiceProfile"};
    protected final WwnKey _pkey;
    protected Wwn _nWwn;
    protected boolean _isLoop;
    protected String _symPortName;
    protected String _symNodeName;
    protected String _nodeIpAddress;
    protected NameKey _enclosurePK;
    protected String _autoAlias;
    protected String _serviceProfile;
    protected FabricPK _fabricPK;
    protected SwitchIntKey _fportPK;
    protected String _ifName;
    protected byte[] _fWwn;
    protected short _ficonAddr = (short)-1;
    protected FcPortRNIDInfo _rnidInfo = null;
    protected int[] _fc4Types;
    protected int _fc4Features;
    protected long _speed;
    protected short _operStatusCause = (short)2;
    protected VsanFcIdKey[] _vsanFcIds;
    protected VsanFportKey[] _vsanFports;
    protected String _displayName;
    protected String _vfcBindTo;
    private boolean _useHost = Boolean.getBoolean("fabric.useHost");

    public EndPortBase(WwnKey epPK, Wwn nWwn) {
        this._pkey = epPK;
        this._nWwn = nWwn;
    }

    public EndPortBase(WwnKey epPK, Wwn nWwn, int[] fc4Types, byte[] fc4Features) {
        this._pkey = epPK;
        this._nWwn = nWwn;
        this.setFc4Type(fc4Types);
        this.setFc4Features(fc4Features);
    }

    public EndPortBase(EndPortBase np) {
        this._pkey = np._pkey;
        this.sync(np);
    }

    public void sync(EndPortBase np) {
        super.sync(np);
        this._fabricPK = np._fabricPK;
        this._nWwn = np._nWwn;
        this._fWwn = np._fWwn;
        this._ficonAddr = np._ficonAddr;
        this._rnidInfo = np._rnidInfo;
        this._fportPK = np._fportPK;
        this._ifName = np._ifName;
        this._isLoop = np._isLoop;
        this._fc4Types = np._fc4Types;
        this._fc4Features = np._fc4Features;
        this._speed = np._speed;
        this._symPortName = np._symPortName;
        this._symNodeName = np._symNodeName;
        this._nodeIpAddress = np._nodeIpAddress;
        this._enclosurePK = np._enclosurePK;
        this._autoAlias = np._autoAlias;
        this._operStatusCause = np._operStatusCause;
        this._vsanFcIds = np._vsanFcIds;
        this._vsanFports = np._vsanFports;
        this._vfcBindTo = np._vfcBindTo;
        this._serviceProfile = np._serviceProfile;
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    public WwnKey getEndPortPK() {
        return this._pkey;
    }

    public FabricPK getFabricPK() {
        return this._fabricPK;
    }

    public void setFabricPK(FabricPK fabricPK) {
        this.setModified(true);
        this._fabricPK = fabricPK;
    }

    public boolean isMemberOfVsan(int vsanId) {
        return this.getFcId(vsanId) != 0;
    }

    public int getFcId(int vsanId) {
        if (this._vsanFcIds != null) {
            for (int i = 0; i < this._vsanFcIds.length; ++i) {
                if (this._vsanFcIds[i]._vsanPK._id != vsanId) continue;
                return this._vsanFcIds[i]._fcId;
            }
        }
        return 0;
    }

    public int[] getFcIds(int vsanId) {
        ArrayList<Integer> fcIds = new ArrayList<Integer>();
        if (this._vsanFcIds != null) {
            for (int i = 0; i < this._vsanFcIds.length; ++i) {
                if (this._vsanFcIds[i]._vsanPK._id != vsanId) continue;
                fcIds.add(new Integer(this._vsanFcIds[i]._fcId));
            }
        }
        int[] ret = new int[fcIds.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)fcIds.get(i);
        }
        return ret;
    }

    public VsanFcIdKey[] getVsanFcIds() {
        if (this._vsanFcIds != null) {
            VsanFcIdKey[] temp = new VsanFcIdKey[this._vsanFcIds.length];
            System.arraycopy(this._vsanFcIds, 0, temp, 0, this._vsanFcIds.length);
            return temp;
        }
        return null;
    }

    public void setVsanFcIds(VsanFcIdKey[] vdKeys) {
        this.setModified(true);
        this._vsanFcIds = vdKeys;
    }

    public VsanFcIdKey addVsanFcId(VsanFcIdKey vsanFcId) {
        if (this._vsanFcIds == null) {
            this._vsanFcIds = new VsanFcIdKey[]{vsanFcId};
        } else {
            for (int i = 0; i < this._vsanFcIds.length; ++i) {
                if (this._vsanFcIds[i]._vsanPK._id != vsanFcId._vsanPK._id) continue;
                if (this._vsanFcIds[i]._fcId == vsanFcId._fcId && this._vsanFcIds[i]._vsanPK._prinSwwn.equals(vsanFcId._vsanPK._prinSwwn)) {
                    return vsanFcId;
                }
                VsanFcIdKey oldVsanFcId = this._vsanFcIds[i];
                this._vsanFcIds[i] = vsanFcId;
                return oldVsanFcId;
            }
            VsanFcIdKey[] newVsanFcIds = new VsanFcIdKey[this._vsanFcIds.length + 1];
            System.arraycopy(this._vsanFcIds, 0, newVsanFcIds, 0, this._vsanFcIds.length);
            newVsanFcIds[this._vsanFcIds.length] = vsanFcId;
            this._vsanFcIds = newVsanFcIds;
            Arrays.sort(this._vsanFcIds);
        }
        return null;
    }

    public VsanFportKey[] getVsanFports() {
        if (this._vsanFports != null) {
            VsanFportKey[] temp = new VsanFportKey[this._vsanFports.length];
            System.arraycopy(this._vsanFports, 0, temp, 0, this._vsanFports.length);
            return temp;
        }
        return null;
    }

    public void setVsanFports(VsanFportKey[] vfKeys) {
        this.setModified(true);
        this._vsanFports = vfKeys;
    }

    public VsanFportKey addVsanFport(VsanFportKey vsanFport) {
        if (this._vsanFports == null) {
            this._vsanFports = new VsanFportKey[]{vsanFport};
        } else {
            for (int i = 0; i < this._vsanFports.length; ++i) {
                if (vsanFport._vsanPK == null) {
                    if (!this._vsanFports[i]._fwwn.equals(vsanFport._fwwn)) continue;
                    if (this._vsanFports[i]._fPortPK.equals(vsanFport._fPortPK)) {
                        return this._vsanFports[i];
                    }
                    VsanFportKey oldVsanFport = this._vsanFports[i];
                    this._vsanFports[i].setFPortPK(vsanFport._fPortPK);
                    this._vsanFports[i].setChanged(true);
                    return oldVsanFport;
                }
                if (this._vsanFports[i]._vsanPK == null) {
                    if (!this._vsanFports[i]._fwwn.equals(vsanFport._fwwn)) continue;
                    this._vsanFports[i].setVsanPK(vsanFport.getVsanPK());
                    this._vsanFports[i].setFc4Type(vsanFport.getFc4Type());
                    return this._vsanFports[i];
                }
                if (this._vsanFports[i]._vsanPK._id != vsanFport._vsanPK._id) continue;
                if (this._vsanFports[i].getChanged()) {
                    return this._vsanFports[i];
                }
                if (this._vsanFports[i]._fPortPK.equals(vsanFport._fPortPK) && this._vsanFports[i]._vsanPK._prinSwwn.equals(vsanFport._vsanPK._prinSwwn)) {
                    return vsanFport;
                }
                VsanFportKey oldVsanFport = this._vsanFports[i];
                this._vsanFports[i] = vsanFport;
                return oldVsanFport;
            }
            VsanFportKey[] newVsanFports = new VsanFportKey[this._vsanFports.length + 1];
            System.arraycopy(this._vsanFports, 0, newVsanFports, 0, this._vsanFports.length);
            newVsanFports[this._vsanFports.length] = vsanFport;
            this._vsanFports = newVsanFports;
        }
        return null;
    }

    public VsanFportKey setVsanFport(SwitchIntKey fPort, Wwn fwwn) {
        for (int i = 0; this._vsanFports != null && i < this._vsanFports.length; ++i) {
            if (!this._vsanFports[i]._fwwn.equals(fwwn)) continue;
            if (this._vsanFports[i]._fPortPK.equals(fPort)) {
                return this._vsanFports[i];
            }
            VsanFportKey oldVsanFport = this._vsanFports[i];
            this._vsanFports[i].setFPortPK(fPort);
            this._vsanFports[i].setChanged(true);
            return oldVsanFport;
        }
        return null;
    }

    public boolean removeVsan(VsanPK vpk) {
        int i;
        ArrayList<PKIf> nl;
        boolean preexist = false;
        boolean preexist1 = false;
        if (this._vsanFcIds != null) {
            nl = new ArrayList<PKIf>(this._vsanFcIds.length);
            for (i = 0; i < this._vsanFcIds.length; ++i) {
                if (this._vsanFcIds[i]._vsanPK.equals(vpk)) {
                    preexist = true;
                    continue;
                }
                nl.add(this._vsanFcIds[i]);
            }
            if (preexist) {
                this._vsanFcIds = nl.size() == 0 ? null : (nl.size() == 1 ? new VsanFcIdKey[]{(VsanFcIdKey)nl.get(0)} : nl.toArray(new VsanFcIdKey[nl.size()]));
            }
        }
        if (this._vsanFports != null) {
            nl = new ArrayList(this._vsanFports.length);
            for (i = 0; i < this._vsanFports.length; ++i) {
                if (this._vsanFports[i]._vsanPK != null && this._vsanFports[i]._vsanPK.equals(vpk)) {
                    preexist1 = true;
                    continue;
                }
                nl.add(this._vsanFports[i]);
            }
            if (preexist1) {
                this._vsanFports = nl.size() == 0 ? null : (nl.size() == 1 ? new VsanFportKey[]{(VsanFportKey)nl.get(0)} : nl.toArray(new VsanFportKey[nl.size()]));
            }
        }
        return preexist;
    }

    public short[] getVsanMembership() {
        return this._vsanFcIds != null ? EndPortBase.getVsans(this._vsanFcIds) : new short[]{};
    }

    public int getNumVsans() {
        return this._vsanFcIds == null ? 0 : this._vsanFcIds.length;
    }

    public VsanPK getVsanPK(int vsanId) {
        if (this._vsanFcIds != null) {
            for (int i = 0; i < this._vsanFcIds.length; ++i) {
                if (this._vsanFcIds[i]._vsanPK._id != vsanId) continue;
                return this._vsanFcIds[i]._vsanPK;
            }
        }
        return null;
    }

    public String getVsansAsString() {
        return this._vsanFcIds != null ? EndPortBase.getVsansAsString(this._vsanFcIds) : "";
    }

    public short getVsan() {
        return this._vsanFcIds == null ? (short)0 : this._vsanFcIds[0]._vsanPK._id;
    }

    public short getFirstVsan() {
        return this._vsanFcIds == null ? (short)0 : this._vsanFcIds[0]._vsanPK._id;
    }

    public static String getFcIdAsString(int fcIdNum) {
        String fcId = Integer.toHexString(fcIdNum);
        int paddings = 6 - fcId.length();
        String padStr = "0x";
        for (int i = 0; i < paddings; ++i) {
            padStr = padStr + "0";
        }
        return padStr + fcId;
    }

    public NameKey getEnclosurePK() {
        return this._enclosurePK;
    }

    public SwitchIntKey getFPortPK() {
        return this._fportPK;
    }

    public void setFPortPK(SwitchIntKey fportPK) {
        this.setModified(true);
        this._fportPK = fportPK;
    }

    public SwitchIntKey getFport(int vsanId) {
        if (this._vsanFports != null) {
            for (int i = 0; i < this._vsanFports.length; ++i) {
                if (this._vsanFports[i]._vsanPK == null || this._vsanFports[i]._vsanPK._id != vsanId) continue;
                return this._vsanFports[i]._fPortPK;
            }
        }
        return null;
    }

    public int getIfIndex() {
        return this._fportPK != null ? this._fportPK._index : 0;
    }

    public String getIfName() {
        return this._ifName;
    }

    public String getIfNameBrief() {
        if (this._ifName != null && this._ifName.indexOf(40) != -1) {
            return this._ifName.substring(0, this._ifName.indexOf(40));
        }
        return this._ifName;
    }

    public void setIfName(String ifName) {
        this.setModified(true);
        this._ifName = ifName;
    }

    public Wwn getPortWwn() {
        return this._pkey._wwn;
    }

    public Wwn getNodeWwn() {
        return this._nWwn;
    }

    public void setNodeWwn(Wwn wwn) {
        this.setModified(true);
        this._nWwn = wwn;
    }

    public byte[] getfWwn() {
        return this._fWwn;
    }

    public byte[] setfWwn(byte[] wwn) {
        this.setModified(true);
        byte[] oldFWwn = this._fWwn;
        this._fWwn = wwn;
        return oldFWwn;
    }

    public String getNodeIpAddress() {
        return this._nodeIpAddress;
    }

    public String setNodeIpAddress(String ipAddr) {
        this.setModified(true);
        String oldIp = this._nodeIpAddress;
        this._nodeIpAddress = ipAddr;
        return oldIp;
    }

    public WwnKey getSwitchPK() {
        return this._fportPK != null ? this._fportPK._swPK : null;
    }

    public WwnKey getSwitchPK(int vsanId) {
        if (this.getNumVsans() > 1) {
            SwitchIntKey fportPK = this.getFport(vsanId);
            return fportPK != null ? fportPK._swPK : null;
        }
        return this._fportPK != null ? this._fportPK._swPK : null;
    }

    public int[] getFc4Type() {
        return this._fc4Types;
    }

    public void setFc4Type(byte[] fc4Types) {
        if (fc4Types == null) {
            return;
        }
        this.setModified(true);
        this._fc4Types = SnmpIntList.valueOf(fc4Types);
    }

    public void setFc4Type(int[] fc4Types) {
        if (this._fc4Types != null && fc4Types != null && !Arrays.equals(this._fc4Types, this._fc4Types)) {
            this.setModified(true);
        }
        this._fc4Types = fc4Types;
    }

    public void setFc4Features(byte[] fc4Features) {
        int _oldFc4Features = this._fc4Features;
        WwnVendor vendor = WwnDictionary.getWwnVendor(this._pkey._wwn.getValue());
        if (fc4Features != null) {
            if (Fc4Decoder.isFc4TypeSet(this._fc4Types, 8)) {
                if (Fc4Decoder.isFc4FeatureSet(fc4Features, 8, 2)) {
                    this._fc4Features |= 2;
                }
                if (Fc4Decoder.isFc4FeatureSet(fc4Features, 8, 1)) {
                    this._fc4Features |= 1;
                }
                if (Fc4Decoder.isFc4FeatureSet(fc4Features, 8, 3)) {
                    this._fc4Features |= 3;
                }
            }
            if (this.isVirtualized()) {
                if (Fc4Decoder.isFc4FeatureSet(fc4Features, 224, 1)) {
                    this._fc4Features |= 0x20;
                }
                if (Fc4Decoder.isFc4FeatureSet(fc4Features, 224, 2)) {
                    this._fc4Features |= 0x40;
                }
                if (Fc4Decoder.isFc4FeatureSet(fc4Features, 224, 3)) {
                    this._fc4Features |= 0x81;
                }
                if (Fc4Decoder.isFc4FeatureSet(fc4Features, 224, 4)) {
                    this._fc4Features |= 0x100;
                }
                if (Fc4Decoder.isFc4FeatureSet(fc4Features, 224, 5)) {
                    this._fc4Features |= 0x200;
                }
                if (Fc4Decoder.isFc4FeatureSet(fc4Features, 224, 6)) {
                    this._fc4Features |= 0x400;
                }
                if (Fc4Decoder.isFc4FeatureSet(fc4Features, 224, 7)) {
                    this._fc4Features |= 0x800;
                }
            }
            if (this.isFicon()) {
                if (Fc4Decoder.isFc4FeatureSet(fc4Features, 24, 4)) {
                    this._fc4Features |= 4;
                } else {
                    if (Fc4Decoder.isFc4FeatureSet(fc4Features, 24, 1)) {
                        this._fc4Features |= 8;
                    }
                    if (Fc4Decoder.isFc4FeatureSet(fc4Features, 24, 2)) {
                        this._fc4Features |= 0x10;
                    }
                    this._fc4Features = (this._fc4Features & 0x18) == 24 ? (this._fc4Features |= 1) : ((this._fc4Features & 8) != 0 ? (this._fc4Features |= 1) : (this._fc4Features |= 2));
                }
            }
        }
        if ((this._fc4Features & 2) == 0 && (this._fc4Features & 1) == 0) {
            if (vendor != null) {
                if (vendor.isHost() && vendor.isStorage()) {
                    this._fc4Features = this._useHost ? (this._fc4Features |= 2) : (this._fc4Features |= 1);
                } else if (vendor.isHost()) {
                    this._fc4Features |= 2;
                } else if (vendor.isStorage()) {
                    this._fc4Features |= 1;
                }
            } else {
                this._fc4Features = this._useHost ? (this._fc4Features |= 2) : (this._fc4Features |= 1);
            }
        }
        if (this._fc4Features != _oldFc4Features) {
            this.setModified(true);
        }
    }

    public String getFc4TypeFeatureString() {
        return EndPortBase.getFc4TypesString(this._fc4Types, this._fc4Features);
    }

    public static String getFc4TypesString(int[] fc4Types, int fc4Features) {
        int wdpos;
        if (fc4Types == null || fc4Types.length == 0) {
            return "unknown";
        }
        StringBuffer sb = new StringBuffer();
        int max = Fc4Decoder.FC4_TYPES.length;
        for (int i = 0; i < max && (wdpos = Fc4Decoder.FC4_TYPES[i] >> 5) < fc4Types.length; ++i) {
            if ((fc4Types[wdpos] & 1 << (Fc4Decoder.FC4_TYPES[i] & 0x1F)) <= 0) continue;
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(Fc4Decoder.getFc4TypeString(Fc4Decoder.FC4_TYPES[i]));
            if (Fc4Decoder.FC4_TYPES[i] == 8) {
                if ((fc4Features & 1) > 0) {
                    if ((fc4Features & 2) > 0) {
                        sb.append(":both");
                        continue;
                    }
                    sb.append(":target");
                    continue;
                }
                if ((fc4Features & 2) <= 0) continue;
                sb.append(":init");
                continue;
            }
            if (Fc4Decoder.FC4_TYPES[i] == 24) {
                if ((fc4Features & 4) > 0) {
                    sb.append(":CUP");
                    continue;
                }
                if ((fc4Features & 8) > 0) {
                    sb.append(":CU");
                    continue;
                }
                if ((fc4Features & 0x10) <= 0) continue;
                sb.append(":CH");
                continue;
            }
            if (Fc4Decoder.FC4_TYPES[i] == 224) {
                if ((fc4Features & 0x20) > 0) {
                    sb.append(":trap");
                    continue;
                }
                if ((fc4Features & 0x40) > 0) {
                    sb.append(":vep");
                    continue;
                }
                if ((fc4Features & 0x100) > 0) {
                    sb.append(":ipfc");
                    continue;
                }
                if ((fc4Features & 0x80) > 0) {
                    sb.append(":volume");
                    continue;
                }
                if ((fc4Features & 0x200) > 0) {
                    sb.append(":VI-DPP");
                    continue;
                }
                if ((fc4Features & 0x400) > 0) {
                    sb.append(":VI-CPP");
                    continue;
                }
                if ((fc4Features & 0x800) <= 0) continue;
                sb.append(":redirect");
                continue;
            }
            if (Fc4Decoder.FC4_TYPES[i] != 226) continue;
        }
        return sb.toString();
    }

    public long getSpeed() {
        return this._speed;
    }

    public void setSpeed(long speed) {
        if (speed != this._speed) {
            this.setModified(true);
        }
        this._speed = speed;
    }

    public String getSymPortName() {
        return this._symPortName;
    }

    public void setSymPortName(String symPortName) {
        this.setModified(true);
        this._symPortName = symPortName;
    }

    public String getSymNodeName() {
        return this._symNodeName;
    }

    public void setSymNodeName(String symNodeName) {
        if (this._symNodeName != null && !this._symNodeName.equals(symNodeName)) {
            this.setModified(true);
        }
        this._symNodeName = symNodeName;
    }

    public String getServiceProfile() {
        return this._serviceProfile;
    }

    public void setServiceProfile(String serviceProfile) {
        if (this._serviceProfile != null && !this._serviceProfile.equals(serviceProfile)) {
            this.setModified(true);
        }
        this._serviceProfile = serviceProfile;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        EndPortBase ep1 = (EndPortBase)o1;
        EndPortBase ep2 = (EndPortBase)o2;
        try {
            if (ep1._vsanFcIds == null || ep2._vsanFcIds == null) {
                return ep1._pkey._wwn.compare(ep1._pkey._wwn, ep2._pkey._wwn);
            }
            return ep1._vsanFcIds[0]._vsanPK._id == ep2._vsanFcIds[0]._vsanPK._id ? ep1._pkey._wwn.compare(ep1._pkey._wwn, ep2._pkey._wwn) : ep1._vsanFcIds[0]._vsanPK._id - ep2._vsanFcIds[0]._vsanPK._id;
        }
        catch (Exception ex) {
            return ep1._pkey._wwn.compare(ep1._pkey._wwn, ep2._pkey._wwn);
        }
    }

    public void setEnclosurePK(NameKey enclosurePK) {
        this.setModified(true);
        this._enclosurePK = enclosurePK;
    }

    public String getAutoAlias() {
        return this._autoAlias;
    }

    public void setAutoAlias(String alias) {
        this.setModified(true);
        this._autoAlias = alias;
    }

    public short getOperStatusCause() {
        return this._operStatusCause;
    }

    public void setOperStatusCause(short cause) {
        if (this._operStatusCause != cause) {
            this.setModified(true);
        }
        this._operStatusCause = cause;
    }

    public int getFc4Features() {
        return this._fc4Features;
    }

    public int setFc4Features(int fc4Features) {
        this.setModified(true);
        this._fc4Features = fc4Features;
        return this._fc4Features;
    }

    public boolean isLoop() {
        return this._isLoop;
    }

    public void setLoop(boolean isLoop) {
        if (this._isLoop != isLoop) {
            this.setModified(true);
        }
        this._isLoop = isLoop;
    }

    public boolean isTarget() {
        return this.isFC4FeatureSet(1);
    }

    public void setTarget(boolean isTarget) {
        this.setModified(true);
        this.setFC4Feature(1, isTarget);
    }

    public boolean isIntiator() {
        return this.isFC4FeatureSet(2);
    }

    public void setInitiator(boolean isInitiator) {
        this.setModified(true);
        this.setFC4Feature(2, isInitiator);
    }

    public boolean isIntiatorOnly() {
        return this.isFC4FeatureSet(2) && !this.isFC4FeatureSet(1);
    }

    public boolean isInitiatorAndTarget() {
        return this.isIntiator() && this.isTarget();
    }

    public boolean isISCSI() {
        return Fc4Decoder.isFc4TypeSet(this._fc4Types, 225);
    }

    public boolean isSVC() {
        return Fc4Decoder.isFc4TypeSet(this._fc4Types, 226);
    }

    public boolean isSET() {
        return Fc4Decoder.isFc4TypeSet(this._fc4Types, 227);
    }

    public boolean isIPFC() {
        Wwn pwwn = this._pkey._wwn;
        return this.isFC4FeatureSet(256) || WwnDictionary.isCiscoWwn(pwwn.getValue()) && pwwn.getValue()[0] >> 4 == 1;
    }

    public short getFiconAddress() {
        return this._ficonAddr;
    }

    public void setFiconAddress(short ficonAddr) {
        this.setModified(true);
        this._ficonAddr = ficonAddr;
    }

    public FcPortRNIDInfo getFiconRNIDInfo() {
        return this._rnidInfo;
    }

    public void setFiconRNIDInfo(FcPortRNIDInfo info) {
        this.setModified(true);
        this._rnidInfo = info;
    }

    public String getVFCBindTo() {
        return this._vfcBindTo;
    }

    public void setVFCBindTo(String bindTo) {
        this.setModified(true);
        this._vfcBindTo = bindTo;
    }

    public boolean isFCoE(IfIndexIf ifIndexIf) {
        return ifIndexIf != null && this._fportPK != null && ifIndexIf.getType(this._fportPK._index) == 30;
    }

    public boolean isFicon() {
        return Fc4Decoder.isFc4TypeSet(this._fc4Types, 24);
    }

    public boolean isFiconCup() {
        return this.isFC4FeatureSet(4);
    }

    public boolean isFiconCU() {
        return this.isFC4FeatureSet(8);
    }

    public boolean isFiconCH() {
        return this.isFC4FeatureSet(16);
    }

    public boolean isVolume() {
        return this.isFC4FeatureSet(128);
    }

    public boolean isVirtualized() {
        return Fc4Decoder.isFc4TypeSet(this._fc4Types, 224);
    }

    public boolean isInternal() {
        return this.isFC4FeatureSet(512) || this.isFC4FeatureSet(1024) || this.isFC4FeatureSet(2048);
    }

    public boolean isVICPP() {
        return this.isFC4FeatureSet(1024);
    }

    public boolean isVIDPP() {
        return this.isFC4FeatureSet(512);
    }

    public boolean isInternalRedirect() {
        return this.isFC4FeatureSet(2048);
    }

    private boolean isFC4FeatureSet(int flagmask) {
        return (this._fc4Features & flagmask) == flagmask;
    }

    private void setFC4Feature(int flagmask, boolean set) {
        this.setModified(true);
        this._fc4Features = set ? this._fc4Features | flagmask : this._fc4Features & ~flagmask;
    }

    public static short[] getVsans(VsanFcIdKey[] vsanFcIds) {
        short[] vids = new short[vsanFcIds.length];
        for (int i = 0; i < vsanFcIds.length; ++i) {
            vids[i] = vsanFcIds[i]._vsanPK._id;
        }
        return vids;
    }

    public static short[] getVsans(VsanFportKey[] vsanFports) {
        short[] vids = new short[vsanFports.length];
        for (int i = 0; i < vsanFports.length; ++i) {
            vids[i] = vsanFports[i]._vsanPK._id;
        }
        return vids;
    }

    public static String getVsansAsString(VsanFcIdKey[] vsanFcIds) {
        return VsanBase.getVsansAsString(EndPortBase.getVsans(vsanFcIds), vsanFcIds.length);
    }

    public static String getVsansAsString(VsanFportKey[] vsanFports) {
        return VsanBase.getVsansAsString(EndPortBase.getVsans(vsanFports), vsanFports.length);
    }

    public static boolean isMember(VsanFcIdKey[] fcIds, VsanFcIdKey fcId) {
        if (fcIds != null) {
            for (int i = 0; i < fcIds.length; ++i) {
                if (!fcIds[i].equals(fcId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        if (this._displayName == null) {
            return "pWWN= " + this._pkey + ", nWWN=" + this._nWwn;
        }
        return this._displayName;
    }

    public String getName() {
        if (this._displayName == null) {
            return this._autoAlias;
        }
        return this._displayName;
    }

    public void setName(String displayName) {
        this.setModified(true);
        this._displayName = displayName;
    }
}

