/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.sm.common.model.EthIslBase;
import com.cisco.dcbu.sm.common.type.EthIslPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.SwitchIntKeyIf;
import com.cisco.dcbu.sm.common.type.SwitchSnIntKey;

public class FexIslBase
extends EthIslBase {
    private final SwitchIntKeyIf _fportPK;
    private final SwitchIntKeyIf _uportPK;

    public FexIslBase(EthIslPK pk) {
        super(pk);
        if (IfIndexUtil.getType(pk.getIfIndex1()) == 200) {
            this._uportPK = pk.getSwitchIntKey1();
            this._fportPK = pk.getSwitchIntKey2();
        } else {
            this._uportPK = pk.getSwitchIntKey2();
            this._fportPK = pk.getSwitchIntKey1();
        }
    }

    public SwitchIntKeyIf getFabricPortPK() {
        return this._fportPK;
    }

    public SwitchSnIntKey getUplinkPortPK() {
        return (SwitchSnIntKey)this._uportPK;
    }

    public PKIf getSwitchPK() {
        return this.getFabricPortPK().getSwitchKey();
    }

    public SerialNumKey getFexPK() {
        return this.getUplinkPortPK().getSwitchKey();
    }

    public int getFabricPortIfIndex() {
        return this.getFabricPortPK().getIfindex();
    }

    public int getUplinkPortIfIndex() {
        return this.getUplinkPortPK().getIfindex();
    }

    @Override
    public boolean isFexIsl() {
        return true;
    }
}

